# 1개월만에 서비스를 개발했다고 하는데... 어떤 기여를 하셨나요?
80퍼센트의 테크니컬 리더, 20퍼센트의 리소스 매니지먼트를 담당했습니다. 기초 코드 컨벤션 정립과 라이브러리 선택, 모듈 구조화 등을 결정하고 구축하였으며 팀원들이 서비스 개발에만 집중할 수 있게 공통 로직을 작성했습니다.

# 모노레포를 선택한 이유는 무엇인가요?
> 적용해야만 했던 타당한 이유

최초 모놀리식 저장소는 단일 버전으로 강하게 결합되어 관심 분리가 어렵고 기능 추가/삭제 시 레포지토리 전체에 영향을 줄 수 있었습니다. 이후 버전 관리가 가능한 모듈로 분리하고 기능 변경이 다른 레포지토리에 영향을 미치지 않도록 멀티 레포로 개선했으나 코드 단계의 재사용이 어렵고 빌드 및 배포 과정이 복잡해졌습니다. 따라서 assets 등의 정적 자원과 코드를 재사용하고 커밋 히스토리 추적에 용이한 모노레포를 선택했으며, 최종적으로 배포 및 빌드, 테스트 등을 병렬로 처리할 수 있게 되어 CI/CD 속도가 30분에서 13분 정도로 50퍼센트 이상 향상되었습니다.

## yarn berry를 선택한 이유는 무엇인가요?
기존 npm은 의존성 탐색 방향이 너무나 비효율적이었습니다. 패키지를 찾기 위해 계속 상위 디렉토리의 node_modules를 탐색했기 때문입니다. I/O 호출이 반복되므로 특정 상황에는 실패하기도 했습니다. 또한 탐색 동작이 환경에 따라 달라졌습니다. window, mac의 경우 상위 디렉토리 형태가 동일하지 않아 동작이 변했는데, 해당 상황은 추적이 까다로워지기 때문입니다. 또한 node_modules의 폴더는 디렉토리 구조를 복잡하게 가져가므로 의존성 트리의 깊이가 깊어집니다. 해당 의존성이 잘 설치되었는지 검증하려면 I/O 호출이 지속적으로 필요했죠. 이런 문제로 yarn classic과 npm은 기본적인 의존성 트리 유효성까지만 검증합니다. 또한 npm, yarn classic은 중복해서 설치되는 node_modules를 최소화하기 위해 호이스팅 기법을 사용하는데, 직접 의존하고 있지 않은 라이브러리를 require 할 수 있는 현상이 발생합니다.

yarn berry는 위와 같은 현상을 pnp 전략으로 해결합니다. .yarn/cache 폴더에 의존성 정보가 저장되고, .pnp.cjs 파일에 의존성을 찾을 수 있는 정보가 기록됩니다. 이 파일을 이용하면 디스크 I/O 없이 어떤 패키지가 라이브러리에 의존하는지, 어디에 위치하는지 알 수 있습니다. 또한 yarn은 node.js가 제공하는 require 구문 동작을 덮어써 효율적으로 패키지를 탐색할 수 있습니다.

yarn PnP 시스템에서 의존성은 Zip 아카이브로 관리됩니다. 장점으로는 zero-install이 되므로 설치 시간이 사라집니다. 각 패키지는 하나의 Zip 아카이브만 존재하여 스토리지 용량을 아낄 수 있습니다. 또한 전체 의존성을 삭제하는 작업이 빠릅니다.

## yarn berry를 사용하면서 문제점은 무엇인가요?
기존에는 peerDependencies에 정의하면 자동으로 import가 되었지만 yarn berry의 PnP는 strict mode이기 때문에 명시하지 않은 의존성에 접근하려면 에러가 발생합니다. 이를 해결하는 방법은 PnP모드를 사용하지 않고 node_modules를 사용하면 됩니다. 다만 이런 경우 yarn berry의 강점이 사라집니다. 이때 pnpMode의 loose를 사용하면 PnP Linker가 node_modules를 사용했을 때 호이스팅 될 패키지들의 리스트를 생성하고 기억합니다. yarn fallback pool이라고 합니다. 이후 런타임에 패키지가 명시하지 않은 의존성을 요구하면 fallback pool에 의존성이 있으면 접근할 수 있게 됩니다.

## 패키지 매니저는 무엇인가요?
1. metadata 작성 및 관리
2. dependencies 설치/수정/삭제 및 업데이트
3. 스크립트 실행
4. 패키지 배포
5. 보안 검사

## npm, yarn, pnpm의 차이점은 무엇인가요?
1. npm : (node pkgmakeinst) 노드에 내장된 패키지 매니저입니다. nvm 등을 사용하여 버전을 스위칭할 수 있습니다. 패키지를 한 번에 하나씩 순차적으로 설치합니다.
2. yarn classic : (Yet Another Resource Negotiator) 여러 패키지를 동시에 가져오고 설치하도록 최적화되어 있습니다. 기존에는 npm의 보안보다 뛰어났는데, npm이 현재 패키지가 아니라 다른 패키지의 코드를 자동으로 실행했기 때문입니다. 그러나 yarn은 yarn.lock 또는 package.json에 있는 파일만 설치합니다. 최근에는 성능상 유의미하게 차이가 나진 않습니다.
   1. native 모노레포 지원
   2. cache-aware 설치
   3. 오프라인 캐싱
   4. lock files
3. pnpm : npm의 상위호환성을 가집니다. pnpm의 개발자들은 npm과 yarn의 dependencies 중복 저장을 가장 큰 문제로 생각했는데, 그 이유는 node_modules의 flat한 관리였습니다. pnpm은 호이스트 방식 대신, content-addressable storage를 사용합니다. 이 방법은 home 폴더의 글로벌 저장소(.pnpm-store)에 패키지를 저장하는 중첩된 node_modules가 생성됩니다. 따라서 모든 버전의 dependencies는 물리적으로 한 번만 저장되므로 `진실은 하나의 소스로부터` 원칙을 구현하고 상당한 디스크 공간을 절약할 수 있습니다. dependencies의 중첩된 구조는 symlink로, 폴더 내부의 모든 패키지 파일은 하드 링크로 구성됩니다.

## 심볼릭 링크와 하드 링크란 무엇인가요?
Inode를 사용하는 참조 파일입니다. 유닉스 계통의 파일 시스템에서 사용하는 자료구조로 파일들의 정보가 Inode에 담겨있습니다. 파일의 실제 값(내용)을 갖고 있진 않으나, 주소를 갖고 있습니다. 심볼릭 링크는 바로가기 역할로, 원본의 Inode와 다르게 유지됩니다. 반면 하드링크는 Inode가 동일한 블록을 가리키고 있으므로 원본 파일이 삭제되어도 링크된 파일은 여전히 내용을 보존할 수 있습니다. 하드 링크 시 Inode에서 링크 수가 하나 늘어납니다.

## 패키지 매니저의 lock 파일은 무엇인가요?
lock 파일은 매 설치시 결정적이고(항상 같은 버전) 예측 가능한 특성을 보장하기 위해 정확한 의존성 버전을 저장하는 파일입니다. package.json은 버전 범위가 존재하기 때문에 lock 파일이 없으면 설치마다 버전이 달라질 수 있습니다. 또한 체크섬이 존재하여 이를 활용해 패키지 무결성을 확인합니다. 만약 package.json 내부에 선언되지 않은 의심스러운 패키지가 존재하면 설치가 중단됩니다.

## 속도는?
yarn berry에 PnP의 strict 모드가 가장 빠르고, 디스크 효율적입니다. 그 다음이 pnpm입니다.

# Next.js
## Hydration에 대해 설명해주세요.
Next.js는 클라이언트에게 웹 페이지를 전송하기 전 Server에서 Pre-Rendering을 진행합니다. 그 후 Pre-Rendering을 통해 생성된 HTML Document를 클라이언트에게 전송합니다. 이때 클라이언트의 웹 페이지는 화면만 그려진 정적인 HTML입니다. JS 모듈, 이벤트가 DOM에 적용되지 않은 상태입니다.

Next.js는 Pre-Rendering 된 웹 페이지를 클라이언트에게 전송하고, 리액트가 번들링 된 자바스크립트 코드들을 클라이언트에게 전송합니다. 최초 페이지를 로드하면 document Type의 파일 하나와 React 코드들이 렌더링된 js 파일이 청크단위로 다운로드 됩니다. 그리고 이 js 코드가 사전에 보내진 HTML DOM 요소 위에서 한 번 더 렌더링을 진행하면서 바인딩됩니다.

### 그럼 문제 아닌가요?
두 번 렌더링은 비효율적이나, 서버에서 Pre-Rendering으로 요소를 그려 빠르게 클라이언트에게 응답할 수 있습니다. 이 속도는 자바스크립트 요소가 제외된 동작이라 빠르게 로딩되죠. 또한 DOM 요소에 js 코드를 바인딩하는 목적이므로 웹 페이지를 다시 그리지 않습니다(repaint 호출되지 않습니다).

실제로 Hydrate는 Next.js에 종속된 동작이 아니라 ReactDOM 함수인데, 

## CSR, SSR, SSG
1. 굳이 SEO 적용 또는 데이터 pre-rendering이 필요 없다면 CSR 방식
2. 정적 문서로 충분한 화면이면서 빠른 HTML 문서 반환이 필요하다면 SSG 방식
3. 매 요청마다 달라지는 화면이면서 서버 사이드로 이를 렌더링 하고자 한다면 SSR 방식

## ServerSide 생명주기
1. nextJs 서버가 GET 요청을 받는다.
2. GET 요청에 맞는 pages/Component를 찾는다.
3. _app.tsx의 getInitialProps가 있다면 실행한다.
4. route에 맞는 페이지의 Component의 getInitialProps가 있다면 실행한다. pageProps들을 받아온다.
5. _document.tsx의 getInitialProps가 있다면 실행한다. pageProps들을 받아온다.
6. 모든 props들을 구성하고, _app.tsx -> page Component 순서로 렌더링
7. 모든 Content를 구성하고 _document.tsx를 실행하여 html 형태로 출력한다.

## _document.tsx는 무엇인가요?
메타 태그를 정의하고 전체 페이지에 관여하는 컴포넌트로 오로지 서버에서만 동작합니다. render 요소를 반여할 뿐 js는 무시하기 때문에 정적인 상황에서만 사용됩니다.

## _app.tsx는 무엇인가요?
해당 파일에서 렌더링 하는 값은 모든 페이지에 영향을 줍니다. 최초로 실행되는 것은 _app.tsx로, 클라이언트에서 띄우길 바라는 전체 컴포넌트 → 공통 레이아웃임으로 최초 실행되며 내부에 컴포넌트들을 실행합니다. 또한 내부에 컴포넌트가 있다면 전부 실행하고 html의 body로 구성하며 Component, pageProps를 받습니다. 이때 여기서 props로 받은 Component는 요청한 페이지입니다. GET / 요청을 보냈다면, Component 에는 /pages/index.js 파일이 props로 내려오게 됩니다. pageProps는 페이지 getInitialProps를 통해 내려 받은 props들을 말합니다. 그 다음 _document.tsx가 실행됩니다. 즉, 페이지를 업데이트 하기 전에 원하는 방식으로 페이지를 업데이트 하는 통로이며 _app.tsx에서 console.log 실행시 client, server 둘 다 콘솔이 찍힙니다. (localhost:3000 웹과 터미널에서 둘다 콘솔 보임)

## 빌드 시 결과물
.next/static
        ├── AbmKMg9BFeVUuJ7lsQ1w8
        ├── chunks                 // 여러 페이지에서 공통으로 사용되는 번들 파일
        │       └──  pages         // 각 페이지의 번들 파일
        ├── runtime                // 웹팩과 next의 런타임과 관련된 번들 파일
        ├── css                    // 애플리케이션의 모든 페이지에 대한 글로벌 CSS 파일
        └── media                  // 정적으로 가져온 이미지 next/image가 여기에 해시 및 복사

.next/cache 폴더
Next.js 서버의 빌드 캐시 및 캐시된 이미지, 응답 및 페이지에 대한 출력.
캐시를 사용하면 빌드 시간이 단축되고 이미지 로드 성능이 향상됩니다.

## Server Side에서 실행되는 prepareServerSide 고차함수에 대해 서명해주세요.

## MSW를 적용한 이유는 무엇인가요? 성과는?

## HTTP Client 모듈을 개발한 이유는 무엇인가요? 성과는?

## JWT와 쿠키를 이용한 타 도메인 로그인 기능에 대해 설명해주세요.

## SEO를 개선하는 방법에는 무엇이 있나요? 왜 개선해야 할까요?

## 동적 메타 태그 기능은 어떻게 구현하셨나요?

# 타입스크립트

# Emotion
## CSS-in-JS vs Atomic CSS
## Emotion vs Styled-Components
## Storybook 선택한 이유

# 상태관리
## 상태관리를 도입하면 좋은 시기는 언제인가요?
자식 컴포넌트들 간의 다이렉트 데이터 전달은 불가능 하다.
자식 컴포넌트들 간의 데이터를 주고 받을 때는 상태를 관리하는 부모 컴포넌트를 통해서 주고 받는다.
그런데 자식이 많아진다면 상태 관리가 매우 복잡해진다.
상태를 관리하는 상위 컴포넌트에서 계속 내려 받아야한다. => Props drilling 이슈

## 상태관리를 어떻게 하고 계시나요?
## 리덕스의 등장 배경에 대해 설명해주세요.
Model - 데이터의 형식이나 구조를 관리한다. 모델에 맞지 않는 데이터는 흐름를 제어 받을 수 있다.
View - 코드가 사용자에게 보여지는 부분을 담당한다. 사용자에게 보여지는 모습과 형태를 관리한다.
Controller - 변화하는 데이터를 관리한다. View에서 발생하는 이벤트로 변경되는 데이터나 서버로부터 받은 변경된 데이터를 Model과 View에 업데이트 해준다.

## 왜 Zustand인가요?
상태 관리의 접근방식은 플럭스, 프록시, 아토믹이 존재합니다. 일반적으로 플럭스 방식은 앱 상태에 대한 모든 변경이 작업에 의해 발생하며, 구성 요소는 셀렉터를 사용하여 상태 부분에 가입하는 것이 특징이다.

이를 통해 우수한 개발자 경험과 적절한 성능을 얻을 수 있습니다. 그러나 모든 사람이 작업과 선택기를 쓰는 것을 좋아하는 것은 아니므로 프록시 접근 방식을 통해 전체 상태에 액세스할 수 있으며 구성 요소에서 사용되는 상태 부분을 자동으로 감지하고 해당 부분의 업데이트만 구독합니다. 

원자 상태는 리액트 상태에 훨씬 가깝고 리액트 트리 내부에 저장된다(플럭스 및 프록시는 외부에 데이터를 저장하고 리액트 없이 사용할 수 있음). 이것이 원자 상태를 다른 상태 관리 라이브러리보다 일반적으로 반응 컨텍스트와 비교하고 상태를 사용하는 이유입니다.

리코일을 사용하면 여러 구성 요소 간에 공유할 수 있는 상태를 만들 수 있습니다. 그것은 일반적인 스테이트 훅과 매우 비슷해 보인다.

상태는 원자들로 나뉘는데, 그것들은 레듀스 저장소와 같은 것보다 훨씬 작고 가볍다. 이들은 원자 기능으로 생성되며 서로 독립적으로 또는 주문형으로 생성될 수 있다. 이렇게 하면 코드 분할이 쉬워집니다.

useState를 사용하는 일반적인 React Context와 비교하여, 원자는 고주파 업데이트에 사용될 수 있다.

리코일은 0.0.11부터 동시 모드를 지원하는데, 이는 지원에 대한 구체적인 계획이 없는 Redux와 같은 도구들과 비교된다.

파생되거나 계산된 상태는 비동기적으로 해결될 수 있습니다(또는 오류를 발생시킬 수도 있습니다). 표준 React 방식에서는 이를 <Suspense> 및 <ErrorBoundary>로 처리해야 합니다.

또한 파생된 상태는 여러 종속성(동적일 수 있음)을 가질 수 있습니다. 즉, 현재 종속성 집합의 업데이트에만 가입합니다.

모든 면에서, Jotai API 전체는 실제로 이것이다: 공급자, 원자, 그리고 use Atom. Jotai가 내보내는 기능의 전체 목록은 아니지만, 일부 기능은 다른 엔드포인트(Jotai/utils 및 Jotai/dev 도구)의 일부로 내보내지기 때문에 Recoil과 Jotai의 작성자가 취한 접근 방식의 차이를 보여준다.

그래서, 이제 막 도서관을 시작하는 사람에게, Jotai는 훨씬 덜 위압적으로 보일 수 있다. 그러나 Recoil은 많은 교묘한 문서를 가지고 있고 더 많은 사람들이 그것을 사용하고 그것에 대해 이야기할 것이기 때문에, 다음은 이 점을 증명하는 피상적인 차트이다.

Jotai의 원자는 키 속성이 없으므로 const counterState = atom("counter")key: "counter", default: 0} 대신 만족스럽게 짧은 const 카운터 Atom = atom(0)을 작성할 수 있습니다.

이것은 잠재적인 문제일 수 있습니다. 예를 들어 디버깅할 원자를 식별하려면 counterAtom.debugLabel = "counter"를 추가해야 합니다. 또 다른 차이점은 원자가 있는 모듈이 업데이트된 경우 모든 새 원자가 더 이상 이전 원자와 참조적으로 같지 않기 때문에(키 문자열을 비교하기 때문에 Recoil에서 작동) 이전 상태를 유지할 수 없다는 것입니다.

그래서, 만약 조타이가 원자와 함께 사용되고 아톰을 사용할 수 있다면, 당신은 모든 추가적인 레코일 기능을 건너뛰고 원자와 함께 계속해서 레코일 상태를 사용할 수 있습니까? 아니, 그럴 수 없어요. 실제로 조타이 원자는 원자와 선택기를 모두 구현하는 데 사용된다. 원자와 선택기의 초기 상태가 설정되는 방식에는 몇 가지 차이가 있다.

Recoil에서 초기 값은 기본 옵션으로 설정되며 원시 값, 약속 또는 다른 원자를 전달하여 상태를 사용할 수 있습니다. 비동기 값으로 인해 렌더링이 일시 중단됩니다. 또한 고급 사용 사례의 경우 setSelf from effects_를 사용할 수 있습니다.기본값 대신 불안정합니다(트리거 가져오기 사용).

반동 선택기는 다른 선택기/원자의 값, 약속 또는 상태를 반환하는 함수에 의해 정의됩니다. 이 기능을 기본 옵션으로 설정하면 효과가 없습니다_선택기가 불안정합니다.

조타이에서, 두 가지 모두 같은 기능을 가진 원자로 만들어질 것입니다. 첫 번째 인수가 함수인 경우 선택기(Jotai 용어로 파생된 원자)를 생성하는 것입니다. 만약 그것이 다른 것이라면, 당신은 원자(염기 또는 원시 원자)를 만들고 있는 것이다. Jotai에서 원자를 초기화하기 위한 모든 고급 사용 사례는 약속을 사용한 비동기 초기화를 포함하여 파생 원자로 구현되어야 한다.

API 복제는 여기서 그치지 않습니다. 원자 계열을 지원하기 위해 레코일은 원자 계열과 선택기 계열을 모두 가져야 했다.

개선된 인체공학의 추세를 계속: 원자나 선택기를 기본값으로 재설정할 수 있는 것이 때로는 유용할 수 있지만, 즉, Recoil에 기록하는 쓰기 가능한 각 선택기에 대해 설정기의 값이 설정하려는 새 값이거나 특별한 기본값이 될 수 있다는 것을 고려해야 합니다.선택기가 재설정된 fies.

그리고 그것은 벌레가 있어요! tempCelcius를 재설정하면 실제로 NaN이 됩니다. 다행히도 이 문제는 TypeScript에 의해 발견되었습니다(그러나 모든 사람이 그것에 만족하는 것은 아닙니다). 이 문제를 해결하려면 기본값을 명시적으로 처리해야 하며 쓰기 가능한 Recoil 선택기 각각에 대해 유사한 처리를 수행해야 합니다.

조타이에서, 리셋 가능한 원자는 원자와 옵트인이다.재설정(jotai/utils에서 내보냄)을 사용하여 쓰기 가능한 파생 원자를 생성하려면 RESET 값을 허용하여 명시적으로 선언합니다.

그리고 TypeScript는 원자가 재설정 가능한 경우에만 ResetAtom 또는 set(RESet)을 사용할 수 있도록 보장합니다.

원자 상태 저장 방법
앞서 언급한 바와 같이 React 트리 내부에 Recoil과 Jotai store state가 모두 React 트리 내부에 있습니다.

또한 자주 업데이트되는 데이터에는 권장되지 않는 React Context도 사용합니다(기본적으로 컨텍스트 값이 변경되면 컨텍스트를 사용하는 각 구성 요소가 다시 렌더링됨). 따라서 원자가 사용자 정의 업데이트 구독을 변경할 때 다시 렌더링해야 하는 구성 요소의 양을 최적화하기 위해 사용됩니다.

반응 실험 반동 실험 사용변형 가능useRef를 사용하여 원자 상태를 소스하고 저장합니다. Jotai는 useMutable을 에뮬레이트하는 use-context-selector로 생성된 컨텍스트에 원자 상태를 저장합니다.소스, 이전 버전의 Reactuator(reducer 사용)의 경우에 따라 reducer를 사용합니다. 이 트윗을 보세요.

상태가 저장되는 방식의 가장 큰 차이는 동시 모드일 것이다. Redux와 같은 것에 비해 두 가지 접근 방식이 더 낫지만 서로 그렇게 다르지는 않다는 것을 알 수 있습니다.


모든 데이터를 React 트리에 저장한다는 것은 앱이 React의 단일 인스턴스로 제어되지 않는 경우 Bridge를 사용하여 연결해야 한다는 것을 의미하며, 이는 Jotai와 Recoil 모두에서 사용할 수 있습니다.

잡역부
조타이의 저자들은 레코일 사용자들이 아니었기 때문에, 조타이 초기 버전에서 빠진 많은 기능들이 깃허브 이슈에서 제안되었다. 보고서를 훑어보면 그 중 일부는 (아직) 프로젝트 범위를 벗어났다는 것을 알 수 있다.

일부는 기존의 조타이 기능 위에 구현될 수 있으며 구현 예가 추가되었다. 일부는 나중에 이 기능의 필요성이 Jotai 저자들에 의해 이해되면서 라이브러리에 추가되었다.

환원제 원자(원자와 함께 환원제 사용 및 조타이/유틸리티의 환원제 원자 사용), 임머 통합(조타이/임머) 및 광학(조타이/광학) 지원과 같은 조타이 고유 기능이 있습니다. 그러나 전반적인 추세는 Recoil이 더 많은 사용 사례를 지원하기 위해 더 많은 기능을 내장하고 있다는 것입니다.

첫 번째로 눈에 띄는 기능은 비동기 선택기에서 작동하는 데 도움이 되는 기능입니다. 예를 들어 서스펜스가 적절하지 않은 컨텍스트에서 비동기 원자를 사용하려면 항상 useRecoStateLoadable과 함께 사용하거나 더 이상 오류나 약속을 던지지 않도록 RecoValueLoadable과 함께 사용할 수 있습니다.

다른 눈에 띄는 도우미로는 waitForAll, waitForAny, waitForNone, noWait 등이 있습니다.

Jotai에서 누락된 다음 기능은 RecoilCallback(및 확장하여 RecoilSnapshot을 사용)을 사용하는 것입니다. 이 기능은 React 구성 요소에서 벗어나 Recoil 상태로 직접 작업할 수 있는 훌륭한 탈출 해치가 될 수 있습니다.

Jotai는 원자 상태를 React 상태로 저장하기 때문에 Jotai에서는 그런 것을 구현할 수 없을 것이라고 생각합니다.

반동 스냅샷
이것은 나에게 조타이와 레코일의 가장 큰 차이점을 가져다준다. 스냅샷을 리코일합니다. Recoil Dev Tools가 작동하도록 만드는 데 사용됩니다.

React를 렌더링할 필요가 없는 테스트를 작성하는 데 사용할 수 있을 뿐만 아니라 로컬 스토리지, 브라우저 기록 상태 또는 URL의 지속적인 글로벌 상태와 같은 몇 가지 실험 기술에 전원을 공급하는 데 사용할 수 있습니다. 전체 상태(실제로, 상태의 불변 스냅샷)에 액세스할 수 있는 것은 매우 유용합니다. 모든 원자가 AC에 있음을 보장합니다.그들의 의존성에 대한 적합성, 심지어 비동기적인 것들.

고급 사용 사례의 경우 useRecoilTransactionObserver_를 포함하여 새 스냅샷을 생성하는 모든 트랜잭션에 대해 알림을 받을 API가 있습니다.불안정하고 Recoil Snapshot을 사용합니다.

useGotoRecoilSnapshot.snapshot.get을 사용하여 이전 스냅샷으로 전환할 수 있습니다.ID를 사용하여 상태가 이전 스냅샷으로 변경되었는지 여부를 탐지할 수 있습니다.

지속 상태
이것은 레코일이 소개되었을 때 상당히 크게 홍보된 기능 중 하나였다. 6개월이 지났지만, 나는 아직도 그것의 현재 상태에 감명을 받지 못했다.

전체적인 아이디어는 다음과 같이 설명할 수 있습니다. localStorage와 같은 영구 스토리지나 브라우저 기록이 변경될 때 상태의 일부를 저장하여 나중에 스토리지에서 해당 상태를 복원하거나 상태 간을 빠르게 이동할 수 있습니다(예: 시간 이동 또는 사용자 버그 보고서 재생성을 위한 동일한 UI 상태로 전환).

나는 너에 대해 잘 모르지만, 나는 2016년에 레덕스가 소개되었을 때 그 모든 것을 들었다.

원래 피치에서는 스냅샷을 통해 전체 상태를 저장하는 맥락에서 지속성이 언급되었습니다. 이제 원자 효과를 사용하고 효과를 사용하여 원자 상태를 서로 독립적으로 저장 및 복원하는 것이 좋습니다_불안정한

그것은 조타이와 함께 추천하는 것과 일치한다.

나는 이것에 대한 확인은 없지만, 페이스북은 반동 데이터를 유지하기 위해 어떤 도구를 사용하는 것 같다. 그러나, 그것은 절대로 오픈 소스화되거나 제대로 설명되지 않았다. 문서화는 예를 들어 임의적으로 보이지만 특정 시스템의 한계를 설명하는 것처럼 원자에 대한 키 또는 가족 원자 매개변수에 대한 원시 값을 사용하는 것이 얼마나 중요한지 설명할 것이다.

따라서 우리가 이 도구에 대해 더 많이 알고 모든 지속성 관련 API가 불안정한 것으로 표시될 때까지, 나는 Jotai가 제공하는 안정적인 API를 사용하는 것이 더 타당하다고 말하고 싶다.

개발 도구
스냅샷과 Recoil 원자 및 셀렉터에 대한 "키"를 지정하면 디버깅에 도움이 됩니다. Recoil에는 전용 개발 도구 확장 기능이 있어 앱 전체의 관찰성, 시간 이동 등을 제공합니다(현재 UI와 기능 모두 통과 가능).

Jotai는 React Dev Tools(atom.debug Label을 사용하는 경우)와 Redux Dev Tools(한 번에 하나의 원자만 디버깅할 수 있을 뿐 아니라 사용할 수 있는 원자의 종류로 제한됨)에 대한 실험적인 지원을 통해 기본적인 관찰성을 가지고 있습니다.

그러나 조만간 Recoil Dev Tools와 동등하지 않을 것입니다.

원자의 초기 값
이는 지속성과 관련이 있지만 다른 이유로 사용될 수 있습니다. 예를 들어, 서버 측 렌더링된 앱의 상태를 수화하는 데 사용할 수 있습니다. 모든 원자 값을 초기화할 수 있는 한 곳이 있는데, Recoil과 매우 유사할 것입니다.

<RecoilRoot initializeState={({set})} => {set(counterState, 1); }}>
그리고 조타이를 위해:
<초기값 제공={[counterAtom, 1] asconst}>

리코일이 수행하는 방식은 유형 안전(0.0.10 이후)인 반면, 조타이에서는 초기 값의 유형이 실질적으로 [any,any][]라는 점에 주목해야 한다. 값이 서버에 의해 생성되고 개발자에 의해 Typescript에 하드코딩되지 않은 경우에는 여전히 무트 포인트일 수 있습니다.

이 기사를 마무리하기 전에, 나는 몇 가지 작은 점들을 언급하고 싶다.

두 프로젝트 모두 아직 서버 측 렌더링에 대한 공식적인 지원은 없지만 온라인에서 수행하는 방법에 대한 레시피가 있습니다.
그 프로젝트들이 얼마나 잘 지원될 것인지 알 수 있는 충분한 데이터가 지금 당장은 없다. 예를 들어, 불변의-js-oss는 "페이스북에서 사용되고 있다"가 충분히 좋은 지표가 아니라는 것을 보여준다.
Jotai는 작은 크기, 수동 React 컨텍스트보다 빠를 수 있는 런타임, 공급자의 범위 필드 등 자신의 라이브러리를 작성할 때 훌륭한 옵션을 제공하는 특별한 기능이 있습니다.
나는 시험을 위해 어느 쪽이 더 나은지 말하기에 충분한 경험이 없다.
재미있는 참고: 작업 항목 목록을 작업할 때도 원자 ID를 사용할 수 있고 ID나 키를 가질 수 없습니다(Atom을 수행하려면 0.12 이후).키가 to doAtom.toString()이 됩니다.

## Zustand를 사용한 이유는 무엇인가요?
## Jotai/Recoil의 컨셉은 무엇인가요?
Context의 re-rendering 문제가 가장 크리티컬했습니다. 컴포넌트의 상태와 상관 없이 Context가 업데이트 되면 Context 하위의 모든 컴포넌트는 전부 리렌더링되니까요. 이를 회피하기 위해 dispatch/state 분리해서 별도의 컨텍스트로 만들기, 필요한 값은 memoization하기, Context의 지연 업데이트 등이 있었으나 이렇게까지 해야했을까 했습니다. useContextSelector라는 지연평가 훅이 최근에 머지되었던데...

Jotai는 use-context-selector라는 라이브러리로 Context의 변경점만 반영될 수 있도록 접근했습니다.

기본 철학은 useState와 useReducer 같은 기존 리액트의 사용성을 그대로 가져오면서 core api는 minimalistic 하게 디자인되어 있습니다.

Jotai 는 Context의 re-rendering 문제를 해결하기 위해 만들어진 React 특화 상태관리 라이브러리
Recoil 에서 영감을 받아, atomic 한 상태관리 방식으로 구성됨 (bottom-up 방식)

기본적으로 re-rendering 문제를 줄여주고, selectAtom, splitAtom 과 같은 re-rendering 을 줄이기 위한 유틸들도 지원한다.
보일러 플레이트 코드가 redux에 비하면 현저하게 줄어든다.
앞으로 React 의 주요 feature일 Suspense(Concurrent mode)를 적용하는데에 적합하게 설계되었다.
Jotai 가 강조하는 두가지 특징
Primitive: 리액트 기본 state 함수인 useState 와 유사한 인터페이스
Flexible: atom들끼리 서로 결합 및 상태에 관여할 수 있고, 다른 라이브러리들과 원할한 결합을 지원한다.

useState + useContext 대체하는 경우 - jotai
react 이외에서도 사용해야 되는 경우 - zustand
code splitting이 중요한 경우 - jotai
redux devtools를 선호하는 경우 - zustand
react suspense를 활용하고 싶은 경우 -jotai
이외에도 bottom-top(jotai)와 top-bottom(zustand)로 이루어져 있으면 jotai의 경우 react-query 등의 다른 라이브러리들과 쉽게 연동할 수 있다는 장점이 존재한다.

Zustand 는 기본적으로 Centralized된 큰 store 안에 여러 state 들이 담긴다면, Jotai는 recoil 과 같이 primitive한 atoms 형태로 되어있다.
Zustand 의 store 은 하나의 큰 object. (Top-down 방식)
Jotai 의 state들은 원자 형태로 이루어짐. (Bottom-up 방식)
Zustand는 store 중심으로 이루어져있으며, context 에 맞게 여러 store들을 선언하며, useStore 훅을 이용해서 해당 store를 이용하는 방식이다.
Jotai 와 Zustand 는 개발진이 같다고 하며, jotai 는 recoli, zustand 는 redux 의 형태와 유사하다.
그래서 두 공식문서 모두 Pmdnrs docs 에서 확인이 가능하다. (https://docs.pmnd.rs/)
여담으로, 자바스크립트 라이브러리 계의 유명인 Kent C. Dodds 는 jotai를 경험상 선호한다고 한다.

## 발행-구독 모델이란 무엇인가요?
발행-구독 모델은 비동기 메시징 패러다임으로 발신자의 메시지는 특별한 수신자가 정해져 있지 않습니다. 대신 발행된 메시지는 정해진 범주에 따라, 각 범주에 대한 구독을 신청한 수신자에게 전달됩니다. 수신자는 발행자에 대한 지식이 없어도 원하는 메시지만을 수신할 수 있으며 이러한 발행자와 구독자의 디커플링은 높은 확장성을 허용합니다.

# React-Query
# GraphQL
GraphQL 은 API를 위한 쿼리 언어(Query Language)이며 타입 시스템을 사용하여 쿼리를 실행하는 서버사이드 런타임입니다. GraphQL은 특정한 데이터베이스나 특정한 스토리지 엔진과 관계되어 있지 않으며 기존 코드와 데이터에 의해 대체됩니다.

쿼리 언어(Query Language)
쿼리 언어는 정보를 얻기 위해 보내는 질의문(Query)를 만들기 위해 사용되는 컴퓨터 언어이다. 가장 잘 알려져있는 예시로는 데이터베이스 시스템에 저장된 데이터를 가져오기 위해 사용하는 SQL이 있다.

GraphQL(Graph Query Language)
SQL이 데이터베이스 시스템으로부터 데이터를 가져오는 목적을 가진다면, GraphQL은 클라이언트가 데이터를 서버로부터 가져오는 것을 목적으로 한다.

## GraphQL을 도입한 이유는 무엇인가요?
보통 하나의 엔드포인트를 가지며 요청할 때 사용하는 쿼리에 따라 다른 응답을 받을 수 있습니다. 또한 원하는 데이터(response)만 받을 수 있습니다.

## GraphQL vs REST API
원하는 정보를 하나의 쿼리에 모두 담아 요청 할 수 있어 HTTP 요청 횟수를 줄이고, 모바일 환경에서의 HTTP 응답 사이즈를 줄여 부담을 최소화하고 프론트엔드-백엔드 개발간 의사소통 비용을 줄일 수 있습니다.



# 서비스 UI/기획을 일부 진행하셨는데 무엇을 하셨고 어떤 성과를 내셨나요?

# CI/CD는 어덯게 구축했나요?

# 코드 컨벤션을 정립한 이유는 무엇이고 어떤 것을 작성했나요? 성과는?

# 디자인 시스템을 직접 구축하셨는데...
## 가장 어려웠던 부분은 무엇인가요?
## 반드시 고려해야 하는 부분은 무엇인가요?
> 기술적인 트러블슈팅 녹이기
## 아토믹 디자인 시스템에 대해 설명해주세요.
## UI 테스트는 무엇이 있나요?

## ESM의 특징
구성, 인스턴스화, 평가 세 단계로 이루어집니다.

첫 단계로 로드해야 하는 모듈을 파악하기 위해 종속성 트리를 구성하고, 그래프의 시작점이 될 파일을 명시하여 import 문을 따라가며 종속성 트리를 생성합니다. import로 연결된 파일 자체는 브라우저가 사용할 수 없으므로 Module Record 구조로 변환해야 합니다.

두 번째 단계로 모듈 레코드를 모듈 인스턴스(code, state가 결합된 형태)로 변환합니다. import할 모든 값을 할당할 메모리 공간을 찾는 과정이자 export / import 모두 해당 메모리를 가리키도록 합니다.

세 번째 단계 코드를 실행하여 변수의 실제 값으로 메모리를 채웁니다.

이 세 단계는 개별적으로, 또는 비동기적으로 수행될 수 있습니다.

특징으로는 아래와 같습니다.
1. 정적 구조 : 라이브러리의 정보를 정적으로 파악할 수 있어 access를 최적화 할 수 있습니다. export 문은 ESM의 최상위 레벨에만 위치하며, 컴파일러가 ESM을 좀 더 쉽게 해석할 수 있게 합니다.
2. 메모리 바인딩 : export 한 곳에서 값을 변경하면 해당 변경사항이 import 한 곳에서도 변경한 값이 반영됩니다. 이는 CJS가 다른 메모리 주소를 바라보기 때문입니다. 반면 ESM은 동일한 메모리 주소를 바라봅니다.

# 번들러
## 트리 쉐이킹이 무엇인가요?
최종 번들 결과물 관점에서 불필요한 코드가 없어지는 과정입니다. 트리 쉐이킹은 ES6의 import/export문에 의존하며 JavaScript 파일 간의 참조 여부를 판단합니다. 즉, ESM 형식이 트리 쉐이킹을 가능하게 합니다.
ESM은 정적인 구조를 가지기 때문에 빌드 타임에 모듈간 관계를 파악하고 이를 기반으로 사용하지 않는 코드를 제거하는 작업도 가능합니다.

ESM의 경우 참조되지 않는 함수, 주석/공백 제거 등의 작업이 수행됩니다. CJS를 빌드하면 결과물에 __webpack_require__가 포함되어 모든 모듈을 포함하는 형태로 번들됩니다.

webpack은 트리 쉐이킹을 usedExports(사용한 모듈 export)와 sideEffects(사용되지 않았고, sideEffects가 없는 모듈은 건너뛴다) 두 가지 옵션으로 적용할 수 있습니다. sideEffects는 모듈을 import 하는 것만으로 실행되는 코드를 뜻합니다.

## 코드 스플리팅은 무엇인가요?
## webpack vs rollup vs vite
1. webpack : 오랫동안 사용되어 개발 레퍼런스가 다양해 가장 안정적인 번들러이며 로더를 통해 JS 모듈과 JS 이외의 모듈들을 통합합니다. 많은 서드파티를 필요로 하는 복잡한 애플리케이션에 주로 활용됩니다. 
2. rollup : ES6 모듈 형식으로 빌드 결과물을 생성할 수 있는 번들러로서 진입점을 다르게 설정하여 번들링 가능하고, 최소한의 서드파티로 라이브러리를 만들기 위해 주로 활용합니다. 의존성 관계를 파악하여 그래프를 생성하고, 이를 AST로 치환하여 구문 분석 후 옵션에 맞게 결과물을 만드는 과정으로 이루어집니다. 불필요한 번들을 제거하는 방식이 아니라, 최종 번들 파일에서 포함되어야 한다고 판단된 모듈을 포함하는 원리로 수행됩니다.
3. vite : 로컬에서 개발할 때 번들링을 하지 않고 ESM 방식을 사용하기 때문에 로컬 서버 구동 속도가 매우 빠릅니다.

Vite의 개발 서버는 꽤 강력하다. Vite는 프로젝트의 모든 의존성을 esbuild를 이용해 단일 기본 자바스크립트 모듈로 사전 번들링을 진행한다. 그 후에 많은 캐시 된 HTTP 헤더와 함께 제공된다. 즉, 첫 페이지 로드 후 가져온 의존성을 컴파일, 제공 또는 요청하는 데 시간이 낭비되지 않는다. 또한 Vite는 명확한 에러 메시지들을 제공하고 문제를 해결하기 위해 정확한 코드 블록과 줄 번호를 보여준다. Vite를 사용하면 노드 API 또는 레거시 형식을 사용하는 의존성을 가져오는 데 문제가 없었다. 모두 브라우저에서 허용되는 esmodule로 변환하는 것처럼 보였다.


# 테스트
## 테스트 피라미드는 무엇인가요? 어떤 것을 구축했나요?
## Dockerfile은 무엇인가요?
## EKS에 대해 설명해주세요.
## 어떤 파이프라인을 구축했나요? 어떻게 작업했나요?

# 코드 컨벤션
## eslint, prettier, husky, commitlint 등에 대한 전반적인 질문

# 플랫폼 서비스 쿠키 공유에 대해 설명해주세요.
## http-proxy-middleware는 무엇인가요?
## 커스텀 서버를 만들면 Next.js에는 무슨 일이 일어나나요?
## 프록시란 무엇인가요?
## 리버스 프록시란 무엇인가요?
## 어떻게 설정할 수 있나요?
## CORS에 대해 설명해주세요.

# FOUC란 무엇인가요?

# 스켈레톤 UI를 사용할 때의 장점과 단점을 설명해 주세요.

# React
- 렌더링이 뭘까요?
- 렌더링 프로세스 개요
- 렌더 및 커밋 단계
- 리액트는 어떤 방식으로 렌더링할까요?
- 렌더링 큐에 렌더링 등록하기
- 일반적인 렌더링 동작
- 리액트 렌더링 규칙
- 컴포넌트 메타데이터와 파이버(Fibers)
- 컴포넌트 타입(Component Types)과 재조정(Reconciliation)
- Key와 재조정
- 렌더링 일괄 처리(Render Batching)와 타이밍
- 비동기 렌더링, 클로저 그리고 상태 스냅샷
- 렌더링 동작 엣지 케이스
- 렌더링 성능 개선
- 컴포넌트 렌더링 최적화 기법
- Props 참조가 렌더링 최적화에 미치는 영향
- Props 참조 최적화
- 전부 메모이제이션할까요?
- 불변성(Immutability)과 리렌더링
- 리액트 컴포넌트 렌더링 성능 측정
- 컨텍스트(Context)와 렌더링 동작
- 컨텍스트 기초
- 컨텍스트 값 업데이트
- 상태 업데이트, 컨텍스트 그리고 리렌더링
- 컨텍스트 업데이트와 렌더링 최적화
- 컨텍스트와 렌더러 경계(Renderer Boundaries)
- React-Redux와 렌더링 동작
- React-Redux 구독(Subscriptions)
- connect와 useSelector의 차이
- "React Forget" 메모이징 컴파일러
- Context Selectors

## React Class Component 생명주기
1. 마운트 : constructor -> getDerivedStateFromProps -> (렌더링) -> componentDidMount
2. 업데이트 : getDerivedStateFromProps -> (렌더링) -> componentDidUpdate
3. 언마운트 : componentWillUnmount

## React Hook 생명주기
1. 마운트 : 함수 컴포넌트 실행 > (useMemo 실행) > JSX 반환 > (렌더링) > (useEffect, useLayoutEffect 실행) > 이펙트가 다시 실행되기 전에 clean up 함수 실행
2. 업데이트 : next props 주입 > useState, useReducer, useContext 실행 > (useCallback 실행) > (렌더링) > (useEffect, useLayoutEffect 실행) > 이펙트가 다시 실행되기 전에 clean up 함수 실행

## useEffect 생명주기
1. componentDidMount
2. componentDidUpdate
3. componentWillUnmount

## setState가 비동기적으로 동작하는 이유는 무엇인가요?
리액트 문서에서 언급하는 것 중 하나는 state 업데이트는 비동기 적일 수 있다는 사실입니다. 특히 리액트는 리액트 이벤트 핸들러에서 발생하는 상태 업데이트를 자동으로 일괄적으로 처리하는데, 일반적인 리액트 애플리케이션에서 매우 큰 부분을 차지하기 때문에 주어진 앱의 대부분의 상태 업데이트가 실제로 일괄적으로 처리된다는 것을 의미합니다.

## useMemo, useCallback 사용처
그 전에, 함수 컴포넌트는 단지 jsx를 반환하는 함수입니다.

컴포넌트가 렌더링 된다는 것은 누군가가 그 함수(컴포넌트)를 호출하여서 실행되는 것을 말한다. 함수가 실행될 때마다 내부에 선언되어 있던 표현식(변수, 또다른 함수 등)도 매번 다시 선언되어 사용된다.

컴포넌트는 자신의 state가 변경되거나, 부모에게서 받는 props가 변경되었을 때마다 리렌더링 된다. (심지어 하위 컴포넌트에 최적화 설정을 해주지 않으면 부모에게서 받는 props가 변경되지 않았더라도 리렌더링 되는게 기본이다. )

## react의 동시성
이번에 리액트 18에서 나온 Concurrent Mode의 경우, 브라우저가 이벤트를 처리할 수 있도록 렌더링 단계에서 작업을 일시 중지 할 수 있습니다. 리액트는 해당 작업을 나중에 다시 시작하거나, 버리거나, 다시 계산할 수 있습니다. 렌더링이 패스가 된 이후에도, 리액트는 커밋단계를 한단계 동기적으로 실행합니다.


실험적 기능으로, CPU 바운드 업데이트(예를 들어 DOM 노드 만들기 및 컴포넌트 코드 실행)의 경우 Concurrency는 더욱 긴급한 업데이트가 이미 시작한 렌더링을 “중단” 할 수 있음을 의미합니다.
IO 바운드 업데이트(예를 들어 네트워크에서 코드나 데이터를 가져오는 것)의 경우 Concurrency는 모든 데이터가 도달하기 전에 React가 메모리에서 렌더링을 시작할 수 있으며 빈 로딩 state표시를 무시할 수 있습니다.
React Concurrent 모드는 내부작업들의 우선순위를 결정하고, 이는 최종적으로 사람-컴퓨터 간 상호작용에 대한 연구 결과가 실제 UI와 통합되도록 돕습니다. 또한, concurrent 모드를 사용하는지 여부와 상관없이 개발자의 입장에서는 기존의 컴퍼넌트, 프롭스, 스테이트 등 근본적으로 같은 방식으로 리액트를 사용할 수 있다는 것입니다.




## ErrorBoundary에 대해 설명해주시고 어떻게 커스텀했는지 말해주세요.
## react-query의 useQueryErrorResetBoundary를 어떻게 적용했나요?

## 성능 최적화는 어느 시점에 이루어지나요?

## Reflow에 대해 설명해주세요.

## Transform 속성에 대해 설명해주세요.

## Common Type, Props를 어떻게 분리했나요?

## 제어/비제어 컴포넌트에 대해 설명해주세요.

## Browser, Client 호환성이란 무엇인가요? 어떻게 고려했나요?

## package.json의 속성에는 무엇이 있나요?

## dependencies, devDependencies, peerDependencies
1. dependencies : 런타임과 빌드타임, 개발 시 종속성 패키지들이 필요하기 때문에 앱이 빌드 될 때 이 종속성 패키지들이 번들에 포함되어 배포됩니다.
2. devDependencies : 빌드 타임 & 개발중에만 필요한 패키지로 빌드 타임에서 이 종속성들은 빌드에 도움을 주거나 참조가 되지만, 번들에는 포함되지 않습니다.
3. peerDependencies : 실제로 패키지에서 직접 require(import) 하지는 않더라도 호환성이 필요한 경우 명시합니다.


## 웹 성능 지표에는 무엇이 있나요?

## TTFB 개선 방법은 무엇인가요?
1. 콘텐츠 전달 네트워크 콘텐츠 전송 
- 네트워크 ( CDN은 )  가 가장 가까운 네트워크 노드를 사용하여 방문하는 웹 사이트에서 다운로드 데이터에 사용자를 허용 서버의 지리적으로 분산 된 네트워크입니다. 이렇게하면 웹 사이트가 다운로드 및 페이지로드 속도가 빨라지고 사용자 경험이 향상됩니다. CDN 의  사용은  모든 종류의 웹 사이트에 필요하지 않으므로 해당 서비스를 사용하는지 여부를 이해하는 것이 유용합니다.

2. 애플리케이션 코드 최적화
- 애플리케이션 코드는 웹 사이트 최적화에서 중요한 부분입니다. 애플리케이션 코드와 관련하여 TTFB의 속도를 높이는 데 도움이되는 몇 가지 조치는로드 밸런서 추가 및 정적 및 동적 콘텐츠 캐시, 웹 서버에 설치된 소프트웨어 업데이트, 리버스 프록시 서버를 사용하여 애플리케이션 가속화 및 보안 등입니다. 또한 데이터를 압축하고 HTTP / 2를 구현하고 웹 서버 성능 및 라이브 활동을 모니터링하여 가능한 병목 현상을 식별합니다.

3. 데이터베이스 쿼리 최적화 데이터베이스 쿼리
- 먼저 인덱스를 적절하게 만들고 실제로 필요한 데이터 만 검색해야합니다. 또한 연산자의 왼쪽에있는 함수를 사용하지 않도록하므로 쿼리에 응답하기 위해 전체 데이터베이스를 읽을 필요가 없습니다. 상호 관련된 하위 쿼리는 다른 쿼리에 의존하고 프로세스 속도를 늦추므로 피하십시오.

4. HTTP 요청 줄이기 HTTP 요청
- 웹 사이트에서 현재 요청하는 수를 확인하고 불필요한 이미지를 제거해야합니다. 그런 다음 나머지 이미지의 파일 크기를 줄이고로드 속도에 영향을 미칠 수있는 요소를 분석하여 진행할 수 있습니다. TTFB를 최적화하기 위해 할 수있는 다른 작업은 JavaScript를 비동기로 만들고 CSS 파일을 함께 결합하는 것입니다.

5. 빠른 서버 응답 시간 보장
- 여기에서도 CSS 및 JavaScript 파일에 개입하고 외부 파일을 결합하는 것이 중요합니다. 어떤 경우에는 작은 인라인 CSS 및 JavaScript 파일을 사용하여 HTML 파일 자체에 넣을 수 있으므로 외부 리소스가 필요하지 않으며 추가 호출이 필요하지 않습니다. 대역폭을 절약하고 페이지로드 시간을 줄이는 데 도움이되므로 이미지 지연도 중요합니다.

6. RFPL (Respond First, Process Later) 캐시
- 사용이 캐시 방법을 사용하면 사용자는 이전에 캐시 된 응답을 즉시 볼 수 있으며 동시에 서버는 여전히 백그라운드에서 요청을 처리합니다. 이렇게하면 사용자가 응답을 기다리지 않습니다.


## 렌더링 최적화란 무엇인가요?

---

# 자기소개 짧게 해주세요.
안녕하세요, 제 이름은 소인성이고 4년차 프론트엔드 개발자입니다. 저는 넥스트유니콘이라는 서비스 회사에서 개발 생산성과 일관된 사용자 경험을 위한 공통 라이브러리들을 퍼블리시했으며 신사업의 프론트엔드를 저장소 생성부터 배포까지 진행한 경험이 있습니다. 원인을 찾아 명료히 분석하고 기술을 적용하기 까지 깊게 고민하는 경험, 동반 성장하는 환경을 열망하여 귀사에 지원하게 되었습니다.

# 구성원들의 평균 경력은 어떻게 되나요?
신입부터 7년차까지 다양하게 분포되어 있습니다.

# 구성원들간의 갈등을 어떻게 해결했나요?
적극적으로 경청하고 

# 리더로써 무엇을 했나요?

# 현 회사에 다닌지 10개월밖에 되지 않았는데 지원하신 이유가 무엇인가요?
저는 도전과 성장으로 자아를 실현합니다. 많은 개발자들의 간절한 심정으로 귀사의 우아한 테크 코스, 우아한 테크 캠프에 참여하기 위해 기술을 갈고 닦는데, 귀사는 이런 인원들의 방향을 제시해줄 수 있는 스승들이 많은 공간이라고 생각됩니다. 나이, 성별, 신분에 상관 없이 배움의 장을 공유하고 벽을 깨려고 노력하는 사람들과 함께 격정적으로 고난에 부딪히고 극복하면서 기술적 한계를 돌파하고자 지원하게 되었습니다.

# 본인이 생각하는 기술적 한계는 무엇인가요?
현재의 기술적 한계는 자바스크립트의 한계와 일치합니다. 지나친 유연함, 보안 취약점, 디버깅 어려움, 브라우저 호환성, 렌더링 중지 등을 함께 고민하고 대처하고 싶습니다.

# 프론트엔드 개발자를 선택한 이유?
기술적 특이점에 대비하고 싶었습니다. 지금도 많은 언어, 라이브러리, 프레임워크가 등장하고 있는데 자바스크립트만은 특정한 한계 없이 브라우저만 동작하면 개발자 도구를 열어서 코드를 작성할 수 있기 때문에 마치 영어처럼 공용어로 자리잡을 것이라 생각했습니다. 

# 리더라는 직책에서 개발자가 되는 것인데 부담이 없는지

# 개발자의 역할에 대해 어떻게 생각하시나요?
기능 관점, 목적 관점으로 나눠볼 수 있을 것 같습니다. 프로덕트의 성공으로 이윤을 추구하기 위해서는 프로덕트팀과 개발팀이 협의한 시간 내에 적절한 기술로 개발해야 합니다. 

<hr />
<br />



# 브라우저의 비동기 이벤트 루프가 하는 일에 대해 상황과 함께 설명해주세요.




# 캐시를 다뤘던 경험이 있나요?

# 성능 분석 지표에는 무엇이 있나요?

# 프로토타입에 대해 설명해주세요.


# YAGNI 원칙
> 익스트림 프로그래밍(XP)의 원칙
실제로 필요할 때 무조건 구현하되, 그저 필요할 것이라고 예상할 때에는 절대 구현하지 말라

# viewport