# 정규표현식
> 정규표현식이란 String의 검색, 치환, 추출을 위한 패턴입니다. **소프트웨어** 별로 방식, 지원 범위가 다를 수 있음을 주의하세요.

<br>

## 정규표현식 테스트 사이트
regular expressions 101 [Link](https://regex101.com/)<br>
RegExr [Link](https://regexr.com/)<br>
REGEXPER [Link](https://regexper.com/)<br>

<br>

## 정규표현식의 패턴

|패턴|설명|
|----|----|
|`^`|줄(Line)의 시작에서 일치, `/^abc/`|
|`$`|줄(Line)의 끝에서 일치, `/xyz$/`|
|`.`|임의의 한 문자와 일치|
|`a|b`|a 또는 b와 일치, 인덱스가 작은 것을 우선 반환|
|`*`|0회 이상 연속으로 반복되는 문자와 가능한 많이 일치, `{0,}`와 동일|
|`*?`|0회 이상 연속으로 반복되는 문자와 가능한 적게 일치(lazy), `{0}`와 동일|
|`+`|1회 이상 연속으로 반복되는 문자에 가능한 많이 일치, `{1,}`와 동일|
|`+?`|1회 이상 연속으로 반복되는 문자에 가능한 적게 일치(lazy), `{1}`와 동일|
|`?`|없거나 1회 가능한 많이 일치|
|`??`|없거나 1회 가능한 적게 일치(lazy)|
|`{3}`|3(숫자)개 연속 일치|
|`{3,}`|3개 이상 연속 일치|
|`{3,5}`|3개 이상 5개 이하(3~5개) 연속 일치|
|`{3,5}?`|3개 이상 5개 이하(3~5개) 연속 중 가능한 적은 3개 연속 일치(lazy), `{3}`와 동일|
|`()`|캡처(Capture)할 그룹|
|`(?<>)`|캡처 그룹 이름 지정, `/(?<name>pattern)/` **ES2018**|
|`\1~9`|정규식 내 캡처된 값 참조, `/(abc)\1/`|
|`(?:)`|캡처(Capture)하지 않는 그룹|
|`(?=)`|앞쪽 일치(Lookahead), `/ab(?=c)/`|
|`(?!)`|부정 앞쪽 일치(Negative Lookahead), `/ab(?!c)/`|
|`(?<=)`|뒤쪽 일치(Lookbehind), `/(?<=ab)c/` **ES2018**|
|`(?<!)`|부정 뒤쪽 일치(Negative Lookbehind), `/(?<!ab)c/` **ES2018**|
|`[abc]`|a 또는 b 또는 c와 일치, 점(`.`)이나 별표(`*`) 같은 특수 문자는 `[]`안에서 특수 문자가 아님, `/\.[.]/`|
|`[a-z]`|a부터 z 사이의 문자 구간에 일치(영어 소문자)|
|`[A-Z]`|A부터 Z 사이의 문자 구간에 일치(영어 대문자)|
|`[0-9]`|0부터 9 사이의 문자 구간에 일치(숫자)|
|`[가-힣]`|가부터 힣 사이의 문자 구간에 일치(한글)|
|`[2-7]`|2부터 7 사이의 문자 구간에 일치(2,3,4,5,6,7)|
|`[b-f]`|b부터 f 사이의 문자 구간에 일치(b,c,d,e,f)|
|`[다-바]`|다부터 바 사이의 문자 구간에 일치(다,라,마,바)|
|`[^abc]`|a 또는 b 또는 c가 아닌 나머지 문자에 일치(부정)|
|`\`|이스케이프 문자, `/\.\?\/\$\^/`|
|`\b`|63개 문자(영문 대소문자 52개 + 숫자 10개 + `_`(underscore))가 아닌 나머지 문자에 일치하는 경계(boundary)|
|`\B`|63개 문자에 일치하는 경계|
|`\d`|숫자(Digit)에 일치|
|`\D`|숫자가 아닌 문자에 일치|
|`\p{}`|유니코드 속성(Property) 집합에 맞는 문자에 일치, `/\p{Emoji}/u` **ES2018**|
|`\P{}`|유니코드 속성 집합에 맞지 않는 문자에 일치, `/\p{Uppercase}/u` **ES2018**|
|`\s`|공백(Space, Tab 등)에 일치|
|`\S`|공백이 아닌 문자에 일치|
|`\w`|63개 문자(Word, 영문 대소문자 52개 + 숫자 10개 + `_`)에 일치|
|`\W`|63개 문자가 아닌 나머지 문자에 일치|
|`\x`|16진수 문자에 일치, `/\x61/`는 `a`에 일치|
|`\0`|8진수 문자에 일치, `/\141/`은 `a`에 일치|
|`\u`|유니코드(Unicode) 문자에 일치, `/\u0061/`는 `a`에 일치|
|`\c`|제어(Control) 문자에 일치|
|`\f`|폼 피드(FF, U+000C) 문자에 일치|
|`\n`|줄 바꿈(LF, U+000A) 문자에 일치|
|`\r`|캐리지 리턴(CR, U+000D) 문자에 일치|
|`\t`|탭 (U+0009) 문자에 일치|
|$`|문자 대체(replace) 시 일치한 문자 이전 값 참조|
|`$'`|문자 대체(replace) 시 일치한 문자 이후 값 참조|
|`$+`|문자 대체(replace) 시 마지막으로 캡처된 값 참조|
|`$&`|문자 대체(replace) 시 일치한 문자 결과 전체 참조|
|`$_`|문자 대체(replace) 시 입력(input)된 문자 전체 참조|
|`$1~9`|문자 대체(replace) 시 캡처(Capture)된 값 참조|

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## 정규표현식 바이블
### :mag_right:프로토콜, 호스트명, 포트 번호 및 경로를 검증하기
```sql
-- 첫번째
https?://(\w*:\w*@)?[-\w.]+(:\d+)?(/([\w/_.]*(\?\S+)?)?)?

-- 두번째
/^(file|gopher|news|nntp|telnet|https?|ftps?|sftp):\/\/([a-z0-9-]+\.)+[a-z0-9]{2,4}.*$/

-- 세번째
-- 도메인 형태, http:// https:// 포함안해도 되고 해도 되고
/^(((http(s?))\:\/\/)?)([0-9a-zA-Z\-]+\.)+[a-zA-Z]{2,6}(\:[0-9]+)?(\/\S*)?$/

-- 네번째
-- 도메인 형태, http:// https:// 꼭 포함
/^((http(s?))\:\/\/)([0-9a-zA-Z\-]+\.)+[a-zA-Z]{2,6}(\:[0-9]+)?(\/\S*)?$/

-- 다섯번째
-- 도메인 형태, http:// https:// 포함하면 안됨
/^[^((http(s?))\:\/\/)]([0-9a-zA-Z\-]+\.)+[a-zA-Z]{2,6}(\:[0-9]+)?(\/\S*)?$/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:이메일 주소 검증하기
```sql
-- 첫번째
(\w+\.)*\w+@(\w+\.)+[A-Za-z]+

-- 두번째
/^[a-z0-9_+.-]+@([a-z0-9-]+\.)+[a-z0-9]{2,4}$/

-- 세번째
/^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:HTML 태그 찾기
```sql
/\<(/?[^\>]+)\>/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:HTML의 주석 `<!-- -->` 찾기
```sql
<!-{2,}.*?-{2,}>
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:일반적인 프로그래밍 언어의 주석 `//`, `/*` 찾기
```sql
\/\/.*
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:신용카드 번호 검증하기
```sql
-- 마스터카드
5[1-5]\d{14}

-- 비자카드
4\d{12}(\d{3})?

-- 아메리칸 익스프레스카드
3[47]\d{13}

-- 디스커버카드
6011\d{12}

-- 위의 카드 중 하나와 맞는지 검증하기
(5[1-5]\d{14})|(4\d{12})(\d{3}?)|3[47]\d{13}|(6011\d{12})
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:전화번호 검증하기
```sql
-- 첫번째
/(\d{3}).*(\d{3}).*(\d{4})/ -- 123-123-2344 혹은 123-1234-1234

-- 두번째
/^\d{2,3}-\d{3,4}-\d{4}$/ -- 123-123-2344 혹은 123-1234-1234

-- 세번째
/^[0-9]{2,3}-[0-9]{3,4}-[0-9]{4}$/ -- 000-0000-0000만 가능
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:날짜 검증하기
```sql
-- 3/28/2007 혹은 3/28/07
/^\d{1,2}\/\d{1,2}\/\d{2,4}$/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:jpg, gif 또는 png 확장자를 가진 그림 파일명 찾기
```
/([^\s]+(?=\.(jpg|gif|png))\.\2)/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:1부터 50 사이의 번호 찾기
```
/^[1-9]{1}$|^[1-4]{1}[0-9]{1}$|^50$/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:16진수로 이루어진 색깔 번호 검증하기
```
/#?([A-Fa-f0-9]){3}(([A-Fa-f0-9]){3})?/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:비밀번호 검증하기
```sql
-- 적어도 소문자 하나, 대문자 하나, 숫자 하나가 포함되어 있는 8글자 이상 15글자 이하 문자열 검증하기
/(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,15}/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:영문 검증하기
```sql
-- 영문만 가능하며 띄어쓰기 불가능
/^[a-zA-Z]+$/ 

-- 영문과 띄어쓰기 가능
/^[a-zA-Z\s]+$/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:한글 검증하기
```sql
-- 가나다라 형식이며 ㄱㄴㄷ… 형식과 띄어쓰기 불가능
/^[가-힣]+$/

-- 가나다라 형식이며 ㄱㄴㄷ… 형식으로는 입력 불가능, 띄어쓰기 가능
/^[가-힣\s]+$/

-- ㄱㄴㄷㄹ(자음), ㅏㅑㅗㅛ(모음) 및 띄어쓰기도 가능
/^[ㄱ-ㅣ가-힣\s]+$/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:숫자 검증하기
```sql
-- 0 ~ 9 형식이며 띄어쓰기 불가능
/^[0-9]+$/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:한글과 영문 검증하기
```
/^[가-힣a-zA-Z]+$/;
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:숫자, 영문 검증하기
```
/^[a-zA-Z0-9]+$/;
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>

### :mag_right:주민번호 검증하기
```sql
-- 첫번째
/^(?:[0-9]{2}(?:0[1-9]|1[0-2])(?:0[1-9]|[1,2][0-9]|3[0,1]))-[1-4][0-9]{6}$/

-- 두번째
/\d{6} \- [1-4]\d{6}/
```

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<br>