> 선행 : 언어 파트를 어느정도 이해하고 있어야 합니다.

## Java

### :book: [Spring Framework](https://github.com/InSeong-So/IT-Note/blob/master/chapter04.5-%ED%94%84%EB%A0%88%EC%9E%84%EC%9B%8C%ED%81%AC/spring.md#%EC%8A%A4%ED%94%84%EB%A7%81-%ED%94%84%EB%A0%88%EC%9E%84%EC%9B%8C%ED%81%AC)
1. [DI(Dependency Injection)](https://github.com/InSeong-So/IT-Note/blob/master/chapter04.5-%ED%94%84%EB%A0%88%EC%9E%84%EC%9B%8C%ED%81%AC/spring.md#book-didependency-injection)
2. [생명주기(Life Cycle)](https://github.com/InSeong-So/IT-Note/blob/master/chapter04.5-%ED%94%84%EB%A0%88%EC%9E%84%EC%9B%8C%ED%81%AC/spring.md#book-%EC%83%9D%EB%AA%85%EC%A3%BC%EA%B8%B0life-cycle)
3. [웹 프로그래밍 설계 모델](https://github.com/InSeong-So/IT-Note/blob/master/chapter04.5-%ED%94%84%EB%A0%88%EC%9E%84%EC%9B%8C%ED%81%AC/spring.md#book-%EC%9B%B9-%ED%94%84%EB%A1%9C%EA%B7%B8%EB%9E%98%EB%B0%8D-%EC%84%A4%EA%B3%84-%EB%AA%A8%EB%8D%B8)
4. [웹 어플리케이션 구조](https://github.com/InSeong-So/IT-Note/blob/master/chapter04.5-%ED%94%84%EB%A0%88%EC%9E%84%EC%9B%8C%ED%81%AC/spring.md#book-%EC%9B%B9-%EC%96%B4%ED%94%8C%EB%A6%AC%EC%BC%80%EC%9D%B4%EC%85%98-%EA%B5%AC%EC%A1%B0)
5. [컨트롤러의 기능](https://github.com/InSeong-So/IT-Note/blob/master/chapter04.5-%ED%94%84%EB%A0%88%EC%9E%84%EC%9B%8C%ED%81%AC/spring.md#book-%EC%BB%A8%ED%8A%B8%EB%A1%A4%EB%9F%AC%EC%9D%98-%EA%B8%B0%EB%8A%A5)
6. [@RequestParam 어노테이션을 이용한 HTTP 전송 정보 얻기](https://github.com/InSeong-So/IT-Note/blob/master/chapter04.5-%ED%94%84%EB%A0%88%EC%9E%84%EC%9B%8C%ED%81%AC/spring.md#book-requestparam-%EC%96%B4%EB%85%B8%ED%85%8C%EC%9D%B4%EC%85%98%EC%9D%84-%EC%9D%B4%EC%9A%A9%ED%95%9C-http-%EC%A0%84%EC%86%A1-%EC%A0%95%EB%B3%B4-%EC%96%BB%EA%B8%B0)


<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## JavaScript
### React

<details><summary>:persevere:너무 길어요:sob: <strong>자세히보기!</strong></summary>

<br>

### 리액트 컴포넌트 설계 방법에 대해 설명해주세요.
### 리덕스 아키텍쳐는 어떻게 설계하나요?
### 프레젠테이셔널 vs 컨테이너 컴포넌트 차이점을 설명해주세요.
### 리액트의 페이지 컴포넌트는 프레젠테이션인가 컨테이너인요?
### Hooks의 등장으로 프레젠테이셔널, 컨테이너 컴포넌트의 개념이 사라졌다고 대답하셨는데 현업에선 많이 사용중이다. 왜그런지 아나?
### Nextjs에서 프레젠테이셔널 컴포넌트를 어떻게 활용할까?



### Next 버전 뭐썼나?
### Next 9버전 10버전 차이점?
### Nextjs에서 서버사이드 처리를 하기위해 작성해야하는 코드들이 있는데 어디다 작성해야하는가?(페이지 컴포넌트의 어떤영역?)
### Nextjs는 ssr을 처리할 수 있음과 동시에 csr영역도 담당하므로 여러 문제 또는 현상이 발생할 슈 있다. 예를 들어 현재 환경이 브라우저인지 서버인지 판단하기 어렵다. 어떻게 판단하면 될까?
### Reject하지않은 CRA 리액트는 csr이다. 따라서 next나 cra를 reject 처리하여 ssr을 구현하는데 왜 이렇게 번거로운 작업을 하는것인가?
### 클라이언트는 react 서버사이드 프레임워크는 next 서버는 nodejs를 사용한다고 했을때 ssr과정이 어떻게 일어나는지 코드 관점에서 구체적으로 설명해달라 (브라우저에 렌더링이 되기까지)
### Ssr을 적용하면 서버에서 데이터를 채운 html파일을 보내줘야한다. 너가 한 프로젝트에서는 그 데이터를 어디서 가져왔는가?


</details>

<br>
<hr>
<br>

### Vue

<!-- https://github.com/sudheerj/vuejs-interview-questions-korean/blob/master/README.md -->


<details><summary>:persevere:너무 길어요:sob: <strong>자세히보기!</strong></summary>

<br>

### Vue.js에 대해 간략한 설명과 장단점을 말해주세요.
- Even You(에번 유) 가 2014년도에 발표한 자바스크립트 프레임워크
- 동적인 사용자 인터페이스(UI) 를 만들기 위한 프레임워크

<br>

### Vue.js의 Life-cycle에 대해 알려주세요.
> Creation, Mounting, Updating, Destruction
Creation은 라이프사이클 중 가장 먼저 실행되는 단계이다.
이 단계의 훅에서는 DOM트리에 해당 컴포넌트가 반영이 안되므로 태그의 id나 class에 접근할 수 없다.
훅으로는 beforeCreated, created가 있는데 beforeCreated에서는 data나 event에 접근할 수 없다.
Mounting은 DOM 삽입 단계로 렌더링 되기 직전의 컴포넌트에 접근할 수 있다.
훅으로는 beforeMount, mounted가 있는데 beforeMount훅은 템플릿과 렌더 함수들이 컴파일이 되고 렌더링이되기 직전 단계에 호출이 된다.
아직 까지 DOM element에 직접적으로 접근할 수가 없다.
mounted 훅에서, 컴포넌트가 렌더링이 된 상태일 때 호출된다. DOM에 접근할 수 있지만 주의해야할 점은 자식 컴포넌트에서 마운트된 상태임을 보장할 수 없다는 점이다.
Updating은 웹페이지의 내용이나 무언가 바껴서 재렌더링을 해야할 때 실행된다.
훅으로는 beforeUpdate와 updated가 있고 beforeUpdate 훅은 DOM변경이 완료가 되고 패치가 되기 직전에 호출이된다.
updated 훅은 재 렌더링이 완료된 이후에 호출이 된다.
updated는 패치 이후에 호출되는 훅이라 변화가 끝난 DOM에 접근이 가능하다.
Destruction은 컴포넌트가 해체?파괴될 때 실행된다.
훅으로는 beforeDestroy, destroyed 단계로 beforeDestroy는 해체 직전에 호출되며 모든 DOM과 이벤트들이 남아있다.
destroyed는 해체가 완전히 된 후에 호출이되는 훅이다.
Vue.js 에서 DOM은 어느 시점에 생성되나
Computed와 Methods의 차이점은 무엇인가
가상돔(Virtual DOM) 개념은 무엇이며, DOM과의 차이점 가상돔의 개념이 사용되게된 배경은 무엇인가
최근의 프레임워크를 사용할때 외부 라이브러리와의 결합시에 더 나은 코드 작성법을 고민해본적이 있는가
DOM을 직접 조작하는 D3.js 같은 라이브러리와의 결합시에 예상되는 문제점이 있는가

### Vue instance 는 어떻게 생성하나요?
- Vue() 생성자 함수를 이용하여 생성
- 생성시 옵션 객체를 전달
let vm = new Vue({});
- vue component 도 vue instance 와 동일하다.


### 단방향, 양방향 바인딩에 대한 차이점을 설명해주세요.
단방향 바인딩 : 데이터 흐름이 한쪽인 경우를 의미한다. 
대표적인 지시어는 v-on, v-bind, {{}} 머스태시 태그
v-on(@) 은 UI에서 데이터 모델(viewModel)을 업데이트 하거나 출력할때 사용한다.
v-bind(:) 는 데이터 모델(viewModel) 에서 업데이트 된 상태를 UI에 반영한다.
 
양방햔 바인딩 : 데이터 흐름이 양방향이 경우를 의미한다.
대표적인 지시어는 v-model
데이터모델(viewModel)이 변경되면, 자동으로 UI도 변경이 된다.

<br>

### 양방향 바인딩 어떻게 생성하나요?
 
- v-model 지시어를 사용

<br>

### 컴포넌트 props 란 무엇인가요?
 
- props 는 상위컴포넌트에서 하위컴포넌트에게 데이터를 전달할때 사용하는 옵션
- vue 에 데이터 흐름은 위에서 아래로 흐르기때문에 하위 컴포넌트가 상위 컴포넌트 상태를 직접 참조할 수 없음
- props 로 상태가 전달이 되면 해당 컴포넌트에 속성이 된다
 
Vue.component('child', {
  // props 정의
  props: ['message'],
  // 데이터와 마찬가지로 prop은 템플릿 내부에서 사용할 수 있으며
  // vm의 this.message로 사용할 수 있습니다.
  template: '<span>{{ message }}</span>'
});
 
<child message="안녕하세요!"></child>

<br>

### Vue 프로젝트를 어떻게 배포하나요?
 
- SFC(Single File Component) 방식으로 코드를 작성했다면 웹팩 빌드 후, 빌드 결과물을 정적 서버에 올린다. 
- express-static 같은걸로 빌드 후, 서버 올리면 될듯..?
Q7: What are Components in Vue.js?
Q7. 컴포넌트란 무엇인가?
 
- vue component 는 재사용 및 확장성을 위해 코드를 캡슐화한거다.
- vue component 는 vue instance 이기도 하여, 옵션 객체 사용이 가능(root component 에서만 사용하는 옵션 제외)
Q8: What is filters in Vue.js?
Q8. filter 란 무엇인가?
 
- 일반적인 text 형식(format)을 가공해주는 역할을 한다.
- 머스태시 태그와 v-bind 에서 사용 가능하며, | (파이프) 기호와 함께 사용한다.
- 필터 체이닝도 가능하다 ( {{ message | filterA | filterB }}
 
<!-- in mustaches --> 
{{ message | capitalize }} //  capitalize -> filter
 
<!-- in v-bind --> 
<div v-bind:id="rawId | formatId"></div> //  formatId -> filter

<br>

### 다른 페이지로 리다이렉트(redirect) 어떻게 하나요?
re(다시) + 지시하다(direct) : 다시 지시하는 것
 
- vue-router 모듈을 이용하여 routing 기능을 구현할 수 있다.
(라우팅이란 출발지부터 목적지까지의 경로를 설정하는것을 의미한다.)
- $router.push();

<br>

### vue 앱 구조에 대한 기본 개념을 설명해주세요.
 
- vue 는 루트 컴포넌트(root instance)를 생성하고 루트 컴포넌트가 최상위를 기준으로 자식컴포넌트들이 tree 구조로 구성됩니다.
 
root component
  ㄴ header component
  ㄴ body component
    ㄴ main component
  ㄴ footer component

<br>

### Vuex 란 무엇인가요?
 
- vue 앱에 상태관리를 위한 라이브러리
- 모든 컴포넌트에 대한 상태를 중앙집중식으로 관리하는 저장소 역할을 한다.
img


<br>

### Vue 에서 mixin 이 필요한 이유는 무엇인가요?
 
- mixin 은 여러 컴포넌트간의 공통으로 사용하고 있는 로직, 상태들을 재사용하는 방법
- 2개의 컴포넌트가 동일한 기능을 가지고 있다고 생각해보자. 만약 같은 메서드를 2개 작성한다면 코드 중복 + 해당 메서드들이 바뀌면 코드를 2번 수정해야한다. -> 이걸 우아하게 mixin 으로 해결 가능하다.
- mixins : []  속성으로 지정하면 된다.
- mixin과 컴포넌트의 옵션이 중첩이 된다면, 두 옵션은 'Merged' 된다.
 
- 라이프사이클도 믹스인에 정의가 가능하지만, 라이프사이클 함수는 모두 실행된다(mixin -> component)

</details>

<br>
<hr>
<br>



<!-- 

1. 리액트는 JS로 모든 것을 구현할 수 있지만, 뷰는 기본적으로 마크업과 스타일, 스크립트를 써야 한다.

리액트는 JSX와 styled-components과 같은 외부 라이브러리를 이용해서 js로 마크업과 스타일을 구현할 수 있다.

하지만 뷰는 기본적으로 템플릿 언어이기 때문에, HTML로 마크업을, js로 스크립트를, css로 스타일을 구현해야 한다. (물론 JSX문법도 지원한다.)

이 부분은 취향 차이겠지만, 고전적인 HTML CSS JS를 배운 초보자들에겐 뷰가 더 익숙할 듯 하다.

 

2. 둘 다 가상 DOM을 사용한다.

뷰같은 경우엔 확실하게 MVVM 패턴으로 구현되어 있는데, 리액트는 따로 명시한 걸 본적이 없다. 가상 DOM을 쓰는 걸 보면, 아마 MVVM이 맞을 거 같다.

 

3. 일반적인 경우, 뷰가 더 빠르다.

최적화된 리액트 > 최적화되지 않은 뷰 > 최적화되지 않은 리액트 (왼쪽이 빠름, 오른쪽이 느림) 이라고 한다.

자세한 것은 Vue.js 공식 홈페이지의 다른 프레임워크와의 비교 글을 참고.

 

4. 리액트의 클래스 컴포넌트는 this를 사용한다는 점에서 뷰와 비슷하다.

this를 이용해 props와 state(data)에 접근하는 방식이 유사하다. 이는 개발자로 하여금 JS를 더 깊게 배우게 만들고, 러닝커브가 심해진다.

나는 리액트의 함수 컴포넌트와 hook이 더 직관적이고 실수할 확률이 적다고 생각한다. (리액트 공식 문서에도 this에 대한 언급이 있다.)

 

5. 커뮤니티 크기는 리액트 > 뷰

그러나 요즘 뷰 점유율이 리액트를 따라잡고 있다는 얘기를 들었다. 아마 니콜라스님 유투브에서 본듯?

 

6. 공식 레퍼런스의 친절도는 리액트 < 뷰

초창기부터 한글 번역이 지원되었고, 공식 문서의 가이드가 자세하고 따라가기 쉽게 쓰여져 있다. 심지어 각 항목마다 대부분 프리뷰도 있어, 바로 눈으로 확인이 가능해서 더욱 좋다.

리액트도 한글 지원은 되지만, 함수 시그니쳐와 프리뷰 같은 소소한 부분에서 디테일이 부족한듯..

 

7. 양방향 데이터 바인딩은 뷰가 더 편하다. 하지만 안정성은 리액트 > 뷰

뷰는 v-model을 이용해 dom 객체의 value와 data를 양방향 동기화 할 수 있다. 즉, 브라우저에서 텍스트 필드에 값을 입력하면 컴포넌트의 data가 바뀌며, 역도 된다는 것.

그러나 리액트는 양방향 바인딩을 하려면 이벤트 핸들러를 등록하여 state를 갱신해야 한다. 안정성에서는 리액트가 더 좋은 듯.

 

8. 리액트는 immutable, 뷰는 mutable

컴포넌트의 상태를 갱신하기 위해서, 리액트는 특정 함수를 통해 항상 새로운 객체 혹은 값을 덮어씌워줘야 한다. 즉 불변성을 지킨다. 함수는 값으로 평가되므로 편하게 다른 컴포넌트에게 전달할 수 있다. 이 것은 소소한 장점인듯?

그러나 뷰는 this.data의 속성에 값을 재할당하면 되며, 알아서 이전 상태와 병합을 한다. 즉, 가변성이 있다.

리액트가 특정 함수를 이용해 상태를 갱신하는 이유는 다른 생명주기 함수의 트리거 유무를 간단하게 알기 위해서라고.. 이런 면에서는 리액트가 더 좋은 듯.

 

9. props나 state에 의존하는 스타일 작성엔 리액트가 유리하다

styled-components는 컴포넌트의 props를 받아서 간단한 분기처리가 가능하다. 뷰도 가능한가? 뷰 안한지 좀 되서 잘 모르겠다.

 

10. 둘 다 컴포넌트 기반 개발이 가능하다.

웹 페이지를 작은 단위로 쪼개고, 그것을 조합하여 페이지를 구성하는 컴포넌트 기반 개발이 가능하며, 이로 인해 재사용성이 높다.

 

11. 둘 다 DOM조작을 최소화 할 수 있다.

리액트는 JSX를, 뷰는 html섹션을 통해 컴포넌트를 원하는 위치에 편하게 삽입할 수 있다.

 

12. flux 기반 상태관리 라이브러리가 있다.

리액트는 redux와 mobx, 뷰는 vuex.

리액트의 경우, 중앙집중형 상태 저장소(store)가 싫다면(즉, 일부 범위에서만 데이터를 공유하고 싶다면) context를 사용할 수 있다.

 

13. 컴포넌트에 props나 속성을 줄 때는 리액트가 직관적이다.

리액트는 컴포넌트에 속성을 추가할 때 스트링 리터럴 혹은 브라켓으로 묶어서 표현할 수 있다.

그러나 뷰는 무조건 스트링 리터럴로 표현해야 한다. 이로 인해 리터럴 값과 아닌 값을 쉽게 구분하기 힘들다.

 

14. 부모 자식 간 데이터 및 함수 공유

리액트는 값(JS는 함수도 값으로 평가한다)을 props로 자식에게 넘겨주면 된다.

만약 자식이 부모의 상태를 변경하고 싶다면 부모가 자식에게 클로저를 이용한 함수를 넘겨주면 된다. 하지만 뷰는 이벤트 에미터를 이용해 이벤트를 트리거해야 한다.

딱히 둘 중에 뭐가 더 나은지는 잘 모르겠다. 아마 복잡한 의존성 관계라면 구독/발행 패턴인 이벤트 에미터가 더 유지보수하기 쉬울 듯?




-->