# 1장 HTTP 개관
> 브라우저 상에서 데이터를 전달할 때 사용되는 통신 규약입니다.

HTTP(Hypertext Transfer Protocol)의 뜻을 살펴보자면 이렇습니다.
- **Hypertext**: 참조를 통해 독자가 한 문서에서 다른 문서로 즉시 접근할 수 있는 텍스트

- **Transfer**: 전송

- **Protocol**: 컴퓨터나 원거리 통신 장비 사이에서 메시지를 주고 받는 양식과 규칙의 체계

<br>

## 1.1 HTTP: 인터넷의 멀티미디어 배달부
> HTTP는 신뢰성 있는 데이터 전송 프로토콜을 사용하여 무언가를 전달합니다.

따라서 사용자는 정보가 손상된 게 아닌 지 염려할 필요 없어요.

<hr>
<br>

## 1.2 웹 클라이언트와 서버
> 월드 와이드 웹의 기본 요소로 웹 클라이언트와 서버가 있습니다.

- **웹(HTTP) 클라이언트**: 웹 브라우저(ex 크롬, 익스플로러)

- **웹(HTTP) 서버**: 인터넷의 데이터를 저장하고 클라이언트에게 제공

즉, 클라이언트는 서버에게 HTTP 요청을 보내고 서버는 요청된 데이터를 HTTP 응답으로 돌려주는 것이죠.

<hr>
<br>

## 1.3 리소스
> 웹 서버는 웹 리소스를 관리하고 제공합니다.

`웹 리소스(Web Resource)`는 웹 콘텐츠의 원천입니다. 가장 단순한 웹 리소스로는 웹 서버 파일 시스템의 정적 파일(텍스트, HTML, JPEG ... 그 외 모든 종류의 파일) 등이 있어요.

물론, 반드시 정적 파일일 필요는 없습니다. 요청에 따라 콘텐츠를 생산하는 프로그램이 될 수도 있어요.

가령 카메라에서 라이브 영상을 가져와 보여주거나, 주식 거래, 부동산 데이터베이스 검색, 온라인 쇼핑몰에서 선물 구입을 할 수 있게 도와줄 수도 있습니다. 또는 기업 판매 예측 스프레드 시트 파일이나 인터넷 검색 엔진에도 사용될 수 있죠.

<br>

### 1.3.1 미디어 타입
> 인터넷은 수천가지 데이터 타입을 다루기 때문에, HTTP는 웹에서 전송되는 객체 각각에 MIME 타입이라는 데이터 포맷 라벨을 붙입니다.

`MIME(Multipurpose Internet Mail Extensions, 다목적 인터넷 메일 확장)`은 다른 전자 메일 시스템 사이에서 메시지가 오갈 때 겪는 문제점 해결하기 위해 설계되었습니다. 이메일에서 잘 동작했기 때문에, HTTP에서도 멀티미디어 콘텐츠를 기술하고 라벨을 붙이기 위해 채택되었습니다.

웹 서버는 모든 HTTP 객체 데이터에 MIME 타입을 붙입니다. 그로 인해 서버로부터 객체를 돌려받는 순간 다룰 수 있는 객체인지 MIME 타입을 통해 확인할 수 있어요.

대부분의 웹 브라우저는 잘 알려진 객체 타입 수백 가지를 다룰 수 있는데, 대표적인 것을 알아보자면... MIME 타입은 사선(/)으로 구분된 주 타입(Primary object type)과 부 타입(specific subtype)으로 이루어진 문자열 라벨로 식별 가능합니다.
  - **HTML로 작성된 텍스트 문서**: text/html
  
  - **plain ASCII 텍스트 문서**: text/plain
  
  - **JEPG 이미지**: image/jpeg
  
  - **GIF 이미지**: image/gif
  
  - **JSON 형태의 응답**: application/json
  
  - 애플 퀵타임 동영상: video/quicktime
  
  - 마이크로소프트 파워포인트 프레젠테이션: application/vnd.ms-powerpoint

<br>

### 1.3.2 URI
> URI는 통합 자원 식별자(uniform resource identifier)로서 서버 리소스의 명칭이 됩니다.

웹 서버 리소스는 각자 이름을 갖고 있기 때문에, 클라이언트는 관심 있는 리소스를 지목할 수 있습니다. 현실세계로 따지면 우편물 주소 같은 것이에요. 아래의 절차를 봅시다.

```sh
http://www.joes-hardware.com/specials/saw-blade.gif
```
1. `http://`: http 프로토콜을 사용할 것
2. `www.joes-hardware.com`: 해당 도메인으로 이동할 것
3. `/specials/saw-blade.gif`: 해당 리소스를 가져올 것

<br>

URI에는 URL과 URN 두 가지가 존재합니다.
- URL(Uniform Resource Locator, 통합 자원 지시자)
  - 리소스 식별자의 가장 흔한 형태입니다.
  
  - 특정 서버의 한 리소스에 대한 구체적인 위치를 서술합니다.
  
  - URL은 세 부분으로 이루어진 표준 포맷을 따릅니다.
    - 첫번째 부분: 스킴(scheme)이라고 불리는 리소스에 접근하기 위해 사용되는 프로토콜. 일반적으로는 `HTTP 프로토콜(http://)`.
  
    - 두번째 부분: 웹 서버의 인터넷 주소(ex: www.joes-hardware.com)
  
    - 세번째 부분: 웹 서버의 리소스(ex: /specials/saw-blade.gif)

<br>

- URN(Uniform Resource Name, 통합 자원 이름)
  - 콘텐츠를 이루는 한 리소스에 대해, 그 리소스의 위치에 영향 받지 않는 유일무이한 이름 역할을 합니다.
  
  - 위치 독립적이므로 리소스를 여기저기로 옮기더라도 문제없이 동작합니다.
  
  - 리소스가 그 이름을 변하지 않게 유지하는 한, 여러 종류의 네트워크 접속 프로토콜로 접근해도 문제가 없습니다.
    - 인터넷 표준문서 RFC 2141에 대한 URN은 `urn:ietf:rfc:2141`입니다.

  - URN은 여전히 실험 중인데, 이는 리소스 위치를 분석하기 위한 인프라 지원이 부족하기 때문입니다. 그러나 전망은 밝아요.

<hr>
<br>

## 1.4 트랜잭션
> HTTP 트랜잭션은 요청 명령과 응답 결과로 구성되어 있습니다.

<br>

### 1.4.1 메서드
> HTTP는 HTTP 메서드라고 불리는 여러 종류의 요청 명령을 지원하며, 모든 HTTP 요청 메시지는 한 개의 메서드를 가집니다.

- `GET`: 서버 => 클라이언트로 지정한 리소스 전달

- `PUT`: 클라이언트 => 서버로 보낸 데이터를 지정한 이름의 리소스로 저장

- `DELETE`: 지정한 리소스를 서버에서 삭제

- `POST`: 클라이언트 데이터 => 서버 게이트웨이 애플리케이션으로 전달

- `HEAD`: 지정한 리소스에 대한 응답에서 HTTP 헤더 부분만 전달

<br>

### 1.4.2 상태코드
> 모든 HTTP 응답 메시지는 상태 코드와 함께 반환됩니다.

상태 코드는 클라이언트에게 요청이 성공했는지 또는 추가 조치가 필요한지 알려주는 세 자리 숫자입니다. 
```
200 : 성공
404 : 리소스를 찾을 수 없음
```

HTTP는 상태 코드와 함께 텍스트로 된 사유 구절 reason phrase도 함께 전달해요.
```
200 OK
200 Success
```

<br>

### 1.4.3 웹페이지는 여러 객체로 이루어질 수 있다
애플리케이션은 보통 하나의 작업을 수행하기 위해 여러 HTTP 트랜잭션을 수행합니다. 동일한 의미로, 웹 브라우저는 시각적으로 풍부한 웹 페이지를 가져올 때 대량의 HTTP 트랜잭션을 수행하죠. 페이지 레이아웃을 서술하는 HTML 뼈대를 한번의 트랜잭션으로 가져온 뒤 첨부된 이미지, 그래픽 조각, 자바 애플릿 등을 가져오기 위해 추가로 HTTP 트랜잭션들을 수행합니다.

<hr>
<br>

## 1.5 메시지
> HTTP 메시지는 단순한 줄 단위의 문자열로서 이진 형식이 아닌 일반 텍스트라 사람이 읽고 쓰기 쉽게 구성되어 있습니다.

메시지는 시작줄, 헤더, 본문 세 개의 파트로 분리되어 있습니다.
- **시작줄**
    - 메시지의 첫 줄은 반드시 시작줄입니다.
    
    - 요청이라면 `무엇을 해야 하는지` 응답이라면 `무슨 일이 일어났는지` 나타냅니다.

- **헤더**
    - 시작줄 다음에는 0개 이상의 헤더 필드가 이어집니다.
    - 각 헤더 필드는 쉬운 구문분석을 위해 쌍점(:)으로 구분되어 있는 하나의 이름과 하나의 값으로 구성됩니다.
    - 헤더 필드를 추가하려면 그저 한 줄을 더하기만 하면 됩니다.
    - 헤더는 빈 줄로 끝납니다.

- **본문**
    - 빈 줄 다음에는 어떤 종류의 데이터든 들어갈 수 있는 메시지 본문이 필요에 따라 올 수 있습니다.
    - 요청의 본문은 웹 서버로 데이터를 실어 보내며, 응답의 본문은 클라이언트로 데이터를 반환합니다.
    - 문자열이며 구조적인 시작줄이나 헤더와 달리, 본문은 임의의 이진 데이터를 포함할 수 있습니다.
    - 텍스트, 이미지, 비디오, 오디오 트랙, 응용 소프트웨어 등이 될 수 있습니다.

<br>

요청 메시지와 응답 메시지 구성을 간략하게 볼까요?
- 요청 메시지(Request Message): 웹 클라이언트에서 웹 서버로 보낸 HTTP 메시지
    ```
    요청 메시지

    GET /test/hi-there.txt HTTP/1.0

    ---

    Accept: text/*

    Accept-Language: en,fr
    ```

- 응답 메시지(Response Message): 서버에서 클라이언트로 가는 메시지
    ```
    응답 메시지

    HTTP/1.0 200 OK

    ---

    Content-type: text/plain

    Content-length: 19

    ---

    Hi! I'm a message!
    ```

<hr>
<br>

## 1.6 TCP 커넥션
> TCP(Transmission Control Protocol, 전송 제어 프로토콜)

HTTP 메시지는 TCP 커넥션을 통해 한 곳에서 다른 곳으로 옮겨갑니다.

<br>

### 1.6.1 TCP/IP
HTTP는 애플리케이션 계층 프로토콜이므로 네트워크 통신의 핵심적인 세부사항에 대해 신경쓰지 않지만, 이를 TCP/IP에게 책임을 위임합니다.

TCP가 제공하는 것은 아래와 같습니다.
- 오류 없는 데이터 전송

- 순서에 맞는 전달(데이터는 언제나 보낸 순서대로 도착)

- 조각나지 않는 데이터 스트림(언제든 어떤 크기로든 전송 가능)

<br>

인터넷은 TCP/IP에 기초하고 있으며 TCP/IP는 TCP와 IP가 층을 이루는, 패킷 교환 네트워크 프로토콜의 집합입니다. 이는 어떤 종류의 컴퓨터나 네트워크든 서로 신뢰성 있는 의사소통을 하게 해주죠.

<br>

*참고) HTTP 네트워크 프로토콜 스택(TCP/IP <> OSI 7 Layers)*
```
HTTP: 애플리케이션 계층

TCP: 전송 계층

IP: 네트워크 계층

네트워크를 위한 링크 인터페이스: 데이터 링크 계층

물리적인 네트워크 하드웨어: 물리 계층
```

<br>

### 1.6.2 접속, IP 주소 그리고 포트번호
HTTP 클라이언트가 서버에 메시지를 전송하려면 인터넷 프로토콜(Internet Protocol, IP) 주소와 포트번호를 사용해 클라이언트와 서버 사이에 TCP/IP 커넥션을 맺어야 합니다.

TCP 커넥션을 맺는 것은 다른 회사 사무실에 있는 누군가에게 전화를 거는 것과 비슷하해요. 먼저 `회사의 전화번호를 누르고 회사와 연결`하면 `상대방이 쓰는 번호를 눌러` 전화를 걸 수 있죠.


따라서 TCP에서는 서버 컴퓨터에 대한 IP 주소와 그 서버에서 실행중인 프로그램이 사용 중인 포트번호가 필요합니다. 이때 URL을 이용해 HTTP 서버의 IP 주소와 포트번호를 알아낼 수 있어요.

통신 과정을 정리하자면 아래와 같습니다.
1. 웹브라우저는 서버의 URL에서 호스트명을 추출

2. 웹브라우저는 서버의 호스트 명을 IP로 변환

3. 웹브라우저는 URL에서 포트번호(있다면)를 추출

4. 웹브라우저는 웹 서버와 TCP 커넥션을 맺음

5. 웹브라우저는 서버에 HTTP 요청을 보냄

6. 서버는 웹 브라우저에 HTTP 응답을 돌려줌

7. 커넥션이 닫히면, 웹브라우저는 문서를 보여줌

<hr>
<br>

## 1.7 프로토콜 버전
> HTTP 버전에 따른 명세입니다.

**HTTP/0.9**
- 심각한 디자인 결함 있고, 구식 클라이언트하고만 사용 가능

- GET 메서드만 지원

- 멀티미디어 콘텐츠에 대한 MIME 타입이나, HTTP 헤더, 버전 번호는 미지원

**HTTP/1.0**
- 버전 번호, HTTP 헤더, 추가 메서드, 멀티미디어 객체 처리 추가

- 시각적으로 매력적인 웹페이지와 상호작용하는 폼을 실현하여 월드 와이드 웹이 유명해집니다.

**HTTP/1.0+**
- 1990년대 중반, 월드 와이드 웹이 급격히 팽창하고 상업적으로도 성공하면서 여러 유명 웹 클라이언트와 서버들은 그에 따른 요구를 만족시키기 위해 발빠르게 HTTP에 기능 추가

- 오래 지속되는 `keep-alive` 커넥션, 가상 호스팅 지원, 프락시 연결 지원

**HTTP/1.1**
- HTTP 설계의 구조적 결함 교정, 두드러진 성능 최적화, 잘못된 기능 제거

- 더 복잡해진 웹 애플리케이션과 배포 지원

- `현재의 HTTP 버전`

**HTTP/2.0**
- 구글의 SPDY 프로토콜을 기반으로 설계가 진행 중인 프로토콜

<hr>
<br>

## 1.8 웹의 구성요소
인터넷과 상호작용 할 수 있는 웹 애플리케이션의 종류는 아래와 같습니다.
- **프락시**: 클라이언트와 서버 사이에 위치한 HTTP 중개자

- **캐시**: 많이 찾는 웹페이지를 클라이언트 가까이에 보관하는 HTTP 창고

- **게이트웨이**: 다른 애플리케이션과 연결된 특별한 웹 서버

- **터널**: 단순히 HTTP 통신을 전달하기만 하는 특별한 프락시

- **에이전트**: 자동화된 HTTP 요청을 만드는 준지능적 웹클라이언트

<br>

### 1.8.1 프락시
> 웹 보안, 애플리케이션 통합, 성능 최적화를 위한 중요한 구성 요소입니다.

클라이언트와 서버 사이에 위치하여 클라이언트의 모든 HTTP 요청을 받아 서버에 전달합니다(대개 요청을 수정한 뒤). 자세한 역할은 아래와 같습니다.
- 사용자를 대신해서 서버에 접근

- 주로 보안을 위해 사용

- 요청과 응답을 필터링
  - 회사에서 무엇인가를 다운 받을 때 애플리케이션 바이러스를 검출
  
  - 초등학교 학생들에게서 성인 콘텐츠를 차단

<br>

### 1.8.2 캐시
웹 캐시와 캐시 프락시가 존재하는데, 자신을 거쳐 가는 문서들 중 자주 찾는 것의 사본을 저장해 두는 특별한 종류의 HTTP 프락시 서버입니다. 다음에 클라이언트가 같은 문서를 요청하면 그 캐시가 갖고 있는 사본을 받을 수 있어요.

그 이점으로는 클라이언트가 멀리 떨어진 웹 서버보다 근처의 캐시에서 훨씬 더 빨리 문서를 다운 받을 수 있습니다.

HTTP는 캐시를 효율적으로 동작하게 하고 캐시된 콘텐츠를 최신 버전으로 유지하면서 동시에 프라이버시도 보호하기 위한 많은 기능을 정의합니다.

<br>

### 1.8.3 게이트웨이
> 다른 서버들의 중개자로 동작하는 특별한 서버입니다.

주로 HTTP 트래픽을 다른 프로토콜로 변환하기 위해 사용되며 언제나 스스로가 리소스를 갖고 있는 진짜 서버인 것처럼 요청을 다룹니다. 따라서 클라이언트는 자신이 게이트웨이와 통신하고 있음을 알아차리지 못하죠.

HTTP/FTP 게이트웨이는 FTP URI에 대한 HTTP 요청을 받아들인 뒤, FTP 프로토콜을 이용해 문서를 가져오고, 그 문서는 HTTP 메시지에 담겨 클라이언트에게 보내집니다.

<br>

### 1.8.4 터널
> 두 커넥션 사이에서 날 데이터를 열어보지 않고 그대로 전달해주는 HTTP 애플리케이션입니다.

HTTP 터널은 주로 비 HTTP 데이터를 하나 이상의 HTTP 연결을 통해 그대로 전송해주기 위해 사용됩니다. HTTP 터널을 활용하는 대표적인 예는 아래와 같아요.

```
암호화된 SSL 트래픽을 HTTP 커넥션으로 전송하여 웹 트래픽만 허용하는 사내 방화벽을 통과시킵니다.
```
1. 우선 HTTP/SSL 터널은 HTTP 요청을 받아들여 목적지의 주소와 포트번호로 커넥션을 맺습니다.

2. 이후부터는 암호화된 SSL 트래픽을 HTTP 채널을 통해 목적지 서버로 전송할 수 있게 됩니다.

<br>

### 1.8.5 에이전트
> 사용자를 위해 HTTP 요청을 만들어주는 클라이언트 프로그램입니다.

웹 요청을 만드는 애플리케이션은 뭐든 HTTP 에이전트가 됩니다.
   - 사람의 통제 없이 스스로 웹을 돌아다니며 HTTP 트랜잭션을 일으키고 콘텐츠를 받아오는 자동화된 사용자 에이전트(스파이더 또는 웹 로봇)
   
   - 스파이더는 웹을 돌아다니며, 검색엔진의 데이터베이스나 가격비교 로봇을 위한 제품 카탈로그와 같은 유용한 웹 콘텐츠 보관소를 만듭니다.

<br>