# 네트워크

## :book: `HTTP` 란 무엇인가요?
> HyperText Transfer Protocol의 약자로 WWW(Worl-Wide-Web)에 내재된 프로토콜입니다.

WWW 에서 하이퍼텍스트(hypertext) 문서를 교환하기 위하여 사용되는 통신 규약으로, 초기에 사용했던 HTTP 프로토콜은 매우 단순하였습니다. 이를 **HTTP/0.9 버전**이자 단일 프로토콜(One-line)이라고 하며, 많은 개선을 거쳐 현재의 표준화 된 **HTTP/1.1**, 더 나아가 **HTTP/2.0**이 등장하게 됩니다.

각 버전의 특징을 위주로 살펴볼까요?

### 🔧 HTTP/0.9 – 원-라인 프로토콜
> HTTP 프로토타입입니다. 번호가 없어 차후 버전과 구별하기 위해 HTTP/0.9로 호칭됩니다.

HTTP/0.9는 극도로 단순하여 많은 구조적 결함과 문제가 있었습니다. 그래서 금방 HTTP/1.0으로 대체되었죠. 특징은 다음과 같습니다.
1. 요청은 `GET 메서드와 요청 URL만으로 구성`됩니다.
2. 응답은 시작줄, 헤더 없이 `오직 엔티티 본문만이 존재`합니다.
3. 위의 이유로 `HTML 파일만 전송이 가능`했습니다.
4. 상태 코드가 존재하지 않으므로 `파일 내부에 상태에 대한 설명을 첨부`하여 응답했습니다.

<br>

### ⛏ HTTP/1.0 - 확장성 추가
> 매우 제한적이었지만, 브라우저와 서버 모두 빠르게 확장되기 시작합니다.

HTTP가 급성장하던 시기에 만들어진 잘 동작하는 사용 예제들의 모음에 가까워요. 따라서 잘 정의된 명세서는 아닙니다. 특징은 다음과 같습니다.
1. `버전 번호`가 추가되었습니다.
2. `HTTP 헤더와 메서드`가 추가되었습니다.
3. `멀티미디어 객체 처리`가 추가되었습니다.
4. 시각적인 효과를 가진 `폼(form)`을 구현하여 WWW를 대세로 만들었습니다.

여기서 끝이었지만, 상업적으로 크게 성공하여 기능이 확장되기 시작했습니다. 다음과 같이 여러 항목들이 있었죠.
1. `keep-alive` 커넥션이 추가 되었습니다.
2. `가상 호스팅`을 지원합니다.
3. `프록시 연결`을 지원합니다.

공식적이진 않으나 사실상의 표준으로 추가된 것이죠. 이를 두고 흔히들 `HTTP/1.0+`라고 부릅니다.

<br>

### 🔨 HTTP/1.1 - 현재의 표준 프로토콜
> 구현과 표준화를 동시에 진행했던 HTTP/1.0의 개선된 버전입니다.

널리 사용되고 있는 버전으로, 많은 개선이 이루어져 사용하는 데 큰 무리가 없습니다.
1. `커넥션(Connection)의 재사용`이 가능해졌습니다.
   - 기존에 응답 받은 리소스를 시간을 절약하면서 출력할 수 있게 되었습니다.
2. `파이프라이닝(Pipelining)`이 추가되었습니다.
   - 첫 요청이 도달만 한다면 요청에 대한 응답이 도달하지 않아도 두 번째 요청을 할 수 있게 되었습니다. 이는 커넥션의 요청-응답 지연 시간을 단축시켰습니다.
3. `청크된 응답`을 지원합니다.
4. `캐시 제어 메커니즘`이 도입되었습니다.
5. `컨텐츠 협상`이 도입되었습니다.
   - 브라우저-서버가 교환하려는 컨텐츠(언어, 인코딩 등)가 가장 적합한지 판단할 수 있게 되었습니다.
6. `Host 헤더`가 도입되었습니다.
   - 동일 IP 주소에 다른 도메인을 호스트할 수 있는 `코로케이션`이 가능해졌습니다.
   
      > 코로케이션(Colocation) : 자신의 서버를 직접 인터넷 데이터 센터(IDC)로 운반하여, 미리 준비된 공간에 서버를 입고시킨 후 사용하는 방식입니다.

<br>

### 🛠 HTTP/2.0 - 더 나은 성능을 위한 프로토콜
> 구글의 SPDY 프로토콜을 적용했고 HTTP/1.0의 문제를 개선한 표준화 되지 않은 초안입니다.

SPDY는 아래에 설명하는 구분이 있으니, [여기]()를 참고해주시고, 특징에 대해 살펴봅니다.
1. `이진(Binary) 프로토콜`에 가까운 형태입니다.
   - 읽거나 작성할 수 없으므로, 새로운 최적화 기술이 구현될 수 있습니다.
2. 병렬 요청이 동일한 커넥션에서 이루어질 수 있는 `다중화 프로토콜`입니다.
   - HTTP/1.1이 지닌 제약사항인 순서를 제거했습니다.
3. 전송된 데이터의 `중복`을 제거합니다.
   - 이러한 데이터로부터 유발되는 **오버헤드**를 해소하고 연속된 요청의 유사한 헤더를 압축할 수 있습니다.
4. `서버 푸시(Server Push)`라는 메커니즘을 도입하였습니다.
   - 클라이언트 캐시에 필요한 데이터를 전송할 수 있게 되었습니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `HTTP/1.1`과 `HTTP/2.0`의 차이점은 뭐에요?
> HTTP/1.1의 가장 큰 문제점, 회전 지연(Latency)를 해결하기 위해 제안되었습니다.

HTTP/1.1의 요청-응답 메세지 포맷은 `구현의 단순성`, `접근성`을 중점으로 최적화 되었습니다. 하나의 요청에 하나의 응답만을 받는(1:1) HTTP 메세지 교환 방식은 응답을 받아야만 다음 요청을 보낼 수 있으므로 심각한 회전 지연이 발생했습니다. 병렬 커넥션, 파이프라인 커넥션 등이 도입 되었지만 이를 완전히 해결하진 못했죠.

HTTP/2.0은 기존의 요청-응답과는 약간 다른 서버 푸시(Server Push)를 도입하여 요청을 명시적으로 받지 않아도 능동적으로 클라이언트에 리소스를 전송할 수 있게 되었습니다.

서두가 길었네요. 차이점을 살펴봅시다.
1. HTTP/2.0의 모든 메세지는 프레임에 담겨 전송됩니다.
2. 스트림(Stream)과 멀티 플렉싱(Multi-flexing)을 지원합니다.
   - 하나의 커넥션에 여러 스트림이 동시에 열리거나 우선순위를 가질 수 있습니다.
3. 헤더 압축를 압축하여 보내므로 중복된 내용을 효과적으로 처리할 수 있습니다.
4. 서버 푸시가 도입되어 클라이언트가 능동적으로 리소스를 푸시합니다.
5. 효율적인 페이지 로딩을 위해 URL 이미지, 스크립트 등의 리소스를 압축하여 요청을 감소시킵니다.

다른 항목들과 많이 겹치는 것이 보일텐데, 그만큼 중요한 것이며 두드러지는 특징이기 때문임을 기억하세요.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `SPDY 프로토콜`에 대해 설명해주세요.
> Google의 HTTP의 단점들을 보완하여 인터넷 환경을 보다 효율적으로 이용하기 위해 제안한 `speedy`한 새로운 프로토콜입니다.

즉, 기존 HTTP의 속도를 개선하기 위한 여러 기능을 추가한 것이죠. 많은 개발자와 기업이 새로운 프로토콜을 만들었지만, HTTP/2.0은 2013년까지 SPDY의 특징을 유지하고 있으므로 SPDY를 다룹니다.
1. 헤더를 압축하여 대역폭을 절약했습니다.
2. 하나의 TCP 커넥션에 여러 요청을 동시에 보낼 수 있습니다.
3. 클라이언트가 요청을 보내지 않아도 서버가 능동적으로 리소스를 푸시(push)할 수 있습니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `HTTP 메세지`란 무엇인가요?
> HTTP 애플리케이션 간에 주고받은 데이터의 블록들입니다.

데이터 블록은 메세지의 내용과 의미를 설명하는 텍스트 메타 정보로 시작합니다. 그 다음에는 선택적으로 데이터가 존재할 수 있죠. 이런 메세지는 `클라이언트(브라우저)`, `서버`, `프록시` 사이를 흐르며, 흐르는 방향을 `인바운드`, `아웃바운드`, `업스트림`, `다운스트림`이라고 합니다.

메세지는 아주 단순합니다. 클라이언트로부터의 요청이나 서버로부터의 응답 중 하나를 포함하며 **시작줄**, **헤더 블록**, **본문**의 세 항목으로 나누어집니다. 간단히 살펴봅시다.
- 시작줄
  - 요청 시 : `HTTP 메서드 / URL, 또는 프로토콜, 포트, 도메인의 절대 경로 / ​​​​HTTP 버전`
  - 응답 시 : `프로토콜 버전 / 상태코드 / 상태코드 정의`

<br>

- 헤더 블록 : `key:value`로 이루어지며, 확장 가능합니다.
  - 요청 시
      ```
      Accept : 클라이언트가 받을 수 있는 컨텐츠
      Cookie : 쿠키
      Content-Type : 메세지 바디 종류
      Content-Length : 메세지 바디 길이
      If-Modified-Since : 특정 날짜 이후 변경됐을 때
      ```
  - 응답 시
      ```
      Content-Type : 바디 데이터의 타입
      Content-Length : 바디 데이터 크기
      Set-Cookie : 쿠키 설정
      ETag : 엔티티 태그
      ```

<br>

- 본문
  - 요청 시 : `Entity Body`, 보통 공백입니다.
  - 응답 시 : `HTML, JSON, Octet Stream 등`

<br>

이 중 HTTP 헤더에 대한 내용은 분리해서 봅니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `HTTP 메서드` 의 종류는 뭐가 있나요?
> 모든 서버가 HTTP 메서드를 구현하지는 않음을 유의하세요.

HTTP 메서드는 대부분 제한적으로 사용되며 서버마다 다르게 결정되기도 합니다. 기본적으로 정의된 메서드를 사용하기도, 확장하기도, 변형하기도 하죠. 아래는 기본적인 메서드의 종류입니다.

|메소드명|역할|설명|본문 유무|
|:------:|----|-------------|:-----:|
|`GET`|리소스 취득|서버에서 특정 문서를 가져옵니다.|X|
|`HEAD`|메세지 헤더 취득|서버에서 특정 문서에 대한 헤더(Header)만 가져옵니다.|X|
|`POST`|엔티티 바디 전송|서버가 처리할 데이터를 전송합니다.|O|
|`PUT`|리소스 전송|서버에 요청 메세지 본문을 저장합니다.|O|
|`TRACE`|경로 조사|보낸 메세지를 다시 돌려 받습니다.|X|
|`OPTIONS`|서포트 메소드 문의|요청한 URL 에 어떠한 메소드 요청이 가능한지 묻습니다.|X|
|`DELETE`|리소스 삭제|URL 의 리소스를 삭제합니다.|X|

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

### :book: `HTTP 상태 코드` 의 종류는 뭐가 있나요?
> 상태 코드는 크게 다섯 가지로 구분합니다.

상태 코드는 클라이언트가 트랜젝션을 이해할 수 있게 하는 수단입니다. 보통 응답 메세지에 상태 코드와 사유를 기입하여 보내지만, 사유를 어떻게 작성하느냐는 가이드는 존재하지 않습니다.

다섯 가지 분류의 상태코드와, 자주 사용하는 항목을 소개합니다.

### 📑 100-199 : 정보
> HTTP/1.1에 도입되었으나 잘 사용하지 않습니다.

|상태 코드|사유 구절|의미|
|----|-----|---|
|100|Continue|요청의 시작 부분 일부가 허용되었으니<br>클라이언트는 나머지를 계속 요청하라는 의미입니다.|
|101|Swiching Protocols|클라이언트가 Upgrade 헤더에 나열한 것 중<br>하나로 서버가 프로토콜을 변경했다는 의미입니다.|

<br>

### 📑 200-299 : 성공
> 클라이언트의 요청이 성공했는지에 대응하는 코드입니다.

클라이언트의 요청은 대부분 성공하며 서버는 이러한 요청에 대응하는 성공 코드를 가지고 있습니다.

|상태 코드|사유 구절|의미|
|----|-----|---|
|200|OK|요청이 정상이며 엔터티 본문이 요청된 리소스를<br>포함하고 있다는 의미입니다.|
|202|Accepted|요청은 허용되었으나 서버는 어떤 동작도<br>수행하지 않았음을 의미합니다.|

<br>

### 📑 300-399 : 리다이렉션
> 클라이언트가 관심있는 리소스에 대해 다른 위치를 사용하라고 응답합니다.

만약 리소스가 이동 되었다면 클라이언트에게 해당 정보, 또는 선택적으로 Location 헤더를 전송할 수 있으며 브라우저는 사용자를 귀찮게 하지 않고 새 위치로 이동합니다.

|상태 코드|사유 구절|의미|
|----|-----|---|
|300|Multiple Choices|클라이언트가 여러 리소스를 가리키는 URL을<br>요청했다면 그 리소스의 목록과 함께 반환합니다.|
|301|Accepted|요청한 URL이 이동되었을 때 사용하며,<br>Location 헤더에 URL을 포함해야 합니다.|

<br>

### 📑 400-499 : 클라이언트
> 많은 클라이언트 에러는 브라우저에 의해 처리됩니다.

가끔 클라이언트는 서버에 잘못된 요청을 전송합니다. 예를 들어 존재하지 않는 페이지 같은 것들요.

|상태 코드|사유 구절|의미|
|----|-----|---|
|401|Unauthorzied|클라이언트의 인증(유효한 사용자 ID와 암호)을 요구합니다.|
|403|Forbidden|요청이 서버에 의해 거부되었음을 의미합니다.|
|404|Not Found|서버가 요청한 URL을 찾을 수 없음을 알려주기 위해 사용합니다.|

<br>

### 📑 500-599 : 서버 에러
> 프록시는 클라이언트의 입장으로 서버와 통신하는데, 이 때 발생하는 문제를 500번대 상태 코드로 알립니다.

클라이언트가 올바른 요청을 전송했음에도 서버 자체에서 발생하는 경우가 있죠? 이는 클라이언트가 서버에 제한이 걸린 것일 수도, 서버의 보조 구성 요소에서 발생항 에러일 수도 있습니다.

|상태 코드|사유 구절|의미|
|----|-----|---|
|500|Internal Server Error|서버가 요청을 처리하지 못하게 만드는 에러가<br>발생했음을 의미합니다.|
|502|Bad Gateway|요청-응답 연쇄의 다음 링크로부터 에러가<br>발생했음을 의미합니다.|
|503|Service Unavailable|현재는 서버가 요청을 처리할 수 없으나 나중에는<br>가능함을 의미합니다.|

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: 서버로 요청하면 일어나는 `일련의 과정`에 대해 설명해주세요.
> 브라우저에 URL을 입력했을 때 수행되는 과정을 간략하게 설명합니다.

절차는 이렇습니다.
1. 브라우저에 URL 입력
2. 호스트 명 획득
3. DNS 서버에 IP주소 요청
4. 포트(Port) 번호 획득
5. IP 주소로 포트 번호에 연결(Connection)
   - 여기에서 `3-Hand-Shaking`이 일어납니다. 다른 항목에서 더 자세히 알아봅시다.
6. 클라이언트가 HTTP 메서드를 통하여 서버에 요청
7. 서버가 HTTP 상태 코드로 클라이언트에 응답
8. 커넥션 종료

<br>

자, 아주 조금만 자세하게 볼까요? 이해를 도울 뿐이므로 더욱 세부적으로는 다루지 않겠습니다.

1. 기본 정보를 확인합니다.
   - 브라우저의 로컬 `hosts`파일에 입력한 URL에 연결된 정보가 있는지 확인합니다.
2. 외부와 통신할 준비를 합니다.
   - `DHCP(Dynamic Host Configuration Protocol)`에서 브라우저의 IP 주소, 가장 가까운 라우터(Router)의 IP 주소, 가장 가까운 DNS 서버의 IP 주소를 수신합니다.
   - `주소 결정 프로토콜(Address Resolution Protocol, ARP)`로 이동하려는 URL 호스트에 연결된 IP 주소와 가장 가까운 라우터의 MAC 주소를 확인합니다.
3. DNS 서버와 IP 주소를 송수신합니다.
   - DNS Query를 DNS 서버에 송신하면 DNS 서버는 웹 서버의 IP 주소를 브라우저로 반환합니다.
4. 웹 서버에 접속(연결)합니다.
   - 요청을 위해 TCP 소켓을 개방한뒤 연결(Connection)합니다. 이 과정에서 3-Hand-Shaking이 일어나며, TCP 연결이 성공되면 요청이 소켓을 통해 전송됩니다.
5. 서버는 요청을 처리하 클라이언트에게 응답하며, 커넥션을 종료합니다.
6. 응답된 전송을 브라우저가 수신합니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `HTTP` 와 `HTTPS` 의 차이점은요?
### HTTP의 개요
- 인터넷상에서 데이터를 주고 받기 위한 서버/클라이언트 모델을 따르는 전송 프로토콜이자 애플리케이션 레벨의 프로토콜로 TCP/IP위에서 작동합니다.
  - 클라이언트에서 요청(request)를 보내면 서버는 요청을 처리해서 응답(response)합니다.
  - 암호화가 되지 않은 평문 데이터를 전송하는 프로토콜로서, 제 3자가 중요한 정보를 조회할 수 있는 문제가 있었습니다.
  - 또한 통신 상대를 확인하지 않으므로 위장이 가능했으며, 완전성을 증명할 수 없어 변조까지 가능했습니다.

- 상태를 가지고 있지 않는 Stateless 프로토콜입니다.
  - Method, Path, Version, Headers, Body 등으로 구성됩니다.

- 기본적으로 80번 포트를 사용합니다.

<br>

### 비상태연결 *(Stateless, Connectless)*
> 서버에 연결하고 요청해서 응답을 받으면 연결을 끊습니다.

- 장점
  - 접속유지 최소화
  - 불특정 다수를 대상으로 하는 서비스에 유리

- 단점
  - 연결을 끊어버리므로 클라이언트의 이전 상태를 알 수 없음
  - 따라서 로그인을 해도 정보유지 불가
  - 이를 해결하기 위해 쿠키, 세션 등을 이용

<br>

### Keep Alive *(HTTP 1.1 부터 지원)*
> HTTP는 하나의 연결 시 하나의 요청과 응답이 기준

- 페이지에 여러 리소스가 존재하면 해당 수만큼 연결하여 리소스를 다운하고 연결 해제를 반복합니다.
  - 이처럼 TCP 통신 과정에서 비용이 많이 소모되어 등장한 개념으로 지정된 시간 동안 연결이 끊기지 않고 요청과 응답을 계속해서 보낼 수 있습니다.

<br>

### HTTPS의 개요
- HTTP 통신 소켓을 SSL(Secure Socket Layer)/TLS(Transport Layer Security) 프로토콜로 대체했습니다.
  - 즉, `HTTP-SSL-TCP`와 통신하는 시스템으로 암호화와 증명서, 안전성 보호를 이용할 수 있게 되었습니다.
  - 공개키/개인키 암호화를 지원하여 데이터를 보호합니다.

- 평문 통신에 비해 암호화 통신은 CPU나 메모리가 많이 필요하여 민감한 정보를 다룰 때에만 사용합니다.
  - HTTP 2.0이 발전되면서 HTTPS가 HTTP보다 빠르다고 합니다. [Link](https://tech.ssut.me/https-is-faster-than-http/)

- 기본적으로 443번 포트를 사용합니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `OSI` 가 뭐죠?
### 들어가기에 앞서
- PDU(Protocol Data Unit) : 프로토콜 데이터 단위
  - 계층이 전달한 데이터에 붙이는 제어 정보입니다.
  - 데이터는 동일하나 Layer를 거치면서 헤더 정보가 갱신되며 이름이 달라집니다. 사용자는 Data로, TCP는 Segment, IP는 Packet처럼 말이죠.

<br>

### OSI 의 개요
> OSI 모형(Open Systems Interconnection Reference Model)은  국제표준화기구(ISO)에서 개발한 모델

- 컴퓨터 네트워크 프로토콜 디자인과 통신을 계층으로 나누어 설명한 것으로 `OSI 7 계층 모형(OSI 7-Layer Model)`이라고 합니다.

<br>

### OSI 7 Layer
- `1 Layer : Physical` *(물리 계층)*
  - 역할 : 실제 장치들을 연결하기 위해 필요한 전기적, 물리적 세부 사항들을 정의합니다.
  - PDU : 비트(Bit)
  - 프로토콜 : Modem, Cable, Fiber, RS-232C
  - 관련 장비 : 리피터, 허브

- `2 Layer : Data link` *(데이터 링크 계층)*
  - 역할 : 포인트 투 포인트(Point to Point) 간 신뢰성 있는 전송을 보장합니다. 송수신 속도 차이를 해결하기 위한 흐름 제어와 프레임 동기화 등의 역할을 합니다.
  - PDU : 프레임(Frame)
  - 프로토콜 : 이더넷, MAC, PPP, ATM, LAN, Wifi
  - 관련 장비 : 랜카드, 브릿지, 스위치

- `3 Layer : Network` *(네트워크 계층)*
  - 역할 : 여러 개의 노드를 거칠 때마다 경로를 찾아주는 역할을 합니다.
  - PDU : 패킷(Packet)
  - 프로토콜 : IP, ICMP 등
  - 관련 장비 : 라우터, L3 스위치

- `4 Layer : Transport` *(전송 계층)*
  - 역할 : 양 끝단(End to end)의 사용자들이 신뢰성있는 데이터를 주고 받을 수 있도록 해줍니다. 헤드에는 세그먼트가 포함되며 주소 설정, 오류 및 흐름 제어, 다중화를 수행합니다.
  - PDU : 세그먼트(Segment)
  - 프로토콜 : TCP, UDP , ARP, RTP
  - 관련 장비 : 게이트웨이, L4 스위치

- `5 Layer : Session` *(세션 계층)*
  - 역할 : 양 끝단의 응용 프로세스가 통신을 관리하기 위한 방법을 제공합니다.
  - PDU : 메세지(Message)
  - 프로토콜 : NetBIOS, SSH, TLS

- `6 Layer : Presentation` *(표현 계층)*
  - 역할 : 표현계층은 송신측과 수신측 사이에서 데이터의 형식(png, jpg, jpeg...)을 정합니다. 받은 데이터를 코드 변환, 구문 검색, 암호화, 압축의 과정을 통해 올바른 표준방식으로 변환해 줍니다.
  - PDU : 메세지(Message)
  - 프로토콜 : JPG, MPEG, SMB, AFP

- `7 Layer : Application` *(응용 계층)*
  - 역할 : 응용 프로세스와 직접 관계하여 일반적인 응용 서비스를 수행합니다.
  - PDU : 메세지(Message)
  - 프로토콜 : HTTP, SMTP, SNMP, FTP, Telnet, SSH & Scp, NFS, RTSP 

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `TCP` 와 `UDP` 의 차이점은 무엇이죠?
- TCP(Stateful, 상태유지)는 신뢰성이 있는 연결, UDP(Stateless, 무상태)는 빠른 전송을 지향하는 프로토콜입니다.

- TCP는 내가 보낸 데이터가 확실히 상대방에게 전달이 되었는지 포커를 맺고, UDP는 일방적으로 전송을 합니다.

- UDP의 한 예로 스트리밍 방송이 있는데, 방송을 하다가 중간에 신호가 끊어져도 다음으로 그냥 이어서 방송을 하는 것처럼 UDP는 일방적인 데이터 전송을 하는 반면, TCP는 데이터 하나라도 놓치지 않고 완벽히 보내는 것이 목표이기 때문에 방향성이 완전히 다릅니다.

- UDP는 알고리즘이 간단한 반면, TCP는 연결부터 끊는 과정까지 상대적으로 복잡합니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `TCP/IP` 는 뭐죠?

<div align=center>

<img src="img/osi7layer_tcp-ip4layer.png" alt="osi7layer_tcp-ip4layer" width="500"/>

</div>

<br>

### TCP/IP 의 개요
> TCP/IP (Transmission Control Protocol / Internet Protocol)

- 인터넷 통신의 기반이 되는 프로토콜로 이를 이용해 컴퓨터를 연결하는 체계를 이더넷(Ethernet)이라고 합니다.

<br>

### 계층
- `1 Layer : Network Access` or Network Interface Layer *(네트워크 액세스 계층)*
  > OSI 7계층의 물리계층과 데이터 링크 계층에 해당하며 물리적인 주소로 MAC을 사용합니다.

  - LAN, 패킷망 등

- `2 Layer : Internet Layer` *(인터넷 계층)*
  > OSI 7계층의 네트워크 계층에 해당하며 통신 노드 간의 IP패킷을 전송하는 기능과 라우팅 기능을 담당합니다.

  - IP, ARP, RARP 등


- `3 Layer : Transport Layer` *(전송 계층)*
  > OSI 7계층의 전송 계층에 해당하며 통신 노드 간의 연결을 제어하고, 신뢰성 있는 데이터 전송을 담당합니다.

  - TCP, UDP 등

- `4 Layer : Application Layer` *(응용 계층)*
  > OSI 7계층의 세션 계층, 표현 계층, 응용 계층에 해당하며 TCP/UDP 기반의 응용 프로그램을 구현할 때 사용합니다.

  - FTP, HTTP, SSH 등

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `TCP-3-way-hands-shaking` 에 대해 설명해주세요.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `DNS` 의 `Round Robin` 방식을 설명해주세요.
- L4 스위치 같은 로드밸런싱 장비가 부담이 될 때 저렴하고 간단하게 서버 분산을 구현하는 방법입니다.
  - 클라이언트 세션을 유지하며 처음 연결한 서버에 지속적으로 연결해주는 기능은 없습니다.

  - 간단한 요청과 결과로만 이루어진 페이지들이라면 사용할 수 있습니다.

- 서버가 A, B, C 3대가 있으면 첫 요청에 A, 다음엔 B, 다음에 C로 연결하고 이후엔 다시 A-B-C 절차를 반복합니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `Routing Table` 은 무엇인가요?
> 주소를 이용하여 목적지까지 메시지를 전달하는 방법을 결정하는 경로 선택 과정입니다.
> - 이 과정을 능동적으로 수행하는 장치를 라우터(Router)라고 합니다.
  
- 경로 선택을 위한 데이터베이스(목록)을 라우팅 테이블(Routing Table)이라고 하며 목적지 네트워크 주소, 라우터의 출구 포트 정보, 최적 경로 산출을 위한 metrics 등의 정보를 포함합니다.
  - 라우터가 최적의 경로를 찾아 결정할 때 사용합니다.
  
  - 라우터가 패킷을 수신하면 패킷의 목적지 IP주소를 검사하고, 라우터의 라우팅 테이블 안에 있는 가장 일치하는 네트워크 주소를 검색합니다.
  
  - 라우팅 테이블은 또한 패킷을 전송하는데 사용되는 인터페이스를 포함합니다.
  
  - 부합하는 네트워크를 찾게 되면 라우터는 밖으로 나가는 인터페이스의 데이터 링크 프레임 안에 IP패킷을 캡슐화하고, 그 다음에 그것의 목적지 쪽으로 패킷을 전송합니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `URL Encode` 는 무엇인가요?
> Encoding이란 정보의 형태, 형식을 내용의 변경 없이 변환하는 처리 방식입니다.

- 암호화로는 사용할 수 없으며 ASCII, URL, Base64, MS Script 등이 있습니다.

### ASCII Encoding이란?
- ASCII (American Standard Code for Information Interchange, 미국 정보 교환 표준 부호, 아스키 코드)
  - 미국 ANSI에서 표준화한 정보교환용 7비트 부호체계입니다.
  - 나머지 1비트는 패리티 비트(Parity bit)로 정보 전달 시 오류 발생여부를 검사하기 위해 사용했습니다.
    - 체크에 검출되지 않는 신호 에러도 생길 수 있고 현재는 더 이상 쓰이지 않습니다.
  - 000(0x00)부터 127(0x7F)까지 총 128개의 부호가 사용됩니다.
  - 영문 키보드로 입력할 수 있는 모든 기호들로 할당되어 매우 단순하고 간단합니다.
  - 8비트 문자 인코딩에서는 맨 앞 비트에 0을 붙이고 이어서 7비트가 이어지는 식의 인코딩이 일반적입니다.

<br>

### URL Encode란?
- 주소 지정을 목적으로 웹 브라우저 / 서버가 이해할 수 있는 문자로 특수 문자를 대체합니다.
  - ASCII 코드에서 표현하지 않는 외국어와 특수문자를 표현하기 위해 사용합니다.
  - 코드의 앞에 %문자가 포함되는 형태입니다.

<br>

### Base64 Encoding이란?

<br>

### MS script Encoding이란?

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `UTF-8`을 설명해주세요.
> 가장 많이 사용되는 가변 길이 유니코드 인코딩입니다.

- 표현 가능한 길이는 최대 6바이트지만 다른 인코딩과의 호환을 위해 4바이트까지만 사용합니다.

- 아스키 코드의 0~127까지는 UTF-8로 완전히 동일하게 기록됩니다.
  - 아스키로 구축된 사이트를 별다른 변환 처리 없이 그대로 쓸 수 있는 엄청난 장점이 있습니다.

- UTF-8은 엔디안에 상관없이 똑같이 읽을 수 있으므로 크로스플랫폼 호환성도 뛰어납니다.
  - 엔디안(Endianness) : 메모리와 같은 1차원의 공간에 여러 개의 연속된 대상을 배열하는 방법입니다.

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `URL` 과 `URI` 의 차이점을 모르겠어요.
> `URI는 식별`하고 `URL은 식별하고 찾습`니다.

- 모든 URL과 URN은 URI이지만 모든 URI는 URL이 아닙니다.

- 통합 자원 식별자(Uniform Resource Identifier, URI)는 인터넷에 있는 자원을 나타내는 유일한 주소입니다.
  - URL은 해당 리소스를 얻는 데 필요한 특정 정보를 제공합니다.

- URI의 하위개념으로 URL, URN 이 있습니다.
  - URL(Uniform Resource Locator) : 파일 식별자, 유일자원지시기
  - URN(Uniform Resource Name) : 통합 자원 이름
    - 영속적이며 위치에 독립적인 자원을 위한 지시자로 사용하기 위한 것입니다.

- 문법
  - URI
    > scheme:[//[user[:password]@]host[:port]][/path][?query][#fragment]

  - URL
    > scheme:[//[user:password@]host[:port]][/]path[?query][#fragment]

  - URN
    > `<URN>` ::= "urn:" `<NID>` ":" `<NSS>`

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>

## :book: `Server 의 인증방식`에 대해 설명해주세요.
### 인증이 필요한 이유
> 서버에서는 사용자가 보낸 요청을 받았을 때 그것이 누구의 요청인지 정확하게 알아야 합니다.

- `Front-end 관점` : 사용자의 로그인, 회원가입과 같이 사용자의 도입 부분을 가리킵니다.

- `Server-side 관점` : 모든 API 요청에 대해 사용자를 확인하는 작업

<br>

### 계정 정보를 Request Header 에 넣는 방식

<br>

### 세션(Session)과 쿠키(Cookie)
> `무연결 프로토콜` *(Connectionless Protocol)*의 불편함을 해결하기 위해 클라이언트-서버의 연결을 유지해주는 방법들입니다.

- 웹 서비스는 클라이언트와 서버의 관계를 유지하지 않는 특성을 지닌 HTTP 프로토콜을 기반으로 합니다.
  - 서버의 부하가 최소화되나 기능 구현은 어렵습니다.

- 서버와 클라이언트의 연결 상태를 유지
  - 클라이언트`[ 요청(Request) ]` : 서버 연결 시작
  - 서버`[ 응답(Response) ]` : 서버 연결 종료
  ```
  [클라이언트] 로그인 요청 | 로그인 응답 [서버]
  [클라이언트] 상품 주문 요청 | 상품 주문 응답 [서버]
  ```

  - 서버의 부하를 줄일 수 있는 장점은 있으나 클라이언트의 요청마다 매번 새로운 연결이 생성되어 일반적인 상태 유지 기능의 구현이 어렵습니다.
  - 이러한 Connectionless Protocol의 불편함을 해결하기 위해서 세션과 쿠키를 이용합니다. 


|방법|내용| 
|----|----|
|Session|서버에서 연결 정보를 관리|
|Cookie|클라이언트에서 연결 정보를 관리|

<br>

<sup>[(상위 문서로)](https://github.com/InSeong-So/IT-Note)</sup>

<hr>
<br>
