<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 5.1.6 or newer
 *
 * @package        CodeIgniter
 * @author        EllisLab Dev Team
 * @copyright        Copyright (c) 2008 - 2014, EllisLab, Inc.
 * @copyright        Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license        http://codeigniter.com/user_guide/license.html
 * @link        http://codeigniter.com
 * @since        Version 2.1.2
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * PDO Result Class
 *
 * This class extends the parent result class: CI_DB_result
 *
 * @category    Database
 * @author        EllisLab Dev Team
 * @link        http://codeigniter.com/user_guide/database/
 */
class CI_DB_pdo_result extends CI_DB_result {

    public $num_rows;

    /**
     * Number of rows in the result set
     *
     * @return    int
     */
    public function num_rows()
    {
        if (is_int($this->num_rows))
        {
            return $this->num_rows;
        }
        elseif (($this->num_rows = $this->result_id->rowCount()) > 0)
        {
            return $this->num_rows;
        }

        $this->num_rows = count($this->result_id->fetchAll());
        $this->result_id->execute();
        return $this->num_rows;
    }

    // --------------------------------------------------------------------

    /**
     * Number of fields in the result set
     *
     * @access    public
     * @return    integer
     */
    function num_fields()
    {
        return $this->result_id->columnCount();
    }

    // --------------------------------------------------------------------

    /**
     * Fetch Field Names
     *
     * Generates an array of column names
     *
     * @access    public
     * @return    array
     */
    function list_fields()
    {
        if ($this->db->db_debug)
        {
            return $this->db->display_error('db_unsuported_feature');
        }
        return FALSE;
    }

    // --------------------------------------------------------------------

    /**
     * Field data
     *
     * Generates an array of objects containing field meta-data
     *
     * @access    public
     * @return    array
     */
    function field_data()
    {
        $data = array();

        try
        {
            for($i = 0; $i < $this->num_fields(); $i++)
            {
                $data[] = $this->result_id->getColumnMeta($i);
            }

            return $data;
        }
        catch (Exception $e)
        {
            if ($this->db->db_debug)
            {
                return $this->db->display_error('db_unsuported_feature');
            }
            return FALSE;
        }
    }

    // --------------------------------------------------------------------

    /**
     * Free the result
     *
     * @return    null
     */
    function free_result()
    {
        if (is_object($this->result_id))
        {
            $this->result_id = FALSE;
        }
    }

    // --------------------------------------------------------------------

    /**
     * Data Seek
     *
     * Moves the internal pointer to the desired offset.  We call
     * this internally before fetching results to make sure the
     * result set starts at zero
     *
     * @access    private
     * @return    array
     */
    function _data_seek($n = 0)
    {
        return FALSE;
    }

    // --------------------------------------------------------------------

    /**
     * Result - associative array
     *
     * Returns the result set as an array
     *
     * @access    private
     * @return    array
     */
    function _fetch_assoc()
    {
        return $this->result_id->fetch(PDO::FETCH_ASSOC);
    }

    // --------------------------------------------------------------------

    /**
     * Result - object
     *
     * Returns the result set as an object
     *
     * @access    private
     * @return    object
     */
    function _fetch_object()
    {
        return $this->result_id->fetchObject();
    }

}


/* End of file pdo_result.php */
/* Location: ./system/database/drivers/pdo/pdo_result.php */