# Contributing

Our project welcomes external contributions. To contribute code or documentation, please submit a [pull request][pulls].

A good way to familiarize yourself with the codebase and contribution process is
to look for and tackle low-hanging fruit in the  [issue tracker][issues].

## Proposing new features

If you would like to implement a new feature, like a utility or helper functions, please [raise an issue][issues] before sending a pull request so the feature can be discussed. This is to avoid
you wasting your valuable time working on a feature that the project developers
are not interested in accepting into the code base.

## Fixing bugs

If you would like to fix a bug, please [raise an issue][issues] before sending a
pull request so it can be tracked.

## Legal

Each source file must include a license header for the Apache
Software License 2.0. Using the SPDX format is the simplest approach.
For example:

```javascript
/*
Copyright <holder> All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
```

We have tried to make it as easy as possible to make contributions. This
applies to how we handle the legal aspects of contribution. We use the
same approach - the [Developer's Certificate of Origin 1.1 (DCO)][DCO] - that the Linux® Kernel [community](https://elinux.org/Developer_Certificate_Of_Origin)
uses to manage code contributions.

We simply ask that when submitting a patch for review, the developer
must include a sign-off statement in the commit message.

Here is an example Signed-off-by line, which indicates that the
submitter accepts the DCO:

```text
Signed-off-by: John Doe <john.doe@example.com>
```

You can include this automatically when you commit a change to your
local git repository using the following command:

```bash
git commit -s
```

## Communication

Feel free to [create an issue][issues] to question or discuss anything with us.

<!-- links -->
[issues]: https://github.com/IBM/carbon-ui-builder/issues
[pulls]: https://github.com/IBM/carbon-ui-builder/pulls
[DCO]: https://developercertificate.org/
