// Code generated by protoc-gen-go. DO NOT EDIT.
// source: trainer.proto

/*
Package grpc_trainer_v2 is a generated protocol buffer package.

It is generated from these files:
	trainer.proto

It has these top-level messages:
	CreateRequest
	EMExtractionSpec
	EMGroup
	EMMeta
	EMAny
	MetaInfo
	LogLine
	Any
	EMetrics
	Query
	CreateResponse
	UpdateRequest
	UpdateResponse
	GetRequest
	GetResponse
	GetStatusResponse
	GetStatusIDResponse
	GetMetricsStringResponse
	GetTestResponse
	GetAllRequest
	GetAllResponse
	HaltRequest
	HaltResponse
	ResumeRequest
	ResumeResponse
	DeleteRequest
	DeleteResponse
	Metrics
	Job
	ModelDefinition
	Framework
	ImageLocation
	Training
	TrainingStatus
	Datastore
	ResourceRequirements
	ModelDefinitionRequest
	TrainedModelRequest
	TrainedModelLogRequest
	TrainedModelMetricsRequest
	GetLatestMetricsRequest
	GetLatestMetricsResponse
	UpdateTrainedModelMetricsRequest
	UpdateTrainedModelMetricsResponse
	ByteStreamResponse
	ZippedDataChunk
	GetVersionsRequest
	Frameworks
	FrameworkDetailList
	FrameworkDetails
*/
package grpc_trainer_v2

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type SizeUnit int32

const (
	SizeUnit_MB  SizeUnit = 0
	SizeUnit_MiB SizeUnit = 1
	SizeUnit_GB  SizeUnit = 2
	SizeUnit_GiB SizeUnit = 3
)

var SizeUnit_name = map[int32]string{
	0: "MB",
	1: "MiB",
	2: "GB",
	3: "GiB",
}
var SizeUnit_value = map[string]int32{
	"MB":  0,
	"MiB": 1,
	"GB":  2,
	"GiB": 3,
}

func (x SizeUnit) String() string {
	return proto.EnumName(SizeUnit_name, int32(x))
}
func (SizeUnit) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type Status int32

const (
	Status_NOT_STARTED Status = 0
	Status_PENDING     Status = 1
	Status_HALTED      Status = 5
	Status_FAILED      Status = 10
	Status_DEPLOY      Status = 20
	Status_DOWNLOADING Status = 30
	Status_PROCESSING  Status = 40
	Status_STORING     Status = 50
	Status_COMPLETED   Status = 60
	Status_QUEUED      Status = 70
)

var Status_name = map[int32]string{
	0:  "NOT_STARTED",
	1:  "PENDING",
	5:  "HALTED",
	10: "FAILED",
	20: "DEPLOY",
	30: "DOWNLOADING",
	40: "PROCESSING",
	50: "STORING",
	60: "COMPLETED",
	70: "QUEUED",
}
var Status_value = map[string]int32{
	"NOT_STARTED": 0,
	"PENDING":     1,
	"HALTED":      5,
	"FAILED":      10,
	"DEPLOY":      20,
	"DOWNLOADING": 30,
	"PROCESSING":  40,
	"STORING":     50,
	"COMPLETED":   60,
	"QUEUED":      70,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type Any_DataType int32

const (
	Any_STRING     Any_DataType = 0
	Any_JSONSTRING Any_DataType = 1
	Any_INT        Any_DataType = 2
	Any_FLOAT      Any_DataType = 3
)

var Any_DataType_name = map[int32]string{
	0: "STRING",
	1: "JSONSTRING",
	2: "INT",
	3: "FLOAT",
}
var Any_DataType_value = map[string]int32{
	"STRING":     0,
	"JSONSTRING": 1,
	"INT":        2,
	"FLOAT":      3,
}

func (x Any_DataType) String() string {
	return proto.EnumName(Any_DataType_name, int32(x))
}
func (Any_DataType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

type Query_SearchType int32

const (
	Query_TERM   Query_SearchType = 0
	Query_NESTED Query_SearchType = 1
	Query_MATCH  Query_SearchType = 2
	Query_ALL    Query_SearchType = 3
)

var Query_SearchType_name = map[int32]string{
	0: "TERM",
	1: "NESTED",
	2: "MATCH",
	3: "ALL",
}
var Query_SearchType_value = map[string]int32{
	"TERM":   0,
	"NESTED": 1,
	"MATCH":  2,
	"ALL":    3,
}

func (x Query_SearchType) String() string {
	return proto.EnumName(Query_SearchType_name, int32(x))
}
func (Query_SearchType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 0} }

type CreateRequest struct {
	UserId          string           `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	ModelDefinition *ModelDefinition `protobuf:"bytes,2,opt,name=model_definition,json=modelDefinition" json:"model_definition,omitempty" bson:"model_definition,omitempty"`
	Training        *Training        `protobuf:"bytes,3,opt,name=training" json:"training,omitempty" bson:"training,omitempty"`
	Datastores      []*Datastore     `protobuf:"bytes,4,rep,name=datastores" json:"datastores,omitempty" bson:"datastores,omitempty"`
	// EMExtractionSpec allows the caller to specify evaluation metrics extraction.
	EvaluationMetrics *EMExtractionSpec `protobuf:"bytes,5,opt,name=evaluation_metrics,json=evaluationMetrics" json:"evaluation_metrics,omitempty" bson:"evaluation_metrics,omitempty"`
}

func (m *CreateRequest) Reset()                    { *m = CreateRequest{} }
func (m *CreateRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateRequest) ProtoMessage()               {}
func (*CreateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *CreateRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *CreateRequest) GetModelDefinition() *ModelDefinition {
	if m != nil {
		return m.ModelDefinition
	}
	return nil
}

func (m *CreateRequest) GetTraining() *Training {
	if m != nil {
		return m.Training
	}
	return nil
}

func (m *CreateRequest) GetDatastores() []*Datastore {
	if m != nil {
		return m.Datastores
	}
	return nil
}

func (m *CreateRequest) GetEvaluationMetrics() *EMExtractionSpec {
	if m != nil {
		return m.EvaluationMetrics
	}
	return nil
}

// EMExtractionSpec represents the specification for extracting structured evaluation metrics from training jobs.
// It is used across all log collectors, so some fields may not be relevent for all log collectors.
// Note: Don't use enums with this, as need to do untyped YAML convert to string and back
// Refer to https://github.com/IBM/FfDL/training-metrics-service for complete
// documentation.
type EMExtractionSpec struct {
	// Loosly typed string representing what kind of log-collector to use.
	// For Logs-only, specify `type: logger`
	// For the Regex_extractor log-collector, specify `type: regex_extractor`
	// For Tensorboard, specify `type: tensorboard`
	// To invoke the emetrics_file_extractor, you can specify the following synonyms
	// `type: optivist` || `type: emetrics_file` || `type: file`.
	Type     string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty" bson:"type,omitempty"`
	ImageTag string `protobuf:"bytes,6,opt,name=image_tag,json=imageTag" json:"image_tag,omitempty" bson:"image_tag,omitempty"`
	// The filename of the logfile.  (Normally this should be left to default).
	In string `protobuf:"bytes,2,opt,name=in" json:"in,omitempty" bson:"in,omitempty"`
	// For the regex_extractor, number of lines to keep in the buffer for regex matching.
	LineLookahead int32 `protobuf:"varint,3,opt,name=line_lookahead,json=lineLookahead" json:"line_lookahead,omitempty" bson:"line_lookahead,omitempty"`
	// (Eventual) Available event types: 'images', 'distributions', 'histograms', 'images'
	// 'audio', 'scalars', 'tensors', 'graph', 'meta_graph', 'run_metadata'.
	// For now only scalars are supported.
	EventTypes []string `protobuf:"bytes,4,rep,name=eventTypes" json:"eventTypes,omitempty" bson:"eventTypes,omitempty"`
	// For the regex_extractor, the `EMExtractionSpec` should contain a `groups` section, which should contain
	// templates for groups such as `test` and `train`, which group names should be be the keys of this map.
	Groups map[string]*EMGroup `protobuf:"bytes,5,rep,name=groups" json:"groups,omitempty" bson:"groups,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *EMExtractionSpec) Reset()                    { *m = EMExtractionSpec{} }
func (m *EMExtractionSpec) String() string            { return proto.CompactTextString(m) }
func (*EMExtractionSpec) ProtoMessage()               {}
func (*EMExtractionSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *EMExtractionSpec) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *EMExtractionSpec) GetImageTag() string {
	if m != nil {
		return m.ImageTag
	}
	return ""
}

func (m *EMExtractionSpec) GetIn() string {
	if m != nil {
		return m.In
	}
	return ""
}

func (m *EMExtractionSpec) GetLineLookahead() int32 {
	if m != nil {
		return m.LineLookahead
	}
	return 0
}

func (m *EMExtractionSpec) GetEventTypes() []string {
	if m != nil {
		return m.EventTypes
	}
	return nil
}

func (m *EMExtractionSpec) GetGroups() map[string]*EMGroup {
	if m != nil {
		return m.Groups
	}
	return nil
}

// EMGroup represents a group, such as `test` or `train`, that acts as a template for structured evaluation metrics,
// and which allows the specification of a regular expression (regex) that contains named bindings with
// sub-expressions, which can then be used as references to specify structured time-related (x-axis) and value-related
// (y-axis) values.
type EMGroup struct {
	// Python regular expressions, which use the named group feature `(?P<name>...)`, to specify
	// a name of a matching expression, which can then be used to specify the value that is used in the template
	// for the `EMetrics` record. To help with verbosity, the regex_extractor allows the following macros: GLOG_STAMP,
	// TIMESTAMP, FLOAT, INT, INT_ANY, and HEX.  (See dlaas-training-metrics-service README for more details.
	Regex string `protobuf:"bytes,1,opt,name=regex" json:"regex,omitempty" bson:"regex,omitempty"`
	// Allows the caller to specify a binding for the time field of the meta structure.
	Meta *EMMeta `protobuf:"bytes,2,opt,name=meta" json:"meta,omitempty" bson:"meta,omitempty"`
	// Map of keys and regex references for value-related (y-axis) values.
	Values map[string]*EMAny `protobuf:"bytes,3,rep,name=values" json:"values,omitempty" bson:"values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Map of keys and regex references for time-related (x-axis) values.
	Etimes map[string]*EMAny `protobuf:"bytes,4,rep,name=etimes" json:"etimes,omitempty" bson:"etimes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *EMGroup) Reset()                    { *m = EMGroup{} }
func (m *EMGroup) String() string            { return proto.CompactTextString(m) }
func (*EMGroup) ProtoMessage()               {}
func (*EMGroup) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *EMGroup) GetRegex() string {
	if m != nil {
		return m.Regex
	}
	return ""
}

func (m *EMGroup) GetMeta() *EMMeta {
	if m != nil {
		return m.Meta
	}
	return nil
}

func (m *EMGroup) GetValues() map[string]*EMAny {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *EMGroup) GetEtimes() map[string]*EMAny {
	if m != nil {
		return m.Etimes
	}
	return nil
}

// Allows the user to bind an extracted value to the time field of the evaluation metrics.
type EMMeta struct {
	// Time that the metric occured: representing the number of millisecond since midnight January 1, 1970.
	// (ref, for instance $timestamp).  Value will be extracted from timestamps
	Time string `protobuf:"bytes,3,opt,name=time" json:"time,omitempty" bson:"time,omitempty"`
	// Optional subid
	Subid string `protobuf:"bytes,5,opt,name=subid" json:"subid,omitempty" bson:"subid,omitempty"`
}

func (m *EMMeta) Reset()                    { *m = EMMeta{} }
func (m *EMMeta) String() string            { return proto.CompactTextString(m) }
func (*EMMeta) ProtoMessage()               {}
func (*EMMeta) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *EMMeta) GetTime() string {
	if m != nil {
		return m.Time
	}
	return ""
}

func (m *EMMeta) GetSubid() string {
	if m != nil {
		return m.Subid
	}
	return ""
}

// Typed value for EMExtractionSpec.  The data type here can't be an enum, due to internal issues with YAML
// conversion.
type EMAny struct {
	// one of: STRING, JSONSTRING, INT, FLOAT
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty" bson:"type,omitempty"`
	// String represenation of the value.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty" bson:"value,omitempty"`
}

func (m *EMAny) Reset()                    { *m = EMAny{} }
func (m *EMAny) String() string            { return proto.CompactTextString(m) }
func (*EMAny) ProtoMessage()               {}
func (*EMAny) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *EMAny) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *EMAny) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// MetaInfo represents data shared with both log lines and evaluation metrics.
type MetaInfo struct {
	// Unique id identifying the training job
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	// Unique id identifying the user
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	// Time that the metric occured: representing the number of millisecond since midnight January 1, 1970.
	Time int64 `protobuf:"varint,3,opt,name=time" json:"time,omitempty" bson:"time,omitempty"`
	// Sequential index, 1-based
	Rindex int64 `protobuf:"varint,4,opt,name=rindex" json:"rindex,omitempty" bson:"rindex,omitempty"`
	// Optional subid
	Subid string `protobuf:"bytes,5,opt,name=subid" json:"subid,omitempty" bson:"subid,omitempty"`
}

func (m *MetaInfo) Reset()                    { *m = MetaInfo{} }
func (m *MetaInfo) String() string            { return proto.CompactTextString(m) }
func (*MetaInfo) ProtoMessage()               {}
func (*MetaInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *MetaInfo) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *MetaInfo) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *MetaInfo) GetTime() int64 {
	if m != nil {
		return m.Time
	}
	return 0
}

func (m *MetaInfo) GetRindex() int64 {
	if m != nil {
		return m.Rindex
	}
	return 0
}

func (m *MetaInfo) GetSubid() string {
	if m != nil {
		return m.Subid
	}
	return ""
}

// LogLine represents one line of log information, returned by training data endpoints.
type LogLine struct {
	// For MetaInfo, at the minimum training_id and user_id must be specified.
	Meta *MetaInfo `protobuf:"bytes,1,opt,name=meta" json:"meta,omitempty" bson:"meta,omitempty"`
	// Raw line from the logs.
	Line string `protobuf:"bytes,2,opt,name=line" json:"line,omitempty" bson:"line,omitempty"`
}

func (m *LogLine) Reset()                    { *m = LogLine{} }
func (m *LogLine) String() string            { return proto.CompactTextString(m) }
func (*LogLine) ProtoMessage()               {}
func (*LogLine) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *LogLine) GetMeta() *MetaInfo {
	if m != nil {
		return m.Meta
	}
	return nil
}

func (m *LogLine) GetLine() string {
	if m != nil {
		return m.Line
	}
	return ""
}

// Any represents a typed value used with the evaluation metrics record.
type Any struct {
	// Datatype of the value.
	Type Any_DataType `protobuf:"varint,1,opt,name=type,enum=grpc.trainer.v2.Any_DataType" json:"type,omitempty" bson:"type,omitempty"`
	// String representation of a value
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty" bson:"value,omitempty"`
}

func (m *Any) Reset()                    { *m = Any{} }
func (m *Any) String() string            { return proto.CompactTextString(m) }
func (*Any) ProtoMessage()               {}
func (*Any) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *Any) GetType() Any_DataType {
	if m != nil {
		return m.Type
	}
	return Any_STRING
}

func (m *Any) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// EMetrics specifies an evaluation metrics record from the training data.
type EMetrics struct {
	// For MetaInfo, at the minimum training_id and user_id must be specified.
	Meta *MetaInfo `protobuf:"bytes,1,opt,name=meta" json:"meta,omitempty" bson:"meta,omitempty"`
	// Map of temporal keys, normally values for the x-axis on a graph.
	// Example: {"iteration": 209}
	Etimes map[string]*Any `protobuf:"bytes,2,rep,name=etimes" json:"etimes,omitempty" bson:"etimes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Group label, such as test, train, or validate
	Grouplabel string `protobuf:"bytes,3,opt,name=grouplabel" json:"grouplabel,omitempty" bson:"grouplabel,omitempty"`
	// Map of value keys, normally values for the y-axis on a graph.
	// / Example: {"cross_entropy": 0.4430539906024933,	"accuracy": 0.8999999761581421}
	Values map[string]*Any `protobuf:"bytes,4,rep,name=values" json:"values,omitempty" bson:"values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *EMetrics) Reset()                    { *m = EMetrics{} }
func (m *EMetrics) String() string            { return proto.CompactTextString(m) }
func (*EMetrics) ProtoMessage()               {}
func (*EMetrics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *EMetrics) GetMeta() *MetaInfo {
	if m != nil {
		return m.Meta
	}
	return nil
}

func (m *EMetrics) GetEtimes() map[string]*Any {
	if m != nil {
		return m.Etimes
	}
	return nil
}

func (m *EMetrics) GetGrouplabel() string {
	if m != nil {
		return m.Grouplabel
	}
	return ""
}

func (m *EMetrics) GetValues() map[string]*Any {
	if m != nil {
		return m.Values
	}
	return nil
}

// Query specifies the input query for logs and evaluation metrics.
type Query struct {
	// At this time, the SearchType value should normally always be TERM.
	SearchType Query_SearchType `protobuf:"varint,1,opt,name=searchType,enum=grpc.trainer.v2.Query_SearchType" json:"searchType,omitempty" bson:"searchType,omitempty"`
	// At the minimum, the training_data and user_data must be specified in the meta substructure.
	Meta  *MetaInfo `protobuf:"bytes,3,opt,name=meta" json:"meta,omitempty" bson:"meta,omitempty"`
	Since string    `protobuf:"bytes,4,opt,name=since" json:"since,omitempty" bson:"since,omitempty"`
	// Only get this many records
	Pagesize int32 `protobuf:"varint,5,opt,name=pagesize" json:"pagesize,omitempty" bson:"pagesize,omitempty"`
	// The starting position.  If positive or zero, count from beginning, if negative, count from end, exclusive with since.
	Pos int64 `protobuf:"varint,6,opt,name=pos" json:"pos,omitempty" bson:"pos,omitempty"`
}

func (m *Query) Reset()                    { *m = Query{} }
func (m *Query) String() string            { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()               {}
func (*Query) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Query) GetSearchType() Query_SearchType {
	if m != nil {
		return m.SearchType
	}
	return Query_TERM
}

func (m *Query) GetMeta() *MetaInfo {
	if m != nil {
		return m.Meta
	}
	return nil
}

func (m *Query) GetSince() string {
	if m != nil {
		return m.Since
	}
	return ""
}

func (m *Query) GetPagesize() int32 {
	if m != nil {
		return m.Pagesize
	}
	return 0
}

func (m *Query) GetPos() int64 {
	if m != nil {
		return m.Pos
	}
	return 0
}

type CreateResponse struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
}

func (m *CreateResponse) Reset()                    { *m = CreateResponse{} }
func (m *CreateResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateResponse) ProtoMessage()               {}
func (*CreateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CreateResponse) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

type UpdateRequest struct {
	TrainingId    string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId        string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	Status        Status `protobuf:"varint,3,opt,name=status,enum=grpc.trainer.v2.Status" json:"status,omitempty" bson:"status,omitempty"`
	StatusMessage string `protobuf:"bytes,4,opt,name=status_message,json=statusMessage" json:"status_message,omitempty" bson:"status_message,omitempty"`
	ErrorCode     string `protobuf:"bytes,5,opt,name=error_code,json=errorCode" json:"error_code,omitempty" bson:"error_code,omitempty"`
	Timestamp     string `protobuf:"bytes,6,opt,name=timestamp" json:"timestamp,omitempty" bson:"timestamp,omitempty"`
}

func (m *UpdateRequest) Reset()                    { *m = UpdateRequest{} }
func (m *UpdateRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateRequest) ProtoMessage()               {}
func (*UpdateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *UpdateRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *UpdateRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UpdateRequest) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_NOT_STARTED
}

func (m *UpdateRequest) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *UpdateRequest) GetErrorCode() string {
	if m != nil {
		return m.ErrorCode
	}
	return ""
}

func (m *UpdateRequest) GetTimestamp() string {
	if m != nil {
		return m.Timestamp
	}
	return ""
}

type UpdateResponse struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
}

func (m *UpdateResponse) Reset()                    { *m = UpdateResponse{} }
func (m *UpdateResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateResponse) ProtoMessage()               {}
func (*UpdateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *UpdateResponse) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

type GetRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
}

func (m *GetRequest) Reset()                    { *m = GetRequest{} }
func (m *GetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRequest) ProtoMessage()               {}
func (*GetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *GetRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type GetResponse struct {
	Job *Job `protobuf:"bytes,1,opt,name=job" json:"job,omitempty" bson:"job,omitempty"`
}

func (m *GetResponse) Reset()                    { *m = GetResponse{} }
func (m *GetResponse) String() string            { return proto.CompactTextString(m) }
func (*GetResponse) ProtoMessage()               {}
func (*GetResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GetResponse) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

type GetStatusResponse struct {
	Status *TrainingStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty" bson:"status,omitempty"`
}

func (m *GetStatusResponse) Reset()                    { *m = GetStatusResponse{} }
func (m *GetStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*GetStatusResponse) ProtoMessage()               {}
func (*GetStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *GetStatusResponse) GetStatus() *TrainingStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type GetStatusIDResponse struct {
	Status Status `protobuf:"varint,1,opt,name=status,enum=grpc.trainer.v2.Status" json:"status,omitempty" bson:"status,omitempty"`
}

func (m *GetStatusIDResponse) Reset()                    { *m = GetStatusIDResponse{} }
func (m *GetStatusIDResponse) String() string            { return proto.CompactTextString(m) }
func (*GetStatusIDResponse) ProtoMessage()               {}
func (*GetStatusIDResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GetStatusIDResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_NOT_STARTED
}

type GetMetricsStringResponse struct {
	Metrics string `protobuf:"bytes,1,opt,name=metrics" json:"metrics,omitempty" bson:"metrics,omitempty"`
}

func (m *GetMetricsStringResponse) Reset()                    { *m = GetMetricsStringResponse{} }
func (m *GetMetricsStringResponse) String() string            { return proto.CompactTextString(m) }
func (*GetMetricsStringResponse) ProtoMessage()               {}
func (*GetMetricsStringResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *GetMetricsStringResponse) GetMetrics() string {
	if m != nil {
		return m.Metrics
	}
	return ""
}

type GetTestResponse struct {
	Test string `protobuf:"bytes,1,opt,name=test" json:"test,omitempty" bson:"test,omitempty"`
}

func (m *GetTestResponse) Reset()                    { *m = GetTestResponse{} }
func (m *GetTestResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTestResponse) ProtoMessage()               {}
func (*GetTestResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *GetTestResponse) GetTest() string {
	if m != nil {
		return m.Test
	}
	return ""
}

type GetAllRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
}

func (m *GetAllRequest) Reset()                    { *m = GetAllRequest{} }
func (m *GetAllRequest) String() string            { return proto.CompactTextString(m) }
func (*GetAllRequest) ProtoMessage()               {}
func (*GetAllRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *GetAllRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type GetAllResponse struct {
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs" json:"jobs,omitempty" bson:"jobs,omitempty"`
}

func (m *GetAllResponse) Reset()                    { *m = GetAllResponse{} }
func (m *GetAllResponse) String() string            { return proto.CompactTextString(m) }
func (*GetAllResponse) ProtoMessage()               {}
func (*GetAllResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *GetAllResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

type HaltRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
}

func (m *HaltRequest) Reset()                    { *m = HaltRequest{} }
func (m *HaltRequest) String() string            { return proto.CompactTextString(m) }
func (*HaltRequest) ProtoMessage()               {}
func (*HaltRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *HaltRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *HaltRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type HaltResponse struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	Status     Status `protobuf:"varint,3,opt,name=status,enum=grpc.trainer.v2.Status" json:"status,omitempty" bson:"status,omitempty"`
}

func (m *HaltResponse) Reset()                    { *m = HaltResponse{} }
func (m *HaltResponse) String() string            { return proto.CompactTextString(m) }
func (*HaltResponse) ProtoMessage()               {}
func (*HaltResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *HaltResponse) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *HaltResponse) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *HaltResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_NOT_STARTED
}

type ResumeRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
}

func (m *ResumeRequest) Reset()                    { *m = ResumeRequest{} }
func (m *ResumeRequest) String() string            { return proto.CompactTextString(m) }
func (*ResumeRequest) ProtoMessage()               {}
func (*ResumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ResumeRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *ResumeRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type ResumeResponse struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	Status     Status `protobuf:"varint,3,opt,name=status,enum=grpc.trainer.v2.Status" json:"status,omitempty" bson:"status,omitempty"`
}

func (m *ResumeResponse) Reset()                    { *m = ResumeResponse{} }
func (m *ResumeResponse) String() string            { return proto.CompactTextString(m) }
func (*ResumeResponse) ProtoMessage()               {}
func (*ResumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *ResumeResponse) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *ResumeResponse) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ResumeResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_NOT_STARTED
}

type DeleteRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
}

func (m *DeleteRequest) Reset()                    { *m = DeleteRequest{} }
func (m *DeleteRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRequest) ProtoMessage()               {}
func (*DeleteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *DeleteRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *DeleteRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type DeleteResponse struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
}

func (m *DeleteResponse) Reset()                    { *m = DeleteResponse{} }
func (m *DeleteResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteResponse) ProtoMessage()               {}
func (*DeleteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *DeleteResponse) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

type Metrics struct {
	Timestamp string            `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp,omitempty" bson:"timestamp,omitempty"`
	Type      string            `protobuf:"bytes,2,opt,name=type" json:"type,omitempty" bson:"type,omitempty"`
	Iteration int32             `protobuf:"varint,3,opt,name=iteration" json:"iteration,omitempty" bson:"iteration,omitempty"`
	Values    map[string]string `protobuf:"bytes,4,rep,name=values" json:"values,omitempty" bson:"values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Metrics) Reset()                    { *m = Metrics{} }
func (m *Metrics) String() string            { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()               {}
func (*Metrics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *Metrics) GetTimestamp() string {
	if m != nil {
		return m.Timestamp
	}
	return ""
}

func (m *Metrics) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Metrics) GetIteration() int32 {
	if m != nil {
		return m.Iteration
	}
	return 0
}

func (m *Metrics) GetValues() map[string]string {
	if m != nil {
		return m.Values
	}
	return nil
}

type Job struct {
	TrainingId      string           `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId          string           `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	ModelDefinition *ModelDefinition `protobuf:"bytes,3,opt,name=model_definition,json=modelDefinition" json:"model_definition,omitempty" bson:"model_definition,omitempty"`
	Training        *Training        `protobuf:"bytes,4,opt,name=training" json:"training,omitempty" bson:"training,omitempty"`
	Status          *TrainingStatus  `protobuf:"bytes,5,opt,name=status" json:"status,omitempty" bson:"status,omitempty"`
	Datastores      []*Datastore     `protobuf:"bytes,6,rep,name=datastores" json:"datastores,omitempty" bson:"datastores,omitempty"`
	JobId           string           `protobuf:"bytes,7,opt,name=job_id,json=jobId" json:"job_id,omitempty" bson:"job_id,omitempty"`
	Metrics         *Metrics         `protobuf:"bytes,8,opt,name=metrics" json:"metrics,omitempty" bson:"metrics,omitempty"`
}

func (m *Job) Reset()                    { *m = Job{} }
func (m *Job) String() string            { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()               {}
func (*Job) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *Job) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *Job) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *Job) GetModelDefinition() *ModelDefinition {
	if m != nil {
		return m.ModelDefinition
	}
	return nil
}

func (m *Job) GetTraining() *Training {
	if m != nil {
		return m.Training
	}
	return nil
}

func (m *Job) GetStatus() *TrainingStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Job) GetDatastores() []*Datastore {
	if m != nil {
		return m.Datastores
	}
	return nil
}

func (m *Job) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *Job) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type ModelDefinition struct {
	Name        string     `protobuf:"bytes,1,opt,name=name" json:"name,omitempty" bson:"name,omitempty"`
	Description string     `protobuf:"bytes,2,opt,name=description" json:"description,omitempty" bson:"description,omitempty"`
	Content     []byte     `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty" bson:"content,omitempty"`
	Location    string     `protobuf:"bytes,4,opt,name=location" json:"location,omitempty" bson:"location,omitempty"`
	Framework   *Framework `protobuf:"bytes,5,opt,name=framework" json:"framework,omitempty" bson:"framework,omitempty"`
}

func (m *ModelDefinition) Reset()                    { *m = ModelDefinition{} }
func (m *ModelDefinition) String() string            { return proto.CompactTextString(m) }
func (*ModelDefinition) ProtoMessage()               {}
func (*ModelDefinition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *ModelDefinition) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModelDefinition) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ModelDefinition) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *ModelDefinition) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *ModelDefinition) GetFramework() *Framework {
	if m != nil {
		return m.Framework
	}
	return nil
}

type Framework struct {
	Name          string         `protobuf:"bytes,1,opt,name=name" json:"name,omitempty" bson:"name,omitempty"`
	Version       string         `protobuf:"bytes,2,opt,name=version" json:"version,omitempty" bson:"version,omitempty"`
	ImageTag      string         `protobuf:"bytes,3,opt,name=image_tag,json=imageTag" json:"image_tag,omitempty" bson:"image_tag,omitempty"`
	ImageLocation *ImageLocation `protobuf:"bytes,4,opt,name=image_location,json=imageLocation" json:"image_location,omitempty" bson:"image_location,omitempty"`
}

func (m *Framework) Reset()                    { *m = Framework{} }
func (m *Framework) String() string            { return proto.CompactTextString(m) }
func (*Framework) ProtoMessage()               {}
func (*Framework) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *Framework) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Framework) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Framework) GetImageTag() string {
	if m != nil {
		return m.ImageTag
	}
	return ""
}

func (m *Framework) GetImageLocation() *ImageLocation {
	if m != nil {
		return m.ImageLocation
	}
	return nil
}

type ImageLocation struct {
	Registry    string `protobuf:"bytes,1,opt,name=registry" json:"registry,omitempty" bson:"registry,omitempty"`
	Namespace   string `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty" bson:"namespace,omitempty"`
	AccessToken string `protobuf:"bytes,3,opt,name=access_token,json=accessToken" json:"access_token,omitempty" bson:"access_token,omitempty"`
	Email       string `protobuf:"bytes,4,opt,name=email" json:"email,omitempty" bson:"email,omitempty"`
}

func (m *ImageLocation) Reset()                    { *m = ImageLocation{} }
func (m *ImageLocation) String() string            { return proto.CompactTextString(m) }
func (*ImageLocation) ProtoMessage()               {}
func (*ImageLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *ImageLocation) GetRegistry() string {
	if m != nil {
		return m.Registry
	}
	return ""
}

func (m *ImageLocation) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ImageLocation) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *ImageLocation) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

type Training struct {
	// Command to execute during training
	Command string `protobuf:"bytes,1,opt,name=command" json:"command,omitempty" bson:"command,omitempty"`
	// Resource requirements for the training
	Resources *ResourceRequirements `protobuf:"bytes,2,opt,name=resources" json:"resources,omitempty" bson:"resources,omitempty"`
	// Input and output data as data store references
	InputData  []string `protobuf:"bytes,3,rep,name=input_data,json=inputData" json:"input_data,omitempty" bson:"input_data,omitempty"`
	OutputData []string `protobuf:"bytes,4,rep,name=output_data,json=outputData" json:"output_data,omitempty" bson:"output_data,omitempty"`
	// whether we want to enable detailed profiling during the training
	Profiling bool `protobuf:"varint,5,opt,name=profiling" json:"profiling,omitempty" bson:"profiling,omitempty"`
}

func (m *Training) Reset()                    { *m = Training{} }
func (m *Training) String() string            { return proto.CompactTextString(m) }
func (*Training) ProtoMessage()               {}
func (*Training) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *Training) GetCommand() string {
	if m != nil {
		return m.Command
	}
	return ""
}

func (m *Training) GetResources() *ResourceRequirements {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Training) GetInputData() []string {
	if m != nil {
		return m.InputData
	}
	return nil
}

func (m *Training) GetOutputData() []string {
	if m != nil {
		return m.OutputData
	}
	return nil
}

func (m *Training) GetProfiling() bool {
	if m != nil {
		return m.Profiling
	}
	return false
}

type TrainingStatus struct {
	Status                 Status `protobuf:"varint,1,opt,name=status,enum=grpc.trainer.v2.Status" json:"status,omitempty" bson:"status,omitempty"`
	SubmissionTimestamp    string `protobuf:"bytes,3,opt,name=submission_timestamp,json=submissionTimestamp" json:"submission_timestamp,omitempty" bson:"submission_timestamp,omitempty"`
	CompletionTimestamp    string `protobuf:"bytes,4,opt,name=completion_timestamp,json=completionTimestamp" json:"completion_timestamp,omitempty" bson:"completion_timestamp,omitempty"`
	DownloadStartTimestamp string `protobuf:"bytes,5,opt,name=download_start_timestamp,json=downloadStartTimestamp" json:"download_start_timestamp,omitempty" bson:"download_start_timestamp,omitempty"`
	ProcessStartTimestamp  string `protobuf:"bytes,6,opt,name=process_start_timestamp,json=processStartTimestamp" json:"process_start_timestamp,omitempty" bson:"process_start_timestamp,omitempty"`
	StoreStartTimestamp    string `protobuf:"bytes,7,opt,name=store_start_timestamp,json=storeStartTimestamp" json:"store_start_timestamp,omitempty" bson:"store_start_timestamp,omitempty"`
	StatusMessage          string `protobuf:"bytes,8,opt,name=status_message,json=statusMessage" json:"status_message,omitempty" bson:"status_message,omitempty"`
	ErrorCode              string `protobuf:"bytes,9,opt,name=error_code,json=errorCode" json:"error_code,omitempty" bson:"error_code,omitempty"`
}

func (m *TrainingStatus) Reset()                    { *m = TrainingStatus{} }
func (m *TrainingStatus) String() string            { return proto.CompactTextString(m) }
func (*TrainingStatus) ProtoMessage()               {}
func (*TrainingStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *TrainingStatus) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_NOT_STARTED
}

func (m *TrainingStatus) GetSubmissionTimestamp() string {
	if m != nil {
		return m.SubmissionTimestamp
	}
	return ""
}

func (m *TrainingStatus) GetCompletionTimestamp() string {
	if m != nil {
		return m.CompletionTimestamp
	}
	return ""
}

func (m *TrainingStatus) GetDownloadStartTimestamp() string {
	if m != nil {
		return m.DownloadStartTimestamp
	}
	return ""
}

func (m *TrainingStatus) GetProcessStartTimestamp() string {
	if m != nil {
		return m.ProcessStartTimestamp
	}
	return ""
}

func (m *TrainingStatus) GetStoreStartTimestamp() string {
	if m != nil {
		return m.StoreStartTimestamp
	}
	return ""
}

func (m *TrainingStatus) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *TrainingStatus) GetErrorCode() string {
	if m != nil {
		return m.ErrorCode
	}
	return ""
}

type Datastore struct {
	Id   string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty" bson:"id,omitempty"`
	Type string `protobuf:"bytes,2,opt,name=type" json:"type,omitempty" bson:"type,omitempty"`
	// additional fields for the given Datastore type
	Fields map[string]string `protobuf:"bytes,3,rep,name=fields" json:"fields,omitempty" bson:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// connection information for the given Datastore type
	Connection map[string]string `protobuf:"bytes,4,rep,name=connection" json:"connection,omitempty" bson:"connection,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Datastore) Reset()                    { *m = Datastore{} }
func (m *Datastore) String() string            { return proto.CompactTextString(m) }
func (*Datastore) ProtoMessage()               {}
func (*Datastore) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *Datastore) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Datastore) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Datastore) GetFields() map[string]string {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *Datastore) GetConnection() map[string]string {
	if m != nil {
		return m.Connection
	}
	return nil
}

// Used to specify resource requirements of a training job
type ResourceRequirements struct {
	// Number of CPU cores
	Cpus float32 `protobuf:"fixed32,1,opt,name=cpus" json:"cpus,omitempty" bson:"cpus,omitempty"`
	// Number of GPUs
	Gpus float32 `protobuf:"fixed32,2,opt,name=gpus" json:"gpus,omitempty" bson:"gpus,omitempty"`
	// RAM
	Memory      float32  `protobuf:"fixed32,3,opt,name=memory" json:"memory,omitempty" bson:"memory,omitempty"`
	MemoryUnit  SizeUnit `protobuf:"varint,4,opt,name=memory_unit,json=memoryUnit,enum=grpc.trainer.v2.SizeUnit" json:"memory_unit,omitempty" bson:"memory_unit,omitempty"`
	Storage     float32  `protobuf:"fixed32,5,opt,name=storage" json:"storage,omitempty" bson:"storage,omitempty"`
	StorageUnit SizeUnit `protobuf:"varint,6,opt,name=storage_unit,json=storageUnit,enum=grpc.trainer.v2.SizeUnit" json:"storage_unit,omitempty" bson:"storage_unit,omitempty"`
	// Number of learners
	Learners     int32  `protobuf:"varint,7,opt,name=learners" json:"learners,omitempty" bson:"learners,omitempty"`
	Schedpolicy  string `protobuf:"bytes,8,opt,name=schedpolicy" json:"schedpolicy,omitempty" bson:"schedpolicy,omitempty"`
	Topology     string `protobuf:"bytes,9,opt,name=topology" json:"topology,omitempty" bson:"topology,omitempty"`
	Architecture string `protobuf:"bytes,10,opt,name=architecture" json:"architecture,omitempty" bson:"architecture,omitempty"`
	// Optional. If not specified, job will be scheduled ONLY on nvidia-TeslaK80
	// Constraint strictly enforced. If e.g., a nvidia-TeslaP100 is requested,
	// job will NOT start until a nvidia-TeslaP100 is available
	// Can only be nvidia-TeslaK80, nvidia-TeslaP100 or nvidia-TeslaV100
	GpuType string `protobuf:"bytes,11,opt,name=gpu_type,json=gpuType" json:"gpu_type,omitempty" bson:"gpu_type,omitempty"`
}

func (m *ResourceRequirements) Reset()                    { *m = ResourceRequirements{} }
func (m *ResourceRequirements) String() string            { return proto.CompactTextString(m) }
func (*ResourceRequirements) ProtoMessage()               {}
func (*ResourceRequirements) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *ResourceRequirements) GetCpus() float32 {
	if m != nil {
		return m.Cpus
	}
	return 0
}

func (m *ResourceRequirements) GetGpus() float32 {
	if m != nil {
		return m.Gpus
	}
	return 0
}

func (m *ResourceRequirements) GetMemory() float32 {
	if m != nil {
		return m.Memory
	}
	return 0
}

func (m *ResourceRequirements) GetMemoryUnit() SizeUnit {
	if m != nil {
		return m.MemoryUnit
	}
	return SizeUnit_MB
}

func (m *ResourceRequirements) GetStorage() float32 {
	if m != nil {
		return m.Storage
	}
	return 0
}

func (m *ResourceRequirements) GetStorageUnit() SizeUnit {
	if m != nil {
		return m.StorageUnit
	}
	return SizeUnit_MB
}

func (m *ResourceRequirements) GetLearners() int32 {
	if m != nil {
		return m.Learners
	}
	return 0
}

func (m *ResourceRequirements) GetSchedpolicy() string {
	if m != nil {
		return m.Schedpolicy
	}
	return ""
}

func (m *ResourceRequirements) GetTopology() string {
	if m != nil {
		return m.Topology
	}
	return ""
}

func (m *ResourceRequirements) GetArchitecture() string {
	if m != nil {
		return m.Architecture
	}
	return ""
}

func (m *ResourceRequirements) GetGpuType() string {
	if m != nil {
		return m.GpuType
	}
	return ""
}

type ModelDefinitionRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
}

func (m *ModelDefinitionRequest) Reset()                    { *m = ModelDefinitionRequest{} }
func (m *ModelDefinitionRequest) String() string            { return proto.CompactTextString(m) }
func (*ModelDefinitionRequest) ProtoMessage()               {}
func (*ModelDefinitionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *ModelDefinitionRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *ModelDefinitionRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type TrainedModelRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
}

func (m *TrainedModelRequest) Reset()                    { *m = TrainedModelRequest{} }
func (m *TrainedModelRequest) String() string            { return proto.CompactTextString(m) }
func (*TrainedModelRequest) ProtoMessage()               {}
func (*TrainedModelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *TrainedModelRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *TrainedModelRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type TrainedModelLogRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	Follow     bool   `protobuf:"varint,5,opt,name=follow" json:"follow,omitempty" bson:"follow,omitempty"`
	// These are for internal use only, and will be eventually removed!
	IsMetrics bool `protobuf:"varint,3,opt,name=is_metrics,json=isMetrics" json:"is_metrics,omitempty" bson:"is_metrics,omitempty"`
	IsSummary bool `protobuf:"varint,4,opt,name=is_summary,json=isSummary" json:"is_summary,omitempty" bson:"is_summary,omitempty"`
}

func (m *TrainedModelLogRequest) Reset()                    { *m = TrainedModelLogRequest{} }
func (m *TrainedModelLogRequest) String() string            { return proto.CompactTextString(m) }
func (*TrainedModelLogRequest) ProtoMessage()               {}
func (*TrainedModelLogRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *TrainedModelLogRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *TrainedModelLogRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *TrainedModelLogRequest) GetFollow() bool {
	if m != nil {
		return m.Follow
	}
	return false
}

func (m *TrainedModelLogRequest) GetIsMetrics() bool {
	if m != nil {
		return m.IsMetrics
	}
	return false
}

func (m *TrainedModelLogRequest) GetIsSummary() bool {
	if m != nil {
		return m.IsSummary
	}
	return false
}

type TrainedModelMetricsRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	Follow     bool   `protobuf:"varint,3,opt,name=follow" json:"follow,omitempty" bson:"follow,omitempty"`
}

func (m *TrainedModelMetricsRequest) Reset()                    { *m = TrainedModelMetricsRequest{} }
func (m *TrainedModelMetricsRequest) String() string            { return proto.CompactTextString(m) }
func (*TrainedModelMetricsRequest) ProtoMessage()               {}
func (*TrainedModelMetricsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *TrainedModelMetricsRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *TrainedModelMetricsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *TrainedModelMetricsRequest) GetFollow() bool {
	if m != nil {
		return m.Follow
	}
	return false
}

type GetLatestMetricsRequest struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
}

func (m *GetLatestMetricsRequest) Reset()                    { *m = GetLatestMetricsRequest{} }
func (m *GetLatestMetricsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetLatestMetricsRequest) ProtoMessage()               {}
func (*GetLatestMetricsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *GetLatestMetricsRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *GetLatestMetricsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type GetLatestMetricsResponse struct {
	TrainingId string   `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string   `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	Metrics    *Metrics `protobuf:"bytes,3,opt,name=metrics" json:"metrics,omitempty" bson:"metrics,omitempty"`
}

func (m *GetLatestMetricsResponse) Reset()                    { *m = GetLatestMetricsResponse{} }
func (m *GetLatestMetricsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetLatestMetricsResponse) ProtoMessage()               {}
func (*GetLatestMetricsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *GetLatestMetricsResponse) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *GetLatestMetricsResponse) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetLatestMetricsResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type UpdateTrainedModelMetricsRequest struct {
	TrainingId string   `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
	UserId     string   `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty" bson:"user_id,omitempty"`
	NewMetrics *Metrics `protobuf:"bytes,3,opt,name=new_metrics,json=newMetrics" json:"new_metrics,omitempty" bson:"new_metrics,omitempty"`
}

func (m *UpdateTrainedModelMetricsRequest) Reset()         { *m = UpdateTrainedModelMetricsRequest{} }
func (m *UpdateTrainedModelMetricsRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTrainedModelMetricsRequest) ProtoMessage()    {}
func (*UpdateTrainedModelMetricsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{42}
}

func (m *UpdateTrainedModelMetricsRequest) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

func (m *UpdateTrainedModelMetricsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UpdateTrainedModelMetricsRequest) GetNewMetrics() *Metrics {
	if m != nil {
		return m.NewMetrics
	}
	return nil
}

type UpdateTrainedModelMetricsResponse struct {
	TrainingId string `protobuf:"bytes,1,opt,name=training_id,json=trainingId" json:"training_id,omitempty" bson:"training_id,omitempty"`
}

func (m *UpdateTrainedModelMetricsResponse) Reset()         { *m = UpdateTrainedModelMetricsResponse{} }
func (m *UpdateTrainedModelMetricsResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateTrainedModelMetricsResponse) ProtoMessage()    {}
func (*UpdateTrainedModelMetricsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{43}
}

func (m *UpdateTrainedModelMetricsResponse) GetTrainingId() string {
	if m != nil {
		return m.TrainingId
	}
	return ""
}

type ByteStreamResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty" bson:"data,omitempty"`
}

func (m *ByteStreamResponse) Reset()                    { *m = ByteStreamResponse{} }
func (m *ByteStreamResponse) String() string            { return proto.CompactTextString(m) }
func (*ByteStreamResponse) ProtoMessage()               {}
func (*ByteStreamResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *ByteStreamResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type ZippedDataChunk struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty" bson:"data,omitempty"`
}

func (m *ZippedDataChunk) Reset()                    { *m = ZippedDataChunk{} }
func (m *ZippedDataChunk) String() string            { return proto.CompactTextString(m) }
func (*ZippedDataChunk) ProtoMessage()               {}
func (*ZippedDataChunk) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *ZippedDataChunk) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type GetVersionsRequest struct {
}

func (m *GetVersionsRequest) Reset()                    { *m = GetVersionsRequest{} }
func (m *GetVersionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVersionsRequest) ProtoMessage()               {}
func (*GetVersionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

// Contains a list of all frameworks currently supported along with the versions of that framework and whether a
// specific framework version can be used by anyone or only for internal usage.
type Frameworks struct {
	Frameworks map[string]*FrameworkDetailList `protobuf:"bytes,1,rep,name=frameworks" json:"frameworks,omitempty" bson:"frameworks,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Frameworks) Reset()                    { *m = Frameworks{} }
func (m *Frameworks) String() string            { return proto.CompactTextString(m) }
func (*Frameworks) ProtoMessage()               {}
func (*Frameworks) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *Frameworks) GetFrameworks() map[string]*FrameworkDetailList {
	if m != nil {
		return m.Frameworks
	}
	return nil
}

type FrameworkDetailList struct {
	Versions []*FrameworkDetails `protobuf:"bytes,1,rep,name=versions" json:"versions,omitempty" bson:"versions,omitempty"`
}

func (m *FrameworkDetailList) Reset()                    { *m = FrameworkDetailList{} }
func (m *FrameworkDetailList) String() string            { return proto.CompactTextString(m) }
func (*FrameworkDetailList) ProtoMessage()               {}
func (*FrameworkDetailList) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *FrameworkDetailList) GetVersions() []*FrameworkDetails {
	if m != nil {
		return m.Versions
	}
	return nil
}

type FrameworkDetails struct {
	Version string `protobuf:"bytes,1,opt,name=version" json:"version,omitempty" bson:"version,omitempty"`
	// If true, the image can be used by any user. If false, the image is only available for internal usage.
	External bool `protobuf:"varint,2,opt,name=external" json:"external,omitempty" bson:"external,omitempty"`
}

func (m *FrameworkDetails) Reset()                    { *m = FrameworkDetails{} }
func (m *FrameworkDetails) String() string            { return proto.CompactTextString(m) }
func (*FrameworkDetails) ProtoMessage()               {}
func (*FrameworkDetails) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{49} }

func (m *FrameworkDetails) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *FrameworkDetails) GetExternal() bool {
	if m != nil {
		return m.External
	}
	return false
}

func init() {
	proto.RegisterType((*CreateRequest)(nil), "grpc.trainer.v2.CreateRequest")
	proto.RegisterType((*EMExtractionSpec)(nil), "grpc.trainer.v2.EMExtractionSpec")
	proto.RegisterType((*EMGroup)(nil), "grpc.trainer.v2.EMGroup")
	proto.RegisterType((*EMMeta)(nil), "grpc.trainer.v2.EMMeta")
	proto.RegisterType((*EMAny)(nil), "grpc.trainer.v2.EMAny")
	proto.RegisterType((*MetaInfo)(nil), "grpc.trainer.v2.MetaInfo")
	proto.RegisterType((*LogLine)(nil), "grpc.trainer.v2.LogLine")
	proto.RegisterType((*Any)(nil), "grpc.trainer.v2.Any")
	proto.RegisterType((*EMetrics)(nil), "grpc.trainer.v2.EMetrics")
	proto.RegisterType((*Query)(nil), "grpc.trainer.v2.Query")
	proto.RegisterType((*CreateResponse)(nil), "grpc.trainer.v2.CreateResponse")
	proto.RegisterType((*UpdateRequest)(nil), "grpc.trainer.v2.UpdateRequest")
	proto.RegisterType((*UpdateResponse)(nil), "grpc.trainer.v2.UpdateResponse")
	proto.RegisterType((*GetRequest)(nil), "grpc.trainer.v2.GetRequest")
	proto.RegisterType((*GetResponse)(nil), "grpc.trainer.v2.GetResponse")
	proto.RegisterType((*GetStatusResponse)(nil), "grpc.trainer.v2.GetStatusResponse")
	proto.RegisterType((*GetStatusIDResponse)(nil), "grpc.trainer.v2.GetStatusIDResponse")
	proto.RegisterType((*GetMetricsStringResponse)(nil), "grpc.trainer.v2.GetMetricsStringResponse")
	proto.RegisterType((*GetTestResponse)(nil), "grpc.trainer.v2.GetTestResponse")
	proto.RegisterType((*GetAllRequest)(nil), "grpc.trainer.v2.GetAllRequest")
	proto.RegisterType((*GetAllResponse)(nil), "grpc.trainer.v2.GetAllResponse")
	proto.RegisterType((*HaltRequest)(nil), "grpc.trainer.v2.HaltRequest")
	proto.RegisterType((*HaltResponse)(nil), "grpc.trainer.v2.HaltResponse")
	proto.RegisterType((*ResumeRequest)(nil), "grpc.trainer.v2.ResumeRequest")
	proto.RegisterType((*ResumeResponse)(nil), "grpc.trainer.v2.ResumeResponse")
	proto.RegisterType((*DeleteRequest)(nil), "grpc.trainer.v2.DeleteRequest")
	proto.RegisterType((*DeleteResponse)(nil), "grpc.trainer.v2.DeleteResponse")
	proto.RegisterType((*Metrics)(nil), "grpc.trainer.v2.Metrics")
	proto.RegisterType((*Job)(nil), "grpc.trainer.v2.Job")
	proto.RegisterType((*ModelDefinition)(nil), "grpc.trainer.v2.ModelDefinition")
	proto.RegisterType((*Framework)(nil), "grpc.trainer.v2.Framework")
	proto.RegisterType((*ImageLocation)(nil), "grpc.trainer.v2.ImageLocation")
	proto.RegisterType((*Training)(nil), "grpc.trainer.v2.Training")
	proto.RegisterType((*TrainingStatus)(nil), "grpc.trainer.v2.TrainingStatus")
	proto.RegisterType((*Datastore)(nil), "grpc.trainer.v2.Datastore")
	proto.RegisterType((*ResourceRequirements)(nil), "grpc.trainer.v2.ResourceRequirements")
	proto.RegisterType((*ModelDefinitionRequest)(nil), "grpc.trainer.v2.ModelDefinitionRequest")
	proto.RegisterType((*TrainedModelRequest)(nil), "grpc.trainer.v2.TrainedModelRequest")
	proto.RegisterType((*TrainedModelLogRequest)(nil), "grpc.trainer.v2.TrainedModelLogRequest")
	proto.RegisterType((*TrainedModelMetricsRequest)(nil), "grpc.trainer.v2.TrainedModelMetricsRequest")
	proto.RegisterType((*GetLatestMetricsRequest)(nil), "grpc.trainer.v2.GetLatestMetricsRequest")
	proto.RegisterType((*GetLatestMetricsResponse)(nil), "grpc.trainer.v2.GetLatestMetricsResponse")
	proto.RegisterType((*UpdateTrainedModelMetricsRequest)(nil), "grpc.trainer.v2.UpdateTrainedModelMetricsRequest")
	proto.RegisterType((*UpdateTrainedModelMetricsResponse)(nil), "grpc.trainer.v2.UpdateTrainedModelMetricsResponse")
	proto.RegisterType((*ByteStreamResponse)(nil), "grpc.trainer.v2.ByteStreamResponse")
	proto.RegisterType((*ZippedDataChunk)(nil), "grpc.trainer.v2.ZippedDataChunk")
	proto.RegisterType((*GetVersionsRequest)(nil), "grpc.trainer.v2.GetVersionsRequest")
	proto.RegisterType((*Frameworks)(nil), "grpc.trainer.v2.Frameworks")
	proto.RegisterType((*FrameworkDetailList)(nil), "grpc.trainer.v2.FrameworkDetailList")
	proto.RegisterType((*FrameworkDetails)(nil), "grpc.trainer.v2.FrameworkDetails")
	proto.RegisterEnum("grpc.trainer.v2.SizeUnit", SizeUnit_name, SizeUnit_value)
	proto.RegisterEnum("grpc.trainer.v2.Status", Status_name, Status_value)
	proto.RegisterEnum("grpc.trainer.v2.Any_DataType", Any_DataType_name, Any_DataType_value)
	proto.RegisterEnum("grpc.trainer.v2.Query_SearchType", Query_SearchType_name, Query_SearchType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Trainer service

type TrainerClient interface {
	// Creates a new deep learning training job for a given model definition.
	CreateTrainingJob(ctx context.Context, in *CreateRequest, opts ...grpc.CallOption) (*CreateResponse, error)
	// Reads a training job with a given ID.
	GetTrainingJob(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (*GetResponse, error)
	// Returns all training jobs for a given user.
	GetAllTrainingsJobs(ctx context.Context, in *GetAllRequest, opts ...grpc.CallOption) (*GetAllResponse, error)
	// Deletes a training job with a given ID.
	DeleteTrainingJob(ctx context.Context, in *DeleteRequest, opts ...grpc.CallOption) (*DeleteResponse, error)
	// Halts the training with a given ID without discarding the result.
	HaltTrainingJob(ctx context.Context, in *HaltRequest, opts ...grpc.CallOption) (*HaltResponse, error)
	// Returns the model definition that was used for training as application/zip.
	GetModelDefinition(ctx context.Context, in *ModelDefinitionRequest, opts ...grpc.CallOption) (Trainer_GetModelDefinitionClient, error)
	// Returns the trained model as application/zip.
	GetTrainedModel(ctx context.Context, in *TrainedModelRequest, opts ...grpc.CallOption) (Trainer_GetTrainedModelClient, error)
	// Returns the logs from the ZIP file stored in the object store.
	// Deprecated
	GetTrainedModelLogs(ctx context.Context, in *TrainedModelLogRequest, opts ...grpc.CallOption) (Trainer_GetTrainedModelLogsClient, error)
	GetTrainingLogs(ctx context.Context, in *Query, opts ...grpc.CallOption) (Trainer_GetTrainingLogsClient, error)
	// Get evaluation metrics records, based on query
	GetTrainingEMetrics(ctx context.Context, in *Query, opts ...grpc.CallOption) (Trainer_GetTrainingEMetricsClient, error)
	GetVersions(ctx context.Context, in *GetVersionsRequest, opts ...grpc.CallOption) (*Frameworks, error)
	// For internal use only!
	GetTrainingStatusID(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (*GetStatusIDResponse, error)
	// For internal use only!
	// Updates an existing training status
	// TODO we should not have this but until we fix the status update handling properly, we have no other choice.
	UpdateTrainingJob(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error)
	// Not implemented, to be removed (for GA)
	ResumeTrainingJob(ctx context.Context, in *ResumeRequest, opts ...grpc.CallOption) (*ResumeResponse, error)
}

type trainerClient struct {
	cc *grpc.ClientConn
}

func NewTrainerClient(cc *grpc.ClientConn) TrainerClient {
	return &trainerClient{cc}
}

func (c *trainerClient) CreateTrainingJob(ctx context.Context, in *CreateRequest, opts ...grpc.CallOption) (*CreateResponse, error) {
	out := new(CreateResponse)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/CreateTrainingJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trainerClient) GetTrainingJob(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (*GetResponse, error) {
	out := new(GetResponse)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/GetTrainingJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trainerClient) GetAllTrainingsJobs(ctx context.Context, in *GetAllRequest, opts ...grpc.CallOption) (*GetAllResponse, error) {
	out := new(GetAllResponse)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/GetAllTrainingsJobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trainerClient) DeleteTrainingJob(ctx context.Context, in *DeleteRequest, opts ...grpc.CallOption) (*DeleteResponse, error) {
	out := new(DeleteResponse)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/DeleteTrainingJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trainerClient) HaltTrainingJob(ctx context.Context, in *HaltRequest, opts ...grpc.CallOption) (*HaltResponse, error) {
	out := new(HaltResponse)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/HaltTrainingJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trainerClient) GetModelDefinition(ctx context.Context, in *ModelDefinitionRequest, opts ...grpc.CallOption) (Trainer_GetModelDefinitionClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Trainer_serviceDesc.Streams[0], c.cc, "/grpc.trainer.v2.Trainer/GetModelDefinition", opts...)
	if err != nil {
		return nil, err
	}
	x := &trainerGetModelDefinitionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Trainer_GetModelDefinitionClient interface {
	Recv() (*ZippedDataChunk, error)
	grpc.ClientStream
}

type trainerGetModelDefinitionClient struct {
	grpc.ClientStream
}

func (x *trainerGetModelDefinitionClient) Recv() (*ZippedDataChunk, error) {
	m := new(ZippedDataChunk)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *trainerClient) GetTrainedModel(ctx context.Context, in *TrainedModelRequest, opts ...grpc.CallOption) (Trainer_GetTrainedModelClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Trainer_serviceDesc.Streams[1], c.cc, "/grpc.trainer.v2.Trainer/GetTrainedModel", opts...)
	if err != nil {
		return nil, err
	}
	x := &trainerGetTrainedModelClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Trainer_GetTrainedModelClient interface {
	Recv() (*ZippedDataChunk, error)
	grpc.ClientStream
}

type trainerGetTrainedModelClient struct {
	grpc.ClientStream
}

func (x *trainerGetTrainedModelClient) Recv() (*ZippedDataChunk, error) {
	m := new(ZippedDataChunk)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *trainerClient) GetTrainedModelLogs(ctx context.Context, in *TrainedModelLogRequest, opts ...grpc.CallOption) (Trainer_GetTrainedModelLogsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Trainer_serviceDesc.Streams[2], c.cc, "/grpc.trainer.v2.Trainer/GetTrainedModelLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &trainerGetTrainedModelLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Trainer_GetTrainedModelLogsClient interface {
	Recv() (*ByteStreamResponse, error)
	grpc.ClientStream
}

type trainerGetTrainedModelLogsClient struct {
	grpc.ClientStream
}

func (x *trainerGetTrainedModelLogsClient) Recv() (*ByteStreamResponse, error) {
	m := new(ByteStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *trainerClient) GetTrainingLogs(ctx context.Context, in *Query, opts ...grpc.CallOption) (Trainer_GetTrainingLogsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Trainer_serviceDesc.Streams[3], c.cc, "/grpc.trainer.v2.Trainer/GetTrainingLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &trainerGetTrainingLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Trainer_GetTrainingLogsClient interface {
	Recv() (*LogLine, error)
	grpc.ClientStream
}

type trainerGetTrainingLogsClient struct {
	grpc.ClientStream
}

func (x *trainerGetTrainingLogsClient) Recv() (*LogLine, error) {
	m := new(LogLine)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *trainerClient) GetTrainingEMetrics(ctx context.Context, in *Query, opts ...grpc.CallOption) (Trainer_GetTrainingEMetricsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Trainer_serviceDesc.Streams[4], c.cc, "/grpc.trainer.v2.Trainer/GetTrainingEMetrics", opts...)
	if err != nil {
		return nil, err
	}
	x := &trainerGetTrainingEMetricsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Trainer_GetTrainingEMetricsClient interface {
	Recv() (*EMetrics, error)
	grpc.ClientStream
}

type trainerGetTrainingEMetricsClient struct {
	grpc.ClientStream
}

func (x *trainerGetTrainingEMetricsClient) Recv() (*EMetrics, error) {
	m := new(EMetrics)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *trainerClient) GetVersions(ctx context.Context, in *GetVersionsRequest, opts ...grpc.CallOption) (*Frameworks, error) {
	out := new(Frameworks)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/GetVersions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trainerClient) GetTrainingStatusID(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (*GetStatusIDResponse, error) {
	out := new(GetStatusIDResponse)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/GetTrainingStatusID", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trainerClient) UpdateTrainingJob(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error) {
	out := new(UpdateResponse)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/UpdateTrainingJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trainerClient) ResumeTrainingJob(ctx context.Context, in *ResumeRequest, opts ...grpc.CallOption) (*ResumeResponse, error) {
	out := new(ResumeResponse)
	err := grpc.Invoke(ctx, "/grpc.trainer.v2.Trainer/ResumeTrainingJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Trainer service

type TrainerServer interface {
	// Creates a new deep learning training job for a given model definition.
	CreateTrainingJob(context.Context, *CreateRequest) (*CreateResponse, error)
	// Reads a training job with a given ID.
	GetTrainingJob(context.Context, *GetRequest) (*GetResponse, error)
	// Returns all training jobs for a given user.
	GetAllTrainingsJobs(context.Context, *GetAllRequest) (*GetAllResponse, error)
	// Deletes a training job with a given ID.
	DeleteTrainingJob(context.Context, *DeleteRequest) (*DeleteResponse, error)
	// Halts the training with a given ID without discarding the result.
	HaltTrainingJob(context.Context, *HaltRequest) (*HaltResponse, error)
	// Returns the model definition that was used for training as application/zip.
	GetModelDefinition(*ModelDefinitionRequest, Trainer_GetModelDefinitionServer) error
	// Returns the trained model as application/zip.
	GetTrainedModel(*TrainedModelRequest, Trainer_GetTrainedModelServer) error
	// Returns the logs from the ZIP file stored in the object store.
	// Deprecated
	GetTrainedModelLogs(*TrainedModelLogRequest, Trainer_GetTrainedModelLogsServer) error
	GetTrainingLogs(*Query, Trainer_GetTrainingLogsServer) error
	// Get evaluation metrics records, based on query
	GetTrainingEMetrics(*Query, Trainer_GetTrainingEMetricsServer) error
	GetVersions(context.Context, *GetVersionsRequest) (*Frameworks, error)
	// For internal use only!
	GetTrainingStatusID(context.Context, *GetRequest) (*GetStatusIDResponse, error)
	// For internal use only!
	// Updates an existing training status
	// TODO we should not have this but until we fix the status update handling properly, we have no other choice.
	UpdateTrainingJob(context.Context, *UpdateRequest) (*UpdateResponse, error)
	// Not implemented, to be removed (for GA)
	ResumeTrainingJob(context.Context, *ResumeRequest) (*ResumeResponse, error)
}

func RegisterTrainerServer(s *grpc.Server, srv TrainerServer) {
	s.RegisterService(&_Trainer_serviceDesc, srv)
}

func _Trainer_CreateTrainingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).CreateTrainingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/CreateTrainingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).CreateTrainingJob(ctx, req.(*CreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Trainer_GetTrainingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).GetTrainingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/GetTrainingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).GetTrainingJob(ctx, req.(*GetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Trainer_GetAllTrainingsJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAllRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).GetAllTrainingsJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/GetAllTrainingsJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).GetAllTrainingsJobs(ctx, req.(*GetAllRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Trainer_DeleteTrainingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).DeleteTrainingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/DeleteTrainingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).DeleteTrainingJob(ctx, req.(*DeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Trainer_HaltTrainingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HaltRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).HaltTrainingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/HaltTrainingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).HaltTrainingJob(ctx, req.(*HaltRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Trainer_GetModelDefinition_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ModelDefinitionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TrainerServer).GetModelDefinition(m, &trainerGetModelDefinitionServer{stream})
}

type Trainer_GetModelDefinitionServer interface {
	Send(*ZippedDataChunk) error
	grpc.ServerStream
}

type trainerGetModelDefinitionServer struct {
	grpc.ServerStream
}

func (x *trainerGetModelDefinitionServer) Send(m *ZippedDataChunk) error {
	return x.ServerStream.SendMsg(m)
}

func _Trainer_GetTrainedModel_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TrainedModelRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TrainerServer).GetTrainedModel(m, &trainerGetTrainedModelServer{stream})
}

type Trainer_GetTrainedModelServer interface {
	Send(*ZippedDataChunk) error
	grpc.ServerStream
}

type trainerGetTrainedModelServer struct {
	grpc.ServerStream
}

func (x *trainerGetTrainedModelServer) Send(m *ZippedDataChunk) error {
	return x.ServerStream.SendMsg(m)
}

func _Trainer_GetTrainedModelLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TrainedModelLogRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TrainerServer).GetTrainedModelLogs(m, &trainerGetTrainedModelLogsServer{stream})
}

type Trainer_GetTrainedModelLogsServer interface {
	Send(*ByteStreamResponse) error
	grpc.ServerStream
}

type trainerGetTrainedModelLogsServer struct {
	grpc.ServerStream
}

func (x *trainerGetTrainedModelLogsServer) Send(m *ByteStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Trainer_GetTrainingLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Query)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TrainerServer).GetTrainingLogs(m, &trainerGetTrainingLogsServer{stream})
}

type Trainer_GetTrainingLogsServer interface {
	Send(*LogLine) error
	grpc.ServerStream
}

type trainerGetTrainingLogsServer struct {
	grpc.ServerStream
}

func (x *trainerGetTrainingLogsServer) Send(m *LogLine) error {
	return x.ServerStream.SendMsg(m)
}

func _Trainer_GetTrainingEMetrics_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Query)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TrainerServer).GetTrainingEMetrics(m, &trainerGetTrainingEMetricsServer{stream})
}

type Trainer_GetTrainingEMetricsServer interface {
	Send(*EMetrics) error
	grpc.ServerStream
}

type trainerGetTrainingEMetricsServer struct {
	grpc.ServerStream
}

func (x *trainerGetTrainingEMetricsServer) Send(m *EMetrics) error {
	return x.ServerStream.SendMsg(m)
}

func _Trainer_GetVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).GetVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/GetVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).GetVersions(ctx, req.(*GetVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Trainer_GetTrainingStatusID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).GetTrainingStatusID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/GetTrainingStatusID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).GetTrainingStatusID(ctx, req.(*GetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Trainer_UpdateTrainingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).UpdateTrainingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/UpdateTrainingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).UpdateTrainingJob(ctx, req.(*UpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Trainer_ResumeTrainingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrainerServer).ResumeTrainingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grpc.trainer.v2.Trainer/ResumeTrainingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrainerServer).ResumeTrainingJob(ctx, req.(*ResumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Trainer_serviceDesc = grpc.ServiceDesc{
	ServiceName: "grpc.trainer.v2.Trainer",
	HandlerType: (*TrainerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTrainingJob",
			Handler:    _Trainer_CreateTrainingJob_Handler,
		},
		{
			MethodName: "GetTrainingJob",
			Handler:    _Trainer_GetTrainingJob_Handler,
		},
		{
			MethodName: "GetAllTrainingsJobs",
			Handler:    _Trainer_GetAllTrainingsJobs_Handler,
		},
		{
			MethodName: "DeleteTrainingJob",
			Handler:    _Trainer_DeleteTrainingJob_Handler,
		},
		{
			MethodName: "HaltTrainingJob",
			Handler:    _Trainer_HaltTrainingJob_Handler,
		},
		{
			MethodName: "GetVersions",
			Handler:    _Trainer_GetVersions_Handler,
		},
		{
			MethodName: "GetTrainingStatusID",
			Handler:    _Trainer_GetTrainingStatusID_Handler,
		},
		{
			MethodName: "UpdateTrainingJob",
			Handler:    _Trainer_UpdateTrainingJob_Handler,
		},
		{
			MethodName: "ResumeTrainingJob",
			Handler:    _Trainer_ResumeTrainingJob_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetModelDefinition",
			Handler:       _Trainer_GetModelDefinition_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTrainedModel",
			Handler:       _Trainer_GetTrainedModel_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTrainedModelLogs",
			Handler:       _Trainer_GetTrainedModelLogs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTrainingLogs",
			Handler:       _Trainer_GetTrainingLogs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTrainingEMetrics",
			Handler:       _Trainer_GetTrainingEMetrics_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "trainer.proto",
}

func init() { proto.RegisterFile("trainer.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2562 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0xcd, 0x73, 0x1b, 0x49,
	0x15, 0xf7, 0x68, 0xac, 0xaf, 0xa7, 0x58, 0xd6, 0x76, 0x1c, 0x47, 0x51, 0xbe, 0x9c, 0xd9, 0x64,
	0x71, 0x65, 0x77, 0xbd, 0xc4, 0xb0, 0x4b, 0xd6, 0x95, 0x50, 0xa5, 0x58, 0xb2, 0xe2, 0xac, 0x6c,
	0x39, 0x23, 0x25, 0xc0, 0x56, 0x51, 0xaa, 0xd1, 0xa8, 0xad, 0x4c, 0x32, 0x5f, 0xcc, 0xb4, 0x92,
	0x68, 0xb9, 0x41, 0x15, 0x45, 0x71, 0xdd, 0x03, 0x27, 0xee, 0xfc, 0x03, 0x40, 0x15, 0x07, 0xae,
	0xdc, 0xb9, 0x70, 0xe3, 0x4f, 0xe0, 0xc6, 0x81, 0x1b, 0xd5, 0x1f, 0xf3, 0x25, 0x8d, 0x2c, 0x1b,
	0x9b, 0xe2, 0xd6, 0xfd, 0xfa, 0xbd, 0xdf, 0x74, 0xbf, 0x7e, 0x5f, 0xfd, 0x24, 0x58, 0x21, 0x9e,
	0x66, 0xd8, 0xd8, 0xdb, 0x72, 0x3d, 0x87, 0x38, 0x68, 0x75, 0xe4, 0xb9, 0xfa, 0x56, 0x40, 0x7b,
	0xbb, 0xad, 0xfc, 0x39, 0x03, 0x2b, 0xbb, 0x1e, 0xd6, 0x08, 0x56, 0xf1, 0xcf, 0xc6, 0xd8, 0x27,
	0xe8, 0x2a, 0xe4, 0xc7, 0x3e, 0xf6, 0xfa, 0xc6, 0xb0, 0x2a, 0x6d, 0x48, 0x9b, 0x45, 0x35, 0x47,
	0xa7, 0xfb, 0x43, 0xf4, 0x15, 0x54, 0x2c, 0x67, 0x88, 0xcd, 0xfe, 0x10, 0x1f, 0x1b, 0xb6, 0x41,
	0x0c, 0xc7, 0xae, 0x66, 0x36, 0xa4, 0xcd, 0xd2, 0xf6, 0xc6, 0xd6, 0x14, 0xec, 0xd6, 0x01, 0x65,
	0x6c, 0x84, 0x7c, 0xea, 0xaa, 0x95, 0x24, 0xa0, 0xcf, 0xa1, 0xc0, 0xd8, 0x0d, 0x7b, 0x54, 0x95,
	0x19, 0xc8, 0xb5, 0x19, 0x90, 0x9e, 0x60, 0x50, 0x43, 0x56, 0xb4, 0x03, 0x30, 0xd4, 0x88, 0xe6,
	0x13, 0xc7, 0xc3, 0x7e, 0x75, 0x79, 0x43, 0xde, 0x2c, 0x6d, 0xd7, 0x66, 0x04, 0x1b, 0x01, 0x8b,
	0x1a, 0xe3, 0x46, 0x47, 0x80, 0xf0, 0x5b, 0xcd, 0x1c, 0x6b, 0x74, 0x03, 0x7d, 0x0b, 0x13, 0xcf,
	0xd0, 0xfd, 0x6a, 0x96, 0x7d, 0xfc, 0xce, 0x0c, 0x46, 0xf3, 0xa0, 0xf9, 0x9e, 0x78, 0x9a, 0x4e,
	0x99, 0xbb, 0x2e, 0xd6, 0xd5, 0x0f, 0x22, 0xe1, 0x03, 0x2e, 0xab, 0xfc, 0x31, 0x03, 0x95, 0x69,
	0x3e, 0x84, 0x60, 0x99, 0x4c, 0x5c, 0x2c, 0x94, 0xc7, 0xc6, 0xe8, 0x3a, 0x14, 0x0d, 0x4b, 0x1b,
	0xe1, 0x3e, 0xd1, 0x46, 0xd5, 0x1c, 0x5b, 0x28, 0x30, 0x42, 0x4f, 0x1b, 0xa1, 0x32, 0x64, 0x0c,
	0xae, 0xc9, 0xa2, 0x9a, 0x31, 0x6c, 0x74, 0x0f, 0xca, 0xa6, 0x61, 0xe3, 0xbe, 0xe9, 0x38, 0x6f,
	0xb4, 0x57, 0x58, 0x1b, 0x32, 0x05, 0x65, 0xd5, 0x15, 0x4a, 0x6d, 0x07, 0x44, 0x74, 0x0b, 0x00,
	0xbf, 0xc5, 0x36, 0xe9, 0x4d, 0x5c, 0xa1, 0x8a, 0xa2, 0x1a, 0xa3, 0xa0, 0x26, 0xe4, 0x46, 0x9e,
	0x33, 0x76, 0xe9, 0x11, 0xa9, 0x9a, 0x3e, 0x5d, 0x78, 0xc4, 0xad, 0x16, 0xe3, 0x6f, 0xda, 0xc4,
	0x9b, 0xa8, 0x42, 0xb8, 0xd6, 0x85, 0x52, 0x8c, 0x8c, 0x2a, 0x20, 0xbf, 0xc1, 0x13, 0x71, 0x38,
	0x3a, 0x44, 0x5b, 0x90, 0xa5, 0x8a, 0xc1, 0xc2, 0x16, 0xaa, 0x29, 0x9f, 0x61, 0x00, 0x2a, 0x67,
	0xdb, 0xc9, 0x3c, 0x94, 0x94, 0x7f, 0x66, 0x20, 0x2f, 0xc8, 0x68, 0x0d, 0xb2, 0x1e, 0x1e, 0xe1,
	0xf7, 0x02, 0x93, 0x4f, 0xd0, 0xc7, 0xb0, 0x6c, 0x61, 0xa2, 0x09, 0xd0, 0xab, 0x29, 0xa0, 0x07,
	0x98, 0x68, 0x2a, 0x63, 0x42, 0x8f, 0x20, 0xc7, 0xb0, 0xfd, 0xaa, 0xcc, 0x8e, 0x7a, 0x77, 0xde,
	0x1e, 0xb6, 0x5e, 0x32, 0x36, 0x71, 0x42, 0x2e, 0x43, 0xa5, 0x31, 0x31, 0xac, 0xd0, 0x9e, 0xe6,
	0x4b, 0x37, 0x19, 0x9b, 0x90, 0xe6, 0x32, 0xb5, 0xe7, 0x50, 0x8a, 0x81, 0xa6, 0xe8, 0xe7, 0x93,
	0xa4, 0x7e, 0xd6, 0x53, 0xd0, 0xeb, 0xf6, 0x24, 0xa6, 0x1d, 0x0a, 0x19, 0xfb, 0xd2, 0x45, 0x40,
	0x2a, 0xdb, 0x90, 0xe3, 0x1a, 0x63, 0xe6, 0x69, 0x58, 0x98, 0xd9, 0x14, 0x35, 0x4f, 0xc3, 0xc2,
	0xf4, 0x0a, 0xfc, 0xf1, 0xc0, 0x18, 0x32, 0x67, 0x28, 0xaa, 0x7c, 0xa2, 0x3c, 0x80, 0x2c, 0xc3,
	0x49, 0xb5, 0xe8, 0xb5, 0xf8, 0x16, 0x8a, 0xe2, 0x53, 0xca, 0xaf, 0x24, 0x28, 0xd0, 0xaf, 0xec,
	0xdb, 0xc7, 0x0e, 0xba, 0x0d, 0xa5, 0xc0, 0x6f, 0xa3, 0x60, 0x02, 0x01, 0x69, 0x7f, 0x18, 0x8f,
	0x34, 0x99, 0x44, 0xa4, 0x89, 0xef, 0x51, 0x16, 0x7b, 0x5c, 0x87, 0x9c, 0x67, 0xd8, 0x43, 0xfc,
	0xbe, 0xba, 0xcc, 0xa8, 0x62, 0x36, 0x67, 0xef, 0x6d, 0xc8, 0xb7, 0x9d, 0x51, 0xdb, 0xb0, 0x31,
	0xfa, 0x54, 0x58, 0x92, 0x34, 0x27, 0xca, 0x04, 0xfb, 0x15, 0xb6, 0x84, 0x60, 0x99, 0xfa, 0x99,
	0xd8, 0x11, 0x1b, 0x2b, 0xbf, 0x91, 0x40, 0xa6, 0x8a, 0x78, 0x10, 0x53, 0x44, 0x79, 0xfb, 0xe6,
	0x0c, 0x54, 0xdd, 0x9e, 0xb0, 0xd8, 0x43, 0x1d, 0xf0, 0x44, 0x3d, 0xed, 0x40, 0x21, 0xe0, 0x43,
	0x00, 0xb9, 0x6e, 0x4f, 0xdd, 0x3f, 0x6c, 0x55, 0x96, 0x50, 0x19, 0xe0, 0x59, 0xb7, 0x73, 0x28,
	0xe6, 0x12, 0xca, 0x83, 0xbc, 0x7f, 0xd8, 0xab, 0x64, 0x50, 0x11, 0xb2, 0x7b, 0xed, 0x4e, 0xbd,
	0x57, 0x91, 0x95, 0x7f, 0x67, 0xa0, 0xd0, 0x14, 0x11, 0xe8, 0xac, 0x87, 0x7b, 0x1c, 0x9a, 0x7a,
	0x86, 0x99, 0xfa, 0xbd, 0x14, 0xcb, 0xe1, 0xc8, 0x69, 0xb6, 0x4e, 0x43, 0x0e, 0x8b, 0x0a, 0xa6,
	0x36, 0xc0, 0xa6, 0xb0, 0xa0, 0x18, 0x85, 0xc2, 0x0b, 0x3f, 0x5c, 0x5e, 0x04, 0x9f, 0xe2, 0x88,
	0xb5, 0xce, 0x22, 0xbb, 0xbf, 0x9f, 0xb4, 0xfb, 0xb5, 0xb4, 0x0b, 0x88, 0x3b, 0x52, 0x67, 0x91,
	0x6f, 0x9e, 0x11, 0x50, 0xf9, 0x97, 0x04, 0xd9, 0xe7, 0x63, 0xec, 0x4d, 0x50, 0x1d, 0xc0, 0xc7,
	0x9a, 0xa7, 0xbf, 0xea, 0x45, 0x06, 0x31, 0x9b, 0x44, 0x18, 0xef, 0x56, 0x37, 0x64, 0x54, 0x63,
	0x42, 0xe1, 0xdd, 0xc9, 0xa7, 0xbb, 0x3b, 0x6a, 0xe8, 0x86, 0xad, 0x63, 0x66, 0xff, 0xd4, 0xd0,
	0xe9, 0x04, 0xd5, 0xa0, 0xe0, 0x6a, 0x23, 0xec, 0x1b, 0xdf, 0x60, 0xe6, 0x01, 0x59, 0x35, 0x9c,
	0xd3, 0xf3, 0xba, 0x8e, 0xcf, 0xf2, 0x8d, 0xac, 0xd2, 0xa1, 0xf2, 0x05, 0x40, 0xb4, 0x19, 0x54,
	0x80, 0xe5, 0x5e, 0x53, 0x3d, 0xa8, 0x2c, 0x51, 0x1b, 0x3c, 0x6c, 0x76, 0x7b, 0xcd, 0x46, 0x45,
	0xa2, 0xa6, 0x76, 0x50, 0xef, 0xed, 0x3e, 0xad, 0x64, 0xa8, 0xf9, 0xd5, 0xdb, 0xed, 0x8a, 0xac,
	0x3c, 0x80, 0x72, 0x50, 0x24, 0xf8, 0xae, 0x63, 0xfb, 0x78, 0xa1, 0x73, 0x2b, 0xff, 0x90, 0x60,
	0xe5, 0x85, 0x3b, 0x8c, 0x15, 0x16, 0xff, 0x7d, 0x3c, 0xf8, 0x0c, 0x72, 0x3e, 0xd1, 0xc8, 0xd8,
	0x67, 0xba, 0x2a, 0xa7, 0xa4, 0x83, 0x2e, 0x5b, 0x56, 0x05, 0x1b, 0x4d, 0xa1, 0x7c, 0xd4, 0xb7,
	0xb0, 0xef, 0x6b, 0xa3, 0x40, 0x69, 0x2b, 0x9c, 0x7a, 0xc0, 0x89, 0xe8, 0x26, 0x00, 0xf6, 0x3c,
	0xc7, 0xeb, 0xeb, 0xce, 0x10, 0x8b, 0x00, 0x52, 0x64, 0x94, 0x5d, 0x67, 0x88, 0xd1, 0x0d, 0x28,
	0x32, 0x73, 0x24, 0x9a, 0xe5, 0x8a, 0xac, 0x1d, 0x11, 0xa8, 0x4e, 0x82, 0xf3, 0x9d, 0x56, 0x27,
	0x7b, 0x00, 0x2d, 0x4c, 0xce, 0xad, 0x0f, 0xe5, 0x73, 0x28, 0x31, 0x1c, 0xf1, 0xdd, 0x8f, 0x40,
	0x7e, 0xed, 0x0c, 0x44, 0x0c, 0x98, 0xb5, 0xe1, 0x67, 0xce, 0x40, 0xa5, 0x0c, 0x4a, 0x1b, 0x3e,
	0x68, 0x61, 0x22, 0x54, 0x15, 0x08, 0xff, 0x20, 0xd4, 0x2d, 0x97, 0xbf, 0x3d, 0xb7, 0x0c, 0x4b,
	0xea, 0x58, 0xd9, 0x83, 0xcb, 0x21, 0xda, 0x7e, 0x23, 0xc4, 0xfb, 0x2c, 0x81, 0xb7, 0xf8, 0xae,
	0x94, 0xef, 0x43, 0xb5, 0x85, 0x89, 0x88, 0x0b, 0x5d, 0xe2, 0xd1, 0x82, 0x2f, 0x00, 0xab, 0x42,
	0x3e, 0xa8, 0xd3, 0xb8, 0x7a, 0x82, 0xa9, 0x72, 0x0f, 0x56, 0x5b, 0x98, 0xf4, 0xb0, 0x1f, 0xa9,
	0x81, 0x66, 0x0d, 0xec, 0x93, 0x30, 0x4d, 0x61, 0x9f, 0x28, 0x9b, 0xb0, 0xd2, 0xc2, 0xa4, 0x6e,
	0x9a, 0x8b, 0xaa, 0x5b, 0x65, 0x07, 0xca, 0x01, 0xa7, 0xc0, 0xdb, 0x84, 0xe5, 0xd7, 0xce, 0x80,
	0x7e, 0x59, 0x9e, 0xab, 0x57, 0xc6, 0xa1, 0xb4, 0xa0, 0xf4, 0x54, 0x33, 0x2f, 0xe0, 0x62, 0x27,
	0x70, 0x89, 0x03, 0x9d, 0xd2, 0xa2, 0x2e, 0xce, 0x65, 0x94, 0x7d, 0x58, 0x51, 0xb1, 0x3f, 0xb6,
	0xce, 0xef, 0xae, 0xca, 0xcf, 0xa1, 0x1c, 0x40, 0xfd, 0x5f, 0xce, 0xd1, 0xc0, 0x26, 0xbe, 0x80,
	0xb0, 0x43, 0x3d, 0x3c, 0x80, 0x3a, 0xad, 0x87, 0xff, 0x4d, 0x82, 0x7c, 0x90, 0x9b, 0x13, 0xe1,
	0x43, 0x9a, 0x0a, 0x1f, 0x61, 0x51, 0x95, 0x89, 0x15, 0x55, 0x37, 0xa0, 0x68, 0x10, 0xec, 0xb1,
	0x37, 0x86, 0x28, 0xfa, 0x23, 0x42, 0xac, 0xca, 0x9d, 0x57, 0xa7, 0x9e, 0x94, 0x5c, 0xbf, 0x5c,
	0x94, 0x0b, 0x53, 0x2b, 0x15, 0x96, 0xf5, 0x7e, 0x29, 0x83, 0xfc, 0xcc, 0x19, 0x9c, 0xe3, 0x16,
	0xd3, 0x9e, 0x8e, 0xf2, 0x45, 0x3c, 0x1d, 0x97, 0x4f, 0xff, 0x74, 0x8c, 0x02, 0x5d, 0xf6, 0x4c,
	0x81, 0x6e, 0xea, 0xcd, 0x99, 0x3b, 0xd3, 0x9b, 0xf3, 0x0a, 0xe4, 0x5e, 0x3b, 0x03, 0xaa, 0x90,
	0x3c, 0xd7, 0xea, 0x6b, 0x67, 0xb0, 0x3f, 0x44, 0xdb, 0x51, 0x5c, 0x2b, 0xcc, 0x79, 0x35, 0x89,
	0xbb, 0x8c, 0x22, 0xde, 0x9f, 0x24, 0x58, 0x9d, 0xd2, 0x0d, 0x35, 0x22, 0x5b, 0xb3, 0xc2, 0xca,
	0x9c, 0x8e, 0xd1, 0x06, 0x94, 0x86, 0xd8, 0xd7, 0x3d, 0xc3, 0x0d, 0x5f, 0xe8, 0x45, 0x35, 0x4e,
	0xa2, 0x51, 0x55, 0x77, 0x6c, 0x82, 0x6d, 0xc2, 0x2e, 0xe1, 0x92, 0x1a, 0x4c, 0x69, 0x35, 0x61,
	0x3a, 0x3a, 0xb7, 0x3f, 0x9e, 0x31, 0xc3, 0x39, 0x7a, 0x08, 0xc5, 0x63, 0x4f, 0xb3, 0xf0, 0x3b,
	0xc7, 0x7b, 0x23, 0x54, 0x38, 0xab, 0x85, 0xbd, 0x80, 0x43, 0x8d, 0x98, 0x95, 0xdf, 0x49, 0x50,
	0x0c, 0x17, 0x52, 0xf7, 0x5c, 0x85, 0xfc, 0x5b, 0xec, 0xf9, 0xd1, 0x7e, 0x83, 0x69, 0xf2, 0xe5,
	0x2c, 0x4f, 0xbd, 0x9c, 0x9b, 0x50, 0xe6, 0x8b, 0x89, 0x4d, 0x97, 0xb6, 0x6f, 0xcd, 0xec, 0x6b,
	0x9f, 0xb2, 0xb5, 0x05, 0x97, 0xba, 0x62, 0xc4, 0xa7, 0xca, 0x2f, 0x24, 0x58, 0x49, 0x30, 0x50,
	0x3d, 0x78, 0x78, 0x64, 0xf8, 0xc4, 0x0b, 0x5c, 0x24, 0x9c, 0x53, 0x27, 0xa5, 0x7b, 0xf6, 0x5d,
	0x4d, 0x0f, 0x7c, 0x25, 0x22, 0xa0, 0x3b, 0x70, 0x49, 0xd3, 0x75, 0xec, 0xfb, 0x7d, 0xe2, 0xbc,
	0xc1, 0xb6, 0xd8, 0x72, 0x89, 0xd3, 0x7a, 0x94, 0x44, 0x1d, 0x0d, 0x5b, 0x9a, 0x61, 0x06, 0x85,
	0x1c, 0x9b, 0x28, 0x7f, 0x95, 0xa0, 0x10, 0x18, 0x20, 0xbf, 0x21, 0xcb, 0xd2, 0xec, 0xc0, 0xcb,
	0x82, 0x29, 0xda, 0x85, 0xa2, 0x87, 0x7d, 0x67, 0xec, 0xe9, 0xac, 0x88, 0x97, 0x52, 0xab, 0x6c,
	0x55, 0x70, 0xd0, 0x10, 0x68, 0x78, 0xd8, 0xc2, 0x36, 0xf1, 0xd5, 0x48, 0x8e, 0xd6, 0x3d, 0x86,
	0xed, 0x8e, 0x49, 0x9f, 0x5a, 0x2a, 0x7b, 0x33, 0x17, 0xd5, 0x22, 0xa3, 0x50, 0x2b, 0xa6, 0x7e,
	0xee, 0x8c, 0x49, 0xb8, 0x2e, 0x5a, 0x0b, 0x9c, 0xc4, 0x18, 0x6e, 0x40, 0xd1, 0xf5, 0x9c, 0x63,
	0xc3, 0xa4, 0x2e, 0x48, 0x4d, 0xa1, 0xa0, 0x46, 0x04, 0xe5, 0x5b, 0x19, 0xca, 0x49, 0x57, 0x3a,
	0x73, 0x51, 0x80, 0x1e, 0xc0, 0x9a, 0x3f, 0x1e, 0x58, 0x86, 0x4f, 0x8d, 0xa0, 0x1f, 0x85, 0x51,
	0xae, 0xce, 0xcb, 0xd1, 0x5a, 0x2f, 0x0c, 0xa8, 0x0f, 0x60, 0x4d, 0x77, 0x2c, 0xd7, 0xc4, 0x24,
	0x29, 0xc2, 0xb5, 0x7c, 0x39, 0x5a, 0x8b, 0x44, 0x1e, 0x42, 0x75, 0xe8, 0xbc, 0xb3, 0x4d, 0x47,
	0x1b, 0xf6, 0x7d, 0xa2, 0x79, 0x24, 0x26, 0xc6, 0xab, 0xc1, 0xf5, 0x60, 0xbd, 0x4b, 0x97, 0x23,
	0xc9, 0x2f, 0xe0, 0xaa, 0xeb, 0x39, 0xec, 0x9e, 0xa7, 0x05, 0x79, 0xa1, 0x78, 0x45, 0x2c, 0x4f,
	0xc9, 0x6d, 0xc3, 0x15, 0x16, 0x19, 0x66, 0xa4, 0xf2, 0xe2, 0x60, 0x74, 0x71, 0x4a, 0x66, 0xb6,
	0x98, 0x2d, 0x2c, 0x2e, 0x66, 0x8b, 0x53, 0xc5, 0xac, 0xf2, 0x87, 0x0c, 0x14, 0xc3, 0x18, 0xc5,
	0x7a, 0x4e, 0x81, 0x6d, 0x65, 0x8c, 0x61, 0x6a, 0x36, 0xfa, 0x21, 0xe4, 0x8e, 0x0d, 0x6c, 0x0e,
	0x83, 0xae, 0xca, 0x47, 0xf3, 0x63, 0xde, 0xd6, 0x1e, 0x63, 0x14, 0x19, 0x87, 0x4b, 0xa1, 0x67,
	0x00, 0xba, 0x63, 0xdb, 0x58, 0x17, 0x9e, 0x49, 0x31, 0xee, 0x9f, 0x80, 0xb1, 0x1b, 0x32, 0x73,
	0x9c, 0x98, 0x34, 0xcd, 0x5e, 0xb1, 0x4f, 0x9c, 0x25, 0x7b, 0xd5, 0x1e, 0xc3, 0xea, 0x14, 0xf2,
	0x59, 0x93, 0xdf, 0x5a, 0x9a, 0x3f, 0x51, 0x95, 0xe9, 0xae, 0xb0, 0xe8, 0x8c, 0xca, 0xc6, 0x94,
	0x36, 0xa2, 0xb4, 0x0c, 0xa7, 0xd1, 0x31, 0x5a, 0x87, 0x9c, 0x85, 0x2d, 0xc7, 0x9b, 0x30, 0xe3,
	0xcd, 0xa8, 0x62, 0x86, 0x76, 0xa0, 0xc4, 0x47, 0xfd, 0xb1, 0x6d, 0x10, 0x66, 0xa6, 0xe5, 0x94,
	0x4c, 0xd6, 0x35, 0xbe, 0xc1, 0x2f, 0x6c, 0x83, 0xa8, 0xc0, 0xb9, 0xe9, 0x98, 0xc6, 0x07, 0xaa,
	0x33, 0x6a, 0x0b, 0x59, 0x06, 0x1a, 0x4c, 0xd1, 0x23, 0xb8, 0x24, 0x86, 0x1c, 0x36, 0xb7, 0x08,
	0xb6, 0x24, 0xd8, 0x19, 0x2e, 0x8d, 0xff, 0x58, 0xf3, 0x6c, 0xec, 0xf9, 0xcc, 0x22, 0xb3, 0x6a,
	0x38, 0xa7, 0x79, 0xc5, 0xd7, 0x5f, 0xe1, 0xa1, 0xeb, 0x98, 0x86, 0x3e, 0x11, 0x36, 0x18, 0x27,
	0x51, 0x69, 0xe2, 0xb8, 0x8e, 0xe9, 0x8c, 0x26, 0xc2, 0xfe, 0xc2, 0x39, 0x52, 0xe0, 0x12, 0x7d,
	0x77, 0x1a, 0x04, 0xeb, 0x64, 0xec, 0xe1, 0x2a, 0xb0, 0xf5, 0x04, 0x0d, 0x5d, 0x83, 0xc2, 0xc8,
	0x1d, 0xf7, 0x99, 0x21, 0x96, 0x78, 0xd8, 0x1b, 0xb9, 0x63, 0xfa, 0x54, 0x55, 0x54, 0x58, 0x9f,
	0xae, 0x0b, 0xce, 0x5d, 0xde, 0x75, 0xe0, 0x32, 0x0b, 0x53, 0x78, 0xc8, 0xa0, 0xcf, 0x0f, 0xf8,
	0x7b, 0x09, 0xd6, 0xe3, 0x88, 0x6d, 0x67, 0x74, 0xfe, 0xb7, 0xef, 0x3a, 0xe4, 0x8e, 0x1d, 0xd3,
	0x74, 0xde, 0x89, 0x40, 0x2b, 0x66, 0x2c, 0x86, 0xfb, 0x61, 0x17, 0x5b, 0xe6, 0x41, 0xd8, 0xf0,
	0x83, 0xe2, 0x93, 0x2f, 0xfb, 0x63, 0xcb, 0xd2, 0xbc, 0x09, 0x33, 0x2e, 0xb6, 0xdc, 0xe5, 0x04,
	0xc5, 0x86, 0x5a, 0x7c, 0xa7, 0x41, 0xb1, 0x71, 0x81, 0xbb, 0x95, 0xe3, 0xbb, 0x55, 0xba, 0x70,
	0xb5, 0x85, 0x49, 0x5b, 0xa3, 0x8f, 0xb2, 0x8b, 0xfa, 0x98, 0xf2, 0x6b, 0x89, 0x3d, 0x1d, 0xa7,
	0x50, 0xcf, 0xfd, 0xe4, 0x88, 0x15, 0x67, 0xf2, 0x69, 0x8b, 0xb3, 0xdf, 0x4a, 0xb0, 0xc1, 0xbb,
	0x01, 0xff, 0x13, 0xb5, 0x7e, 0x09, 0x25, 0x1b, 0xbf, 0xeb, 0x9f, 0x76, 0x5b, 0x60, 0xe3, 0x77,
	0xc1, 0x6f, 0x14, 0x0d, 0xb8, 0x73, 0xc2, 0xc6, 0x4e, 0xfb, 0xae, 0xd9, 0x04, 0xf4, 0x64, 0x42,
	0x70, 0x97, 0x78, 0x58, 0xb3, 0xe2, 0x2f, 0x6e, 0x56, 0x21, 0x48, 0xac, 0x8a, 0x64, 0x63, 0xfa,
	0x30, 0xff, 0xda, 0x70, 0x5d, 0x3c, 0xa4, 0x81, 0x7d, 0xf7, 0xd5, 0xd8, 0x7e, 0x93, 0xca, 0xb6,
	0x06, 0xa8, 0x85, 0xc9, 0x4b, 0x5e, 0xe5, 0x05, 0x1a, 0x52, 0xfe, 0x22, 0x01, 0x84, 0x95, 0xa2,
	0x8f, 0xbe, 0x02, 0x08, 0xab, 0xc8, 0xe0, 0x1d, 0xfe, 0xf1, 0xfc, 0x9a, 0xd3, 0x8f, 0x0d, 0x45,
	0x0a, 0x89, 0xc4, 0x6b, 0x3a, 0xac, 0x4e, 0x2d, 0xa7, 0xe4, 0x81, 0x9d, 0x64, 0x43, 0xf0, 0xee,
	0xfc, 0x8f, 0x35, 0x30, 0xd1, 0x0c, 0xb3, 0x6d, 0xf8, 0x24, 0x9e, 0x2d, 0x7a, 0x70, 0x39, 0x85,
	0x03, 0x3d, 0x86, 0x82, 0x28, 0x68, 0x83, 0x63, 0xdc, 0x59, 0x84, 0xec, 0xab, 0xa1, 0x88, 0xf2,
	0x14, 0x2a, 0xd3, 0xab, 0xf1, 0x92, 0x59, 0x4a, 0x96, 0xcc, 0x35, 0x28, 0xe0, 0xf7, 0x04, 0x7b,
	0xb6, 0x66, 0xb2, 0x63, 0x14, 0xd4, 0x70, 0x7e, 0xff, 0x13, 0x28, 0x04, 0x91, 0x1f, 0xe5, 0x20,
	0x73, 0xf0, 0xa4, 0xb2, 0x84, 0xf2, 0x20, 0x1f, 0x18, 0x4f, 0x2a, 0x12, 0x25, 0xb4, 0x9e, 0xf0,
	0xb6, 0x5f, 0xcb, 0x78, 0x52, 0x91, 0xef, 0x7f, 0x2b, 0x41, 0x4e, 0x54, 0x70, 0xab, 0x50, 0x3a,
	0xec, 0xf4, 0xfa, 0xdd, 0x5e, 0x5d, 0xed, 0x35, 0x1b, 0x95, 0x25, 0x54, 0x82, 0xfc, 0x51, 0xf3,
	0xb0, 0xc1, 0xfb, 0xd4, 0x00, 0xb9, 0xa7, 0xf5, 0x36, 0x5d, 0xc8, 0xd2, 0xf1, 0x5e, 0x7d, 0xbf,
	0xdd, 0x6c, 0x54, 0x80, 0x8e, 0x1b, 0xcd, 0xa3, 0x76, 0xe7, 0x27, 0x95, 0x35, 0x8a, 0xd0, 0xe8,
	0xfc, 0xe8, 0xb0, 0xdd, 0xa9, 0x33, 0xa1, 0x5b, 0xa8, 0x0c, 0x70, 0xa4, 0x76, 0x76, 0x9b, 0xdd,
	0x2e, 0x9d, 0x6f, 0x52, 0xc4, 0x6e, 0xaf, 0xc3, 0x3a, 0xdf, 0xdb, 0x68, 0x05, 0x8a, 0xbb, 0x9d,
	0x83, 0xa3, 0x76, 0x93, 0x82, 0x3e, 0xa2, 0x40, 0xcf, 0x5f, 0x34, 0x5f, 0x34, 0x1b, 0x95, 0xbd,
	0xed, 0xbf, 0x17, 0x21, 0xcf, 0x8d, 0xd9, 0x43, 0x2f, 0xe1, 0x03, 0xde, 0x98, 0x0c, 0x0a, 0x4e,
	0xfa, 0x4e, 0x9d, 0x2d, 0xff, 0x13, 0xbf, 0x70, 0xd6, 0x6e, 0xcf, 0x5d, 0xe7, 0x76, 0xad, 0x2c,
	0xa1, 0x03, 0xd6, 0x0d, 0x8a, 0x83, 0x5e, 0x9f, 0x11, 0x8a, 0x5a, 0x79, 0xb5, 0x1b, 0xe9, 0x8b,
	0x21, 0xdc, 0x8f, 0x59, 0xaf, 0xac, 0x6e, 0x9a, 0x01, 0xa2, 0xff, 0xcc, 0x19, 0xf8, 0x29, 0x1b,
	0x4d, 0x34, 0xab, 0x52, 0x36, 0x9a, 0x6c, 0x51, 0x29, 0x4b, 0x54, 0x01, 0xbc, 0x47, 0x71, 0xb2,
	0x02, 0x12, 0x2d, 0x91, 0x14, 0xdc, 0x64, 0x9f, 0x43, 0x59, 0x42, 0x47, 0xb0, 0xfa, 0x54, 0x33,
	0x13, 0x1a, 0x98, 0x3d, 0x64, 0xac, 0xe9, 0x55, 0xbb, 0x39, 0x67, 0x35, 0x44, 0xd4, 0x99, 0xc7,
	0x4f, 0xbf, 0x60, 0xbf, 0xb3, 0xf0, 0xfd, 0x2f, 0xf0, 0x67, 0x1b, 0x05, 0x53, 0x61, 0x46, 0x59,
	0xfa, 0xae, 0x84, 0x7e, 0xca, 0xdb, 0x82, 0xb1, 0x50, 0x87, 0xee, 0xa6, 0xbf, 0xf3, 0x93, 0x59,
	0xff, 0x94, 0xf0, 0x23, 0x76, 0x8f, 0x53, 0x39, 0xde, 0x4f, 0x39, 0x44, 0x7a, 0x19, 0x50, 0xfb,
	0x70, 0x86, 0x71, 0x36, 0xaa, 0xb2, 0x0f, 0xb5, 0xa2, 0x73, 0x18, 0xf6, 0x88, 0x7d, 0x64, 0x3d,
	0xfd, 0xd7, 0x85, 0xda, 0x6c, 0x1a, 0x10, 0xbf, 0x7c, 0x31, 0xa0, 0x76, 0xb4, 0x63, 0xc3, 0x1e,
	0x85, 0xbf, 0x1b, 0xcd, 0x03, 0xbb, 0x36, 0xf7, 0x17, 0x1b, 0x86, 0xf6, 0x9c, 0x35, 0x9e, 0x83,
	0xa8, 0x8d, 0x3e, 0x4c, 0xb3, 0xcf, 0xa9, 0x98, 0x5e, 0xbb, 0x7e, 0x42, 0xc0, 0x56, 0x96, 0xd0,
	0xd7, 0x89, 0x0d, 0x06, 0xed, 0xe4, 0x93, 0xdd, 0xed, 0x6e, 0xda, 0xe2, 0x74, 0x27, 0x9a, 0x3b,
	0x47, 0x2c, 0xf7, 0xcd, 0x75, 0x8e, 0xc4, 0xcf, 0x14, 0x29, 0xce, 0x91, 0x6c, 0xf3, 0x73, 0x5c,
	0xde, 0xe0, 0x3c, 0x19, 0x37, 0xd1, 0x4f, 0x4d, 0xc1, 0x4d, 0x36, 0x49, 0x95, 0xa5, 0x41, 0x8e,
	0xfd, 0x49, 0xe3, 0x7b, 0xff, 0x09, 0x00, 0x00, 0xff, 0xff, 0x4a, 0x16, 0xcf, 0xb3, 0xb5, 0x21,
	0x00, 0x00,
}
