// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	strfmt "github.com/go-openapi/strfmt"
)

// NewGetLogsParams creates a new GetLogsParams object
// with the default values initialized.
func NewGetLogsParams() GetLogsParams {
	var (
		followDefault    = bool(false)
		sinceTimeDefault = string("")
		versionDefault   = string("2017-02-13")
	)
	return GetLogsParams{
		Follow: &followDefault,

		SinceTime: &sinceTimeDefault,

		Version: versionDefault,
	}
}

// GetLogsParams contains all the bound params for the get logs operation
// typically these are obtained from a http.Request
//
// swagger:parameters getLogs
type GetLogsParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request

	/*Follow the log stream if true. Default false.
	  In: query
	  Default: false
	*/
	Follow *bool
	/*The id of the model.
	  Required: true
	  In: path
	*/
	ModelID string
	/*An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned.  If this value is in the future, no logs will be returned.
	  In: query
	  Default: ""
	*/
	SinceTime *string
	/*The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.
	  Required: true
	  In: query
	  Default: "2017-02-13"
	*/
	Version string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls
func (o *GetLogsParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error
	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qFollow, qhkFollow, _ := qs.GetOK("follow")
	if err := o.bindFollow(qFollow, qhkFollow, route.Formats); err != nil {
		res = append(res, err)
	}

	rModelID, rhkModelID, _ := route.Params.GetOK("model_id")
	if err := o.bindModelID(rModelID, rhkModelID, route.Formats); err != nil {
		res = append(res, err)
	}

	qSinceTime, qhkSinceTime, _ := qs.GetOK("since_time")
	if err := o.bindSinceTime(qSinceTime, qhkSinceTime, route.Formats); err != nil {
		res = append(res, err)
	}

	qVersion, qhkVersion, _ := qs.GetOK("version")
	if err := o.bindVersion(qVersion, qhkVersion, route.Formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetLogsParams) bindFollow(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if raw == "" { // empty values pass all other validations
		var followDefault bool = bool(false)
		o.Follow = &followDefault
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("follow", "query", "bool", raw)
	}
	o.Follow = &value

	return nil
}

func (o *GetLogsParams) bindModelID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	o.ModelID = raw

	return nil
}

func (o *GetLogsParams) bindSinceTime(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if raw == "" { // empty values pass all other validations
		var sinceTimeDefault string = string("")
		o.SinceTime = &sinceTimeDefault
		return nil
	}

	o.SinceTime = &raw

	return nil
}

func (o *GetLogsParams) bindVersion(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("version", "query")
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}
	if err := validate.RequiredString("version", "query", raw); err != nil {
		return err
	}

	o.Version = raw

	return nil
}
