// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/IBM/FfDL/restapi/api_v1/restmodels"
)

// DownloadTrainedModelOKCode is the HTTP code returned for type DownloadTrainedModelOK
const DownloadTrainedModelOKCode int = 200

/*DownloadTrainedModelOK Model definition

swagger:response downloadTrainedModelOK
*/
type DownloadTrainedModelOK struct {

	/*
	  In: Body
	*/
	Payload io.ReadCloser `json:"body,omitempty"`
}

// NewDownloadTrainedModelOK creates DownloadTrainedModelOK with default headers values
func NewDownloadTrainedModelOK() *DownloadTrainedModelOK {
	return &DownloadTrainedModelOK{}
}

// WithPayload adds the payload to the download trained model o k response
func (o *DownloadTrainedModelOK) WithPayload(payload io.ReadCloser) *DownloadTrainedModelOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download trained model o k response
func (o *DownloadTrainedModelOK) SetPayload(payload io.ReadCloser) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadTrainedModelOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}

}

// DownloadTrainedModelUnauthorizedCode is the HTTP code returned for type DownloadTrainedModelUnauthorized
const DownloadTrainedModelUnauthorizedCode int = 401

/*DownloadTrainedModelUnauthorized Unauthorized

swagger:response downloadTrainedModelUnauthorized
*/
type DownloadTrainedModelUnauthorized struct {

	/*
	  In: Body
	*/
	Payload *restmodels.Error `json:"body,omitempty"`
}

// NewDownloadTrainedModelUnauthorized creates DownloadTrainedModelUnauthorized with default headers values
func NewDownloadTrainedModelUnauthorized() *DownloadTrainedModelUnauthorized {
	return &DownloadTrainedModelUnauthorized{}
}

// WithPayload adds the payload to the download trained model unauthorized response
func (o *DownloadTrainedModelUnauthorized) WithPayload(payload *restmodels.Error) *DownloadTrainedModelUnauthorized {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download trained model unauthorized response
func (o *DownloadTrainedModelUnauthorized) SetPayload(payload *restmodels.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadTrainedModelUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(401)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DownloadTrainedModelNotFoundCode is the HTTP code returned for type DownloadTrainedModelNotFound
const DownloadTrainedModelNotFoundCode int = 404

/*DownloadTrainedModelNotFound The trained model cannot be found.

swagger:response downloadTrainedModelNotFound
*/
type DownloadTrainedModelNotFound struct {

	/*
	  In: Body
	*/
	Payload *restmodels.Error `json:"body,omitempty"`
}

// NewDownloadTrainedModelNotFound creates DownloadTrainedModelNotFound with default headers values
func NewDownloadTrainedModelNotFound() *DownloadTrainedModelNotFound {
	return &DownloadTrainedModelNotFound{}
}

// WithPayload adds the payload to the download trained model not found response
func (o *DownloadTrainedModelNotFound) WithPayload(payload *restmodels.Error) *DownloadTrainedModelNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download trained model not found response
func (o *DownloadTrainedModelNotFound) SetPayload(payload *restmodels.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadTrainedModelNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DownloadTrainedModelGoneCode is the HTTP code returned for type DownloadTrainedModelGone
const DownloadTrainedModelGoneCode int = 410

/*DownloadTrainedModelGone If the trained model storage time has expired and it has been deleted. It only gets deleted if it not stored on an external data store.

swagger:response downloadTrainedModelGone
*/
type DownloadTrainedModelGone struct {

	/*
	  In: Body
	*/
	Payload *restmodels.Error `json:"body,omitempty"`
}

// NewDownloadTrainedModelGone creates DownloadTrainedModelGone with default headers values
func NewDownloadTrainedModelGone() *DownloadTrainedModelGone {
	return &DownloadTrainedModelGone{}
}

// WithPayload adds the payload to the download trained model gone response
func (o *DownloadTrainedModelGone) WithPayload(payload *restmodels.Error) *DownloadTrainedModelGone {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the download trained model gone response
func (o *DownloadTrainedModelGone) SetPayload(payload *restmodels.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DownloadTrainedModelGone) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(410)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
