package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	middleware "github.com/go-openapi/runtime/middleware"
)

// UpdateEventEndpointHandlerFunc turns a function with the right signature into a update event endpoint handler
type UpdateEventEndpointHandlerFunc func(UpdateEventEndpointParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn UpdateEventEndpointHandlerFunc) Handle(params UpdateEventEndpointParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// UpdateEventEndpointHandler interface for that can handle valid update event endpoint params
type UpdateEventEndpointHandler interface {
	Handle(UpdateEventEndpointParams, interface{}) middleware.Responder
}

// NewUpdateEventEndpoint creates a new http.Handler for the update event endpoint operation
func NewUpdateEventEndpoint(ctx *middleware.Context, handler UpdateEventEndpointHandler) *UpdateEventEndpoint {
	return &UpdateEventEndpoint{Context: ctx, Handler: handler}
}

/*UpdateEventEndpoint swagger:route POST /v1/models/{model_id}/events/{event_type} Events updateEventEndpoint

Update an event notification endpoint.

Updates a specific event type's URL notification endpoint.

*/
type UpdateEventEndpoint struct {
	Context *middleware.Context
	Handler UpdateEventEndpointHandler
}

func (o *UpdateEventEndpoint) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		r = rCtx
	}
	var Params = NewUpdateEventEndpointParams()

	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		r = aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request

	o.Context.Respond(rw, r, route.Produces, route, res)

}
