// Code generated by go-swagger; DO NOT EDIT.

package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/IBM/FfDL/restapi/api_v1/restmodels"
)

// DeleteEventEndpointOKCode is the HTTP code returned for type DeleteEventEndpointOK
const DeleteEventEndpointOKCode int = 200

/*DeleteEventEndpointOK Event updated successfully

swagger:response deleteEventEndpointOK
*/
type DeleteEventEndpointOK struct {

	/*
	  In: Body
	*/
	Payload io.ReadCloser `json:"body,omitempty"`
}

// NewDeleteEventEndpointOK creates DeleteEventEndpointOK with default headers values
func NewDeleteEventEndpointOK() *DeleteEventEndpointOK {
	return &DeleteEventEndpointOK{}
}

// WithPayload adds the payload to the delete event endpoint o k response
func (o *DeleteEventEndpointOK) WithPayload(payload io.ReadCloser) *DeleteEventEndpointOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete event endpoint o k response
func (o *DeleteEventEndpointOK) SetPayload(payload io.ReadCloser) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteEventEndpointOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}

}

// DeleteEventEndpointUnauthorizedCode is the HTTP code returned for type DeleteEventEndpointUnauthorized
const DeleteEventEndpointUnauthorizedCode int = 401

/*DeleteEventEndpointUnauthorized Unauthorized

swagger:response deleteEventEndpointUnauthorized
*/
type DeleteEventEndpointUnauthorized struct {

	/*
	  In: Body
	*/
	Payload *restmodels.Error `json:"body,omitempty"`
}

// NewDeleteEventEndpointUnauthorized creates DeleteEventEndpointUnauthorized with default headers values
func NewDeleteEventEndpointUnauthorized() *DeleteEventEndpointUnauthorized {
	return &DeleteEventEndpointUnauthorized{}
}

// WithPayload adds the payload to the delete event endpoint unauthorized response
func (o *DeleteEventEndpointUnauthorized) WithPayload(payload *restmodels.Error) *DeleteEventEndpointUnauthorized {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete event endpoint unauthorized response
func (o *DeleteEventEndpointUnauthorized) SetPayload(payload *restmodels.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteEventEndpointUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(401)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DeleteEventEndpointNotFoundCode is the HTTP code returned for type DeleteEventEndpointNotFound
const DeleteEventEndpointNotFoundCode int = 404

/*DeleteEventEndpointNotFound The model or event type cannot be found.

swagger:response deleteEventEndpointNotFound
*/
type DeleteEventEndpointNotFound struct {

	/*
	  In: Body
	*/
	Payload *restmodels.Error `json:"body,omitempty"`
}

// NewDeleteEventEndpointNotFound creates DeleteEventEndpointNotFound with default headers values
func NewDeleteEventEndpointNotFound() *DeleteEventEndpointNotFound {
	return &DeleteEventEndpointNotFound{}
}

// WithPayload adds the payload to the delete event endpoint not found response
func (o *DeleteEventEndpointNotFound) WithPayload(payload *restmodels.Error) *DeleteEventEndpointNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete event endpoint not found response
func (o *DeleteEventEndpointNotFound) SetPayload(payload *restmodels.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteEventEndpointNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DeleteEventEndpointGoneCode is the HTTP code returned for type DeleteEventEndpointGone
const DeleteEventEndpointGoneCode int = 410

/*DeleteEventEndpointGone If the trained model storage time has expired and it has been deleted. It only gets deleted if it not stored on an external data store.

swagger:response deleteEventEndpointGone
*/
type DeleteEventEndpointGone struct {

	/*
	  In: Body
	*/
	Payload *restmodels.Error `json:"body,omitempty"`
}

// NewDeleteEventEndpointGone creates DeleteEventEndpointGone with default headers values
func NewDeleteEventEndpointGone() *DeleteEventEndpointGone {
	return &DeleteEventEndpointGone{}
}

// WithPayload adds the payload to the delete event endpoint gone response
func (o *DeleteEventEndpointGone) WithPayload(payload *restmodels.Error) *DeleteEventEndpointGone {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete event endpoint gone response
func (o *DeleteEventEndpointGone) SetPayload(payload *restmodels.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteEventEndpointGone) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(410)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
