// Code generated by go-swagger; DO NOT EDIT.

package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/IBM/FfDL/restapi/api_v1/restmodels"
)

// NewCreateEventEndpointParams creates a new CreateEventEndpointParams object
// with the default values initialized.
func NewCreateEventEndpointParams() CreateEventEndpointParams {
	var ()
	return CreateEventEndpointParams{}
}

// CreateEventEndpointParams contains all the bound params for the create event endpoint operation
// typically these are obtained from a http.Request
//
// swagger:parameters createEventEndpoint
type CreateEventEndpointParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request

	/*The URL that should be notified when an event triggers.
	  Required: true
	  In: body
	*/
	CallbackURL *restmodels.EventEndpointRegistration
	/*The id of the endpoint.
	  Required: true
	  In: path
	*/
	EndpointID string
	/*The type of event.
	  Required: true
	  In: path
	*/
	EventType string
	/*The id of the model.
	  Required: true
	  In: path
	*/
	ModelID string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls
func (o *CreateEventEndpointParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error
	o.HTTPRequest = r

	if runtime.HasBody(r) {
		defer r.Body.Close()
		var body restmodels.EventEndpointRegistration
		if err := route.Consumer.Consume(r.Body, &body); err != nil {
			if err == io.EOF {
				res = append(res, errors.Required("callbackUrl", "body"))
			} else {
				res = append(res, errors.NewParseError("callbackUrl", "body", "", err))
			}

		} else {
			if err := body.Validate(route.Formats); err != nil {
				res = append(res, err)
			}

			if len(res) == 0 {
				o.CallbackURL = &body
			}
		}

	} else {
		res = append(res, errors.Required("callbackUrl", "body"))
	}

	rEndpointID, rhkEndpointID, _ := route.Params.GetOK("endpoint_id")
	if err := o.bindEndpointID(rEndpointID, rhkEndpointID, route.Formats); err != nil {
		res = append(res, err)
	}

	rEventType, rhkEventType, _ := route.Params.GetOK("event_type")
	if err := o.bindEventType(rEventType, rhkEventType, route.Formats); err != nil {
		res = append(res, err)
	}

	rModelID, rhkModelID, _ := route.Params.GetOK("model_id")
	if err := o.bindModelID(rModelID, rhkModelID, route.Formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateEventEndpointParams) bindEndpointID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	o.EndpointID = raw

	return nil
}

func (o *CreateEventEndpointParams) bindEventType(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	o.EventType = raw

	return nil
}

func (o *CreateEventEndpointParams) bindModelID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	o.ModelID = raw

	return nil
}
