// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"net/http"
	"strings"

	errors "github.com/go-openapi/errors"
	loads "github.com/go-openapi/loads"
	runtime "github.com/go-openapi/runtime"
	middleware "github.com/go-openapi/runtime/middleware"
	security "github.com/go-openapi/runtime/security"
	spec "github.com/go-openapi/spec"
	strfmt "github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/IBM/FfDL/restapi/api_v1/server/operations/events"
	"github.com/IBM/FfDL/restapi/api_v1/server/operations/models"
	"github.com/IBM/FfDL/restapi/api_v1/server/operations/training_data"
)

// NewDlaasAPI creates a new Dlaas instance
func NewDlaasAPI(spec *loads.Document) *DlaasAPI {
	return &DlaasAPI{
		handlers:              make(map[string]map[string]http.Handler),
		formats:               strfmt.Default,
		defaultConsumes:       "application/json",
		defaultProduces:       "application/json",
		ServerShutdown:        func() {},
		spec:                  spec,
		ServeError:            errors.ServeError,
		BasicAuthenticator:    security.BasicAuth,
		APIKeyAuthenticator:   security.APIKeyAuth,
		BearerAuthenticator:   security.BearerAuth,
		JSONConsumer:          runtime.JSONConsumer(),
		MultipartformConsumer: runtime.DiscardConsumer,
		JSONProducer:          runtime.JSONProducer(),
		BinProducer:           runtime.ByteStreamProducer(),
/*
		EventsCreateEventEndpointHandler: events.CreateEventEndpointHandlerFunc(func(params events.CreateEventEndpointParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation EventsCreateEventEndpoint has not yet been implemented")
		}),
		EventsDeleteEventEndpointHandler: events.DeleteEventEndpointHandlerFunc(func(params events.DeleteEventEndpointParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation EventsDeleteEventEndpoint has not yet been implemented")
		}),
		ModelsDeleteModelHandler: models.DeleteModelHandlerFunc(func(params models.DeleteModelParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ModelsDeleteModel has not yet been implemented")
		}),
		ModelsDownloadModelDefinitionHandler: models.DownloadModelDefinitionHandlerFunc(func(params models.DownloadModelDefinitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ModelsDownloadModelDefinition has not yet been implemented")
		}),
		ModelsDownloadTrainedModelHandler: models.DownloadTrainedModelHandlerFunc(func(params models.DownloadTrainedModelParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ModelsDownloadTrainedModel has not yet been implemented")
		}),
		TrainingDataGetEMetricsHandler: training_data.GetEMetricsHandlerFunc(func(params training_data.GetEMetricsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation TrainingDataGetEMetrics has not yet been implemented")
		}),
		EventsGetEventEndpointHandler: events.GetEventEndpointHandlerFunc(func(params events.GetEventEndpointParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation EventsGetEventEndpoint has not yet been implemented")
		}),
		EventsGetEventTypeEndpointsHandler: events.GetEventTypeEndpointsHandlerFunc(func(params events.GetEventTypeEndpointsParams) middleware.Responder {
			return middleware.NotImplemented("operation EventsGetEventTypeEndpoints has not yet been implemented")
		}),
		TrainingDataGetLoglinesHandler: training_data.GetLoglinesHandlerFunc(func(params training_data.GetLoglinesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation TrainingDataGetLoglines has not yet been implemented")
		}),
		ModelsGetLogsHandler: models.GetLogsHandlerFunc(func(params models.GetLogsParams) middleware.Responder {
			return middleware.NotImplemented("operation ModelsGetLogs has not yet been implemented")
		}),
		ModelsGetMetricsHandler: models.GetMetricsHandlerFunc(func(params models.GetMetricsParams) middleware.Responder {
			return middleware.NotImplemented("operation ModelsGetMetrics has not yet been implemented")
		}),
		ModelsGetModelHandler: models.GetModelHandlerFunc(func(params models.GetModelParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ModelsGetModel has not yet been implemented")
		}),
		ModelsListModelsHandler: models.ListModelsHandlerFunc(func(params models.ListModelsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ModelsListModels has not yet been implemented")
		}),
		ModelsPatchModelHandler: models.PatchModelHandlerFunc(func(params models.PatchModelParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ModelsPatchModel has not yet been implemented")
		}),
		ModelsPostModelHandler: models.PostModelHandlerFunc(func(params models.PostModelParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ModelsPostModel has not yet been implemented")
		}),

		// Applies when the "Authorization" header is set
		BasicAuthTokenAuth: func(token string) (interface{}, error) {
			return nil, errors.NotImplemented("api key auth (basicAuthToken) Authorization from header param [Authorization] has not yet been implemented")
		},
		// Applies when the "X-Watson-Authorization-Token" header is set
		WatsonAuthTokenAuth: func(token string) (interface{}, error) {
			return nil, errors.NotImplemented("api key auth (watsonAuthToken) X-Watson-Authorization-Token from header param [X-Watson-Authorization-Token] has not yet been implemented")
		},
		// Applies when the "watson-token" query is set
		WatsonAuthTokenQueryAuth: func(token string) (interface{}, error) {
			return nil, errors.NotImplemented("api key auth (watsonAuthTokenQuery) watson-token from query param [watson-token] has not yet been implemented")
		},

		// default authorizer is authorized meaning no requests are blocked
		APIAuthorizer: security.Authorized(),
*/
	}
}

/*DlaasAPI DLaaS enables deep learning (DL) highly scalable training of models for multiple frameworks on GPUs. The [DLaaS user
guide](https://dlaas-guide.stage1.mybluemix.net/) provides more details on how to use the service, including examples.
*/
type DlaasAPI struct {
	spec            *loads.Document
	context         *middleware.Context
	handlers        map[string]map[string]http.Handler
	formats         strfmt.Registry
	defaultConsumes string
	defaultProduces string
	Middleware      func(middleware.Builder) http.Handler

	// BasicAuthenticator generates a runtime.Authenticator from the supplied basic auth function.
	// It has a default implemention in the security package, however you can replace it for your particular usage.
	BasicAuthenticator func(security.UserPassAuthentication) runtime.Authenticator
	// APIKeyAuthenticator generates a runtime.Authenticator from the supplied token auth function.
	// It has a default implemention in the security package, however you can replace it for your particular usage.
	APIKeyAuthenticator func(string, string, security.TokenAuthentication) runtime.Authenticator
	// BearerAuthenticator generates a runtime.Authenticator from the supplied bearer token auth function.
	// It has a default implemention in the security package, however you can replace it for your particular usage.
	BearerAuthenticator func(string, security.ScopedTokenAuthentication) runtime.Authenticator

	// JSONConsumer registers a consumer for a "application/json" mime type
	JSONConsumer runtime.Consumer
	// MultipartformConsumer registers a consumer for a "multipart/form-data" mime type
	MultipartformConsumer runtime.Consumer

	// JSONProducer registers a producer for a "application/json" mime type
	JSONProducer runtime.Producer
	// BinProducer registers a producer for a "application/octet-stream" mime type
	BinProducer runtime.Producer

	// BasicAuthTokenAuth registers a function that takes a token and returns a principal
	// it performs authentication based on an api key Authorization provided in the header
	BasicAuthTokenAuth func(string) (interface{}, error)

	// WatsonAuthTokenAuth registers a function that takes a token and returns a principal
	// it performs authentication based on an api key X-Watson-Authorization-Token provided in the header
	WatsonAuthTokenAuth func(string) (interface{}, error)

	// WatsonAuthTokenQueryAuth registers a function that takes a token and returns a principal
	// it performs authentication based on an api key watson-token provided in the query
	WatsonAuthTokenQueryAuth func(string) (interface{}, error)

	// APIAuthorizer provides access control (ACL/RBAC/ABAC) by providing access to the request and authenticated principal
	APIAuthorizer runtime.Authorizer

	// EventsCreateEventEndpointHandler sets the operation handler for the create event endpoint operation
	EventsCreateEventEndpointHandler events.CreateEventEndpointHandler
	// EventsDeleteEventEndpointHandler sets the operation handler for the delete event endpoint operation
	EventsDeleteEventEndpointHandler events.DeleteEventEndpointHandler
	// ModelsDeleteModelHandler sets the operation handler for the delete model operation
	ModelsDeleteModelHandler models.DeleteModelHandler
	// ModelsDownloadModelDefinitionHandler sets the operation handler for the download model definition operation
	ModelsDownloadModelDefinitionHandler models.DownloadModelDefinitionHandler
	// ModelsDownloadTrainedModelHandler sets the operation handler for the download trained model operation
	ModelsDownloadTrainedModelHandler models.DownloadTrainedModelHandler
	// TrainingDataGetEMetricsHandler sets the operation handler for the get e metrics operation
	TrainingDataGetEMetricsHandler training_data.GetEMetricsHandler
	// EventsGetEventEndpointHandler sets the operation handler for the get event endpoint operation
	EventsGetEventEndpointHandler events.GetEventEndpointHandler
	// EventsGetEventTypeEndpointsHandler sets the operation handler for the get event type endpoints operation
	EventsGetEventTypeEndpointsHandler events.GetEventTypeEndpointsHandler
	// TrainingDataGetLoglinesHandler sets the operation handler for the get loglines operation
	TrainingDataGetLoglinesHandler training_data.GetLoglinesHandler
	// ModelsGetLogsHandler sets the operation handler for the get logs operation
	ModelsGetLogsHandler models.GetLogsHandler
	// ModelsGetMetricsHandler sets the operation handler for the get metrics operation
	ModelsGetMetricsHandler models.GetMetricsHandler
	// ModelsGetModelHandler sets the operation handler for the get model operation
	ModelsGetModelHandler models.GetModelHandler
	// ModelsListModelsHandler sets the operation handler for the list models operation
	ModelsListModelsHandler models.ListModelsHandler
	// ModelsPatchModelHandler sets the operation handler for the patch model operation
	ModelsPatchModelHandler models.PatchModelHandler
	// ModelsPostModelHandler sets the operation handler for the post model operation
	ModelsPostModelHandler models.PostModelHandler

	// ServeError is called when an error is received, there is a default handler
	// but you can set your own with this
	ServeError func(http.ResponseWriter, *http.Request, error)

	// ServerShutdown is called when the HTTP(S) server is shut down and done
	// handling all active connections and does not accept connections any more
	ServerShutdown func()

	// Custom command line argument groups with their descriptions
	CommandLineOptionsGroups []swag.CommandLineOptionsGroup

	// User defined logger function.
	Logger func(string, ...interface{})
}

// SetDefaultProduces sets the default produces media type
func (o *DlaasAPI) SetDefaultProduces(mediaType string) {
	o.defaultProduces = mediaType
}

// SetDefaultConsumes returns the default consumes media type
func (o *DlaasAPI) SetDefaultConsumes(mediaType string) {
	o.defaultConsumes = mediaType
}

// SetSpec sets a spec that will be served for the clients.
func (o *DlaasAPI) SetSpec(spec *loads.Document) {
	o.spec = spec
}

// DefaultProduces returns the default produces media type
func (o *DlaasAPI) DefaultProduces() string {
	return o.defaultProduces
}

// DefaultConsumes returns the default consumes media type
func (o *DlaasAPI) DefaultConsumes() string {
	return o.defaultConsumes
}

// Formats returns the registered string formats
func (o *DlaasAPI) Formats() strfmt.Registry {
	return o.formats
}

// RegisterFormat registers a custom format validator
func (o *DlaasAPI) RegisterFormat(name string, format strfmt.Format, validator strfmt.Validator) {
	o.formats.Add(name, format, validator)
}

// Validate validates the registrations in the DlaasAPI
func (o *DlaasAPI) Validate() error {
	var unregistered []string

	if o.JSONConsumer == nil {
		unregistered = append(unregistered, "JSONConsumer")
	}

	if o.MultipartformConsumer == nil {
		unregistered = append(unregistered, "MultipartformConsumer")
	}

	if o.JSONProducer == nil {
		unregistered = append(unregistered, "JSONProducer")
	}

	if o.BinProducer == nil {
		unregistered = append(unregistered, "BinProducer")
	}

	if o.BasicAuthTokenAuth == nil {
		unregistered = append(unregistered, "AuthorizationAuth")
	}

	if o.WatsonAuthTokenAuth == nil {
		unregistered = append(unregistered, "XWatsonAuthorizationTokenAuth")
	}

	if o.WatsonAuthTokenQueryAuth == nil {
		unregistered = append(unregistered, "WatsonTokenAuth")
	}

	if o.EventsCreateEventEndpointHandler == nil {
		unregistered = append(unregistered, "events.CreateEventEndpointHandler")
	}

	if o.EventsDeleteEventEndpointHandler == nil {
		unregistered = append(unregistered, "events.DeleteEventEndpointHandler")
	}

	if o.ModelsDeleteModelHandler == nil {
		unregistered = append(unregistered, "models.DeleteModelHandler")
	}

	if o.ModelsDownloadModelDefinitionHandler == nil {
		unregistered = append(unregistered, "models.DownloadModelDefinitionHandler")
	}

	if o.ModelsDownloadTrainedModelHandler == nil {
		unregistered = append(unregistered, "models.DownloadTrainedModelHandler")
	}

	if o.TrainingDataGetEMetricsHandler == nil {
		unregistered = append(unregistered, "training_data.GetEMetricsHandler")
	}

	if o.EventsGetEventEndpointHandler == nil {
		unregistered = append(unregistered, "events.GetEventEndpointHandler")
	}

	if o.EventsGetEventTypeEndpointsHandler == nil {
		unregistered = append(unregistered, "events.GetEventTypeEndpointsHandler")
	}

	if o.TrainingDataGetLoglinesHandler == nil {
		unregistered = append(unregistered, "training_data.GetLoglinesHandler")
	}

	if o.ModelsGetLogsHandler == nil {
		unregistered = append(unregistered, "models.GetLogsHandler")
	}

	if o.ModelsGetMetricsHandler == nil {
		unregistered = append(unregistered, "models.GetMetricsHandler")
	}

	if o.ModelsGetModelHandler == nil {
		unregistered = append(unregistered, "models.GetModelHandler")
	}

	if o.ModelsListModelsHandler == nil {
		unregistered = append(unregistered, "models.ListModelsHandler")
	}

	if o.ModelsPatchModelHandler == nil {
		unregistered = append(unregistered, "models.PatchModelHandler")
	}

	if o.ModelsPostModelHandler == nil {
		unregistered = append(unregistered, "models.PostModelHandler")
	}

	if len(unregistered) > 0 {
		return fmt.Errorf("missing registration: %s", strings.Join(unregistered, ", "))
	}

	return nil
}

// ServeErrorFor gets a error handler for a given operation id
func (o *DlaasAPI) ServeErrorFor(operationID string) func(http.ResponseWriter, *http.Request, error) {
	return o.ServeError
}

// AuthenticatorsFor gets the authenticators for the specified security schemes
func (o *DlaasAPI) AuthenticatorsFor(schemes map[string]spec.SecurityScheme) map[string]runtime.Authenticator {

	result := make(map[string]runtime.Authenticator)
	for name, scheme := range schemes {
		switch name {

		case "basicAuthToken":

			result[name] = o.APIKeyAuthenticator(scheme.Name, scheme.In, o.BasicAuthTokenAuth)

		case "watsonAuthToken":

			result[name] = o.APIKeyAuthenticator(scheme.Name, scheme.In, o.WatsonAuthTokenAuth)

		case "watsonAuthTokenQuery":

			result[name] = o.APIKeyAuthenticator(scheme.Name, scheme.In, o.WatsonAuthTokenQueryAuth)

		}
	}
	return result

}

// Authorizer returns the registered authorizer
func (o *DlaasAPI) Authorizer() runtime.Authorizer {

	return o.APIAuthorizer

}

// ConsumersFor gets the consumers for the specified media types
func (o *DlaasAPI) ConsumersFor(mediaTypes []string) map[string]runtime.Consumer {

	result := make(map[string]runtime.Consumer)
	for _, mt := range mediaTypes {
		switch mt {

		case "application/json":
			result["application/json"] = o.JSONConsumer

		case "multipart/form-data":
			result["multipart/form-data"] = o.MultipartformConsumer

		}
	}
	return result

}

// ProducersFor gets the producers for the specified media types
func (o *DlaasAPI) ProducersFor(mediaTypes []string) map[string]runtime.Producer {

	result := make(map[string]runtime.Producer)
	for _, mt := range mediaTypes {
		switch mt {

		case "application/json":
			result["application/json"] = o.JSONProducer

		case "application/octet-stream":
			result["application/octet-stream"] = o.BinProducer

		}
	}
	return result

}

// HandlerFor gets a http.Handler for the provided operation method and path
func (o *DlaasAPI) HandlerFor(method, path string) (http.Handler, bool) {
	if o.handlers == nil {
		return nil, false
	}
	um := strings.ToUpper(method)
	if _, ok := o.handlers[um]; !ok {
		return nil, false
	}
	if path == "/" {
		path = ""
	}
	h, ok := o.handlers[um][path]
	return h, ok
}

// Context returns the middleware context for the dlaas API
func (o *DlaasAPI) Context() *middleware.Context {
	if o.context == nil {
		o.context = middleware.NewRoutableContext(o.spec, o, nil)
	}

	return o.context
}

func (o *DlaasAPI) initHandlerCache() {
	o.Context() // don't care about the result, just that the initialization happened

	if o.handlers == nil {
		o.handlers = make(map[string]map[string]http.Handler)
	}

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/models/{model_id}/events/{event_type}/{endpoint_id}"] = events.NewCreateEventEndpoint(o.context, o.EventsCreateEventEndpointHandler)

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v1/models/{model_id}/events/{event_type}/{endpoint_id}"] = events.NewDeleteEventEndpoint(o.context, o.EventsDeleteEventEndpointHandler)

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v1/models/{model_id}"] = models.NewDeleteModel(o.context, o.ModelsDeleteModelHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/models/{model_id}/definition"] = models.NewDownloadModelDefinition(o.context, o.ModelsDownloadModelDefinitionHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/models/{model_id}/trained_model"] = models.NewDownloadTrainedModel(o.context, o.ModelsDownloadTrainedModelHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/logs/{model_id}/emetrics"] = training_data.NewGetEMetrics(o.context, o.TrainingDataGetEMetricsHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/models/{model_id}/events/{event_type}/{endpoint_id}"] = events.NewGetEventEndpoint(o.context, o.EventsGetEventEndpointHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/models/{model_id}/events/{event_type}"] = events.NewGetEventTypeEndpoints(o.context, o.EventsGetEventTypeEndpointsHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/logs/{model_id}/loglines"] = training_data.NewGetLoglines(o.context, o.TrainingDataGetLoglinesHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/models/{model_id}/logs"] = models.NewGetLogs(o.context, o.ModelsGetLogsHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/models/{model_id}/metrics"] = models.NewGetMetrics(o.context, o.ModelsGetMetricsHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/models/{model_id}"] = models.NewGetModel(o.context, o.ModelsGetModelHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/models"] = models.NewListModels(o.context, o.ModelsListModelsHandler)

	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v1/models/{model_id}"] = models.NewPatchModel(o.context, o.ModelsPatchModelHandler)

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/models"] = models.NewPostModel(o.context, o.ModelsPostModelHandler)

}

// Serve creates a http handler to serve the API over HTTP
// can be used directly in http.ListenAndServe(":8000", api.Serve(nil))
func (o *DlaasAPI) Serve(builder middleware.Builder) http.Handler {
	o.Init()

	if o.Middleware != nil {
		return o.Middleware(builder)
	}
	return o.context.APIHandler(builder)
}

// Init allows you to just initialize the handler cache, you can then recompose the middelware as you see fit
func (o *DlaasAPI) Init() {
	if len(o.handlers) == 0 {
		o.initHandlerCache()
	}
}
