// Code generated by go-swagger; DO NOT EDIT.

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

// SwaggerJSON embedded version of the swagger document used at generation time
var SwaggerJSON json.RawMessage

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "DLaaS enables deep learning (DL) highly scalable training of models for multiple frameworks on GPUs. The [DLaaS user\nguide](https://dlaas-guide.stage1.mybluemix.net/) provides more details on how to use the service, including examples.\n",
    "title": "IBM Deep Learning as a Service (DLaaS)",
    "version": "1.0.0"
  },
  "host": "gateway.watsonplatform.net",
  "basePath": "/",
  "paths": {
    "/v1/logs/{model_id}/emetrics": {
      "get": {
        "tags": [
          "TrainingData"
        ],
        "summary": "Get evaluation metrics records, based on query",
        "operationId": "getEMetrics",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "TERM",
              "NESTED",
              "MATCH"
            ],
            "type": "string",
            "default": "TERM",
            "name": "searchType",
            "in": "query"
          },
          {
            "type": "string",
            "format": "string",
            "default": "",
            "description": "Time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. If this value is a raw integer, it represents the time that the metric occured: representing the number of milliseconds since midnight January 1, 1970. If this value is a negative integer, it represents the number of lines to count backwards. If this value is empty, the logs since the beginning of the job will be returned",
            "name": "since_time",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "description": "Number of lines to output.",
            "name": "pagesize",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "If positive, line number from start, if negative line counting from end",
            "name": "pos",
            "in": "query"
          },
          {
            "type": "string",
            "default": "2017-10-01",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "(streaming responses)",
            "schema": {
              "$ref": "#/definitions/v1EMetricsList"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/logs/{model_id}/loglines": {
      "get": {
        "tags": [
          "TrainingData"
        ],
        "summary": "Get loglines, based on query",
        "operationId": "getLoglines",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "TERM",
              "NESTED",
              "MATCH"
            ],
            "type": "string",
            "default": "TERM",
            "name": "searchType",
            "in": "query"
          },
          {
            "type": "string",
            "format": "string",
            "default": "",
            "description": "Time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. If this value is a raw integer, it represents the time that the metric occured: representing the number of milliseconds since midnight January 1, 1970. If this value is a negative integer, it represents the number of lines to count backwards. If this value is empty, the logs since the beginning of the job will be returned",
            "name": "since_time",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "description": "Number of lines to output.",
            "name": "pagesize",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "If positive, line number from start, if negative line counting from end",
            "name": "pos",
            "in": "query"
          },
          {
            "type": "string",
            "default": "2017-10-01",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "(streaming responses)",
            "schema": {
              "$ref": "#/definitions/v1LogLinesList"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/models": {
      "get": {
        "description": "Get a list of all available deep learning models and their configuration that a user can see.\n",
        "tags": [
          "Models"
        ],
        "summary": "Get a list of available deep learning models.",
        "operationId": "listModels",
        "parameters": [
          {
            "type": "string",
            "default": "2017-02-13",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "List of deep learning models.",
            "schema": {
              "$ref": "#/definitions/ModelList"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "description": "Trains a deep neural network written in a DL framework supported by the DLaaS platform (such as Caffe, Tensorflow, etc.). The model code has to be uploaded and configuration parameters have to be provided.\n",
        "consumes": [
          "multipart/form-data"
        ],
        "produces": [
          "application/json"
        ],
        "tags": [
          "Models"
        ],
        "summary": "Trains a new deep learning model.",
        "operationId": "postModel",
        "parameters": [
          {
            "type": "file",
            "description": "The deep learning model code as compressed archive (ZIP).",
            "name": "model_definition",
            "in": "formData"
          },
          {
            "type": "file",
            "description": "The manifest providing configuration for the deep learning model, the training data and the training execution.",
            "name": "manifest",
            "in": "formData",
            "required": true
          },
          {
            "type": "string",
            "default": "2017-02-13",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "Deep learning model successfully accepted.",
            "schema": {
              "$ref": "#/definitions/BasicNewModel"
            },
            "headers": {
              "Location": {
                "type": "string",
                "description": "Location header containing the model id."
              }
            }
          },
          "400": {
            "description": "Error in the the model_definition or manifest.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/models/{model_id}": {
      "get": {
        "description": "Get detailed information about a model such as training status.\n",
        "tags": [
          "Models"
        ],
        "summary": "Get detailed information about a model.",
        "operationId": "getModel",
        "parameters": [
          {
            "type": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "default": "2017-02-13",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Detailed model and training information.",
            "schema": {
              "$ref": "#/definitions/Model"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "Model with the given ID not found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes an existing model. It does not delete any data in the user's data store.\n",
        "tags": [
          "Models"
        ],
        "summary": "Deletes an existing model",
        "operationId": "deleteModel",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "default": "2017-02-13",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Model deleted successfully.",
            "schema": {
              "$ref": "#/definitions/BasicModel"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The model cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "description": "Changes the status of the training progress to the given ` + "`" + `status` + "`" + ` value (currently ` + "`" + `halt` + "`" + ` only). Halt means the training will be stopped and the last snapshot will be stored and can be retrieved.",
        "tags": [
          "Models"
        ],
        "summary": "Changes the status of the training progress.",
        "operationId": "patchModel",
        "parameters": [
          {
            "type": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "description": "Currently accepts \"halt\" as the only valid value.",
            "name": "payload",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/TrainingUpdate"
            }
          },
          {
            "type": "string",
            "default": "2017-02-13",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Training successfully halted.",
            "schema": {
              "$ref": "#/definitions/BasicModel"
            }
          },
          "400": {
            "description": "Incorrect status specified.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "Model with the given ID not found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/models/{model_id}/definition": {
      "get": {
        "description": "Downloads the model definition that was initial used for training as ZIP archive.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Models"
        ],
        "summary": "Downloads the model definition.",
        "operationId": "downloadModelDefinition",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "default": "2017-02-13",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Model definition",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The model cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/models/{model_id}/events/{event_type}": {
      "get": {
        "description": "Get all notification endpoint URLs for this event type.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Events"
        ],
        "summary": "Get all notification endpoints for this event type.",
        "operationId": "getEventTypeEndpoints",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "string",
            "description": "The type of event.",
            "name": "event_type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Event endpoints",
            "schema": {
              "$ref": "#/definitions/EndpointList"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The model or event type cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "410": {
            "description": "If the trained model storage time has expired and it has been deleted. It only gets deleted if it not stored on an external data store.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/models/{model_id}/events/{event_type}/{endpoint_id}": {
      "get": {
        "description": "Get a specific endpoint description.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Events"
        ],
        "summary": "Get endpoint description.",
        "operationId": "getEventEndpoint",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "string",
            "description": "The type of event.",
            "name": "event_type",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "string",
            "description": "The id of the endpoint.",
            "name": "endpoint_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Event description",
            "schema": {
              "$ref": "#/definitions/Endpoint"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The model or event type cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "410": {
            "description": "If the trained model storage time has expired and it has been deleted. It only gets deleted if it not stored on an external data store.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "description": "Creates a specific event type's URL notification endpoint.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Events"
        ],
        "summary": "Creates an event notification endpoint.",
        "operationId": "createEventEndpoint",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "string",
            "description": "The type of event.",
            "name": "event_type",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "string",
            "description": "The id of the endpoint.",
            "name": "endpoint_id",
            "in": "path",
            "required": true
          },
          {
            "description": "The URL that should be notified when an event triggers.",
            "name": "callback_url",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/EventEndpointRegistration"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Event updated successfully",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The model or event type cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "410": {
            "description": "If the trained model storage time has expired and it has been deleted. It only gets deleted if it not stored on an external data store.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes a specific event type's URL notification endpoint.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Events"
        ],
        "summary": "Deletes an event notification endpoint.",
        "operationId": "deleteEventEndpoint",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "string",
            "description": "The type of event.",
            "name": "event_type",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "string",
            "description": "The id of the endpoint.",
            "name": "endpoint_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Event updated successfully",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The model or event type cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "410": {
            "description": "If the trained model storage time has expired and it has been deleted. It only gets deleted if it not stored on an external data store.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/models/{model_id}/logs": {
      "get": {
        "description": "Get training logs for the given model as websocket stream. Each message can contain one or more log lines.\n",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Models"
        ],
        "summary": "Get training logs as websocket stream.\n",
        "operationId": "getLogs",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "format": "boolean",
            "default": false,
            "description": "Follow the log stream if true. Default false.",
            "name": "follow",
            "in": "query"
          },
          {
            "type": "string",
            "format": "string",
            "default": "",
            "description": "An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned.  If this value is in the future, no logs will be returned.",
            "name": "since_time",
            "in": "query"
          },
          {
            "type": "string",
            "default": "2017-02-13",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Dump of the training log to-date",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The model cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/models/{model_id}/metrics": {
      "get": {
        "description": "Get training metrics such as learning rate, accurarcy, loss from a model training via a websocket. It returns one or more JSON payloads at a time with the following schema.\n",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Models"
        ],
        "summary": "Get training metrics from a model training as websocket.\n",
        "operationId": "getMetrics",
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "format": "boolean",
            "default": false,
            "description": "Follow the log stream if true. Default false.",
            "name": "follow",
            "in": "query"
          },
          {
            "type": "string",
            "format": "string",
            "default": "",
            "description": "An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned.  If this value is in the future, no metrics will be returned.",
            "name": "since_time",
            "in": "query"
          },
          {
            "type": "string",
            "default": "2017-06-07",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Dump of the training log to-date",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The training job cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/v1/models/{model_id}/trained_model": {
      "get": {
        "description": "Downloads the trained model as ZIP archive.",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Models"
        ],
        "summary": "Downloads the trained model.",
        "operationId": "downloadTrainedModel",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "string",
            "description": "The id of the model.",
            "name": "model_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "default": "2017-02-13",
            "description": "The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Model definition",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "The trained model cannot be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "410": {
            "description": "If the trained model storage time has expired and it has been deleted. It only gets deleted if it not stored on an external data store.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "AnyDataType": {
      "type": "string",
      "default": "STRING",
      "enum": [
        "STRING",
        "JSONSTRING",
        "INT",
        "FLOAT"
      ]
    },
    "BasicModel": {
      "type": "object",
      "properties": {
        "model_id": {
          "description": "A unique id of the deep learning model.",
          "type": "string"
        }
      }
    },
    "BasicNewModel": {
      "allOf": [
        {
          "$ref": "#/definitions/BasicModel"
        },
        {
          "properties": {
            "location": {
              "description": "Location of the model to retrieve it.",
              "type": "string"
            }
          }
        }
      ]
    },
    "Datastore": {
      "type": "object",
      "properties": {
        "connection": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "data_store_id": {
          "description": "the id of the data store as defined in the manifest.",
          "type": "string"
        },
        "type": {
          "description": "the type of the data store as defined in the manifest.",
          "type": "string"
        }
      }
    },
    "Endpoint": {
      "type": "object",
      "properties": {
        "id": {
          "description": "the id of the endpoint",
          "type": "string"
        },
        "url": {
          "description": "the url of the endpoint",
          "type": "string"
        }
      }
    },
    "EndpointList": {
      "type": "object",
      "properties": {
        "endpoints": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Endpoint"
          }
        }
      }
    },
    "Error": {
      "type": "object",
      "properties": {
        "code": {
          "type": "integer",
          "format": "int32"
        },
        "description": {
          "type": "string"
        },
        "error": {
          "type": "string"
        }
      }
    },
    "Event": {
      "type": "object",
      "properties": {
        "endpoints": {
          "$ref": "#/definitions/EndpointList"
        },
        "type": {
          "description": "the type of event (i.e. update, metrics, logs, all...)",
          "type": "string"
        }
      }
    },
    "EventEndpointRegistration": {
      "type": "object",
      "properties": {
        "type": {
          "description": "The type of event this URL should be notified of.",
          "type": "string"
        },
        "url": {
          "description": "The URL to notify on events.",
          "type": "string"
        }
      }
    },
    "EventList": {
      "type": "object",
      "properties": {
        "events": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Event"
          }
        }
      }
    },
    "Framework": {
      "type": "object",
      "properties": {
        "name": {
          "description": "the name of the deep learning framework (e.g. caffe, torch, tensorflow)",
          "type": "string"
        },
        "version": {
          "description": "the version of the specific framework to use.",
          "type": "string"
        }
      }
    },
    "MetricData": {
      "type": "object",
      "properties": {
        "Values": {
          "description": "map of key/values, that describe evaluation metrics",
          "type": "object",
          "additionalProperties": {
            "type": "object"
          }
        },
        "iteration": {
          "description": "Current iteration number be processed.",
          "type": "number",
          "format": "int32"
        },
        "timestamp": {
          "description": "Timestamp of the metric. Format: yyyy-MM-dd'T'HH:mm:ss.SSS'Z'\n",
          "type": "string"
        },
        "type": {
          "description": "The type of metrics data",
          "type": "string"
        }
      }
    },
    "Model": {
      "allOf": [
        {
          "$ref": "#/definitions/BasicNewModel"
        },
        {
          "properties": {
            "data_stores": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Datastore"
              }
            },
            "description": {
              "description": "Detailed description of deep learning model.",
              "type": "string"
            },
            "framework": {
              "$ref": "#/definitions/Framework"
            },
            "metrics": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/MetricData"
              }
            },
            "name": {
              "description": "The name of the deep learning model.",
              "type": "string"
            },
            "training": {
              "$ref": "#/definitions/Training"
            }
          }
        }
      ]
    },
    "ModelList": {
      "type": "object",
      "properties": {
        "models": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Model"
          }
        }
      }
    },
    "QuerySearchType": {
      "type": "string",
      "default": "TERM",
      "enum": [
        "TERM",
        "NESTED",
        "MATCH",
        "ALL"
      ]
    },
    "Training": {
      "type": "object",
      "properties": {
        "command": {
          "description": "the command invoked for running the training. This is specific to the DL framework",
          "type": "string"
        },
        "cpus": {
          "description": "Number of CPUs required",
          "type": "number",
          "format": "double"
        },
        "events": {
          "$ref": "#/definitions/EventList"
        },
        "gpus": {
          "description": "Number of CPUs required",
          "type": "number",
          "format": "double"
        },
        "input_data": {
          "description": "Input data to the training, such as training data, pre-trained model. The input is specified as references to the data_store ids that contain the data.",
          "type": "array",
          "items": {
            "description": "Reference to a data store id.",
            "type": "string"
          }
        },
        "learners": {
          "description": "Number of learners required.",
          "type": "integer",
          "format": "int32"
        },
        "memory": {
          "description": "Amount of memory required",
          "type": "number",
          "format": "double"
        },
        "memory_unit": {
          "description": "Memory unit (default: MiB)\n",
          "type": "string",
          "default": "MiB",
          "enum": [
            "MiB",
            "MB",
            "GiB",
            "GB"
          ]
        },
        "output_data": {
          "description": "Output data of the training, such as trained models. The output is specified as references to the data_store ids that contain the data.",
          "type": "array",
          "items": {
            "description": "Reference to a data store id.",
            "type": "string"
          }
        },
        "size": {
          "description": "the pre-configured deployment size to used for training. The is used instead of directly specifying CPU, GPU, memory and learners.",
          "type": "string"
        },
        "training_status": {
          "$ref": "#/definitions/TrainingStatus"
        }
      }
    },
    "TrainingStatus": {
      "type": "object",
      "properties": {
        "completed": {
          "description": "Training completion timestamp (Format: yyyy-MM-dd'T'HH:mm:ss.SSS'Z')\n",
          "type": "string"
        },
        "error_code": {
          "description": "A code identifying the cause of a status message.",
          "type": "string"
        },
        "status": {
          "description": "Status of the training.",
          "type": "string"
        },
        "status_description": {
          "description": "Description of the training status.",
          "type": "string"
        },
        "status_message": {
          "description": "A human readable message description of the training status.",
          "type": "string"
        },
        "submitted": {
          "description": "Training submission timestamp (Format: yyyy-MM-dd'T'HH:mm:ss.SSS'Z')\n",
          "type": "string"
        }
      }
    },
    "TrainingUpdate": {
      "type": "object",
      "properties": {
        "status": {
          "description": "The status action to be executed on the training job. (Currently only ` + "`" + `halt` + "`" + ` is supported.)",
          "type": "string"
        }
      }
    },
    "v1AddResponse": {
      "type": "object",
      "title": "***",
      "properties": {
        "success": {
          "type": "boolean",
          "format": "boolean"
        }
      }
    },
    "v1Any": {
      "type": "object",
      "properties": {
        "type": {
          "$ref": "#/definitions/AnyDataType"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "v1DeleteResponse": {
      "type": "object",
      "properties": {
        "success": {
          "type": "boolean",
          "format": "boolean"
        }
      }
    },
    "v1EMetrics": {
      "type": "object",
      "properties": {
        "etimes": {
          "type": "object",
          "title": "Repeated, order-dependent list of temporal keys\nExample: {\"iteration\": 209}",
          "additionalProperties": {
            "$ref": "#/definitions/v1Any"
          }
        },
        "grouplabel": {
          "type": "string",
          "title": "Group label, such as test, train, or validate"
        },
        "meta": {
          "$ref": "#/definitions/v1MetaInfo"
        },
        "values": {
          "type": "object",
          "title": "/ {\"cross_entropy\": 0.4430539906024933,\t\"accuracy\": 0.8999999761581421}",
          "additionalProperties": {
            "$ref": "#/definitions/v1Any"
          }
        }
      }
    },
    "v1EMetricsList": {
      "type": "object",
      "properties": {
        "models": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/v1EMetrics"
          }
        }
      }
    },
    "v1HelloResponse": {
      "type": "object",
      "properties": {
        "msg": {
          "type": "string"
        }
      }
    },
    "v1LogLine": {
      "type": "object",
      "properties": {
        "line": {
          "type": "string"
        },
        "meta": {
          "$ref": "#/definitions/v1MetaInfo"
        }
      }
    },
    "v1LogLinesList": {
      "type": "object",
      "properties": {
        "models": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/v1LogLine"
          }
        }
      }
    },
    "v1MetaInfo": {
      "type": "object",
      "properties": {
        "rindex": {
          "type": "string",
          "format": "int64",
          "title": "sequential index"
        },
        "time": {
          "description": "Time that the metric occured: representing the number of millisecond since midnight January 1, 1970.",
          "type": "string",
          "format": "int64"
        },
        "training_id": {
          "type": "string",
          "title": "Unique id identifying the training job"
        },
        "user_id": {
          "type": "string",
          "title": "Unique id identifying the user"
        }
      }
    }
  },
  "parameters": {
    "DlaasGroup": {
      "type": "string",
      "description": "Roles of a DLaaS user",
      "name": "X-DLaaS-Roles",
      "in": "header"
    },
    "DlaasUser": {
      "type": "string",
      "description": "User ID of the DLaaS user (from Bluemix)",
      "name": "X-DLaaS-UserID",
      "in": "header"
    },
    "WatsonUserinfo": {
      "type": "string",
      "description": "Bluemix user information injected by the Watson gateway",
      "name": "X-Watson-Userinfo",
      "in": "header"
    }
  },
  "securityDefinitions": {
    "basicAuth": {
      "description": "Basic Autentication credentials for using the API.",
      "type": "basic"
    },
    "basicAuthToken": {
      "description": "Watson Developer Cloud Basic Autentication. See [here](https://www.ibm.com/smarterplanet/us/en/ibmwatson/developercloud/doc/getting_started/gs-tokens.shtml) for more information",
      "type": "apiKey",
      "name": "Authorization",
      "in": "header"
    },
    "watsonAuthToken": {
      "description": "Watson Developer Cloud Token Autentication. See [here](https://www.ibm.com/smarterplanet/us/en/ibmwatson/developercloud/doc/getting_started/gs-tokens.shtml) for more information",
      "type": "apiKey",
      "name": "X-Watson-Authorization-Token",
      "in": "header"
    },
    "watsonAuthTokenQuery": {
      "description": "Watson Developer Cloud Token Autentication. See [here](https://www.ibm.com/smarterplanet/us/en/ibmwatson/developercloud/doc/getting_started/gs-tokens.shtml) for more information",
      "type": "apiKey",
      "name": "watson-token",
      "in": "query"
    }
  },
  "security": [
    {
      "basicAuthToken": []
    },
    {
      "watsonAuthToken": []
    },
    {
      "watsonAuthTokenQuery": []
    }
  ]
}`))
}
