// Code generated by go-swagger; DO NOT EDIT.

package restmodels

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Training training
// swagger:model Training

type Training struct {

	// the command invoked for running the training. This is specific to the DL framework
	Command string `json:"command,omitempty"`

	// Number of CPUs required
	Cpus float64 `json:"cpus,omitempty"`

	// events
	Events *EventList `json:"events,omitempty"`

	// Number of CPUs required
	Gpus float64 `json:"gpus,omitempty"`

	// Input data to the training, such as training data, pre-trained model. The input is specified as references to the data_store ids that contain the data.
	InputData []string `json:"input_data"`

	// Number of learners required.
	Learners int32 `json:"learners,omitempty"`

	// Amount of memory required
	Memory float64 `json:"memory,omitempty"`

	// Memory unit (default: MiB)
	//
	MemoryUnit *string `json:"memory_unit,omitempty"`

	// Output data of the training, such as trained models. The output is specified as references to the data_store ids that contain the data.
	OutputData []string `json:"output_data"`

	// the pre-configured deployment size to used for training. The is used instead of directly specifying CPU, GPU, memory and learners.
	Size string `json:"size,omitempty"`

	// training status
	TrainingStatus *TrainingStatus `json:"training_status,omitempty"`
}

/* polymorph Training command false */

/* polymorph Training cpus false */

/* polymorph Training events false */

/* polymorph Training gpus false */

/* polymorph Training input_data false */

/* polymorph Training learners false */

/* polymorph Training memory false */

/* polymorph Training memory_unit false */

/* polymorph Training output_data false */

/* polymorph Training size false */

/* polymorph Training training_status false */

// Validate validates this training
func (m *Training) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEvents(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateInputData(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateMemoryUnit(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateOutputData(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if err := m.validateTrainingStatus(formats); err != nil {
		// prop
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Training) validateEvents(formats strfmt.Registry) error {

	if swag.IsZero(m.Events) { // not required
		return nil
	}

	if m.Events != nil {

		if err := m.Events.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("events")
			}
			return err
		}
	}

	return nil
}

func (m *Training) validateInputData(formats strfmt.Registry) error {

	if swag.IsZero(m.InputData) { // not required
		return nil
	}

	return nil
}

var trainingTypeMemoryUnitPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["MiB","MB","GiB","GB"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		trainingTypeMemoryUnitPropEnum = append(trainingTypeMemoryUnitPropEnum, v)
	}
}

const (
	// TrainingMemoryUnitMiB captures enum value "MiB"
	TrainingMemoryUnitMiB string = "MiB"
	// TrainingMemoryUnitMB captures enum value "MB"
	TrainingMemoryUnitMB string = "MB"
	// TrainingMemoryUnitGiB captures enum value "GiB"
	TrainingMemoryUnitGiB string = "GiB"
	// TrainingMemoryUnitGB captures enum value "GB"
	TrainingMemoryUnitGB string = "GB"
)

// prop value enum
func (m *Training) validateMemoryUnitEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, trainingTypeMemoryUnitPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *Training) validateMemoryUnit(formats strfmt.Registry) error {

	if swag.IsZero(m.MemoryUnit) { // not required
		return nil
	}

	// value enum
	if err := m.validateMemoryUnitEnum("memory_unit", "body", *m.MemoryUnit); err != nil {
		return err
	}

	return nil
}

func (m *Training) validateOutputData(formats strfmt.Registry) error {

	if swag.IsZero(m.OutputData) { // not required
		return nil
	}

	return nil
}

func (m *Training) validateTrainingStatus(formats strfmt.Registry) error {

	if swag.IsZero(m.TrainingStatus) { // not required
		return nil
	}

	if m.TrainingStatus != nil {

		if err := m.TrainingStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("training_status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Training) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Training) UnmarshalBinary(b []byte) error {
	var res Training
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
