// Code generated by go-swagger; DO NOT EDIT.

package restmodels

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
)

// Model model
// swagger:model Model

type Model struct {
	BasicNewModel

	// data stores
	DataStores []*Datastore `json:"data_stores"`

	// Detailed description of deep learning model.
	Description string `json:"description,omitempty"`

	// framework
	Framework *Framework `json:"framework,omitempty"`

	// metrics
	Metrics []*MetricData `json:"metrics"`

	// The name of the deep learning model.
	Name string `json:"name,omitempty"`

	// training
	Training *Training `json:"training,omitempty"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *Model) UnmarshalJSON(raw []byte) error {

	var aO0 BasicNewModel
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.BasicNewModel = aO0

	var data struct {
		DataStores []*Datastore `json:"data_stores,omitempty"`

		Description string `json:"description,omitempty"`

		Framework *Framework `json:"framework,omitempty"`

		Metrics []*MetricData `json:"metrics,omitempty"`

		Name string `json:"name,omitempty"`

		Training *Training `json:"training,omitempty"`
	}
	if err := swag.ReadJSON(raw, &data); err != nil {
		return err
	}

	m.DataStores = data.DataStores

	m.Description = data.Description

	m.Framework = data.Framework

	m.Metrics = data.Metrics

	m.Name = data.Name

	m.Training = data.Training

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m Model) MarshalJSON() ([]byte, error) {
	var _parts [][]byte

	aO0, err := swag.WriteJSON(m.BasicNewModel)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)

	var data struct {
		DataStores []*Datastore `json:"data_stores,omitempty"`

		Description string `json:"description,omitempty"`

		Framework *Framework `json:"framework,omitempty"`

		Metrics []*MetricData `json:"metrics,omitempty"`

		Name string `json:"name,omitempty"`

		Training *Training `json:"training,omitempty"`
	}

	data.DataStores = m.DataStores

	data.Description = m.Description

	data.Framework = m.Framework

	data.Metrics = m.Metrics

	data.Name = m.Name

	data.Training = m.Training

	jsonData, err := swag.WriteJSON(data)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, jsonData)

	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this model
func (m *Model) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.BasicNewModel.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFramework(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetrics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTraining(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Model) validateDataStores(formats strfmt.Registry) error {

	if swag.IsZero(m.DataStores) { // not required
		return nil
	}

	for i := 0; i < len(m.DataStores); i++ {

		if swag.IsZero(m.DataStores[i]) { // not required
			continue
		}

		if m.DataStores[i] != nil {

			if err := m.DataStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Model) validateFramework(formats strfmt.Registry) error {

	if swag.IsZero(m.Framework) { // not required
		return nil
	}

	if m.Framework != nil {

		if err := m.Framework.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("framework")
			}
			return err
		}
	}

	return nil
}

func (m *Model) validateMetrics(formats strfmt.Registry) error {

	if swag.IsZero(m.Metrics) { // not required
		return nil
	}

	for i := 0; i < len(m.Metrics); i++ {

		if swag.IsZero(m.Metrics[i]) { // not required
			continue
		}

		if m.Metrics[i] != nil {

			if err := m.Metrics[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrics" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Model) validateTraining(formats strfmt.Registry) error {

	if swag.IsZero(m.Training) { // not required
		return nil
	}

	if m.Training != nil {

		if err := m.Training.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("training")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Model) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Model) UnmarshalBinary(b []byte) error {
	var res Model
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
