// Code generated by go-swagger; DO NOT EDIT.

package training_data

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewGetEMetricsParams creates a new GetEMetricsParams object
// with the default values initialized.
func NewGetEMetricsParams() *GetEMetricsParams {
	var (
		searchTypeDefault = string("TERM")
		sinceTimeDefault  = string("")
		versionDefault    = string("2017-10-01")
	)
	return &GetEMetricsParams{
		SearchType: &searchTypeDefault,
		SinceTime:  &sinceTimeDefault,
		Version:    &versionDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewGetEMetricsParamsWithTimeout creates a new GetEMetricsParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewGetEMetricsParamsWithTimeout(timeout time.Duration) *GetEMetricsParams {
	var (
		searchTypeDefault = string("TERM")
		sinceTimeDefault  = string("")
		versionDefault    = string("2017-10-01")
	)
	return &GetEMetricsParams{
		SearchType: &searchTypeDefault,
		SinceTime:  &sinceTimeDefault,
		Version:    &versionDefault,

		timeout: timeout,
	}
}

// NewGetEMetricsParamsWithContext creates a new GetEMetricsParams object
// with the default values initialized, and the ability to set a context for a request
func NewGetEMetricsParamsWithContext(ctx context.Context) *GetEMetricsParams {
	var (
		searchTypeDefault = string("TERM")
		sinceTimeDefault  = string("")
		versionDefault    = string("2017-10-01")
	)
	return &GetEMetricsParams{
		SearchType: &searchTypeDefault,
		SinceTime:  &sinceTimeDefault,
		Version:    &versionDefault,

		Context: ctx,
	}
}

// NewGetEMetricsParamsWithHTTPClient creates a new GetEMetricsParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewGetEMetricsParamsWithHTTPClient(client *http.Client) *GetEMetricsParams {
	var (
		searchTypeDefault = string("TERM")
		sinceTimeDefault  = string("")
		versionDefault    = string("2017-10-01")
	)
	return &GetEMetricsParams{
		SearchType: &searchTypeDefault,
		SinceTime:  &sinceTimeDefault,
		Version:    &versionDefault,
		HTTPClient: client,
	}
}

/*GetEMetricsParams contains all the parameters to send to the API endpoint
for the get e metrics operation typically these are written to a http.Request
*/
type GetEMetricsParams struct {

	/*ModelID
	  The id of the model.

	*/
	ModelID string
	/*Pagesize
	  Number of lines to output.

	*/
	Pagesize *int32
	/*Pos
	  If positive, line number from start, if negative line counting from end

	*/
	Pos *int64
	/*SearchType*/
	SearchType *string
	/*SinceTime
	  Time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. If this value is a raw integer, it represents the time that the metric occured: representing the number of milliseconds since midnight January 1, 1970. If this value is a negative integer, it represents the number of lines to count backwards. If this value is empty, the logs since the beginning of the job will be returned

	*/
	SinceTime *string
	/*Version
	  The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.

	*/
	Version *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the get e metrics params
func (o *GetEMetricsParams) WithTimeout(timeout time.Duration) *GetEMetricsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get e metrics params
func (o *GetEMetricsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get e metrics params
func (o *GetEMetricsParams) WithContext(ctx context.Context) *GetEMetricsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get e metrics params
func (o *GetEMetricsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get e metrics params
func (o *GetEMetricsParams) WithHTTPClient(client *http.Client) *GetEMetricsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get e metrics params
func (o *GetEMetricsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithModelID adds the modelID to the get e metrics params
func (o *GetEMetricsParams) WithModelID(modelID string) *GetEMetricsParams {
	o.SetModelID(modelID)
	return o
}

// SetModelID adds the modelId to the get e metrics params
func (o *GetEMetricsParams) SetModelID(modelID string) {
	o.ModelID = modelID
}

// WithPagesize adds the pagesize to the get e metrics params
func (o *GetEMetricsParams) WithPagesize(pagesize *int32) *GetEMetricsParams {
	o.SetPagesize(pagesize)
	return o
}

// SetPagesize adds the pagesize to the get e metrics params
func (o *GetEMetricsParams) SetPagesize(pagesize *int32) {
	o.Pagesize = pagesize
}

// WithPos adds the pos to the get e metrics params
func (o *GetEMetricsParams) WithPos(pos *int64) *GetEMetricsParams {
	o.SetPos(pos)
	return o
}

// SetPos adds the pos to the get e metrics params
func (o *GetEMetricsParams) SetPos(pos *int64) {
	o.Pos = pos
}

// WithSearchType adds the searchType to the get e metrics params
func (o *GetEMetricsParams) WithSearchType(searchType *string) *GetEMetricsParams {
	o.SetSearchType(searchType)
	return o
}

// SetSearchType adds the searchType to the get e metrics params
func (o *GetEMetricsParams) SetSearchType(searchType *string) {
	o.SearchType = searchType
}

// WithSinceTime adds the sinceTime to the get e metrics params
func (o *GetEMetricsParams) WithSinceTime(sinceTime *string) *GetEMetricsParams {
	o.SetSinceTime(sinceTime)
	return o
}

// SetSinceTime adds the sinceTime to the get e metrics params
func (o *GetEMetricsParams) SetSinceTime(sinceTime *string) {
	o.SinceTime = sinceTime
}

// WithVersion adds the version to the get e metrics params
func (o *GetEMetricsParams) WithVersion(version *string) *GetEMetricsParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the get e metrics params
func (o *GetEMetricsParams) SetVersion(version *string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *GetEMetricsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param model_id
	if err := r.SetPathParam("model_id", o.ModelID); err != nil {
		return err
	}

	if o.Pagesize != nil {

		// query param pagesize
		var qrPagesize int32
		if o.Pagesize != nil {
			qrPagesize = *o.Pagesize
		}
		qPagesize := swag.FormatInt32(qrPagesize)
		if qPagesize != "" {
			if err := r.SetQueryParam("pagesize", qPagesize); err != nil {
				return err
			}
		}

	}

	if o.Pos != nil {

		// query param pos
		var qrPos int64
		if o.Pos != nil {
			qrPos = *o.Pos
		}
		qPos := swag.FormatInt64(qrPos)
		if qPos != "" {
			if err := r.SetQueryParam("pos", qPos); err != nil {
				return err
			}
		}

	}

	if o.SearchType != nil {

		// query param searchType
		var qrSearchType string
		if o.SearchType != nil {
			qrSearchType = *o.SearchType
		}
		qSearchType := qrSearchType
		if qSearchType != "" {
			if err := r.SetQueryParam("searchType", qSearchType); err != nil {
				return err
			}
		}

	}

	if o.SinceTime != nil {

		// query param since_time
		var qrSinceTime string
		if o.SinceTime != nil {
			qrSinceTime = *o.SinceTime
		}
		qSinceTime := qrSinceTime
		if qSinceTime != "" {
			if err := r.SetQueryParam("since_time", qSinceTime); err != nil {
				return err
			}
		}

	}

	if o.Version != nil {

		// query param version
		var qrVersion string
		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion
		if qVersion != "" {
			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
