// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"os"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewPostModelParams creates a new PostModelParams object
// with the default values initialized.
func NewPostModelParams() *PostModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &PostModelParams{
		Version: versionDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewPostModelParamsWithTimeout creates a new PostModelParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewPostModelParamsWithTimeout(timeout time.Duration) *PostModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &PostModelParams{
		Version: versionDefault,

		timeout: timeout,
	}
}

// NewPostModelParamsWithContext creates a new PostModelParams object
// with the default values initialized, and the ability to set a context for a request
func NewPostModelParamsWithContext(ctx context.Context) *PostModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &PostModelParams{
		Version: versionDefault,

		Context: ctx,
	}
}

// NewPostModelParamsWithHTTPClient creates a new PostModelParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewPostModelParamsWithHTTPClient(client *http.Client) *PostModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &PostModelParams{
		Version:    versionDefault,
		HTTPClient: client,
	}
}

/*PostModelParams contains all the parameters to send to the API endpoint
for the post model operation typically these are written to a http.Request
*/
type PostModelParams struct {

	/*Manifest
	  The manifest providing configuration for the deep learning model, the training data and the training execution.

	*/
	Manifest os.File
	/*ModelDefinition
	  The deep learning model code as compressed archive (ZIP).

	*/
	ModelDefinition *os.File
	/*Version
	  The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.

	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the post model params
func (o *PostModelParams) WithTimeout(timeout time.Duration) *PostModelParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the post model params
func (o *PostModelParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the post model params
func (o *PostModelParams) WithContext(ctx context.Context) *PostModelParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the post model params
func (o *PostModelParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the post model params
func (o *PostModelParams) WithHTTPClient(client *http.Client) *PostModelParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the post model params
func (o *PostModelParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithManifest adds the manifest to the post model params
func (o *PostModelParams) WithManifest(manifest os.File) *PostModelParams {
	o.SetManifest(manifest)
	return o
}

// SetManifest adds the manifest to the post model params
func (o *PostModelParams) SetManifest(manifest os.File) {
	o.Manifest = manifest
}

// WithModelDefinition adds the modelDefinition to the post model params
func (o *PostModelParams) WithModelDefinition(modelDefinition *os.File) *PostModelParams {
	o.SetModelDefinition(modelDefinition)
	return o
}

// SetModelDefinition adds the modelDefinition to the post model params
func (o *PostModelParams) SetModelDefinition(modelDefinition *os.File) {
	o.ModelDefinition = modelDefinition
}

// WithVersion adds the version to the post model params
func (o *PostModelParams) WithVersion(version string) *PostModelParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the post model params
func (o *PostModelParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *PostModelParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// form file param manifest
	if err := r.SetFileParam("manifest", &o.Manifest); err != nil {
		return err
	}

	if o.ModelDefinition != nil {

		if o.ModelDefinition != nil {

			// form file param model_definition
			if err := r.SetFileParam("model_definition", o.ModelDefinition); err != nil {
				return err
			}

		}

	}

	// query param version
	qrVersion := o.Version
	qVersion := qrVersion
	if qVersion != "" {
		if err := r.SetQueryParam("version", qVersion); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
