// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/IBM/FfDL/restapi/api_v1/restmodels"
)

// NewPatchModelParams creates a new PatchModelParams object
// with the default values initialized.
func NewPatchModelParams() *PatchModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &PatchModelParams{
		Version: versionDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewPatchModelParamsWithTimeout creates a new PatchModelParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewPatchModelParamsWithTimeout(timeout time.Duration) *PatchModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &PatchModelParams{
		Version: versionDefault,

		timeout: timeout,
	}
}

// NewPatchModelParamsWithContext creates a new PatchModelParams object
// with the default values initialized, and the ability to set a context for a request
func NewPatchModelParamsWithContext(ctx context.Context) *PatchModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &PatchModelParams{
		Version: versionDefault,

		Context: ctx,
	}
}

// NewPatchModelParamsWithHTTPClient creates a new PatchModelParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewPatchModelParamsWithHTTPClient(client *http.Client) *PatchModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &PatchModelParams{
		Version:    versionDefault,
		HTTPClient: client,
	}
}

/*PatchModelParams contains all the parameters to send to the API endpoint
for the patch model operation typically these are written to a http.Request
*/
type PatchModelParams struct {

	/*ModelID
	  The id of the model.

	*/
	ModelID string
	/*Payload
	  Currently accepts "halt" as the only valid value.

	*/
	Payload *restmodels.TrainingUpdate
	/*Version
	  The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.

	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the patch model params
func (o *PatchModelParams) WithTimeout(timeout time.Duration) *PatchModelParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the patch model params
func (o *PatchModelParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the patch model params
func (o *PatchModelParams) WithContext(ctx context.Context) *PatchModelParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the patch model params
func (o *PatchModelParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the patch model params
func (o *PatchModelParams) WithHTTPClient(client *http.Client) *PatchModelParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the patch model params
func (o *PatchModelParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithModelID adds the modelID to the patch model params
func (o *PatchModelParams) WithModelID(modelID string) *PatchModelParams {
	o.SetModelID(modelID)
	return o
}

// SetModelID adds the modelId to the patch model params
func (o *PatchModelParams) SetModelID(modelID string) {
	o.ModelID = modelID
}

// WithPayload adds the payload to the patch model params
func (o *PatchModelParams) WithPayload(payload *restmodels.TrainingUpdate) *PatchModelParams {
	o.SetPayload(payload)
	return o
}

// SetPayload adds the payload to the patch model params
func (o *PatchModelParams) SetPayload(payload *restmodels.TrainingUpdate) {
	o.Payload = payload
}

// WithVersion adds the version to the patch model params
func (o *PatchModelParams) WithVersion(version string) *PatchModelParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the patch model params
func (o *PatchModelParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *PatchModelParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param model_id
	if err := r.SetPathParam("model_id", o.ModelID); err != nil {
		return err
	}

	if o.Payload == nil {
		o.Payload = new(restmodels.TrainingUpdate)
	}

	if err := r.SetBodyParam(o.Payload); err != nil {
		return err
	}

	// query param version
	qrVersion := o.Version
	qVersion := qrVersion
	if qVersion != "" {
		if err := r.SetQueryParam("version", qVersion); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
