// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/IBM/FfDL/restapi/api_v1/restmodels"
)

// GetModelReader is a Reader for the GetModel structure.
type GetModelReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetModelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewGetModelOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 401:
		result := NewGetModelUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewGetModelNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewGetModelOK creates a GetModelOK with default headers values
func NewGetModelOK() *GetModelOK {
	return &GetModelOK{}
}

/*GetModelOK handles this case with default header values.

Detailed model and training information.
*/
type GetModelOK struct {
	Payload *restmodels.Model
}

func (o *GetModelOK) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}][%d] getModelOK  %+v", 200, o.Payload)
}

func (o *GetModelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(restmodels.Model)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetModelUnauthorized creates a GetModelUnauthorized with default headers values
func NewGetModelUnauthorized() *GetModelUnauthorized {
	return &GetModelUnauthorized{}
}

/*GetModelUnauthorized handles this case with default header values.

Unauthorized
*/
type GetModelUnauthorized struct {
	Payload *restmodels.Error
}

func (o *GetModelUnauthorized) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}][%d] getModelUnauthorized  %+v", 401, o.Payload)
}

func (o *GetModelUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(restmodels.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetModelNotFound creates a GetModelNotFound with default headers values
func NewGetModelNotFound() *GetModelNotFound {
	return &GetModelNotFound{}
}

/*GetModelNotFound handles this case with default header values.

Model with the given ID not found.
*/
type GetModelNotFound struct {
	Payload *restmodels.Error
}

func (o *GetModelNotFound) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}][%d] getModelNotFound  %+v", 404, o.Payload)
}

func (o *GetModelNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(restmodels.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
