// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/IBM/FfDL/restapi/api_v1/restmodels"
)

// GetMetricsReader is a Reader for the GetMetrics structure.
type GetMetricsReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *GetMetricsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewGetMetricsOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 401:
		result := NewGetMetricsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewGetMetricsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewGetMetricsOK creates a GetMetricsOK with default headers values
func NewGetMetricsOK(writer io.Writer) *GetMetricsOK {
	return &GetMetricsOK{
		Payload: writer,
	}
}

/*GetMetricsOK handles this case with default header values.

Dump of the training log to-date
*/
type GetMetricsOK struct {
	Payload io.Writer
}

func (o *GetMetricsOK) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}/metrics][%d] getMetricsOK  %+v", 200, o.Payload)
}

func (o *GetMetricsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMetricsUnauthorized creates a GetMetricsUnauthorized with default headers values
func NewGetMetricsUnauthorized() *GetMetricsUnauthorized {
	return &GetMetricsUnauthorized{}
}

/*GetMetricsUnauthorized handles this case with default header values.

Unauthorized
*/
type GetMetricsUnauthorized struct {
	Payload *restmodels.Error
}

func (o *GetMetricsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}/metrics][%d] getMetricsUnauthorized  %+v", 401, o.Payload)
}

func (o *GetMetricsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(restmodels.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMetricsNotFound creates a GetMetricsNotFound with default headers values
func NewGetMetricsNotFound() *GetMetricsNotFound {
	return &GetMetricsNotFound{}
}

/*GetMetricsNotFound handles this case with default header values.

The training job cannot be found.
*/
type GetMetricsNotFound struct {
	Payload *restmodels.Error
}

func (o *GetMetricsNotFound) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}/metrics][%d] getMetricsNotFound  %+v", 404, o.Payload)
}

func (o *GetMetricsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(restmodels.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
