// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/IBM/FfDL/restapi/api_v1/restmodels"
)

// DownloadTrainedModelReader is a Reader for the DownloadTrainedModel structure.
type DownloadTrainedModelReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *DownloadTrainedModelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewDownloadTrainedModelOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 401:
		result := NewDownloadTrainedModelUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewDownloadTrainedModelNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 410:
		result := NewDownloadTrainedModelGone()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewDownloadTrainedModelOK creates a DownloadTrainedModelOK with default headers values
func NewDownloadTrainedModelOK(writer io.Writer) *DownloadTrainedModelOK {
	return &DownloadTrainedModelOK{
		Payload: writer,
	}
}

/*DownloadTrainedModelOK handles this case with default header values.

Model definition
*/
type DownloadTrainedModelOK struct {
	Payload io.Writer
}

func (o *DownloadTrainedModelOK) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}/trained_model][%d] downloadTrainedModelOK  %+v", 200, o.Payload)
}

func (o *DownloadTrainedModelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadTrainedModelUnauthorized creates a DownloadTrainedModelUnauthorized with default headers values
func NewDownloadTrainedModelUnauthorized() *DownloadTrainedModelUnauthorized {
	return &DownloadTrainedModelUnauthorized{}
}

/*DownloadTrainedModelUnauthorized handles this case with default header values.

Unauthorized
*/
type DownloadTrainedModelUnauthorized struct {
	Payload *restmodels.Error
}

func (o *DownloadTrainedModelUnauthorized) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}/trained_model][%d] downloadTrainedModelUnauthorized  %+v", 401, o.Payload)
}

func (o *DownloadTrainedModelUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(restmodels.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadTrainedModelNotFound creates a DownloadTrainedModelNotFound with default headers values
func NewDownloadTrainedModelNotFound() *DownloadTrainedModelNotFound {
	return &DownloadTrainedModelNotFound{}
}

/*DownloadTrainedModelNotFound handles this case with default header values.

The trained model cannot be found.
*/
type DownloadTrainedModelNotFound struct {
	Payload *restmodels.Error
}

func (o *DownloadTrainedModelNotFound) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}/trained_model][%d] downloadTrainedModelNotFound  %+v", 404, o.Payload)
}

func (o *DownloadTrainedModelNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(restmodels.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadTrainedModelGone creates a DownloadTrainedModelGone with default headers values
func NewDownloadTrainedModelGone() *DownloadTrainedModelGone {
	return &DownloadTrainedModelGone{}
}

/*DownloadTrainedModelGone handles this case with default header values.

If the trained model storage time has expired and it has been deleted. It only gets deleted if it not stored on an external data store.
*/
type DownloadTrainedModelGone struct {
	Payload *restmodels.Error
}

func (o *DownloadTrainedModelGone) Error() string {
	return fmt.Sprintf("[GET /v1/models/{model_id}/trained_model][%d] downloadTrainedModelGone  %+v", 410, o.Payload)
}

func (o *DownloadTrainedModelGone) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(restmodels.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
