// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewDownloadTrainedModelParams creates a new DownloadTrainedModelParams object
// with the default values initialized.
func NewDownloadTrainedModelParams() *DownloadTrainedModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &DownloadTrainedModelParams{
		Version: versionDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewDownloadTrainedModelParamsWithTimeout creates a new DownloadTrainedModelParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewDownloadTrainedModelParamsWithTimeout(timeout time.Duration) *DownloadTrainedModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &DownloadTrainedModelParams{
		Version: versionDefault,

		timeout: timeout,
	}
}

// NewDownloadTrainedModelParamsWithContext creates a new DownloadTrainedModelParams object
// with the default values initialized, and the ability to set a context for a request
func NewDownloadTrainedModelParamsWithContext(ctx context.Context) *DownloadTrainedModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &DownloadTrainedModelParams{
		Version: versionDefault,

		Context: ctx,
	}
}

// NewDownloadTrainedModelParamsWithHTTPClient creates a new DownloadTrainedModelParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewDownloadTrainedModelParamsWithHTTPClient(client *http.Client) *DownloadTrainedModelParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &DownloadTrainedModelParams{
		Version:    versionDefault,
		HTTPClient: client,
	}
}

/*DownloadTrainedModelParams contains all the parameters to send to the API endpoint
for the download trained model operation typically these are written to a http.Request
*/
type DownloadTrainedModelParams struct {

	/*ModelID
	  The id of the model.

	*/
	ModelID string
	/*Version
	  The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.

	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the download trained model params
func (o *DownloadTrainedModelParams) WithTimeout(timeout time.Duration) *DownloadTrainedModelParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the download trained model params
func (o *DownloadTrainedModelParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the download trained model params
func (o *DownloadTrainedModelParams) WithContext(ctx context.Context) *DownloadTrainedModelParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the download trained model params
func (o *DownloadTrainedModelParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the download trained model params
func (o *DownloadTrainedModelParams) WithHTTPClient(client *http.Client) *DownloadTrainedModelParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the download trained model params
func (o *DownloadTrainedModelParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithModelID adds the modelID to the download trained model params
func (o *DownloadTrainedModelParams) WithModelID(modelID string) *DownloadTrainedModelParams {
	o.SetModelID(modelID)
	return o
}

// SetModelID adds the modelId to the download trained model params
func (o *DownloadTrainedModelParams) SetModelID(modelID string) {
	o.ModelID = modelID
}

// WithVersion adds the version to the download trained model params
func (o *DownloadTrainedModelParams) WithVersion(version string) *DownloadTrainedModelParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the download trained model params
func (o *DownloadTrainedModelParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *DownloadTrainedModelParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param model_id
	if err := r.SetPathParam("model_id", o.ModelID); err != nil {
		return err
	}

	// query param version
	qrVersion := o.Version
	qVersion := qrVersion
	if qVersion != "" {
		if err := r.SetQueryParam("version", qVersion); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
