// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewDownloadModelDefinitionParams creates a new DownloadModelDefinitionParams object
// with the default values initialized.
func NewDownloadModelDefinitionParams() *DownloadModelDefinitionParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &DownloadModelDefinitionParams{
		Version: versionDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewDownloadModelDefinitionParamsWithTimeout creates a new DownloadModelDefinitionParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewDownloadModelDefinitionParamsWithTimeout(timeout time.Duration) *DownloadModelDefinitionParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &DownloadModelDefinitionParams{
		Version: versionDefault,

		timeout: timeout,
	}
}

// NewDownloadModelDefinitionParamsWithContext creates a new DownloadModelDefinitionParams object
// with the default values initialized, and the ability to set a context for a request
func NewDownloadModelDefinitionParamsWithContext(ctx context.Context) *DownloadModelDefinitionParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &DownloadModelDefinitionParams{
		Version: versionDefault,

		Context: ctx,
	}
}

// NewDownloadModelDefinitionParamsWithHTTPClient creates a new DownloadModelDefinitionParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewDownloadModelDefinitionParamsWithHTTPClient(client *http.Client) *DownloadModelDefinitionParams {
	var (
		versionDefault = string("2017-02-13")
	)
	return &DownloadModelDefinitionParams{
		Version:    versionDefault,
		HTTPClient: client,
	}
}

/*DownloadModelDefinitionParams contains all the parameters to send to the API endpoint
for the download model definition operation typically these are written to a http.Request
*/
type DownloadModelDefinitionParams struct {

	/*ModelID
	  The id of the model.

	*/
	ModelID string
	/*Version
	  The release date of the version of the API you want to use. Specify dates in YYYY-MM-DD format.

	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the download model definition params
func (o *DownloadModelDefinitionParams) WithTimeout(timeout time.Duration) *DownloadModelDefinitionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the download model definition params
func (o *DownloadModelDefinitionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the download model definition params
func (o *DownloadModelDefinitionParams) WithContext(ctx context.Context) *DownloadModelDefinitionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the download model definition params
func (o *DownloadModelDefinitionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the download model definition params
func (o *DownloadModelDefinitionParams) WithHTTPClient(client *http.Client) *DownloadModelDefinitionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the download model definition params
func (o *DownloadModelDefinitionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithModelID adds the modelID to the download model definition params
func (o *DownloadModelDefinitionParams) WithModelID(modelID string) *DownloadModelDefinitionParams {
	o.SetModelID(modelID)
	return o
}

// SetModelID adds the modelId to the download model definition params
func (o *DownloadModelDefinitionParams) SetModelID(modelID string) {
	o.ModelID = modelID
}

// WithVersion adds the version to the download model definition params
func (o *DownloadModelDefinitionParams) WithVersion(version string) *DownloadModelDefinitionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the download model definition params
func (o *DownloadModelDefinitionParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *DownloadModelDefinitionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param model_id
	if err := r.SetPathParam("model_id", o.ModelID); err != nil {
		return err
	}

	// query param version
	qrVersion := o.Version
	qVersion := qrVersion
	if qVersion != "" {
		if err := r.SetQueryParam("version", qVersion); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
