// Code generated by go-swagger; DO NOT EDIT.

package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewGetEventEndpointParams creates a new GetEventEndpointParams object
// with the default values initialized.
func NewGetEventEndpointParams() *GetEventEndpointParams {
	var ()
	return &GetEventEndpointParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewGetEventEndpointParamsWithTimeout creates a new GetEventEndpointParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewGetEventEndpointParamsWithTimeout(timeout time.Duration) *GetEventEndpointParams {
	var ()
	return &GetEventEndpointParams{

		timeout: timeout,
	}
}

// NewGetEventEndpointParamsWithContext creates a new GetEventEndpointParams object
// with the default values initialized, and the ability to set a context for a request
func NewGetEventEndpointParamsWithContext(ctx context.Context) *GetEventEndpointParams {
	var ()
	return &GetEventEndpointParams{

		Context: ctx,
	}
}

// NewGetEventEndpointParamsWithHTTPClient creates a new GetEventEndpointParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewGetEventEndpointParamsWithHTTPClient(client *http.Client) *GetEventEndpointParams {
	var ()
	return &GetEventEndpointParams{
		HTTPClient: client,
	}
}

/*GetEventEndpointParams contains all the parameters to send to the API endpoint
for the get event endpoint operation typically these are written to a http.Request
*/
type GetEventEndpointParams struct {

	/*EndpointID
	  The id of the endpoint.

	*/
	EndpointID string
	/*EventType
	  The type of event.

	*/
	EventType string
	/*ModelID
	  The id of the model.

	*/
	ModelID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the get event endpoint params
func (o *GetEventEndpointParams) WithTimeout(timeout time.Duration) *GetEventEndpointParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get event endpoint params
func (o *GetEventEndpointParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get event endpoint params
func (o *GetEventEndpointParams) WithContext(ctx context.Context) *GetEventEndpointParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get event endpoint params
func (o *GetEventEndpointParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get event endpoint params
func (o *GetEventEndpointParams) WithHTTPClient(client *http.Client) *GetEventEndpointParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get event endpoint params
func (o *GetEventEndpointParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEndpointID adds the endpointID to the get event endpoint params
func (o *GetEventEndpointParams) WithEndpointID(endpointID string) *GetEventEndpointParams {
	o.SetEndpointID(endpointID)
	return o
}

// SetEndpointID adds the endpointId to the get event endpoint params
func (o *GetEventEndpointParams) SetEndpointID(endpointID string) {
	o.EndpointID = endpointID
}

// WithEventType adds the eventType to the get event endpoint params
func (o *GetEventEndpointParams) WithEventType(eventType string) *GetEventEndpointParams {
	o.SetEventType(eventType)
	return o
}

// SetEventType adds the eventType to the get event endpoint params
func (o *GetEventEndpointParams) SetEventType(eventType string) {
	o.EventType = eventType
}

// WithModelID adds the modelID to the get event endpoint params
func (o *GetEventEndpointParams) WithModelID(modelID string) *GetEventEndpointParams {
	o.SetModelID(modelID)
	return o
}

// SetModelID adds the modelId to the get event endpoint params
func (o *GetEventEndpointParams) SetModelID(modelID string) {
	o.ModelID = modelID
}

// WriteToRequest writes these params to a swagger request
func (o *GetEventEndpointParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param endpoint_id
	if err := r.SetPathParam("endpoint_id", o.EndpointID); err != nil {
		return err
	}

	// path param event_type
	if err := r.SetPathParam("event_type", o.EventType); err != nil {
		return err
	}

	// path param model_id
	if err := r.SetPathParam("model_id", o.ModelID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
