// Code generated by go-swagger; DO NOT EDIT.

package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

// New creates a new events API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) *Client {
	return &Client{transport: transport, formats: formats}
}

/*
Client for events API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

/*
CreateEventEndpoint creates an event notification endpoint

Creates a specific event type's URL notification endpoint.
*/
func (a *Client) CreateEventEndpoint(params *CreateEventEndpointParams, authInfo runtime.ClientAuthInfoWriter, writer io.Writer) (*CreateEventEndpointOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateEventEndpointParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "createEventEndpoint",
		Method:             "POST",
		PathPattern:        "/v1/models/{model_id}/events/{event_type}/{endpoint_id}",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateEventEndpointReader{formats: a.formats, writer: writer},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CreateEventEndpointOK), nil

}

/*
DeleteEventEndpoint deletes an event notification endpoint

Deletes a specific event type's URL notification endpoint.
*/
func (a *Client) DeleteEventEndpoint(params *DeleteEventEndpointParams, authInfo runtime.ClientAuthInfoWriter, writer io.Writer) (*DeleteEventEndpointOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteEventEndpointParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "deleteEventEndpoint",
		Method:             "DELETE",
		PathPattern:        "/v1/models/{model_id}/events/{event_type}/{endpoint_id}",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteEventEndpointReader{formats: a.formats, writer: writer},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeleteEventEndpointOK), nil

}

/*
GetEventEndpoint gets endpoint description

Get a specific endpoint description.
*/
func (a *Client) GetEventEndpoint(params *GetEventEndpointParams, authInfo runtime.ClientAuthInfoWriter) (*GetEventEndpointOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetEventEndpointParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "getEventEndpoint",
		Method:             "GET",
		PathPattern:        "/v1/models/{model_id}/events/{event_type}/{endpoint_id}",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetEventEndpointReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetEventEndpointOK), nil

}

/*
GetEventTypeEndpoints gets all notification endpoints for this event type

Get all notification endpoint URLs for this event type.
*/
func (a *Client) GetEventTypeEndpoints(params *GetEventTypeEndpointsParams) (*GetEventTypeEndpointsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetEventTypeEndpointsParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "getEventTypeEndpoints",
		Method:             "GET",
		PathPattern:        "/v1/models/{model_id}/events/{event_type}",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetEventTypeEndpointsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetEventTypeEndpointsOK), nil

}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
