// Code generated by go-swagger; DO NOT EDIT.

package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewDeleteEventEndpointParams creates a new DeleteEventEndpointParams object
// with the default values initialized.
func NewDeleteEventEndpointParams() *DeleteEventEndpointParams {
	var ()
	return &DeleteEventEndpointParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteEventEndpointParamsWithTimeout creates a new DeleteEventEndpointParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewDeleteEventEndpointParamsWithTimeout(timeout time.Duration) *DeleteEventEndpointParams {
	var ()
	return &DeleteEventEndpointParams{

		timeout: timeout,
	}
}

// NewDeleteEventEndpointParamsWithContext creates a new DeleteEventEndpointParams object
// with the default values initialized, and the ability to set a context for a request
func NewDeleteEventEndpointParamsWithContext(ctx context.Context) *DeleteEventEndpointParams {
	var ()
	return &DeleteEventEndpointParams{

		Context: ctx,
	}
}

// NewDeleteEventEndpointParamsWithHTTPClient creates a new DeleteEventEndpointParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewDeleteEventEndpointParamsWithHTTPClient(client *http.Client) *DeleteEventEndpointParams {
	var ()
	return &DeleteEventEndpointParams{
		HTTPClient: client,
	}
}

/*DeleteEventEndpointParams contains all the parameters to send to the API endpoint
for the delete event endpoint operation typically these are written to a http.Request
*/
type DeleteEventEndpointParams struct {

	/*EndpointID
	  The id of the endpoint.

	*/
	EndpointID string
	/*EventType
	  The type of event.

	*/
	EventType string
	/*ModelID
	  The id of the model.

	*/
	ModelID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the delete event endpoint params
func (o *DeleteEventEndpointParams) WithTimeout(timeout time.Duration) *DeleteEventEndpointParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete event endpoint params
func (o *DeleteEventEndpointParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete event endpoint params
func (o *DeleteEventEndpointParams) WithContext(ctx context.Context) *DeleteEventEndpointParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete event endpoint params
func (o *DeleteEventEndpointParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete event endpoint params
func (o *DeleteEventEndpointParams) WithHTTPClient(client *http.Client) *DeleteEventEndpointParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete event endpoint params
func (o *DeleteEventEndpointParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEndpointID adds the endpointID to the delete event endpoint params
func (o *DeleteEventEndpointParams) WithEndpointID(endpointID string) *DeleteEventEndpointParams {
	o.SetEndpointID(endpointID)
	return o
}

// SetEndpointID adds the endpointId to the delete event endpoint params
func (o *DeleteEventEndpointParams) SetEndpointID(endpointID string) {
	o.EndpointID = endpointID
}

// WithEventType adds the eventType to the delete event endpoint params
func (o *DeleteEventEndpointParams) WithEventType(eventType string) *DeleteEventEndpointParams {
	o.SetEventType(eventType)
	return o
}

// SetEventType adds the eventType to the delete event endpoint params
func (o *DeleteEventEndpointParams) SetEventType(eventType string) {
	o.EventType = eventType
}

// WithModelID adds the modelID to the delete event endpoint params
func (o *DeleteEventEndpointParams) WithModelID(modelID string) *DeleteEventEndpointParams {
	o.SetModelID(modelID)
	return o
}

// SetModelID adds the modelId to the delete event endpoint params
func (o *DeleteEventEndpointParams) SetModelID(modelID string) {
	o.ModelID = modelID
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteEventEndpointParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param endpoint_id
	if err := r.SetPathParam("endpoint_id", o.EndpointID); err != nil {
		return err
	}

	// path param event_type
	if err := r.SetPathParam("event_type", o.EventType); err != nil {
		return err
	}

	// path param model_id
	if err := r.SetPathParam("model_id", o.ModelID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
