
# Fabric for Deep Learning related demos, talks, videos, publications and more.

This is a running list of FfDL demos to be used for conference talks and presentations. 

## Demos to show
1. [Train and Depploy your Fashion MNIST model with FfDL](fashion-mnist-training/README.md)
2. [Launch adversarial attack on Fashion MNIST model ](fashion-mnist-adversarial/README.md)

# FfDL Publications

## Slides
- [Fabric for Deep Learning](https://www.slideshare.net/AnimeshSingh/fabric-for-deep-learning-94941117)

## Videos
- [Introduction to Fabric for Deep Learning (FfDL)](https://www.youtube.com/watch?v=aKOqFL7VWhI)
- [Fabric for Deep Learning](https://www.youtube.com/watch?v=nQsYWmkfLP4)
- [FfDL at IEEE Computer Society Silicon Valley](https://youtu.be/wPKin0mN9LA?t=743)

## Articles
### IBM-Affiliated
- [FfDL IBM Code Open Project Page](https://developer.ibm.com/code/open/projects/fabric-for-deep-learning-ffdl/)
- [developerWorks: Fabric for Deep Learning](https://developer.ibm.com/code/2018/03/20/fabric-for-deep-learning/)
- [developerWorks: Democratize AI with Fabric for Deep Learning (FfDL)](https://developer.ibm.com/code/2018/03/20/democratize-ai-with-fabric-for-deep-learning/)
- [Introducing Fabric for Deep Learning (FfDL) on medium.com](https://medium.com/ibm-watson/introducing-fabric-for-deep-learning-ffdl-542522774775)
- [developerWorks: Serve it hot! Deploy your FfDL trained models using Seldon](https://developer.ibm.com/code/2018/06/12/serve-it-hot-deploy-your-ffdl-trained-models-using-seldon/)
- [Deep Learning Advances from IBM Research](https://www.ibm.com/blogs/research/2018/03/deep-learning-advances/)
### Independent
- [Q&A on IBM's Fabric for Deep Learning with Chief Architect of Watson (InfoQ)](https://www.infoq.com/news/2018/04/ffdl-ruchir-puri)
- [IBM wants to open up the deep learning expertise bottleneck (IT World)](https://www.itworld.com/article/3263454/cloud-computing/ibm-wants-to-open-up-the-deep-learning-expertise-bottleneck.html)
- [IBM launches deep learning as a service inside its Watson Studio (Tech Crunch)](https://techcrunch.com/2018/03/19/ibm-launches-deep-learning-as-a-service-inside-its-watson-studio/)

# FfDL Ecosystem and Related Projects
- [Adversarial Robustness Toolbox](https://developer.ibm.com/code/open/projects/adversarial-robustness-toolbox/), [Github](https://github.com/IBM/adversarial-robustness-toolbox)
- [IBM Code Model Asset Exchange (MAX)](https://developer.ibm.com/code/exchanges/models/)
- [H2O.ai Integration](https://github.com/IBM/FfDL/tree/master/community/FfDL-H2Oai)
- [Seldon Integration](https://github.com/IBM/FfDL/tree/master/community/FfDL-Seldon)

## Papers
- [IBM Deep Learning Service](https://arxiv.org/abs/1709.05871)
- [Scalable Multi-Framework Multi-Tenant Lifecycle Management of Deep Learning Training Jobs](http://learningsys.org/nips17/assets/papers/paper_29.pdf)
- [Dependability in a Multi-tenant Multi-framework Deep Learning as-a-Service Platform](https://arxiv.org/abs/1805.06801)

# IBM Products
## Watson Machine Learning and Watson Studio
- [IBM Watson Machine Learning](https://www.ibm.com/cloud/machine-learning)
- [IBM Watson Studio](https://www.ibm.com/cloud/watson-studio)
- [IBM Watson Studio Workshop](https://github.com/PubChimps/DLaaSWorkshop)
- [IBM Watson Studio: Deep Learning as a Service](https://www.ibm.com/cloud/deep-learning)
- [IBM Cloud Container Service](https://www.ibm.com/cloud/container-service)
- [IBM Cloud Object Storage](https://www.ibm.com/cloud/object-storage)
