# Zenith Sans

![/documentation/img/zenith.png](/documentation/img/zenithsans.png)

![/documentation/img/zenith.png](/documentation/img/diffs.png)

Zenith Sans is a font family largely based on
[Plus Jakarta Sans](https://github.com/tokotype/PlusJakartaSans).

## Modifications

- "a" has been modified to have a straight terminal rather than curving up,
- "i", "j", ".", ";" has been modified to use dots rather than squares,
- "J" has been remapped to ss03 variant (use ss05 to revert),
- "G" has been remapped to the ss01 variant (use ss06 to revert),
- The terminal of "Q" has been shifted towards right,
- "l" now has a tail (use ss07 to revert),
- Serif-like I has been split off ss01 and can now be toggled independently (use
  ss08),
- "1" has been slightly shifted downward.

The original description shall follow below.

---

# Plus Jakarta Sans

![/documentation/img/plusjakartasans.png](/documentation/img/plusjakartasans.png)

![/documentation/img/plusjakartasans-alt.gif](/documentation/img/plusjakartasans-alt.gif)

## About Plus Jakarta Sans Project

Plus Jakarta Sans is a font family that takes geometric sans serif styles,
designed by Gumpita Rahayu from Tokotype, the fonts were originally commissioned
by 6616 Studio for Jakarta Provincial Government program's +Jakarta City of
Collaboration identity in 2020.

Taking part of inspiration such as Neuzit Grotesk, Futura, and 1930s grotesque
sans serif with almost monoline contrast and pointy curves, the fonts consist
modern and clean cut forms, the x-height dimension slight taller to provide
clear spaces between caps and x-height, this also equipped with open counter and
balanced spaces to preserve the legibility at a range of sizes.

The beauty of diversity captured in typography. Like the city itself, the unique
points of this fonts is that in some glyphs has its own diversity and
characteristic of various explorations of forms that enrich the expressions and
stories that coexist. The charms of Plus Jakarta Sans fonts appear when one
looks closer, manifesting in a beauty that emerges once seen as a whole. Each
alternate on the family contains several alternates characters, divided into
three stylistic alternates which Lancip (Sharp), Lurus (Straight), and Lingkar
(Swirl).

As part of Plus Jakarta as a city of collaboration, fonts are made available for
public and use it under the SIL Open Font License.

To contribute to the project, Please see
<a href="https://github.com/tokotype/PlusJakartaSans">github.com/tokotype/PlusJakartaSans</a>
or visit http://www.tokotype.com

## Build

Build the fonts with `gftools builder sources/config.yaml` from the repository’s
root folder

## Test

Test the fonts with `fontbakery check-googlefonts fonts/variable/*.ttf` and
`fontbakery check-googlefonts fonts/ttf/*.ttf` from the repository’s root folder

## FONTLOG for Plus Jakarta Sans fonts

### 6 May 2023 (Gumpita Rahayu) Plus Jakarta Sans v2.7.1

- Fixed kerning missing in static ttf
- Update font repository to
  <a href="https://github.com/googlefonts/googlefonts-project-template">googlefonts-project-template</a>

### 19 May 2023 (Gumpita Rahayu) Plus Jakarta Sans v2.700

- Fixed shapeshifting glyphs on 'ohorn' and 'registered symbol'
- Removed tail on 'æ'
- Adjusted vertical metrics to compensate line-height issues
- Add two strokes on '₦' (Naira symbol)

### 12 November 2021 (Gumpita Rahayu) Plus Jakarta Sans v2.600

- Adding SemiBold instance on static files
- Fixed missing kerning values
- Increasing quote character weight
- Redesigned diacritics glyphs
- Adding Tabular Figures (.tf)

### 21 December 2020 (Gumpita Rahayu) Plus Jakarta Sans v2.500

- Extending ascender character lowercase
- Fixed duplicated alternates

### **4 December 2020 (Gumpita Rahayu) Plus Jakarta Sans v2.400**

- Adding ExtraLight & ExtraLight Italic Master
- Reworking weights and instance
- Adding support for multiple languages (Incl. Vietnamese)
- Encoding based on GF Latin Pro & GF Latin Plus
- Variable fonts support (wght)
- Removed Plus Jakarta Sans Text Version (In addition, Lightest weight added)
- Adding several opentype features stylistic sets glyphs

21 February 2020 (Gumpita Rahayu) Plus Jakarta Sans v1.000

- Open sourced.
- Fine tuning to almost all glyphs.
- First public released.

![/documentation/img/plusjakartasans.gif](/documentation/img/plusjakartasans.gif)

### [↓ Download the latest release ↓](https://github.com/tokotype/plusjakartasans/releases/latest)

After downloading the zip from above:

- Double-click the downloaded zip file to unpack or open it.
- Mac OSX: Use FontBook Software (Default App on Mac). Select the fonts files
  you want to install and drag the fonts into your library or you can find
  Macintosh HD/Library/Fonts and copy the font files to the directory.
- Windows: Select all fonts you want to install and pop-up of the fonts file
  will show, click install and done. Or Go to Start > Control Panel > Fonts,
  then locate fonts file and click install.

## Authors

[Gumpita Rahayu - Tokotype](https://www.tokotype.com)

## Contribution

If you want to contribute to develop improvements of this font family, you can
fork this project and create an issue or email us at mail@tokotype.com

## License

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is copied below, and is also available with a FAQ at:
http://scripts.sil.org/OFL
