module.exports = {
	root: true,
	extends: '@theguild',
	rules: {
		'@typescript-eslint/triple-slash-reference': 'off',
		'@typescript-eslint/no-empty-interface': 'off',
		'@typescript-eslint/no-namespace': 'off',
		'@typescript-eslint/no-unused-vars': 'off',
		'@typescript-eslint/ban-ts-comment': 'off',
		'@typescript-eslint/no-non-null-assertion': 'off',
		'@typescript-eslint/no-explicit-any': 'off',
		'@typescript-eslint/no-empty-function': 'off',
		'@typescript-eslint/ban-types': 'off',
		'@typescript-eslint/no-inferrable-types': 'off',
		'@typescript-eslint/prefer-as-const': 'off',
		'@typescript-eslint/no-var-requires': 'off',
		'@typescript-eslint/consistent-type-imports': [
			'error',
			{
				prefer: 'type-imports',
				fixStyle: 'separate-type-imports',
			},
		],
		'unicorn/no-lonely-if': 'off',
		'unicorn/filename-case': 'off',
		'unicorn/no-instanceof-array': 'off',
		'unicorn/prefer-includes': 'off',
		'import/no-default-export': 'off',
		'sonarjs/no-gratuitous-expressions': 'off',
		'no-lonely-if': 'off',
		'no-console': 'off',
		'prefer-arrow-callback': 'off',
		'prefer-const': 'off',
		'no-else-return': 'off',
		'no-empty': 'off',
		'no-var': 'off',
		'no-undef': 'off',
		'object-shorthand': 'off',
		'unused-imports/no-unused-imports': 'error',
		// 'no-console': ['error', { allow: ['info', 'warn', 'error', 'time', 'timeEnd'] }],
		'import/extensions': 'off',
		'unicorn/no-negated-condition': 'off',
		'logical-assignment-operators': 'off',
		'no-implicit-coercion': 'off',
		'@typescript-eslint/prefer-optional-chain': 'off',
		'no-restricted-syntax': 'off',
		'unicorn/numeric-separators-style': 'off',
		'unicorn/no-useless-spread': 'off',
	},
	ignorePatterns: ['e2e', 'example', 'site'],
	parserOptions: {
		sourceType: 'module',
		ecmaVersion: 2020,
	},
	plugins: ['unused-imports', 'react', 'react-hooks'],
}
