#include "bonsai/internal.hpp"

#define _256KB 0x40000
#define _128KB 0x20000
#define _64KB 0x10000
#define _32KB 0x8000
#define _16KB 0x4000

const std::array<part_t, PART_TABLE_SIZE> part_table = {{

    /* SAMD20 */
    {"SAMD20J18C", _256KB, 0x10001, 0x00},
    {"SAMD20J18A", _256KB, 0x10001, 0x00},
    {"SAMD20J17A", _128KB, 0x10001, 0x01},
    {"SAMD20J16A", _64KB, 0x10001, 0x02},
    {"SAMD20J15A", _32KB, 0x10001, 0x03},
    {"SAMD20J14A", _16KB, 0x10001, 0x04},
    {"SAMD20G18A", _256KB, 0x10001, 0x05},
    {"SAMD20G17A", _128KB, 0x10001, 0x06},
    {"SAMD20G16A", _64KB, 0x10001, 0x07},
    {"SAMD20G15A", _32KB, 0x10001, 0x08},
    {"SAMD20G14A", _16KB, 0x10001, 0x09},
    {"SAMD20E18A", _256KB, 0x10001, 0x0A},
    {"SAMD20E17A", _128KB, 0x10001, 0x0B},
    {"SAMD20E16A", _64KB, 0x10001, 0x0C},
    {"SAMD20E15A", _32KB, 0x10001, 0x0D},
    {"SAMD20E14A", _16KB, 0x10001, 0x0E},
    {"SAMD20G18U", _256KB, 0x10001, 0x10},
    {"SAMD20G17U", _128KB, 0x10001, 0x11},

    /* SAMD21 */
    {"SAMD21J18A", _256KB, 0x10010, 0x00},
    {"SAMD21J17A", _128KB, 0x10010, 0x01},
    {"SAMD21J16A", _64KB, 0x10010, 0x02},
    {"SAMD21J15A", _32KB, 0x10010, 0x03},
    {"SAMD21G18A", _256KB, 0x10010, 0x05},
    {"SAMD21G17A", _128KB, 0x10010, 0x06},
    {"SAMD21G16A", _64KB, 0x10010, 0x07},
    {"SAMD21G15A", _32KB, 0x10010, 0x08},
    {"SAMD21E18A", _256KB, 0x10010, 0x0A},
    {"SAMD21E17A", _128KB, 0x10010, 0x0B},
    {"SAMD21E16A", _64KB, 0x10010, 0x0C},
    {"SAMD21E15A", _32KB, 0x10010, 0x0D},
    {"SAMD21G18A", _256KB, 0x10010, 0x0F},
    {"SAMD21G17A", _128KB, 0x10010, 0x10},
    {"SAMD21J16B", _64KB, 0x10011, 0x20},
    {"SAMD21J15B", _32KB, 0x10011, 0x21},
    {"SAMD21G16B", _64KB, 0x10011, 0x23},
    {"SAMD21G15B", _32KB, 0x10011, 0x24},
    {"SAMD21E16B", _64KB, 0x10011, 0x26},
    {"SAMD21E15B", _32KB, 0x10011, 0x27},

    /* SAMC20 */
    {"SAMC20E15A", _32KB, 0x11000, 0x0D},
    {"SAMC20E16A", _64KB, 0x11000, 0x0C},
    {"SAMC20E17A", _128KB, 0x11000, 0x0B},
    {"SAMC20E18A", _256KB, 0x11000, 0x0A},
    {"SAMC20G15A", _32KB, 0x11000, 0x08},
    {"SAMC20G16A", _64KB, 0x11000, 0x07},
    {"SAMC20G17A", _128KB, 0x11000, 0x06},
    {"SAMC20G18A", _256KB, 0x11000, 0x05},
    {"SAMC20J15A", _32KB, 0x11000, 0x03},
    {"SAMC20J16A", _64KB, 0x11000, 0x02},
    {"SAMC20J17A", _128KB, 0x11000, 0x01},
    {"SAMC20J17AU", _128KB, 0x11000, 0x10},
    {"SAMC20J18A", _256KB, 0x11000, 0x00},
    {"SAMC20J18AU", _256KB, 0x11000, 0x0F},
    {"SAMC20N17A", _128KB, 0x11001, 0x21},
    {"SAMC20N18A", _256KB, 0x11001, 0x20},

    /* SAMC21 */
    {"SAMC21E15A", _32KB, 0x11010, 0x0D},
    {"SAMC21E16A", _64KB, 0x11010, 0x0C},
    {"SAMC21E17A", _128KB, 0x11010, 0x0B},
    {"SAMC21E18A", _256KB, 0x11010, 0x0A},
    {"SAMC21G15A", _32KB, 0x11010, 0x08},
    {"SAMC21G16A", _64KB, 0x11010, 0x07},
    {"SAMC21G17A", _128KB, 0x11010, 0x06},
    {"SAMC21G18A", _256KB, 0x11010, 0x05},
    {"SAMC21J15A", _32KB, 0x11010, 0x03},
    {"SAMC21J16A", _64KB, 0x11010, 0x02},
    {"SAMC21J17A", _128KB, 0x11010, 0x01},
    {"SAMC21J17AU", _128KB, 0x11010, 0x10},
    {"SAMC21J18A", _256KB, 0x11010, 0x00},
    {"SAMC21J18AU", _256KB, 0x11010, 0x0F},
    {"SAMC21N17A", _128KB, 0x11011, 0x21},
    {"SAMC21N18A", _256KB, 0x11011, 0x20},

    // Sentinel
    {"END", 0xFF, 0xFF, 0xFF}}};
