# Многопользовательский тайм-трекер

Задача: разработать Backend сервиса _Многопользовательский тайм-трекер_, доступ к которому можно получить по REST.

Тайм-трекер (англ. Time-tracker или Time-tracking software) - это категория компьютерного программного обеспечения, которое позволяет сотрудникам, работающим за компьютерами, записывать время, потраченное на выполнение задач или проектов, а работодателям их контролировать.

## Типы запросов

1. создать пользователя трекинга;
2. изменить данные пользователя;
3. начать отсчет времени по задаче Х; 
4. прекратить отсчет времени по задаче Х; 
5. показать все трудозатраты пользователя Y за период N..M в виде связного списка Задача - Сумма затраченного времени в виде (чч:мм) с сортировкой от большего к меньшему (для ответа на вопрос, _На какие задачи я потратил больше времени_);
6. показать все временные интервалы занятые работой за период N..M в виде связного списка Временной интервал (число чч:мм) - Задача (для ответа на вопросы, _На что ушла моя неделя_ или _Где за прошедшую неделю были ‘дыры’, когда я ничего не делал_);
7. показать сумму трудозатрат по всем задачам пользователя Y за период N..M (как будто для отображения на панели _Отработано на этой неделе_);
8. очистить данные трекинга пользователя Z;
9. удалить всю информацию о пользователе Z.

## Дополнительные условия

1. Если пользователь не завершил отсчет своего времени, то он должен завершаться автоматически в 23:59 текущего дня.
2. Данные должны храниться в системе не более периода, указанного в конфигурации сервиса. Очистка данных производится задачей по расписанию, работающей в составе java приложения.

## Детали реализации

1. Только backend! RESTful, HTTP, JSON.
2. Разбивать на микросервисы не нужно.
3. Все SQL таблицы существуют в одной схеме данных.
4. Запуск на Ubuntu/Debian или Docker compose.
5. Security не требуется. Доступ к API может быть открытым без аутентификации и авторизации.
6. В реальной системе имя пользователя, конечно, передавалось бы в заголовках, token’ах или где-то еще. В данной задаче имя пользователя передается в запросе. 
7. Данные следует хранить в базе данных MySQL или PostgreSQL.
8. Система должна журналировать происходящие события и ошибки с помощью одного из общепринятых логгеров logback/log4j.
9. Проект должен содержать список всех REST команд которые можно выполнить с кратким описанием входных и выходных данных. Спецификация OpenAPI приветствуется.
10. Язык для документации русский или английский на усмотрение разработчика. 
11. Проект должен содержать README файл с описанием, из которого должно быть понятна процедура сборки, места хранения персистентных данных и журналов работы приложения.

## Исходный код

1. Проект необходимо вести в публичном GitHub.
2. По истории commit'ов должна быть видна самостоятельная разработка кандидата. Один commit с полным набором исходников не приветствуется.
3. Язык программирования Java 8+ или Kotlin. Можно использовать Spring, другие фреймворки и библиотеки на усмотрение автора.
4. В проекте должны быть написаны тесты, демонстрирующие все типы запросов и сценарии.

## Сроки

Мы никуда не спешим. После ознакомления с ТЗ вы сами определяете срок, за который сможете его выполнить. Обычно это 2-4 недели. Можно быстрее, если это не навредит качеству. Можно дольше, но все равно срок надо обозначить заранее.

## При проверке оценивается

1. Работоспособность решения
2. Удобство и надежность API
3. Полноты README и другой документации 
4. Журнал работы 
5. Код решения 
6. Обработка ошибок 
7. Javadoc, комментарии 
8. Тесты

## Контакты автора

[MikhaelGaydamaka](https://t.me/MikhaelGaydamaka) можно задавать вопросы.