Необходимо разработать бекенд (серверную часть) веб-приложения, демонстрирующего
расписание рейсовых автобусов.

Автобусы двигаются по маршрутам от конечной до конечной в прямом и обратном направлении. В
разных направлениях может быть разный набор остановочных пунктов.

Фронтенд приложения получает данные с сервера через REST API, необходимо реализовать
следующие методы этого API:

1. /api/find-bus

Описание:
Возвращает автобусы, маршрут которых включает отрезок от одной остановки к другой, с тремя
ближайшими к текущему времени вариантами времени прибытия на исходную остановку.

Параметры запроса:
* from: id исходной остановки.
* to: id конечной остановки.

Пример ответа:
```
{
    "from": "ул. Пушкина",
    "to": "ул. Ленина",
    "buses": [
        {
            "route": "Автобус No11 в сторону ост. Попова", // указывается конечная остановка маршрута
            "next_arrivals": ["08:15", "08:40", "09:15"]
        },
        {
            "route": "Автобус No21 в сторону ост.Ленина",
            "next_arrivals": ["08:30", "09:04", "09:30"]
        }
    ]
}
```

2. Методы (или метод) предоставляющие механизм редактирования маршрутов, т.е. набора
остановок на пути следования автобуса (без указания времени). Входный параметры и
формат ответа продумать самостоятельно.

Требования к реализации:
1. Язык программирования: PHP (версия 7+).
2. Использование фреймворка: допускается использование фреймворка на выбор: Laravel,
Symfony, Yii2 или чистый PHP.
3. База данных: PostgreSQL.
4. Использование подхода ООП

Оцениваться будут архитектура решения, качество кода, соответствие REST принципам и
тестируемость.

Будет плюсом если проект будет запускаться в docker.

Результат представить в виде ссылки на публичный репозиторий на bitbucket.org. Он должен
включать в себя php файлы проекта, sql дамп базы, схему структуры базы данных в виде
изображения и инструкцию по запуску проекта.