**Описание:** У вас есть 60 минут для прохождения теста из 5 заданий.
Пользоваться разрешается только ручкой/карандашом и бумагой. Целью
является решение как можно большего количества задач.

**Рекомендация:** Вначале прочтите внимательно все задачи и начните
решать наиболее для вас простые.

**Task 1. **

Вы подбрасываете кубик (2N граней), после чего у вас есть две
возможности:

1.  Взять себе сумму \$, равную выпавшему на кубике числу (выпало k –
    получаете k\$)

2.  Отклонить результат первого броска и подбросить кубик второй раз.
    После чего уже взять себе столько

> \$, сколько выпало во второй раз (второй бросок отклонять уже нельзя)

Какую стратегию нужно выбрать, чтобы максимизировать ожидаемую прибыль
(при каких значениях первого броска нужно перебрасывать?)

Чему равна ожидаемая прибыль при этой стратегии (математическое
ожидание)?

**Task 2. **

Перед вами шахматная доска размером NxN. В верхнем левом углу находится
шашка. Шашка может двигаться только вправо или вниз (вверх или влево
двигаться не может). Сколькими различными путями шашка может прийти в
нижний правый угол?

**Task 3. **

Одно очень-очень далёкое кафе было ограблено бандитом. После ограбления
он сел в машину и уехал по бесконечной прямой дороге, у которой стоит
кафе, в одну из двух сторон.

Спустя некоторое время по **другой дороге** в кафе прибыл полицейский и
выехал в погоню за бандитом на

машине, скорость которой в два раза выше скорости машины бандита.

Докажите, что полицейский **может** **поймать** бандита за **конечное**
время.

**Task 4. (будем обсуждать устно, можете сделать предварительные
заметки)**

Представьте, что вы аналитик в крупном интернет-магазине. За последний
месяц факт продаж оказался на 15% ниже прогноза.

![](media/1.png)

1.  Как определить, что это отклонение является аномальным и нужно
    искать его причину?

2.  Как выяснить, в чем причина отклонения? Какие гипотезы вы бы стали
    проверять, как выбрали бы

среди множества гипотез наиболее перспективные, какими методами их
проверяли?

**Task 5. **

В каждом вопросе **есть** только **один** правильный ответ, при решении
считать, что все запросы синтаксически корректны.

1)  В таблице revenue три колонки:

event\_date - дата

user\_id - уникальный id пользователя

revenue - выручка, полученная от этого пользователя в этот день

Какую из колонок нужно добавить в этот запрос,
```
select event_date, user_id, revenue, <?>
from revenue
order by event_date desc, user_id
```
чтобы в ней на каждый день содержалась доля выручки пользователя в
этот день от выручки того же пользователя в предыдущий день?

Для каждой комбинации user\_id, event\_date есть только одно значение
revenue, в данных нет Null-ов.
```
a.  revenue/lag(revenue) over(order by user\_id, event\_date),
b.  revenue/lag(revenue) over(partition by user\_id order by
    event\_date),
c.  revenue/lag(revenue) over(order by event\_date),
d.  revenue/lag(revenue) over(partition by user\_id, event\_date order
    by user\_id, event\_date)
```

2) ```
select distinct a, b, c, sum(d) as revenue
from table
group by a, b, c
```

Сколько строк вернет данный запрос, если такой же запрос без «distinct» вернет 600 строк, а в столбце
revenue содержится 117 уникальных значений?
a) 483
b) 600
c) 117
d) 561

3) Какой запрос вернет самое большое число?
Для справки: ( **A** right join **B)** эквивалентно ( **B** left join **A)**.

```
a) select count(distinct first.counter_column)
from first
left join second
on first.join_key = second.join_key
where second.filter_column >= 5
b) select count(distinct first.counter_column)
from first
left join second
on first.join_key = second.join_key
and second.filter_column >= 5
c) select count(distinct first.counter_column)
from first
right join second
on first.join_key = second.join_key
where second.filter_column >= 5
d) select count(distinct first.counter_column)
from first
right join second
on first.join_key = second.join_key
and second.filter_column >= 5
```