# Список тестовых заданий для прокачки

[![Hexlet Ltd. logo](https://raw.githubusercontent.com/Hexlet/assets/master/images/hexlet_logo128.png)](https://ru.hexlet.io/?utm_source=github&utm_medium=link&utm_campaign=ru-test-assignments)

Данный репозиторий создан и поддерживается командой и сообществом образовательного проекта *Хекслет*. [Подробнее о проекте](https://ru.hexlet.io/?utm_source=github&utm_medium=link&utm_campaign=ru-test-assignments).

Посмотрите самых активных участников проекта на [hexlet-friends](https://friends.hexlet.io/).

---

Выполненные тестовые задания прикрепляйте как портфолио к своему резюме на [Hexlet CV](https://cv.hexlet.io/).

## Как помочь?

Мы принимаем Pull Request'ы!

## Правила

- Располагайте компании в алфавитном порядке

## Задания

<details>
 <summary>Аналитик</summary>

* [Amazon](https://www.amazon.com/)
  * [Тестовое задание для аналитика *(Python, SQL)*](./analytics/Amazon/README.md)

* [Aviasales](https://aviasales.ru)
  * [Тестовое задание для продуктового аналитика](./analytics/Aviasales%20Продуктовый%20аналитик/README.md)

* [avito.tech](https://github.com/avito-tech)
  * [Тестовое задания для аналитика](./analytics/Avito/)

* [Awem](https://awem.com/)
  * [Тестовое задание для продуктового аналитика](./analytics/AWEM%20продуктовый%20аналитик/README.md)

* [Babbel](https://babbel.com/)
  * [Тестовое задание для продуктового аналитика](./analytics/Babbel%20Продуктовый%20Аналитик/README.md)

* [BOLT](https://bolt.eu/)
  * [Тестовое задание для аналитика данных](./analytics/BOLT%20аналитик%20данных/README.md)

* [Chibbis](https://chibbis.ru/)
  * [Тестовое задание для продуктового аналитика](./analytics/Chibbis%20Продуктовый%20аналитик/README.md)

* [Cian](https://cian.ru/)
  * [Тестовое задание для аналитика *(SQL)*](./analytics/Cian%20Аналитик/README.md)

* [CloudReports](https://cloudreports.ru/)
  * [Тестовое задание для аналитика](./analytics/CloudReports%20Аналитик%20данных/README.md)

* [Crazy Panda](https://crazypanda.ru/)
  * [Тестовое задание для аналитика](./analytics/Crazy%20Panda%20Аналитик%20Данных/README.md)

* [Delivery](https://market-delivery.yandex.ru/moscow?shippingType=delivery)
  * [Тестовое задание для аналитика данных](./analytics/Delivery%20Аналитик%20Данных/)

* [Dodo Brands](https://dodobrands.io/)
  * [Тестовое задание для аналитика](./analytics/Dodo%20Brands%20Data%20Analyst/README.md)

* [Driveback](https://vc.ru/s/driveback/details/all)
  * [Тестовое задание для аналитика](./analytics/Driveback%20Аналитик/README.md)

* [Elfsight](https://elfsight.com/)
  * [Тестовое задание для продуктового аналитика](./analytics/Elfsight%20Product%20Analyst/README.md)

* [FriendsOnly](https://friendsonly.ru/)
  * [Тестовое задание для продуктового аналитика *(SQL, PYTHON, R)*](./analytics/FriendsOnly%20Продуктовый%20Аналитик/README.md)

 * [Genius Sport](https://geniussports.com/)
  * [Тестовое задание для аналитика, Reporting Analyst](./analytics/Genius%20Sport%20Reporting%20Analyst/)

* [Happy Games Studio](https://www.hgstudio.ru/)
  * [Тестовое задание для аналитика](./analytics/Happy%20Games%20Studio%20Аналитик%20Данных/README.md)

* [Home Credit Bank](https://home.bank/)
  * [Тестовое задание для Руководителя отдела аналитики *(PostgreSQL, Python)*](./analytics/Home%20Credit%20Bank%20Руководитель%20Отдела%20Аналитики%20/README.md)

* [ivi](https://www.ivi.ru/)
  * [Тестовое задание для аналитика](./analytics/ivi/README.md)

* [Kaspi.kz](https://kaspi.kz/)
  * [Тестовое задание для продуктового аналитика *(SQL)*](./analytics/Kaspi.kz%20продуктовый%20аналитик/Weekend%20Offer%20для%20продуктовых%20аналитиков%20–%20тестово%20b99d51311f1b4a77a3e19f797d680ebb.html)

* [Lesta](https://lesta.ru/ru)
  * [Тестовое задание для аналитика данных *(SQL)*](./analytics/LESTA%20Аналитик%20Данных/README.md)

* [MARS](https://rus.mars.com/)
  * [Тестовое задание для аналитика данных](./analytics/Марс%20Аналитик%20данных/)

* [Mediascope](https://mediascope.net/)
  * [Тестовое задание для аналитика](./analytics/MediaScope%20Аналитик%20Данных/README.md)

* [MediaSoft](https://mediasoft.team/)
  * [Тестовое задание. Системный / Бизнес-аналитик *(any)*](./analytics/MediaSoft/README.md)

* Nortas Analitics
  * [Тестовое задание для аналитика](./analytics/Nortas%20Analitics%20Аналитик%20данных/README.md)

* [Ozon](https://www.ozon.ru/)
  * [Тестовое задание для аналитика *(SQL)*](./analytics/Ozon/)

* [Realweb Camp](https://realweb-camp.ru/)
  * [Тестовое задание для аналитика](./analytics/Realweb%20Camp%20Analytics/README.md)

* [Skypro](https://sky.pro/)
  * [Тестовое задание для аналитика](./analytics/Skypro%20Data%20Analyst/README.md)

* [Teikametrics](https://www.teikametrics.com/)
  * [Тестовое задание для аналитика](./analytics/Teikametrics%20Analyst/README.md)

* [Tinkoff](https://www.tinkoff.ru/)
   * [Тестовое задание аналитика Tinkoff *(Python)*](https://colab.research.google.com/drive/1sbq3bW7FSsqzPBsJu6lmX1cTaC_Oan6S?usp=sharing)
   * [Тестовое задание аналитика Tinkoff *(SQL)*](./analytics/Тинькофф%20Аналитик%20SQL/Тинькофф%20Аналитик%20SQL.jpeg)
   * [Тестовое задание аналитика Tinkoff](./analytics/Tinkoff%20Product%20Analyst/README.md)

* [Vizor](https://vizor-games.com/)
  * [Тестовое задание для аналитика](./analytics/Vizor%20Data%20Analytics/README.md)

* [WhoIsBlogger](https://whoisblogger.com/)
  * [Тестовое задание для junior аналитика данных *(SQL)*](./analytics/WhoIsBlogger%20(WIB),%20junior%20data%20analyst/README.md)

* [Wolt](https://wolt.com/en)
  * [Тестовое задание для аналитика данных](./analytics/Wolt%20Аналитик%20Данных/README.md)

* [X5](https://www.x5.ru/en/)
  * [Тестовое задание, стажировка для аналитика данных *(Python)*](./analytics/X5%20Аналитик%20Данных%20(стажировка)/README.md)

* [Альфа-Банк](https://alfabank.ru/)
  * [Тестовое задание для продуктового аналитика *(SQL)*](./analytics/Альфабанк%20продуктовый%20аналитик/README.md)
  * [Тестовое задание для аналитика данных *(SQL)*](./analytics/Альфа%20Банк%20Продуктовый%20Аналитик/README.md)

* [Банк Открытие](https://www.open.ru/)
  * [Тестовое задание для продуктового аналитика *(SQL)*](./analytics/Банк%20Открытие%20Продуктовый%20Аналитик/README.md)

* [ВК Одноклассники](https://vk.com/)
  * [Тестовое задание для продуктового аналитика *(Python, SQL)*](./analytics/ВК%20Одноклассники%20Продуктовая%20аналитика%20/README.md)
  * [Тестовое задание для аналитика данных *(Python)*](./analytics/ВК%20Аналитик%20данных/README.md)

* [ВТБ](https://www.vtb.ru/)
  * [Тестовое задание для аналитика данных](./analytics/ВТБ%20Аналитик%20данных/README.md)

* [Газпром](https://www.gazprom.ru/)
  * [Тестовое задание для аналитика](./analytics/Газпром/README.md)

* [Делимобиль](https://delimobil.ru/)
  * [Тестовое задание для аналитика](./analytics/Делимобиль/README.md)

* [Красный Яр](https://www.krasyar.ru/)
  * [Тестовое задание для аналитика *(Excel)*](./analytics/Красный%20Яр%20Аналитик%20Данных/README.md)

* [Магнит](https://magnit.ru/)
  * [Тестовое задание для аналитика](./analytics/Магнит/README.md)

* [МТС](https://www.mts.ru/)
  * [Тестовое задание для продуктового аналитика *(SQL, Python)*](./analytics/МТС%20Продуктовый%20аналитик/README.md)

* [Ренессанс Банк](https://rencredit.ru/)
  * [Тестовое задание для аналитика](./analytics/Банк%20ренессанс%20кредит%20Аналитик/README.md)

* [Росмэн](https://rosman.ru/)
  * [Тестовое задание для аналитика *(Excel, SQL)*](./analytics/Росмэн/)

* [Роснефть](https://www.rosneft.ru/)
  * [Тестовое задание для HR аналитика](./analytics/Роснефть%20HR%20аналитик/)

* [Самокат](https://samokat.ru/)
  * [Тестовое задание для аналитика](./analytics/Самокат%20Аналитик%20Данных/README.md)
  * [Тестовое задание для аналитика](./analytics/Самокат%20Аналитик/)

* [Северсталь](https://severstal.com/rus/)
  * [Тестовое задание для аналитика](./analytics/Северсталь/)

* [СКБ Контур](https://kontur.ru/)
  * [Тестовое задание для продуктового аналитика](./analytics/Контур%20Продуктовый%20аналитик/README.md)

* [Совкомбанк Страхование](https://sovcomins.ru/)
  * [Тестовое задание для аналитика *(Python)*](./analytics/Совкомбанк%20Страхование/README.md)

* [Спортмастер](https://www.sportmaster.ru/)
  * [Тестовое задание для аналитика *(SQL)*](./analytics/Спортмастер/)

* [Сравни.ру](https://www.sravni.ru/)
  * [Тестовое задание для Продуктового Аналитика](./analytics/Сравниру%20Product%20Analyst/README.md)

* [Табакон](https://tabakon.su/)
  * [Тестовое для аналитика данных](https://drive.google.com/drive/folders/1FDHErQLGvPoJKECmRqijpwuVifnTaw8x)

* [Учи.ру](https://uchi.ru/)
  * [Тестовое задание для Продуктового Аналитика](./analytics/Учи%20ру%20Продуктовый%20аналитк/README.md)

* [Сборник тестовых заданий для аналитиков](https://pavelbukhtik.notion.site/Product-Analyst-Data-Analyst-a5f7bea5a0064960bbdb7a3ee1e46e97)

* [Тестовое задание для FE стажера в Авито Pro (Команда ARPU) *(JS)*](https://github.com/avito-tech/pro-fe-trainee-task)

</details>

<details>
 <summary>Android</summary>

* [Android разработчик *(Kotlin, Single Activity, Retrofit, Jetpack Compose / XML, Kotlinx Serialization / Gson, RxJava / Coroutines)*](https://github.com/appKODE/trainee-test-android)

* [avito.tech](https://github.com/avito-tech)
  * [Тестовое задание для стажёра Android (archived) *(Kotlin/Java)*](https://github.com/avito-tech/android-trainee-task)
  * [Тестовое задание для стажёра Android *(Kotlin)*](https://github.com/avito-tech/bx-android-trainee-assigment)
  * [Приложение прогноза погоды (Андроид) *(Kotlin)*](https://github.com/avito-tech/android-trainee-task-2021)

* [Android Developer *(Kotlin, Java, C++)*](https://github.com/fs/test-tasks/tree/master/android)

</details>

<details>
 <summary>Automation QA</summary>

 * [Ediweb](https://ediweb.com/ru-ru)
   * [Тестовое задание на должность "Тестировщик" *Automation QA / Ruby*](https://github.com/avannim/Fedorenko_test/tree/59b6c1a395ad8123b102f7f4214db6840be9db01/candidate_test)

* [Тестовое задание для стажёра-автоматизатора](https://github.com/avito-tech/qa-trainee-task)

* [Тестовое задание для стажёра-тестировщика на знание Java и SQL *(any)*](https://github.com/Pammer/traineeTestTask)

* [QATestLab](https://qatestlab.com/company/contact-us/)
  *  [Test task for position QA Specialist // *Java или C#*](https://github.com/n1mnull/QATestLab/blob/51b315d7d2ff011ce8255fb09a88bd6401891600/README.md)

* [Тестовое задание по автоматизации действий в поисковой строке Яндекса для *tensor.ru*](https://github.com/warumbaum/Tensor-Yandex)

* [Тестовое задание QA Auto Python от Effective Mobile](./QA/Effective%20Mobile/README.md)

</details>

<details>
 <summary>Manual QA</summary>

* [avito.tech](https://github.com/avito-tech)
  * [Тестовое задание для стажёра QA *(any)*](https://github.com/avito-tech/ShopX-QA-trainee)
  * [Тестовое задание для QA-стажёра *(Go/any)*](https://github.com/avito-tech/qa-trainee-general)

* [Flatstack](https://www.flatstack.com)
  * [QA engineer](https://github.com/fs/test-tasks/tree/master/qa)

* [HRlink](https://hr-link.ru/)
  * [Junior QA (SQL+Python)](./QA/HRlink/README.md)

* [Matic Insurance Services](https://matic.com/)
  * [Customer Import Platform MQA - MQA test assignment *(ENG)* *(any)*](https://github.com/matic-insurance/assignment-test-import)
  * [Customer Import Platform - AQA test assignment *(ENG)* *(Ruby)*](https://github.com/matic-insurance/assignment-test-import)

* [Purrweb](https://www.purrweb.com/ru/)
  * [Тестовое задание на позицию QA](https://github.com/Hexlet/ru-test-assignments/blob/main/QA/Test%20task%20Purrweb.md)

* [Sendsay](https://sendsay.ru/)
  * [Junior Frontend + QA [АРХИВ] *(JS, Cypress)*](./QA/Sendsay/README.md)

* [Tutu.ru](https://www.Tutu.ru/)
  * [Тестовое задание для кандидата на позицию QA](https://github.com/tutu-ru/tutu-ru.github.io)

* [ООО Крит](https://krit.pro/)
  * [Стажер_QA](./QA/ООО%20Крит/README.md)

* [ООО Синтека](https://cynteka.ru/)
  * [Junior_QA](./QA/ООО%20Синтека/README.md)

</details>

<details>
 <summary>Backend</summary>

* [Appbooster](https://appbooster.com/)
  * [Backend developer *(any)*](https://github.com/appbooster/test-assignments/blob/master/tasks/backend.md)

* [Appstorespy](https://appstorespy.com/)
  * [Junior Backend developer *(Django/Flask, MySQL/PostgreSQL, MongoDB/Redis/Elasticsearch, GraphQL/REST)*](./backend/Appstorespy/README.md)

* [avito.tech](https://github.com/avito-tech)
  * [Тестовое задание для стажёра Backend в команду Advertising *(Go/PHP)*](https://github.com/avito-tech/adv-backend-trainee-assignment)
  * [Тестовое задание на позицию стажера-бекендера в юнит Авто (archived) *(Go/Python/PHP/Java/JavaScript)*](https://github.com/avito-tech/auto-backend-trainee-assignment)
  * [Тестовое задание на позицию стажера backend в юнит Geo *(any)*](https://github.com/avito-tech/geo-backend-trainee-assignment)
  * [Тестовое задание на позицию стажера-бекендера (archived) *(any)*](https://github.com/avito-tech/msg-backend-trainee-assignment)
  * [Тестовое задание для стажёра Backend *(PHP)*](https://github.com/avito-tech/safedeal-backend-trainee)
  * [Тестовое задание для стажёра Backend в команду Trade Marketing *(Go/PHP/Python, PostgreSQL/MySQl, Redis)*](https://github.com/avito-tech/tm-backend-trainee)
  * [Тестовое задание на позицию стажера-бекендера в юнит Buyer Experience (archived) *(Go/PHP)*](https://github.com/avito-tech/bx-backend-trainee-assignment)
  * [Тестовое задание на позицию стажера-бекендера в юнит "Работа" *(Go/PHP, MySQL/PostgreSQL)*](https://github.com/avito-tech/job-backend-trainee-assignment)
  * [Тестовое задание на позицию стажера-бекендера *(Go/PHP/Python,  MySQL/PostgreSQL, Docker)*](https://github.com/avito-tech/autumn-2021-intern-assignment)
  * [Тестовое задание для стажера в юнит Market Intelligence *(Go/Python)*](https://github.com/avito-tech/mi-trainee-task-2021)

* [Edstein](https://www.edstein.ru/)
  * [Тестовое задание Middle Backend-разработчик *(Ruby on Rails)*](./backend/Edstein/README.md)

* [fuse8](https://hr.fuse8.ru/) [byte/minds](https://byteminds.co.uk/)
  * [Задания стажировки для backend-разработчиков *(.Net, C#, Postgres, gRPC)*](https://github.com/Fuse8/school2023)

* [Greensight](https://greensight.ru/)
  * [Тестовое задание для направления Backend разработка *(PHP)*](./backend/Greensight/README.md)

* [ItGlobal](https://itglobal.com/ru-ru/)
  * [Тестовое задание для Junior Backend разработка *(PHP)*](./backend/ItGlobal/README.md)

* [KODE](https://kode.ru/)
   * [Backend разработчик *(Python)*](https://github.com/appKODE/2018-internship-backend)*(изображение не найдено)*

* [pixlpark](https://pixlpark.ru/)
  * [Backend-разработка *(C#, ASP.NET, React/RazorPages)*](https://gist.github.com/paraekklisiarh/d64fbbc1de1028aaa7a47ff3fa0650a1)

* [Tutu.ru](https://www.Tutu.ru/)
  * [Тестовое задание на позицию backend-разработчик *(PHP)*](https://github.com/tutu-ru/php-interview)

* [Waliot](https://waliot.com/)
  * [Backend Developer *(Java/Kotlin, Spring Boot, SQL/NoSQL, Docker)*](https://github.com/waliot/test-tasks/blob/master/tasks/backend-1.md)

* [Wargaming.net](https://wargaming.com)
  * [Тестовое задание WG Forge (Backend) *(Python 3/Ruby/Go/Erlang/Elixir/Java/Scala/C#/F#, PostgreSQL, Docker)*](https://github.com/wgnet/wg_forge_backend)

* [ООО "МСтрой"](https://mstroy.tech/)
   * [Тестовое задание Backend developer / Python](./backend/ООО%20МСтрой/README.md)

* [ПИКАССО](https://picasso-diagnostic.ru/)
  * [Backend-разработчик (Python)](https://gist.github.com/NikolayZemelko/f1dfcb9b75a7241f5e552b8761e70027)

* [Marketplace Technologies (KazanExpress)](https://github.com/KazanExpress)
  * [Тестовое задания для кандидатов в бэкенд разработку *(Java, Spring)*](https://github.com/KazanExpress/backend-spring-test-task)

* [Oxem Studio](https://oxem.ru)
  * [Бэкенд-разработчик *(PHP)*](./backend/Oxem%20Studio/README.md)

* SoftPro
  * [Тестовое задание *(Go, C++, Python)*](./backend/SoftPro/)

</details>


<details>
 <summary>C#</summary>

* [Тестовое задание *(C#)*](https://drive.google.com/file/d/1GNwTfoJCQD0Ec3JXkWmzaYuIY6DnWnEa/view)

* [Тестовое задание на стажировку *(C#, SQL)*](https://drive.google.com/drive/folders/1--08xK0ympxiR2BedrKVhnE7cjfNn7bk?usp=sharing)

* [Тестовое задание C# *(C#)*](https://gist.github.com/Busyrev/cb89f309d2c32873449366023b8e0057)

* [Тестовое задание на вакансию Junior Разработчика C# *(C#, ASP.NET Core, Entity Framework Core)*](https://versta24.ru/hr/testfordevjun)

* [AFCStudio](https://afcstudio.ru/)
  * [Junior C# Developer *(C#, .NET, Angular, React, Razor)*](https://gist.github.com/paraekklisiarh/0621204ce249e9faf1aaa1e1b7d3f7ef)

* [Стажер-программист *(C#)*](https://drive.google.com/drive/folders/1pnBXXuAABDCMAKrcNjrDvRnE1jPd_LBL?usp=sharing)

* [Тестовое задание *(C#, ASP.NET Core, Entity Framework Core)*](https://disk.yandex.ru/d/Gu5V8FgsEobwzA)

* [Тестовые задания на c# стажировку *(C#)*](https://drive.google.com/drive/folders/185cbL5CzhcYoW2D92D5wHmdd04cDqTYS?usp=sharing)

* [Тестовое на стажировку C#, зима 2019-2020 *(C#, ASP.NET)*](https://drive.google.com/drive/folders/1UCx7__WtgzkWF4iFbkFPfc3NNQAqSKqn?usp=sharing)

</details>

<details>
 <summary>Data Scientist</summary>

* [BST Digital](https://bst.digital/)
  * [Тестовое задание для Data Scientist](https://drive.google.com/drive/folders/1G0VwPL-6T0ThPdLstnZK07dy1q2Mgv2T)

</details>

<details>
 <summary>DevOps</summary>

* [Smena](https://smena.space/)
  * [Тестовое задание DevOps разработчик *(Docker, minikube, Python)*](https://github.com/smenateam/assignments/tree/master/devops)

* [Kittens Store - DevOps test assignment *(ENG)* *(any)*](https://github.com/matic-insurance/assignment-kittens-store)

* [Cats Shop - DevOps test assignment *(ENG)* *(any)*](https://github.com/matic-insurance/assignment-cats-shop)

* [DevOps engineer](https://github.com/ostrovok-team/code-challenge/tree/master/devops)

</details>

<details>
 <summary>Frontend</summary>

* [23Devs](https://23devs.com/)
  * [Тестовое задание на позицию cтажер-разработчик javascript *HTML, CSS, JS*)](https://cloud.mail.ru/public/KN2F/TW4dPYs6n)

* [Appbooster](https://appbooster.com/)
  * [Frontend Developer *(any)*](https://github.com/appbooster/test-assignments/blob/master/tasks/frontend.md)
  * [Frontend + graphql developer *(React, Github GraphQL API)*](https://github.com/appbooster/test-assignments/blob/master/tasks/frontend-graphql.md)
  * [html-верстальщик *(JS, HTML/CSS)*](https://github.com/appbooster/test-assignments/blob/master/tasks/html-css.md)*(отсутствует дизайн-макет по указанной ссылке)*

* [Aviasales](https://aviasales.ru)
  * [~~Тестовое задание Aviasales (frontend) *(JS/TS, React)*~~](https://github.com/KosyanMedia/test-tasks/tree/master/aviasales_frontend) *(сервер тестового задания не работает)*
 * [Тестовое задание - Frontend Developer *(JS/TS)*](https://github.com/KosyanMedia/Front-end_TP_test)
 * [~~Тестовое задание Aviasales (frontend)~~ DEPRECATED *(JS, TS, CS, React)*](https://github.com/KosyanMedia/test-tasks/tree/master/DEPRECATED_aviasales)

* [avito.tech](https://github.com/avito-tech)
  * [Тестовое задание на позицию стажёра-фронтендера 2022 *(React, Redux, TS)*](https://github.com/avito-tech/internship_frontend_2022)
  * [Тестовое задание на позицию стажёра-фронтендера 2023 *(React, React Router, TS)*](https://github.com/avito-tech/frontend-trainee-assignment-2023)
  * [Тестовое задание на позицию стажёра-фронтендера 2024 *(React, React Router, TS)*](https://github.com/avito-tech/frontend-trainee-assignment-2024)
  * [Тестовое задание для стажёра frontend *(React)*](https://github.com/avito-tech/safedeal-frontend-trainee)*(отсутствует дизайн-макет по указанной ссылке)*
  * [Тестовое задание для стажёра Frontend в команду Seller Experience *(Node.JS, React, Redux)*](https://github.com/avito-tech/sx-frontend-trainee-assignment)
  * [Тестовое задание для стажёра Frontend в команду Avito People *(React, MobX, TS, Node.JS)*](https://github.com/avito-tech/ap-frontend-trainee-assignment)

* [BEBOSS](https://beboss.ru/)
  * [Web-разработчик *(PHP, jQuery, YII)*](https://github.com/funkylen/beboss-test-assignments)

* [BeeJee NINJA Developers](https://beejee.org/)
  * [Web-разработчик *(PHP)*](https://docs.google.com/document/d/1Wn_BBhmrF8S5iwgqo5cH63GAM6XTXLi4glp7ZxammIM/edit?usp=sharing)

* [BellIntegrator](http://www.bellintegrator.ru/)
  * [Тестовое задание Frontend JS *(JS, JQuery, HTML5, CSS3)*](https://docs.google.com/document/d/1YWJGDKB1pLrox6Y4CNm15Nuu_EVcAHIciYUHWYrDNDY/edit?usp=sharing)

* [BirdsBuild](https://bb.market/)
  * [Тестовое задание на позицию Frontend разработчик Nuxt.js *(Nuxt 3, TypeScript, GraphQL)*](https://docs.google.com/document/d/1_BN8bbym0InYFDElyyVJ5GzPptaOe0p9kteX-Uaww3I/edit#heading=h.ikkq5tsgq96y)

* [~~Bluesweater-studio~~](https://vk.com/bluesweaterstudio) *студия закрыта*
  * [Frontend task *(JS, React, React Hooks, JSS)*](https://github.com/some-yummy-nick/frontend-task)

* [Chatfuel](https://chatfuel.com/)
  * [Frontend Engineer — тестовое задание *(any)*](https://paper.dropbox.com/doc/Frontend-Engineer-GFOYvLYpCLWUJe59Ydfmw)
  * [Верстальщик](https://paper.dropbox.com/doc/fljyQo7ig1gZRevGejqEX)

* [CS-Cart](https://cs-cart.com/)
  * [Тестовое задание для PHP разработчиков *(PHP)*](https://github.com/cscart/apply-for-job/tree/master/backend/developer)
  * [Тестовое задание для Javascript разработчика *(JS, jQuery)*](https://github.com/cscart/apply-for-job/tree/master/frontend/developer)

* [DAO TECH](https://daotech.ru/)
  * [Тестовое задание на вакансию "Frontend Developer" *(JS, React, Docker)*](https://drive.google.com/file/d/17i3HWkCW8OdvmczEcE2p3q-ljU-2sAWz/view?usp=sharing)

* [Dapplets Project](https://dapplets.org/)
  * [Тестовое задание на вакансию "Frontend Developer" *(TS, React)*](https://docs.google.com/document/d/1A67hVEF5fb6Uk1Y341PeyV9Yr1UUWLtANITxSzWVHHY/edit#heading=h.dn2s0spi21rh)

* [DevJS](https://devjs.ru/)
  * [Тестовое задания на позицию Frontend разработчика *(JS, React)*](https://github.com/devjsru/react_test)*(отсутствует дизайн-макет по указанной ссылке)*

* [Flatstack](https://www.flatstack.com)
  * [Frontend Developer *(JS, HTML, CSS)*](https://github.com/fs/test-tasks/tree/master/front-end)

* [Future](https://future-group.ru/)
  * [Фронтенд-разработчик 1 *(React, Docker, TS)*](https://github.com/fugr-ru/frontend-javascript-test)
  * [Фронтенд-разработчик 2 *(React, Docker, TS, Redux/MobX)*](https://github.com/fugr-ru/frontend-javascript-test-2)
  * [Тестировщик](https://github.com/fugr-ru/qa)
  * [Верстальщик 1 *(HTML, CSS)*](https://github.com/fugr-ru/frontend-html)
  * [Верстальщик 2 *(HTML, CSS, JS)*](https://github.com/fugr-ru/frontend-html-2)
  * [Верстальщик 3 *(Figma, HTML, CSS, JS)*](https://github.com/fugr-ru/frontend-html-3)
  * [Тестовое задание на позицию Менеджер проекта *(Figma, HTML, CSS, JS)*](https://github.com/fugr-ru/frontend-html-3)

* [Hammer Systems](https://hammer.systems/)
  * [Тестовое задание для Frontend разработчика](https://disk.yandex.ru/d/R74ptnVnK5xpPA)

* [Hyundai Mobility Lab](https://mobility.hyundai.ru/)
  * [React-Native Mobile app *(React-Native CLI)*](https://docs.google.com/document/d/1VtzfiPK0FyEG5DDdsr1y3Ahh_T0eOIGHcV0m4Xi943U/edit?usp=sharing)

* [Ivelum](https://ivelum.com/)
  * [frontend-разработчик *(React)*](https://github.com/ivelum/job/blob/master/challenges/frontend.md)

* [KODE](https://kode.ru/)
  * [Frontend разработчик *(Create React App, React Router, Axios)*](https://github.com/appKODE/trainee-test-frontend)

* [Jupiter soft](https://jupiter-soft.com/)
  * [Тестовое задание Junior Frontend Developer (React)](https://docs.google.com/document/d/1VgAhMunSuTNn0a6bjY5F1-qyARkelJcVj50RSC_Bu54/edit?usp=sharing)

* [Marketplace Technologies (KazanExpress)](https://github.com/KazanExpress)
  * [Тестовое задание Front-End *(JS/TS, Vue.js)*](https://github.com/KazanExpress/frontend-test-task)
  * [Упрощённое тестовое задание Front-End *(JS, Vue.js)*](https://github.com/KazanExpress/frontend-test-task-short)

* [Mindbox](https://mindbox.ru/)
  * [Тестовое задание на стажировку Frontend *(JS, React)*](https://docs.google.com/document/d/1jq5yCrQJRHaRG4TabGhDITDMteYuLWG_LjlR9HmB5ac/edit?usp=sharing)

* [NewGen Vision](https://www.unipage.net/)
  * [Junior Frontend Developer *(JS, Vue.js)*](https://newgen-it.github.io/tests/front)

* [Ostrovok.ru](https://ostrovok.ru)
  * [Frontend Developer *(JS, HTML, CSS)*](https://github.com/ostrovok-team/code-challenge/tree/master/js)

* [Oxem Studio](https://oxem.ru)
  * [Фронтенд-разработчик *(React/Vue, вёрстка)*](https://doc.clickup.com/2659433/p/h/2h539-67321/1cdca9cd67897c8)

* [pixlpark](https://pixlpark.ru/)
  * [Frontend-разработка *(React, MobX)*](https://gist.github.com/paraekklisiarh/c03c97ae553a0038962fb945644392cf)

* [Redsoft](https://redsoft.ru)
  * [Frontend-разработчик *(JS, Vue.js, Node.js)*](https://docs.google.com/document/d/1Vamqwl3MaXDFOMcEBTVsvoZhADblO-CcBVqVKs3Pij0)

* [Ruport](http://ruport.ru/)
  * [Middle Frontend Developer *(ECMAScript, SCSS)*](https://github.com/ruport-digital/middle-frontend-assignment)
  * [Junior Frontend Developer *(верстка)*](https://github.com/ruport-digital/junior-frontend-assignment)

* [Sendsay](https://sendsay.ru/)
  * [Junior Frontend + QA [АРХИВ] *(JS, Cypress)*](https://www.notion.so/sendsay/Junior-Frontend-QA-44af3daa06524689aa6ac0fc76f66579)
  * [Frontend-разработчик 1 [АРХИВ] *(JS, React, Redux)*](https://www.notion.so/sendsay/Frontend-4263b61293224088b7c3f929b761f9e3)
  * [Frontend-разработчик 2 [АРХИВ] *(JS, React, Redux)*](https://www.notion.so/sendsay/Frontend-API-75cc5ecc28cd42f4a6f963e2dad88680)
  * [Младший frontend-разработчик *(JS, React)*](https://sendsay.notion.site/Frontend-e378a45c3a934dafb6e44f79da2a0040)

* [Frontend test case *(React, TypeScript)*](https://drive.google.com/file/d/1GPYkayQVevwsPcipL76DsKBm3so3DihR/view?usp=share_link)

* [Test Task for Intern / Junior Front-End Developer Position *(React)*](https://gist.github.com/krambertech/ecb3890824fd7ada0f4ec1ff55125758)

* [Shopify](https://www.shopify.com/)
  * [Frontend Intern, Fall 2022 *(JS, OpenAI) (ENG)*](https://docs.google.com/document/d/16tMBx990qfnX2P1lTKTqaS4Ugp2RzqFrLIZ1TwWCVo4/edit?usp=sharing)

* [Smena](https://smena.space/)
  * [JavaScript Developer *(JS, Vue.js)*](https://github.com/smenateam/assignments/blob/master/site-frontend/README.md)
  * [TypeScript Developer *(TS, React)*](https://github.com/smenateam/assignments/blob/master/erp-frontend/README.md)

* [~~Studika~~](https://studika.ru/) *студия закрыта*
  * [Frontend-разработчик](https://docs.google.com/document/d/1guSGNGsmd5JdKBTgeiik94dLIUVkVgElqOYvqO8ekZ0/edit?usp=sharing)

* [Tutu.ru](https://www.Tutu.ru/)
  * [Домашнее задание для соискателей на позицию фронтенд-разработчика *(JS, React, Node.js)*](https://github.com/tutu-ru/fe-homework)
  * [Тестовое задание на позицию frontend-разработчик *(JS, TS)*](https://github.com/tutu-ru/frontend-javascript-test)
  * [Тестовое задание на позицию верстальщик *(JavaScript/jQuery, HTML, CSS)*](https://github.com/tutu-ru/frontend-html-test)

* [Waliot](https://waliot.com/)
  * [Frontend Developer *(TypeScript/JavaScript, Angular/React/Vue)*](https://github.com/waliot/test-tasks/blob/master/tasks/frontend-1.md)
  * [Angular Developer *(TypeScript, Angular, NgRX, NGXS)*](https://github.com/waliot/test-tasks/blob/master/tasks/frontend-2.md)

* [Wargaming.net](https://wargaming.com)
  * [Тестовое задание WG Forge Platform Front-End *(JS, Node.js)*](https://github.com/wgnet/wg_forge_frontend)

* [Yoldi](https://yoldi.agency/development)
  * [Тестовое задание для вакансии фронтенд разработчик в Yoldi](https://yoldi-agency.notion.site/Yoldi-7552752e30964431ab0ca03d54908148)

* [Армо](http://armo.ru/)
  * [Junior Frontend *(JSc+ Electron, Python + Tornado)*](https://disk.yandex.ru/d/3u7hKvypQ-nOxA)

* [Валантис](https://juvelirnyj-lombard.ru/)
  * [Frontend-разработчик *(React)*](https://github.com/Hexlet/ru-test-assignments/blob/main/frontend/valatris_api.md)

* [Домотехника](https://domotekhnika.ru/)
  * [Тестовое задание Frontend *(Vue.js)*](https://www.notion.so/radislaw/9c4c4b1823304404af78a0f7cbe640f3)

* [Инфоматика](https://infomatika.ru/)
  * [Верстка *(HTML, CSS)*](https://github.com/some-yummy-nick/infomatika-test)

* [Квартирка](https://kvartirka.com/)
  * [Frontend-разработчик,  Junior+ *(JS, React/Next.js/TypeScript)*](https://docs.google.com/document/d/1bSC3hgaYe69FJFKKNFHKokJ2Rs0bxkYQ9ixnBS8xn-M/edit)

* [Маквес Групп](https://www.makves.ru/)
  * [Стажёр-разработчик Frontend *(JS, React)*](https://drive.google.com/file/d/1ZRKa2us1D49l8natOIpO5TYTirKdNssz/view?usp=sharing)

* [НПО Фарватер](https://tsep.pro/)
  * [Junior+ Frontend Developer *(Vue, React, Canvas)*](https://docs.google.com/document/d/1ReRmhwrI1qwJi2PxhC9GQdP1h9BSt3bKZBaj_oV210s/edit)

* [СДК Гарант](https://www.sdkgarant.ru/index.php/ru/)
  * [Junior Front-End разработчик *(JS, ExtJS)*](https://github.com/georgy-p/SDK-Garant-test-task)

* [Frontend test case *(React, TypeScript)*](https://docs.google.com/document/d/16IkxQ_ZDRxrfnzdjQdYP5UfyloGwmwXsZ5IEXEbuL2E/edit?usp=sharing)
* [C32. Frontend JS test task 1 *(React)*](https://docs.google.com/document/d/1LQ7olXMcjNKF_vHoPqm8VsJc65K3PfW5M3s9D1EO8xs/edit)
* [Тестовое задание Frontend-разработчик *(JS, React, Redux, React Router)*](https://docs.yandex.ru/docs/view?url=ya-disk-public%3A%2F%2FPg8Mn9b2nwRtbsd79GdjAOk0sK0J5vagJAQzR5a5H4HBf2B6dSCQGd5kCvgXaxdcq%2FJ6bpmRyOJonT3VoXnDag%3D%3D&name=%D0%A2%D0%B5%D1%81%D1%82%D0%BE%D0%B2%D0%BE%D0%B5%20%D0%B7%D0%B0%D0%B4%D0%B0%D0%BD%D0%B8%D0%B5.docx)

* [Matic Test assignment - Front-end test assignment *(ENG)* *(any)*](https://github.com/matic-insurance/assignment-fetch-n-cache)

* [Тестовое задание.React *(React/Redux)*](https://drive.google.com/file/d/1LUlaX0-8MuZXOMbqsIt8tW3xPrBPWSHU/view?usp=sharing)

* [Frontend test case *(React, TypeScript)*](https://drive.google.com/file/d/1GPYkayQVevwsPcipL76DsKBm3so3DihR/view?usp=share_link)

* ЮТОР
  * [Стажер фронтенд разработчик, 1 этап отбора](https://docs.google.com/document/d/1BK6lOSnTEtI0V5K5idK_QJU6CC5Iv1-lhpGAGDqftkA/edit?usp=sharing)

* [Задание на вакансию "Верстальщик лендингов", осень 2023](https://forms.yandex.ru/surveys/10033975.d66cde35b078199afc83f1e9f11cb58c5cdb22e9/?utm_source=hh&utm_medium=email&utm_content=3472582922)

* [Задание по вёрстке — ШРИ, Москва, Санкт-Петербург, Симферополь, осень 2018](https://github.com/yandex-shri-2018/entrance-task-2-2)

* [Задание по вёрстке — ШРИ, Москва, весна 2018](https://github.com/yandex-shri-2018/entrance-task-2)

* [Тестовое задание для вакансии web-технолог *(CSS)*](https://www.reg.ru/company/jobs/testtask-webtech)

* [Тестовое задание для TypeScript/Vue.js разработчика *(TS, VueJS, HTML/CSS)*](https://github.com/Ecwid/new-job/blob/master/TypeScript.md)

* [Тестовые задания по React *(React, React Router, Redux Saga, Mobx)*](https://github.com/GPB-COS/test-work-react)

* [React Engineer *(JS, HTML, PHP)*](https://docs.google.com/document/d/1UL4FJrtzHamyOavu-VN9fH7Y05lkbmH5abtC2nnx2QY/edit)

* [Тестовое задание для верстальщика](https://hexlet-ru.notion.site/38fd01d380cb43efa94702b5188cfde4)

* [~~Тестовое задание Aviasales (frontend)~~ DEPRECATED *(JS, TS, CS, React)*](https://github.com/KosyanMedia/test-tasks/tree/master/DEPRECATED_aviasales)

* [Front-End Developer *(HTML, CSS, JS)*](https://github.com/JediFE/trial-assignments)

* [~~Тестовое задание Aviasales (frontend) *(JS/TS, React)*~~](https://github.com/KosyanMedia/test-tasks/tree/master/aviasales_frontend) *(сервер тестового задания не работает)*

* [Frontend + graphql developer *(React, Github GraphQL API)*](https://github.com/appbooster/test-assignments/blob/master/tasks/frontend-graphql.md)

* [Тестовое задание для стажёра в команду VAS *(any)*](https://github.com/avito-tech/vas-frontend-trainee-assignment)

</details>


<details>
 <summary>full-stack</summary>

* [Aviasales](https://aviasales.ru)
  * [Тестовое задание в команду гейтов (full-stack) *(JS + React, Redux/Redux-saga, Python + PostgresSQL)*](https://github.com/KosyanMedia/test-tasks/tree/master/gates_team_fullstack)
  * [Тестовое задание Aviasales Marketing (full-stack) *(JS, React, Redux, NodeJS, PostgreSQL)*](https://github.com/KosyanMedia/test-tasks/tree/master/marketing)

</details>

<details>
 <summary>Go</summary>

* [avito.tech](https://github.com/avito-tech)
  * [Тестовое задание на позицию стажёра-бэкендера 2022 *(Go, MySQL/PostgreSQL, Docker)*](https://github.com/avito-tech/internship_backend_2022)
  * [Тестовое задание для стажера в юнит Merchant Experience *(Go, PostgreSQL)*](https://github.com/avito-tech/mx-backend-trainee-assignment)
  * [Тестовое задание стажера в юнит AvitoPRO *(Go)*](https://github.com/avito-tech/pro-backend-trainee-assignment)

* [Тестовое задание для Golang разработчика *(Go)*](https://github.com/KazanExpress/golang-test-task)

* [Test Task: In-memory cache *(eng)* *(Go)*](https://github.com/gojuno/test_tasks)

 </details>

<details>
 <summary>iOS</summary>

* [Задание для стажера на платформу iOS *(Swift)*](https://github.com/avito-tech/ios-trainee-problem-2021)

* [iOS разработчик *(Swift 5, UIKit, iOS 13+, Зависимости через SPM или Cocoapods)*](https://github.com/appKODE/trainee-test-ios)

* [Appbooster](https://appbooster.com/)
  * [iOS Developer *(any)*](https://github.com/appbooster/test-assignments/blob/master/tasks/ios.md)

* [avito.tech](https://github.com/avito-tech)
  * [Тестовое задание на позицию стажёра в iOS 2022 *(Swift)*](https://github.com/avito-tech/internship_ios_2022)
  * [Задача для стажера на платформу iOS (archived)](https://github.com/avito-tech/ios-trainee-problem)

* [Flatstack](https://www.flatstack.com)
  * [iOS Developer *(any)*](https://github.com/fs/test-tasks/tree/master/ios)

* [FunBox](https://funbox.ru/)
  * [iOS/Android-разработчик *(Xcode/Android Studio)*](https://dl.funbox.ru/qt-mobile.pdf)

* [Хитрые задачки по iOS *(any)*](https://github.com/appKODE/test2019)*(сервер тестового задания не работает)*

* [Internship *(iOS)*](https://github.com/avito-tech/internship)

</details>


<details>
 <summary>Java</summary>

* [Java разработчик](https://docs.google.com/document/d/1peoDqaNraEL5jW3kMWPSQevLvKNwyOjC0KNOigfQTNM/edit?usp=sharing)

* [Java разработчик](https://docs.google.com/document/d/1f5frd0d_sQk471oeznTnHpc-YSo9EfkQ3avHpxy4TtE/edit?usp=sharing)

* [Ecwid](https://www.ecwid.com/)
  * [Парсер SQL запросов *(Kotlin/Java)*](https://github.com/Ecwid/new-job/blob/master/SQL-parser.md)
  * [Глубокое копирование *(Kotlin/Java)*](https://github.com/Ecwid/new-job/blob/master/Deep-clone.md)
  * [java.util.Map поверх Redis *(Kotlin/Java, Redis)*](https://github.com/Ecwid/new-job/blob/master/Redis-and-collections.md)
  * [Посчитать количество уникальных IP-адресов в простом текстовом файле *(Kotlin/Java)*](https://github.com/Ecwid/new-job/blob/master/IP-Addr-Counter.md)

* [Eltex](https://eltex-co.ru/)
  * [Многопользовательский тайм-трекер *(Backend Java/Kotlin)*](backend/java_time_tracker.md)

* [FunBox](https://funbox.ru/)
  * [Java-разработчик *(Java)*](https://dl.funbox.ru/qt-java.pdf)

* [Haulmont](https://www.haulmont.ru)
  * [StudentDatabase *(Java)*](https://github.com/nikolaychernov/StudentDatabase)

* [Infomaximum](https://infomaximum.com)
  * [Java разработчик](https://drive.google.com/file/d/17g9-4HTkBtJln-3I-iavMqWkX9bBYcg2/view?usp=sharing)

* [Marketplace Technologies (KazanExpress)](https://github.com/KazanExpress)
  * [Тестовое задание для кандидатов в бэкенд разработку *(Java, Spring)*](https://github.com/KazanExpress/backend-spring-test-task)
  * [Тестовое задание на Android разработку - поиск коктейлей *(Java, Kotlin)*](https://github.com/KazanExpress/android-test-task)
  * [Тестовое задание на Android разработку - просмотр статей *(Java, Kotlin)*](https://github.com/KazanExpress/ke-test-android)

* [MediaSoft](https://mediasoft.team/)
  * [Тестовое задание.Java *(Java EE/Spring, Maven/Gradle)*](https://drive.google.com/file/d/1obl6-j36xkLszszRPnj0enWxPX-nzzuQ/view?usp=sharing)
 
* [Tutu.ru](https://www.Tutu.ru/)
  * [Тестовое задание на позицию Android-разработчика *(Kotlin/Java, Dagger, RxJava)*](https://github.com/tutu-ru/hire_android_test)

* [Waliot](https://waliot.com/)
  * [Backend Developer *(Java/Kotlin, Spring Boot, SQL/NoSQL, Docker)*](https://github.com/waliot/test-tasks/blob/master/tasks/backend-1.md)

* [СКБ Контур](https://kontur.ru/)
  * [Тестовые задания на java *(Java)*](https://drive.google.com/drive/folders/1zhJUFNYc8KJkLNOmPueoQkaiZCv5kodM?usp=sharing)

* [ЭВРИКА](https://hr.eureca.ru)
  * [Fullstack разработчик *(JS + Java)*](https://docs.google.com/document/d/1fodUFtPCuHyP2Hn7ly3ZsSD_GsSR_wTf/edit?usp=sharing&ouid=115639618941993452518&rtpof=true&sd=true)

</details>

<details>
<summary>Python</summary>

* [FitnessKit](https://fitness-kit.ru/)
  * [Python разработчик на backend *(Python, Django)*](https://fitness-kit.ru/files/%D1%82%D0%B5%D1%81%D1%82%D0%BE%D0%B2%D0%BE%D0%B5%20%D0%B1%D1%8D%D0%BA.pdf)

* [Тестовое задание в команду гейтов *(Python)*](https://github.com/KosyanMedia/test-tasks/tree/master/gates_team)

* [KazanExpress test for Python developer *(eng)* *(Python, Django)*](https://github.com/KazanExpress/django-test-task)

* [Тестовое задание для Backend Python. Конвертер валют на FastAPI](https://docs.google.com/document/d/190wtDNCDUX826L_Tr0x_PsYNaxhBSBcdtbp7YSasYVQ/edit?usp=sharing)

* [Сбербанк](https://www.sberbank.ru/ru/person)
  * [Тестовое задание для инженера данных *(Python, SQL)*](https://drive.google.com/drive/folders/1EMRCcMT852e-rAxliXn-3eihjcS2SnP-)

* [abz.agency](https://abz.agency/)
  * [Junior Python Developer *(Python, Django/Flask, MySQL/PostgreSQL)*](https://drive.google.com/file/d/1qUzx0m_Koj83k_G8BScCNK7opazbuDzk/view?usp=sharing)

* [Backend developer *(any)*](https://github.com/appbooster/test-assignments/blob/master/tasks/backend.md)

* [Appstorespy](https://appstorespy.com/)
  * [Junior Backend developer *(Django/Flask, MySQL/PostgreSQL, MongoDB/Redis/Elasticsearch, GraphQL/REST)*](https://catkin-gymnast-f1a.notion.site/junior-backend-developer-2022-2f4803705cb84485a81a1d716bdf0a8c)

* [Aviasales](https://aviasales.ru)
  * [Тестовое задание в команду ассистеда *(Python, Go)*](https://github.com/KosyanMedia/test-tasks/tree/master/assisted_team)

* [Тестовое задание в команду гейтов *(Python)*](https://github.com/KosyanMedia/test-tasks/tree/master/gates_team)

  * [Тестовое задание на позицию стажера-бекендера в юнит Авто (archived) *(Go/Python/PHP/Java/JavaScript)*](https://github.com/avito-tech/auto-backend-trainee-assignment)

  * [Тестовое задание для стажёра Backend в команду Market Intelligence *(Python)*](https://github.com/avito-tech/mi-backend-trainee-assignment)

* [Тестовое задание для стажера в Market Intelligence (archived) *(Python)*](https://github.com/avito-tech/mi-trainee-task)

* [Тестовое задание по python *(Python)*](https://github.com/avito-tech/python-trainee-assignment)

* [Bewise](https://bewise.ai/)
  * [Тестовое задание на позицию Python Junior](https://docs.google.com/document/d/1lZ6nzX6Bt855aYpP9Z0ca6h0jc28Qn0w048UdsnLoLY/edit?usp=sharing)

* [Escape Tech](https://escape-team.tech/)
  * [Python разработчик (стажер), *Python*](https://github.com/brain4power/software_tester)

* [HardQode](https://hardqode.com/)
  * [Тестовое задание Junior Python(Django, Django DRF)](https://docs.google.com/document/d/1jIuNfvfv1AX99BzQX_cSmhXMSRnpk1ZUZW8C42j3UWM/edit?usp=sharing)

* [Ivelum](https://ivelum.com/)
  * [Python-разработчик *(Python)*](https://github.com/ivelum/job/blob/master/challenges/python.md)

* [KODE](https://kode.ru/)
 * [Backend разработчик *(Python)*](https://github.com/appKODE/2018-internship-backend)*(изображение не найдено)*

 * [KazanExpress test for Python developer *(eng)* *(Python, Django)*](https://github.com/KazanExpress/django-test-task)

  * [Тестовое задание.Python *(Python)*](https://drive.google.com/file/d/1DU2-MSCNN-FzCa8ksB3rx2GQy23LSt5T/view?usp=sharing)

* [Python Developer *(Python)*](https://github.com/ostrovok-team/code-challenge/tree/master/python)

* [PyShop](https://pyshop.ru/)
  * [Разработчик Python (стажировка)](https://jl.pyshop.ru/tasks/python-dev/) Задание также можно найти в `backend/PyShop_python_trainee.md`

  * [Python Developer *(Python, Django, PostgreSQL, Docker)*](https://github.com/smenateam/assignments/blob/master/backend/README.md)

* [Очень Интересно](https://www.interesnee.ru/)
  * [Python-разработчик на позицию стажера](https://github.com/David-Roklem/django-test-task/blob/main/Task-itself.md)

* [ПИКАССО](https://picasso-diagnostic.ru/)
  * [Backend-разработчик (Python)](https://gist.github.com/NikolayZemelko/f1dfcb9b75a7241f5e552b8761e70027)

  * [Тестовое задание для стажера Python [elasticsearch]](https://karpovilia.notion.site/Python-67777c95bdbe4e59856c59b707349f2d)

 * [Тестовое задание для Backend Python. Конвертер валют на FastAPI](https://docs.google.com/document/d/190wtDNCDUX826L_Tr0x_PsYNaxhBSBcdtbp7YSasYVQ/edit?usp=sharing)

* [Django Developer *(в Контент)*](https://github.com/ostrovok-team/code-challenge/blob/master/python/content-tech-task.md)

* [Python-разработчик *(Python)*](https://funbox.ru/q/python.pdf)

* [Тестовое задание для стажера в Market Intelligence *(Python, Docker)*](https://github.com/avito-tech/mi-backend-trainee-assignment)

* [Тестовое задание для стажера в Market Intelligence (archived) *(Python)*](https://github.com/avito-tech/mi-trainee-task)

* [Github repository browsing tool *(Python)*](https://github.com/wemake-services/meta/issues/7)

* [Тестовое задание для стажера Python elasticsearch](https://karpovilia.notion.site/Python-67777c95bdbe4e59856c59b707349f2d)

* [Тестовое UpTrader](https://docs.google.com/document/d/1XTnbcXhejyGB-I2cHRiiSZqI3ElHzqDJeetwHkJbTa8)

* [Тестовое Python Developer](https://drive.google.com/file/d/1ElH6YRA7f9dmKbT4e0HNeR1u4Cxq-rRX)

</details>


<details>
<summary>Clojure</summary>

* [Health Samurai](https://health-samurai.ru/how-to-become)
  * [Clojure Developer](backend/HealthSamurai/HealthSamurai_clojure.md)

</details>



<details>
 <summary>PHP</summary>

* [CLC Tech](https://clc-logistic.ru/)
  * [Junior PHP developer *(yii2)*](https://disk.yandex.ru/d/hN8ycrSdTNCydw)

* [CS-Cart](https://cs-cart.com/)
  * [Тестовое задание для PHP разработчиков *(PHP)*](https://github.com/cscart/apply-for-job/tree/master/backend/developer)

* [DevJS](https://devjs.ru/)
  * [Тестовое задание для PHP разработчиков *(PHP)*](https://github.com/devjsru/php_test)

* [FEIP](https://feip.co/)
  * [PHP-разработчик *(PHP)*](https://docs.google.com/document/d/1SLvbJ1hs3X3my3-gZJ7LsNtTa31IEVF0p6seTML-Efo)

* [Future](https://future-group.ru/)
  * [PHP-разработчик *(PHP, MySQL)*](https://github.com/fugr-ru/php-comments)

* [Greensight](https://greensight.ru/)
  * [Тестовое задание для направления Backend разработка *(PHP)*](https://www.notion.so/Backend-f863a6666e9f40f99f41254a1fffe450)

* [Hommler OU](https://hommler.de/)
  * [Middle developer / PHP разработчик](https://github.com/dimalepel/test-assignments/blob/main/tasks/193305072023.md)

* [is.Digital](https://isdigi.ru/)
  * [Тестовое задание для веб разработчика *(PHP, MySQL)*](https://isdigi.ru/is/job/web-programmer-2/test-web-dev-junior/)

* [Ivelum](https://ivelum.com/)
  * [PHP-разработчик *(PHP)*](https://github.com/ivelum/job/blob/master/challenges/php.md)

* [Oxem Studio](https://oxem.ru)
    * [Бэкенд-разработчик *(PHP)*](https://doc.clickup.com/p/h/2h539-778/840ce49e651e59a)

* [REG.RU](https://www.reg.ru/)
  * [Тестовое задание для вакансии «Программист PHP» *(PHP)*](https://www.reg.ru/company/jobs/testtask-prog-php)

  * [Тестовое задание на позицию backend-разработчик *(PHP)*](https://github.com/tutu-ru/php-interview)

* [Глобал Консалтинг](https://bth.su/)
  * [Тестовое задание для Junior PHP-разработчик *(Laravel)*](https://docs.google.com/document/d/1fl4eCKdpSXUNyu899NCKaDy_fdHcVPDE-GoO9siZPX4/edit)

* [Монолит Северо-Запад](https://spb.hh.ru/employer/4170463?hhtmFrom=vacancy)
  * [Junior Full Stack Web PHP разработчик](https://gleaming-tent-a11.notion.site/PHP-c1648a59bc8c4880a40ec750ee1d8aee)

* [TMK](https://tmktools.ru/)
  * [Тестовое задание PHP-developer *(PHP, Symfony)*](https://docs.google.com/document/d/1ixExyddJG4V4jxpSuYH61rh0rZ-RFztfqWa3aApZnlI/)

* [Hicaliber](https://www.hicaliber.com.au/)
  * [PHP Developer Test *(ENG)* *(PHP + Laravel, Vue.js)*](https://drive.google.com/drive/folders/0ByqxhUNvccJxdTdROE5aX3VSOWc?resourcekey=0-Cf8K_Zu0DCnnhfFs3aokDQ)
</details>


<details>
 <summary>Ruby</summary>

* [Ruby Developer *(Ruby, Rails)*](https://github.com/fs/test-tasks/tree/master/ruby)

* [Ruby Intern *(Ruby, Rails)*](https://github.com/fs/test-tasks/tree/master/ruby-intern)

* [Cats Dealer - Ruby test assignment *(ENG)* *(Ruby)*](https://github.com/matic-insurance/assignment-cats-dealer)

* [Ruby-разработчик *(Ruby, Rails, JS)*](https://dl.funbox.ru/qt-ruby.pdf)

* [Customer Import Platform - Ruby test assignment *(ENG)* *(Ruby)*](https://github.com/matic-insurance/assignment-test-import)

* [Appbooster](https://appbooster.com/)
  * [Ruby Developer *(Ruby)*](https://gist.github.com/KELiON/949731e077656ce036fa6114e7b47d2d#file-ruby-md)

 * [Тестовое задание Software Engineer *(Ruby, Ruby On Rails, ActiveRecord, Docker)*](https://github.com/KosyanMedia/travelpayouts_RoR_test)

</details>


<details>
 <summary>SQL</summary>

* [Airbnb](https://sql-academy.org/ru/trainer)
  * [SQL *(any SQL DB)*](sql/airbnb/airbnb_sql_tests.md)

* [Alfabank](https://sql-academy.org/ru/trainer)
  * [SQL *(any SQL DB)*](sql/alfabank/alfabank_sql_tasks.md)

* [Appbooster](https://appbooster.com/)
  * [SQL *(any SQL DB)*](https://gist.github.com/KELiON/949731e077656ce036fa6114e7b47d2d#file-sql-md)

* [Domclick](https://sql-academy.org/ru/trainer)
  * [SQL *(any SQL DB)*](sql/domclick/domclick_sql_tests.md)

* [Samokat](https://sql-academy.org/ru/trainer)
  * [SQL *(any SQL DB)*](sql/samokat/samokat_sql_tests.md)

* [Sberbank](https://sql-academy.org/ru/trainer)
  * [SQL *(any SQL DB)*](sql/sberbank/sberbank_sql_tests.md)

* [VK](https://sql-academy.org/ru/trainer)
  * [SQL *(any SQL DB)*](sql/vk/vk_sql_tests.md)

</details>



<details>
 <summary>Other</summary>

* [Dodo Brands](https://dodobrands.io/)
  * [Тестовое задание для Web-mobile Analyst](https://drive.google.com/drive/folders/18yjaMxWI9qpPa-9kTojYuNVcCj6iG8Pd)

* [Тестовое задание на вакансию Perl-программист *(Perl)*](https://www.reg.ru/company/jobs/testtask-prog)

* [BigData-разработчик *(Hadoop, Cassandra, Docker)*](https://dl.funbox.ru/qt-bigdata.pdf)

* [Тестовое задание для стажёра-автоматизатора в команду разработки Центра экспертизы по Обеспечению качества](https://github.com/avito-tech/qa-into-CoE-trainee-task)

* [Mobile-разработка *(React Native, TS/JS)*](https://gist.github.com/paraekklisiarh/de6b38cc79be8e14f2c98d88028447c6)

* [Тестовое задание для дата-инженера *(SQL)*](https://drive.google.com/drive/folders/1PHzuS3TWdLJBthV35Ra3q1oF9RzEuZ2u)

* [Система решения математических уравнений *(CSS, JS/Ajax, TestUnit/RSpec/Cucumber, Sinatra)*](https://gist.github.com/shiroginne/2cd4ade25d7c81f28798)

* [Тестовое задание Веб-программист *(any, предпочтительно Laravel)*](https://drive.google.com/file/d/1ACBukx7UpnLztRnnCKID3K-DxX1UciMw/view)

* [Тестовое задание на должность «Специалист службы технической поддержки хостинга»](https://www.reg.ru/company/jobs/testtask-hostingsupport)

* [Erlang-разработчик *(Erlang)*](https://dl.funbox.ru/qt-erlang.pdf)

* [Тестовое задание для вакансии «Инженер по автоматизации тестирования» *(any)*](https://www.reg.ru/company/jobs/testtask-qa-automator)

* [Тестовое задание для Workle *(Vue.js)*](https://github.com/mikhail-shamshurin/workle-test-task)

* [Тестовое задание для Fraud Analyst](https://drive.google.com/drive/folders/1JTMqKy8Kgmkh08vAW3wx8NcPfdyqXWuV)

* [Задание "найди ошибки" — ШРИ, Москва, весна 2018 *(Node.js)*](https://github.com/yandex-shri-2018/entrance-task-1)

* [Тестовое задание для дата-менеджера](https://drive.google.com/drive/folders/1FS0GtB_DxK4ZgrI8s6zMSPCYiDhtETNY)

* [Тестовое задание.Mobile *(Swift/Kotlin/Flutter)*](https://drive.google.com/file/d/16glieEeWz0o_Yg-VX2gug7M86g2UoMpi/view?usp=sharing)

* [Node.js Developer *(Node.js)*](https://github.com/fs/test-tasks/tree/master/nodejs)

* [Тестовое на стажировку Тестировщик, осень 2022 *(any)*](https://disk.yandex.kz/i/Aew3EEz3GNuxHA)

* [Remote FS Explorer - Eclipse plugin *(ENG)* *(Eclipse)*](https://docs.xored.com/pages/viewpage.action?pageId=22742624)

* [Тестовое задание для стажёра-автоматизатора](https://github.com/avito-tech/qa-trainee-task)

* [Тестовое задание для стажёра-тестировщика на знание Java и SQL *(any)*](https://github.com/Pammer/traineeTestTask)

* [Задание для тестировщика *(any)*](https://github.com/AlexeyKashin1/Test1?tab=readme-ov-file)

* [GraphQL endpoint for Junior Developer position in Scandiweb *(ENG)* *(TS, GraphQL)*](https://github.com/scandiweb/junior-react-endpoint)

* [Screen sharing + chat *(ENG)* *(any)*](https://docs.xored.com/display/XL/Test+task+Screen+sharing+with+chat)

* [Тестовое задание на позицию React-Native developer *(React-Native CLI (iOS, Android))*](https://docs.google.com/document/d/1AKeJuZmhbLdv7PCMdJsQoCu60tT3OHyen7laa58aKMk/edit?usp=sharing)

* [Тестовое задание для поступления в FrontCloudCamp](https://github.com/FrontCloudCamp/test-assignment)

* [[Dev] Тестовое задание *(any)*](https://drive.google.com/file/d/1cbUD3ID1yyHJES9KQH12L_wGhKTn6Jrg/view)

* [Задание "реализовать алгоритм" — ШРИ, Москва, Санкт-Петербург, Симферополь, осень 2018](https://github.com/yandex-shri-2018/entrance-task-3-2)

* [Посчитать количество уникальных IP-адресов в простом текстовом файле *(Kotlin/Java)*](https://github.com/Ecwid/new-job/blob/master/IP-Addr-Counter.md)

* [Unity Developer *(Unity)*](https://github.com/fs/test-tasks/tree/master/unity)*(ссылка "тестовым проектом" нерабочая)*

* [developer's performance measurement tool *(Eclipse)*](https://docs.xored.com/pages/viewpage.action?pageId=19694895)

* [Задание "найди ошибки" — ШРИ, Москва, Санкт-Петербург, Симферополь, осень 2018 *(Node.js)*](https://github.com/yandex-shri-2018/entrance-task-1-2)

* [Xored home work test task 2 *(ENG)* *(Eclipse)*](https://docs.xored.com/display/XL/Xored+home+work+test+task+2)

* [Тестовое задание *(Eclipse)*](https://docs.xored.com/pages/viewpage.action?pageId=16023682)

* [Маленький Эксель *(any)*](https://docs.xored.com/pages/viewpage.action?pageId=26378756)

* [Xored home work test task *(ENG)* *(Eclipse)*](https://docs.xored.com/display/XL/Xored+home+work+test+task)

</details>
