Задача №1. SQL-запрос

Условия задачи   
В базе данных риелторской компании есть три таблицы.   
1\) Таблица "client", которая содержит информацию о клиентах компании. Она содержит поля:   
"id" – уникальный идентификатор клиента;   
"first\_name" – имя клиента;   
"last\_name" – фамилия клиента.  
2\) Таблица "apartment", которая содержит информацию о продаваемых квартирах. Она содержит поля:  
"id" – уникальный идентификатор квартиры;  
"address" – адрес квартиры;  
"rooms" – количество комнат в квартире.  
3\) Таблица "view", которая содержит информацию о записи на просмотр квартир клиентами. Она содержит поля:  
"id" – уникальный идентификатор записи;  
"apartment\_id" – идентификатор квартиры;  
"client\_id" – идентификатор клиента, записанного на просмотр;  
"date" – дата просмотра квартиры.

Обратите внимание, что на просмотр одной квартиры могут записаться несколько клиентов, а один клиент может записаться на просмотр нескольких квартир.

Ниже представлена схема описанной базы данных.

![][image1]

Исходя из описания и схемы базы данных, составьте SQL-запрос, результатом которого будет список фамилий клиентов, записанных на просмотр двух и более трехкомнатных квартир.

Задача №2

Условия задачи.   
Строительная компания построила небоскреб, в котором N этажей, и хочет посчитать, какую выручку она сможет получить от продажи всех квартир.

На каждом этаже находится только одна квартира.  
Стоимость квартиры зависит от того, на каком этаже она находится.  
Стоимость квартиры возрастает на 1000 долларов каждые M этажей.   
Стоимость квартиры на первом этаже составляет X долларов.

Например: в доме 30 этажей; стоимость возрастает каждые 10 этажей; цена квартиры на первом этаже составляет 10000$. В таком случае квартиры на этажах с 1-го по 10-й будут стоить по 10000$, на этажах с 11-го по 20-й — по 11000$, а с 21-го по 30-й — по 12000$.

Вам даны целые положительные числа N, M, X.  
Напишите функцию, которая возвращает сумму, которую строительная компания сможет получить от продажи всех квартир. Решение можно выполнить на любом современном языке программирования. Допускается использование псевдокода.

[image1]: <data:image/png;base64,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>