use poem::error::{BadRequest, InternalServerError, Unauthorized};
use thiserror::Error;

/// Errors that may be generated by this crate.
/// - Request
/// - Authorization
/// - Header
/// - Server
///    - This is the general server error.
#[derive(Clone, Debug, Error)]
pub enum OxidePoemError {
    /// This is returned when the client request cannot be properly parsed
    #[error("There was a problem with the request")]
    Request,
    /// This is returned when the client request contains an invalid "Authorization" header
    #[error("Invalid Authorization Header")]
    Authorization,
    /// This is for header parsing related errors (server side)
    #[error("Error while parsing header: {0}")]
    Header(String),
    #[error("There was a problem with the server")]
    /// This is the general server error.
    Server,
}

impl From<OxidePoemError> for poem::Error {
    fn from(ox_err: OxidePoemError) -> Self {
        match &ox_err {
            OxidePoemError::Request => BadRequest(ox_err),
            OxidePoemError::Authorization => Unauthorized(ox_err),
            OxidePoemError::Header(_) | OxidePoemError::Server => InternalServerError(ox_err),
        }
    }
}
