<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>

<head>
    <meta charset="UTF-8">
    <title>房屋租赁系统</title>
    <link rel="stylesheet" type="text/css" href="/house/css/common.css"/>
    <link rel="stylesheet" type="text/css" href="/house/css/main.css"/>
    <script type="text/javascript" src="/house/js/libs/modernizr.min.js"></script>
    <script type="text/javascript" src="/house/js/jquery-1.8.3.min.js"></script>
    <script type="text/javascript" src="/house/js/jquery-ui-datepicker.js"></script>
    <script type="text/javascript" src="/house/js/jquery.validate.min.js"></script>
    <link rel="stylesheet" type="text/css" href="/house/css/jquery-ui.css"/>
   <style>
.error {
  font-size:13px;
  color: red;
}
   </style>
    <script type="text/javascript">
    $().ready(function() {
        // 在键盘按下并释放及提交后验证提交表单
        $("#date").datepicker();
        $("#myform").validate({
            rules : {
            	house_id:{
            		required:true,
            		rangelength:[2,10]
            	},
            	address:{
            		required:true,
            		rangelength:[2,50]
            	},
            	date:{
            		required:true,
            	},
            	detail:{
            		required:true,
            		rangelength:[2,500]
            	}
            },
            messages : {
            	house_id:{
            		required:"房屋id不能为空！",
            		rangelength:"房屋id长度必须在2-10之间"
            	},
            	address:{
            		required:"地址不能为空！",
            		rangelength:"地址长度必须在2-50之间"
            	},
            	date:{
            		required:"日期不能为空",
            	},
            	detail:{
            		required:"报障内容不能为空",
            		rangelength:"房报障内容长度必须在2-500之间"
            		
            	}
            }
        });
    })
    
    
	</script>
	
</head>
<body>

<div class="result-title">
<h1>添加报障信息</h1>
</div>
<div class="result-content">
<div class="sidebar-title">
        <form action="/house/wrong/insertwrong.action" method="post" id="myform" name="myform" enctype="multipart/form-data" >
                    <table class="insert-tab" width="100%">
                        <tbody>
                        	<tr>
                                <th><i class="require-red">*</i>房屋id：</th>
                                <td>
                                    <input class="common-text required" value="${zulist.house_id}" id="house_id" name="house_id" size="50" type="text" >
                                </td>
                            </tr>
                            <tr>
                                <th><i class="require-red">*</i>地址：</th>
                                <td><input class="common-text" name="address" value="${zulist.address }" id="address" size="50" type="text" ></td>
                            </tr>
                            <%-- <tr>
                                <th><i class="require-red">*</i>租客姓名：</th>
                                <td><input class="common-text" name="name" value="${zulist.userlist.name }" id="name" size="50" type="text" ></td>
                            </tr> --%>
                           <tr>
                                <th><i class="require-red">*</i>报障日期：</th>
                                <td><input class="common-text" name="date" value="" id="date" size="50" type="text" ></td>
                            </tr>
                             <tr>
                                <th><i class="require-red">*</i>报障内容：</th>
                                <td><textarea class="common-text" name="detail"  id="detail" style="width:430px;height:80px;"></textarea></td>
                            </tr>
                                <input type="hidden" name="userlist_id" id="userlist_id" value="${zulist.userlist_id}"/>
								<tr>
                                <th></th>
                                <td>
                                    <input class="btn btn-primary btn6 mr10" value="提交" type="submit">
                                    <input class="btn btn6" onclick="history.go(-1)" value="返回" type="button">
                                </td>
                            </tr>
							<tr>
                                <font id="error" color="red">${error }</font>
                            </tr>	
                        </tbody></table>
                </form>
          </div>
          </div>
    
</body>
</html>