/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class SqlUtil {
    private static final List<ResultMapping> EMPTY_RESULTMAPPING = new ArrayList<ResultMapping>(0);
    private static final String SUFFIX_PAGE = "_PageHelper";
    private static final String SUFFIX_COUNT = "_PageHelper_Count";
    private static final String PAGEPARAMETER_FIRST = "First_PageHelper";
    private static final String PAGEPARAMETER_SECOND = "Second_PageHelper";
    private static final String PROVIDER_OBJECT = "_provider_object";
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private Parser sqlParser;

    private static MetaObject forObject(Object object) {
        return MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY);
    }

    public SqlUtil(String strDialect) {
        if (strDialect == null || "".equals(strDialect)) {
            throw new IllegalArgumentException("Mybatis\u5206\u9875\u63d2\u4ef6\u65e0\u6cd5\u83b7\u53d6dialect\u53c2\u6570!");
        }
        try {
            Dialect dialect = Dialect.valueOf(strDialect);
            String sqlParserClass = this.getClass().getPackage().getName() + ".SqlParser";
            try {
                Class.forName("net.sf.jsqlparser.statement.select.Select");
                this.sqlParser = (Parser)Class.forName(sqlParserClass).getConstructor(Dialect.class).newInstance(new Object[]{dialect});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.sqlParser == null) {
                this.sqlParser = SimpleParser.newParser(dialect);
            }
        }
        catch (IllegalArgumentException e) {
            String dialects = null;
            for (Dialect d : Dialect.values()) {
                dialects = dialects == null ? d.toString() : dialects + "," + (Object)((Object)d);
            }
            throw new IllegalArgumentException("Mybatis\u5206\u9875\u63d2\u4ef6dialect\u53c2\u6570\u503c\u9519\u8bef\uff0c\u53ef\u9009\u503c\u4e3a[" + dialects + "]");
        }
    }

    public Map setPageParameter(MappedStatement ms, Object parameterObject, Page page) {
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        return this.sqlParser.setPageParameter(ms, parameterObject, boundSql, page);
    }

    public void processCountMappedStatement(MappedStatement ms, SqlSource sqlSource, Object[] args) {
        args[0] = this.getMappedStatement(ms, sqlSource, args[1], SUFFIX_COUNT);
    }

    public void processPageMappedStatement(MappedStatement ms, SqlSource sqlSource, Page page, Object[] args) {
        args[0] = this.getMappedStatement(ms, sqlSource, args[1], SUFFIX_PAGE);
        args[1] = this.setPageParameter((MappedStatement)args[0], args[1], page);
    }

    private MappedStatement getMappedStatement(MappedStatement ms, SqlSource sqlSource, Object parameterObject, String suffix) {
        MappedStatement qs = null;
        try {
            qs = ms.getConfiguration().getMappedStatement(ms.getId() + suffix);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (qs == null) {
            qs = this.newMappedStatement(ms, this.getsqlSource(ms, sqlSource, parameterObject, suffix), suffix);
            try {
                ms.getConfiguration().addMappedStatement(qs);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return qs;
    }

    private MappedStatement newMappedStatement(MappedStatement ms, SqlSource sqlSource, String suffix) {
        String id = ms.getId() + suffix;
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, sqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        if (suffix == SUFFIX_PAGE) {
            builder.resultMaps(ms.getResultMaps());
        } else {
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap resultMap = new ResultMap.Builder(ms.getConfiguration(), id, Integer.TYPE, EMPTY_RESULTMAPPING).build();
            resultMaps.add(resultMap);
            builder.resultMaps(resultMaps);
        }
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public boolean isDynamic(MappedStatement ms) {
        return ms.getSqlSource() instanceof DynamicSqlSource;
    }

    private SqlSource getsqlSource(MappedStatement ms, SqlSource sqlSource, Object parameterObject, String suffix) {
        if (this.isDynamic(ms)) {
            MetaObject msObject = SqlUtil.forObject(ms);
            SqlNode sqlNode = (SqlNode)msObject.getValue("sqlSource.rootSqlNode");
            MixedSqlNode mixedSqlNode = null;
            if (sqlNode instanceof MixedSqlNode) {
                mixedSqlNode = (MixedSqlNode)sqlNode;
            } else {
                ArrayList<SqlNode> contents = new ArrayList<SqlNode>(1);
                contents.add(sqlNode);
                mixedSqlNode = new MixedSqlNode(contents);
            }
            return new MyDynamicSqlSource(ms.getConfiguration(), (SqlNode)mixedSqlNode, suffix == SUFFIX_COUNT);
        }
        if (sqlSource instanceof ProviderSqlSource) {
            return new MyProviderSqlSource(ms.getConfiguration(), (ProviderSqlSource)sqlSource, suffix == SUFFIX_COUNT);
        }
        if (suffix == SUFFIX_PAGE) {
            return this.getPageSqlSource(ms.getConfiguration(), sqlSource, parameterObject);
        }
        return this.getCountSqlSource(ms.getConfiguration(), sqlSource, parameterObject);
    }

    private List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
        ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>();
        newParameterMappings.addAll(boundSql.getParameterMappings());
        newParameterMappings.add(new ParameterMapping.Builder(configuration, PAGEPARAMETER_FIRST, Integer.class).build());
        newParameterMappings.add(new ParameterMapping.Builder(configuration, PAGEPARAMETER_SECOND, Integer.class).build());
        return newParameterMappings;
    }

    private SqlSource getPageSqlSource(Configuration configuration, SqlSource sqlSource, Object parameterObject) {
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new StaticSqlSource(configuration, this.sqlParser.getPageSql(boundSql.getSql()), this.getPageParameterMapping(configuration, boundSql));
    }

    private SqlSource getCountSqlSource(Configuration configuration, SqlSource sqlSource, Object parameterObject) {
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new StaticSqlSource(configuration, this.sqlParser.getCountSql(boundSql.getSql()), boundSql.getParameterMappings());
    }

    public static void testSql(String dialet, String originalSql) {
        SqlUtil sqlUtil = new SqlUtil(dialet);
        String countSql = sqlUtil.sqlParser.getCountSql(originalSql);
        System.out.println(countSql);
        String pageSql = sqlUtil.sqlParser.getPageSql(originalSql);
        System.out.println(pageSql);
    }

    private class MyProviderSqlSource
    implements SqlSource {
        private Configuration configuration;
        private ProviderSqlSource providerSqlSource;
        private Boolean count;

        private MyProviderSqlSource(Configuration configuration, ProviderSqlSource providerSqlSource, Boolean count) {
            this.configuration = configuration;
            this.providerSqlSource = providerSqlSource;
            this.count = count;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            BoundSql boundSql = null;
            boundSql = parameterObject instanceof Map && ((Map)parameterObject).containsKey(SqlUtil.PROVIDER_OBJECT) ? this.providerSqlSource.getBoundSql(((Map)parameterObject).get(SqlUtil.PROVIDER_OBJECT)) : this.providerSqlSource.getBoundSql(parameterObject);
            if (this.count.booleanValue()) {
                return new BoundSql(this.configuration, SqlUtil.this.sqlParser.getCountSql(boundSql.getSql()), boundSql.getParameterMappings(), parameterObject);
            }
            return new BoundSql(this.configuration, SqlUtil.this.sqlParser.getPageSql(boundSql.getSql()), SqlUtil.this.getPageParameterMapping(this.configuration, boundSql), parameterObject);
        }
    }

    private class MyDynamicSqlSource
    implements SqlSource {
        private Configuration configuration;
        private SqlNode rootSqlNode;
        private Boolean count;

        public MyDynamicSqlSource(Configuration configuration, SqlNode rootSqlNode, Boolean count) {
            this.configuration = configuration;
            this.rootSqlNode = rootSqlNode;
            this.count = count;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            DynamicContext context = new DynamicContext(this.configuration, parameterObject);
            this.rootSqlNode.apply(context);
            SqlSourceBuilder sqlSourceParser = new SqlSourceBuilder(this.configuration);
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            SqlSource sqlSource = sqlSourceParser.parse(context.getSql(), parameterType, context.getBindings());
            sqlSource = this.count != false ? SqlUtil.this.getCountSqlSource(this.configuration, sqlSource, parameterObject) : SqlUtil.this.getPageSqlSource(this.configuration, sqlSource, parameterObject);
            BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
            for (Map.Entry entry : context.getBindings().entrySet()) {
                boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
            }
            return boundSql;
        }
    }

    private static class PostgreSQLParser
    extends SimpleParser {
        private PostgreSQLParser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 14);
            sqlBuilder.append(sql);
            sqlBuilder.append(" limit ? offset ?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getPageSize());
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getStartRow());
            return paramMap;
        }
    }

    private static class HsqldbParser
    extends SimpleParser {
        private HsqldbParser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 20);
            sqlBuilder.append(sql);
            sqlBuilder.append(" limit ? offset ?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getPageSize());
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getStartRow());
            return paramMap;
        }
    }

    private static class OracleParser
    extends SimpleParser {
        private OracleParser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
            sqlBuilder.append("select * from ( select tmp_page.*, rownum row_id from ( ");
            sqlBuilder.append(sql);
            sqlBuilder.append(" ) tmp_page where rownum <= ? ) where row_id > ?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getEndRow());
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getStartRow());
            return paramMap;
        }
    }

    private static class MysqlParser
    extends SimpleParser {
        private MysqlParser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 14);
            sqlBuilder.append(sql);
            sqlBuilder.append(" limit ?,?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getStartRow());
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getPageSize());
            return paramMap;
        }
    }

    public static abstract class SimpleParser
    implements Parser {
        public static Parser newParser(Dialect dialect) {
            SimpleParser parser = null;
            switch (dialect) {
                case mysql: 
                case mariadb: 
                case sqlite: {
                    parser = new MysqlParser();
                    break;
                }
                case oracle: {
                    parser = new OracleParser();
                    break;
                }
                case hsqldb: {
                    parser = new HsqldbParser();
                    break;
                }
                default: {
                    parser = new PostgreSQLParser();
                }
            }
            return parser;
        }

        @Override
        public void isSupportedSql(String sql) {
            if (sql.trim().toUpperCase().endsWith("FOR UPDATE")) {
                throw new RuntimeException("\u5206\u9875\u63d2\u4ef6\u4e0d\u652f\u6301\u5305\u542bfor update\u7684sql");
            }
        }

        @Override
        public String getCountSql(String sql) {
            this.isSupportedSql(sql);
            StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
            stringBuilder.append("select count(*) from (");
            stringBuilder.append(sql);
            stringBuilder.append(") tmp_count");
            return stringBuilder.toString();
        }

        @Override
        public abstract String getPageSql(String var1);

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map<String, Object> paramMap = null;
            if (parameterObject == null) {
                paramMap = new HashMap();
            } else if (parameterObject instanceof Map) {
                paramMap = (Map)parameterObject;
            } else {
                paramMap = new HashMap();
                boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass());
                MetaObject metaObject = SqlUtil.forObject(parameterObject);
                if (ms.getSqlSource() instanceof MyProviderSqlSource) {
                    paramMap.put(SqlUtil.PROVIDER_OBJECT, parameterObject);
                }
                if (!hasTypeHandler) {
                    for (String name : metaObject.getGetterNames()) {
                        paramMap.put(name, metaObject.getValue(name));
                    }
                }
                if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                    for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                        String name = parameterMapping.getProperty();
                        if (name.equals(SqlUtil.PAGEPARAMETER_FIRST) || name.equals(SqlUtil.PAGEPARAMETER_SECOND) || paramMap.get(name) != null) continue;
                        if (hasTypeHandler || parameterMapping.getJavaType().equals(parameterObject.getClass())) {
                            paramMap.put(name, parameterObject);
                            continue;
                        }
                        try {
                            paramMap.put(name, metaObject.getValue(name));
                        }
                        catch (Exception e) {}
                    }
                }
            }
            return paramMap;
        }
    }

    public static interface Parser {
        public void isSupportedSql(String var1);

        public String getCountSql(String var1);

        public String getPageSql(String var1);

        public Map setPageParameter(MappedStatement var1, Object var2, BoundSql var3, Page var4);
    }

    public static enum Dialect {
        mysql,
        mariadb,
        sqlite,
        oracle,
        hsqldb,
        postgresql;

    }
}

