/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Page;
import com.github.pagehelper.SqlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;

public class SqlParser
implements SqlUtil.Parser {
    private static final List<SelectItem> COUNT_ITEM = new ArrayList<SelectItem>();
    private static final Alias TABLE_ALIAS;
    private SqlUtil.Parser simpleParser;
    private Map<String, String> CACHE = new ConcurrentHashMap<String, String>();

    public SqlParser(SqlUtil.Dialect dialect) {
        this.simpleParser = SqlUtil.SimpleParser.newParser(dialect);
    }

    @Override
    public void isSupportedSql(String sql) {
        this.simpleParser.isSupportedSql(sql);
    }

    @Override
    public String getCountSql(String sql) {
        this.isSupportedSql(sql);
        return this.parse(sql);
    }

    @Override
    public String getPageSql(String sql) {
        return this.simpleParser.getPageSql(sql);
    }

    @Override
    public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
        return this.simpleParser.setPageParameter(ms, parameterObject, boundSql, page);
    }

    public String parse(String sql) {
        if (this.CACHE.get(sql) != null) {
            return this.CACHE.get(sql);
        }
        Statement stmt = null;
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            String countSql = this.simpleParser.getCountSql(sql);
            this.CACHE.put(sql, countSql);
            return countSql;
        }
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        this.processSelectBody(selectBody);
        this.processWithItemsList(select.getWithItemsList());
        this.sqlToCount(select);
        String result = select.toString();
        this.CACHE.put(sql, result);
        return result;
    }

    public void sqlToCount(Select select) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect && !this.selectItemsHashParameters(((PlainSelect)selectBody).getSelectItems()) && ((PlainSelect)selectBody).getGroupByColumnReferences() == null) {
            ((PlainSelect)selectBody).setSelectItems(COUNT_ITEM);
        } else {
            PlainSelect plainSelect = new PlainSelect();
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody(selectBody);
            subSelect.setAlias(TABLE_ALIAS);
            plainSelect.setFromItem((FromItem)subSelect);
            plainSelect.setSelectItems(COUNT_ITEM);
            select.setSelectBody((SelectBody)plainSelect);
        }
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getPlainSelects() != null && operationList.getPlainSelects().size() > 0) {
                List plainSelects = operationList.getPlainSelects();
                for (PlainSelect plainSelect : plainSelects) {
                    this.processPlainSelect(plainSelect);
                }
            }
            if (!this.orderByHashParameters(operationList.getOrderByElements())) {
                operationList.setOrderByElements(null);
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processWithItemsList(List<WithItem> withItemsList) {
        if (withItemsList != null && withItemsList.size() > 0) {
            for (WithItem item : withItemsList) {
                this.processSelectBody(item.getSelectBody());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoin() != null && subJoin.getJoin().getRightItem() != null) {
                this.processFromItem(subJoin.getJoin().getRightItem());
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    public boolean selectItemsHashParameters(List<SelectItem> selectItems) {
        if (selectItems == null) {
            return false;
        }
        for (SelectItem selectItem : selectItems) {
            if (!selectItem.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    static {
        COUNT_ITEM.add((SelectItem)new SelectExpressionItem((Expression)new Column("count(*)")));
        TABLE_ALIAS = new Alias("table_count");
        TABLE_ALIAS.setUseAs(false);
    }
}

