/*
 * Decompiled with CFR 0.152.
 */
package cn.itcast.utils;

import cn.itcast.utils.Page;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class NavigationTag
extends TagSupport {
    static final long serialVersionUID = 2372405317744358833L;
    private String bean = "page";
    private String url = null;
    private int number = 5;

    public int doStartTag() {
        JspWriter writer = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Page page = (Page)request.getAttribute(this.bean);
        if (page == null) {
            return 0;
        }
        try {
            this.url = this.resolveUrl(this.url, this.pageContext);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            int pageCount = page.getTotal() / page.getSize();
            if (page.getTotal() % page.getSize() > 0) {
                ++pageCount;
            }
            writer.print("<nav><ul class=\"pagination\">");
            if (page.getPage() > 1) {
                String preUrl = this.append(this.url, "page", page.getPage() - 1);
                preUrl = this.append(preUrl, "rows", page.getSize());
                writer.print("<li><a href=\"" + preUrl + "\">\u4e0a\u4e00\u9875</a></li>");
            } else {
                writer.print("<li class=\"disabled\"><a href=\"#\">\u4e0a\u4e00\u9875</a></li>");
            }
            int indexPage = page.getPage() - 2 > 0 ? page.getPage() - 2 : 1;
            int i = 1;
            while (i <= this.number && indexPage <= pageCount) {
                if (indexPage == page.getPage()) {
                    writer.print("<li class=\"active\"><a href=\"#\">" + indexPage + "<span class=\"sr-only\">(current)</span></a></li>");
                } else {
                    String pageUrl = this.append(this.url, "page", indexPage);
                    pageUrl = this.append(pageUrl, "rows", page.getSize());
                    writer.print("<li><a href=\"" + pageUrl + "\">" + indexPage + "</a></li>");
                }
                ++indexPage;
                ++i;
            }
            if (page.getPage() < pageCount) {
                String nextUrl = this.append(this.url, "page", page.getPage() + 1);
                nextUrl = this.append(nextUrl, "rows", page.getSize());
                writer.print("<li><a href=\"" + nextUrl + "\">\u4e0b\u4e00\u9875</a></li>");
            } else {
                writer.print("<li class=\"disabled\"><a href=\"#\">\u4e0b\u4e00\u9875</a></li>");
            }
            writer.print("</nav>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private String append(String url, String key, int value) {
        return this.append(url, key, String.valueOf(value));
    }

    private String append(String url, String key, String value) {
        if (url == null || url.trim().length() == 0) {
            return "";
        }
        url = url.indexOf("?") == -1 ? String.valueOf(url) + "?" + key + "=" + value : (url.endsWith("?") ? String.valueOf(url) + key + "=" + value : String.valueOf(url) + "&amp;" + key + "=" + value);
        return url;
    }

    private String resolveUrl(String url, PageContext pageContext) throws Exception {
        if (url != null) {
            url = new String(url.getBytes("iso8859-1"), "utf-8");
        }
        Map params = pageContext.getRequest().getParameterMap();
        for (Object key : params.keySet()) {
            Object value;
            if ("page".equals(key) || "rows".equals(key) || (value = params.get(key)) == null) continue;
            if (value.getClass().isArray()) {
                url = this.append(url, key.toString(), new String(((String[])value)[0].getBytes("iso8859-1"), "utf-8"));
                continue;
            }
            if (!(value instanceof String)) continue;
            url = this.append(url, key.toString(), new String(value.toString().getBytes("iso8859-1"), "utf-8"));
        }
        return url;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setNumber(int number) {
        this.number = number;
    }
}

