# Hearthstone-Deck-Tracker
[![Build status](https://ci.appveyor.com/api/projects/status/3wow545sjaq9ybji/branch/master?svg=true)](https://ci.appveyor.com/project/azeier/hearthstone-deck-tracker/branch/master)

Hearthstone Deck Tracker is an automatic deck tracker and deck manager for Hearthstone.

## Installation
- Requirements:
  - Windows Vista or higher
  - .NET Framework 4.5 or higher
- [Download and run the installer](https://hsdecktracker.net/download/).

## Community & Troubleshooting
- [Follow HDT on Twitter](https://twitter.com/hsdecktracker)
- Join the Community Discord: [![Join HearthSim Community Discord](https://discordapp.com/api/guilds/265636998700728321/widget.png)](https://discord.gg/hearthsim)
- You can find the [FAQ here](https://github.com/HearthSim/Hearthstone-Deck-Tracker/wiki/FAQ).
- Streamers: Please read [Streaming instructions for OBS and XSplit](https://github.com/HearthSim/Hearthstone-Deck-Tracker/wiki/Streaming-Instructions) and [Twitch extension setup](https://hsdecktracker.net/twitch/setup/).
- HSReplay.net integration: Please email <support@hsdecktracker.net> for support.

## Contributing
- Please read the [coding style and Commit/Pull Request guidelines](https://github.com/HearthSim/Hearthstone-Deck-Tracker/blob/master/CONTRIBUTING.md).
- Developer Discord: [![joindeveloper#hdt](https://discordapp.com/api/guilds/195326447118712832/widget.png)](https://discord.gg/hearthsim-devs)
- Hearthstone Deck Tracker is a [HearthSim](https://hearthsim.info) project.

## Features
An in-game overlay:

![Overlay](https://github.com/HearthSim/Hearthstone-Deck-Tracker/raw/master/raw-assets/readme/overlay.png "Overlay")

The app: 

![Tracker](https://github.com/HearthSim/Hearthstone-Deck-Tracker/raw/master/raw-assets/readme/hdt-ui.png "HDT UI")

- **Tracks**:
  - Cards left in your deck or cards drawn from your deck.
  - Your handcount, deckcount and draw chances.
  - Cards played by your opponent.
  - Your opponent's handcount, deckcount and probablities of him having/drawing cards.
  - How long your opponent had each card in his hand and what cards have been mulliganed, stolen or returned.  
- **Timer** for the current turn and total time spent for you and your opponent.  
- The tracker tries to **automatically select the deck you are playing**.  
- The cards and timer can either be displayed in an overlay (see screenshot) or in **extra windows** (Options > General > Additional Windows)  
- **Deck Manager**:
  - **Import** decks from websites: arenavalue, hearthstats, hearthpwn, hearthhead, hearthstoneplayers, tempostorm, hearthstonetopdeck and hearthnews  
  - Circumvent the 27 deck limit: Saved decks can be **exported to Hearthstone**. (My Decks > More...)
  - Decks can be filtered by custom **tags** and sorted by name, date and tags.  
  - Set **notes** for each deck (My Decks > More...)  
  - Create **screenshots** of decks (My Decks > More...)  
  - **Share** your decks by exporting them as xml files or id-strings (My Decks > More...). Both can be imported via New Deck > Import.  
- **Notifications**: get notified when a game or a turn starts (either by the tray icon flashing or hearthstone popping up)  
- **Customization**: Almost every feature can be turned on/off separately.
- **Extensible via plugins**: [available plugins](https://github.com/HearthSim/Hearthstone-Deck-Tracker/wiki/Available-Plugins)
- **Stats per deck**:
  - Track the result of each game (win/loss), opponents, game mode and more
  - Win/loss rate vs each class.
  - Details for each game (cards drawn, played, etc.).
  - Select which game modes to track (Options > Other).  
  - Import your opponent's (partial) deck from a tracked game as a new deck.

![Stats](https://i.imgur.com/Wke3Cuw.png "Deck stats")


## License

Copyright © [HearthSim](https://hearthsim.net). All Rights Reserved.
