## **Release v1.36.2 - 2024-10-30**
**Fixes**:
- Fixed an issue with setting the initial language configuration.
- Fixed handling of Zilliax Deluxe 3000 when creating related cards.
- Fixed an issue where Lady Liadrin related cards were not resetting after a match.

## **Release v1.36.1 - 2024-10-29**
**Updated for Hearthstone 31.0.0**

**Hearthstone**:
- Added support for cards that will be recasted by Mistah Vistah effect.
- Added support to new expansion cards.\
  *Asteroids, Kil'jaeden, Librams, Ingenious Artificer, Ace Wayfinder, Astrobiologist, Space Pirate, Starlight Wanderer, Stranded Spaceman, Askara, Lucky Coment, Spacerock Collector, Planetary Navigator, Foreboding Flame, Infernal Stratagem,  Expedition Sergeant, Unyielding Vindicator, Wakener Of Souls, Dirdra Rebel Captain, Emergency Meeting,  Headhunt, Voronei Recruiter, Velen Leader Of The Exiled, Yrel Beacon Of Hope, Scrounging Shipwright, Starship Schematic, Archimonde, Xortoth Breaker Of Stars, Talgath, Astral Vigilant*

## **Release v1.36.0 - 2024-10-23**
**Hearthstone**:
- Added tooltips for related cards.\
  *Hovering over cards in hand or deck now shows their related cards. These tooltips will automatically appear for opponents when relevant.*
- Added related cards for: \
  *Return Policy, Hydration Station, Pet Parrot, Product 9, Sasquawk, Stranglethorn Heart, Rewind, Commander Sivara, The Galactic Projection Orb, Tyr, Tyr's Tears, Lady Liadrin, Tess Greymane, Shudderwock, Inventor Boom, Photographer Fizzle, Tidepool Pupil.*
- Implemented Fizzle's Snapshot to track cards as the opponent plays them.
- Updated the elemental turn sequence counter card image to a more fitting one.
- Fixed an issue where cast spells were counted towards "Played Spells" counters.
- Fixed an issue that counters appeared in inappropriate game modes.
- Fixed an issue where card marks displayed incorrect icons when drawn by a blacklisted card.

## **Release v1.35.3 - 2024-10-17**
**Updated for Hearthstone 30.6.2**

## **Release v1.35.1 - 2024-10-11**

**Hearthstone**:
- Tweaked when to show Summoned Dragons and Spell Schools counters.
- Added tourist related cards to the counter system.
- Fixed active effects showing on top of counters.
- Fixed counter text cropping in some cases.

## **Release v1.35.0 - 2024-10-10**
**Updated for Hearthstone 30.6.0**

**Hearthstone**:
- Added new-style counters! They will automatically pop up when they're relevant in a game and feature rich tooltips appropriate to the current game state.\
  *We're still working on making them individually configurable but wanted to share our current progress with you. The old counters are still temporarily available but have been moved to the Advanced options.*
- Added counters for: Abyssal Curse, Astral Automaton, Chaotic Tendril, C'Thun, Elemental turns in a row, Excavate, Fatigue, Galakrond, Jade Display, Jade Golems, Librams, Played Spell Schools, Played Spells, Pogo Hopper, Damage taken on your turns, Summoned Dragons and Wheel of Death.
- Added filtering to "Drawn By" card marks in the opponent's hand to cut down on unimportant information (such as non-tutored draws).
- Added a new icon to the opponents hand to better differentiate a card's identity from the identity of the card that drew it.
- Fixed an info leak related to forged cards that where shuffled into the opponents deck and drawn again later.

**Battlegrounds**:
- Add a counter to show the current Blood Gem size.

## **Release v1.34.0 - 2024-09-26**
**Updated for Hearthstone 30.4.3**

**Hearthstone**:
- Added card mark for Forged cards in the opponent's hand.
- Fixed tourists appearing twice in the opponent's deck list.

**Battlegrounds**:
- Added Battlegrounds Trinket picking stats to the overlay!\
  *Try this feature for free with your weekly Tier7 trials and subscribe to Tier7 for unlimited access.*
- Fixed various simulation interactions between Persistent Poet and All minions.

## **Release v1.33.2 - 2024-09-19**

**Hearthstone**:
- Show the tourist in the opponent's deck list when they play a tourist card.
- Fixed the attack counter sometimes ignoring Windfury and Mega-Windfury.
- Fixed the deck list not correctly updating for plagues with Augmented Elekk.

## **Release v1.33.0 - 2024-09-10**
**Updated for Hearthstone 30.4.0**

**Hearthstone**:
- Fixed some active effects appearing having an unnecessary counter (e.g. Tar Slick).

## **Release v1.32.2 - 2024-09-06**
**General**:
- Fixed a silent crash that affected certain devices after playing a few matches.

**Battlegrounds**:
- Increased the maximum simulation time when Leapfroggers are present.

## **Release v1.32.1 - 2024-09-04**
**Overlay**:
- New Overlay Masking Feature: Introduced a mask that automatically hides the tracker overlay when a specific game UI element is focused. This feature ensures the tracker is more seamlessly integrated with the game interface, reducing clutter and enhancing immersion.

**Hearthstone**:
- New Active Effects Indicator: Added a visual indicator to the overlay to show when game effects are present.
- Show exact card counts, even when there's more than 9 cards in the deck.
- Fixed Plagues not being tracked correctly after playing Helya.
- Fixed Plagues not being removed from the deck list when playing Steamcleaner.

**Battlegrounds:**
- Automatically show Tavern Tier 7 in the Battlegrounds minion browser when Pagle's Fishing Rod or Thorim's Hero Power is offered.
- Fixed Brann Bronzebeard having a golden star in the Battlegrounds minion browser.
- Fixed minions from Tavern Tier 7 not appearing when filtering for a specific minion type.

**Streaming:**
- Added a streaming-specific masking setting for the capturable overlay. This setting allows you to choose whether the overlay should be masked when streaming or not.\
  *You'll find this setting under Options > Streaming > Capturable Overlay*

## **Release v1.31.5 - 2024-08-29**
**Updated for Hearthstone 30.2.2**

**Overlay**:
- Fixed an issue where the "Always show Tavern Tier 7" setting for Battlegrounds was disabled.
- Fixed Rylak Metalhead's card text being outdated in the Battlegrounds minion browser.

**Battlegrounds**:
- Fixed a simulation issue when Flourishing Frostling triggers Moss of the Schloss.
- Fixed a simulation crash when the Boom Controller trinket was present.

## **Release v1.31.3 - 2024-08-27**
**Battlegrounds**:
- Fixed a major simulation issue with the Bronze Timepiece trinket.
- Fixed trinkets from Souvenir Stand not being incorporated into the simulations.

## **Release v1.31.1 - 2024-08-25**
**Battlegrounds**:
- Automatically show Tavern Tier 7 in the Battlegrounds minion browser when you have Pagle's Fishing Rod.
- Added a setting to always show Tavern Tier 7 in the Battlegrounds minion browser.\
  *You'll find this setting under Options > Overlay > Battlegrounds > Always show Tavern Tier 7.*
- Added support for the Blood Golem Sticker trinket.
- Fixed a simulation crash that could cause the odds to spin forever.

**Streaming**:
- Fixed hero powers not being hoverable on the Twitch Extension.
- Added full trinket support in an upcoming version of the Twitch Extension.\
  *Until then, your viewers can hover the weapon slot to see the latest trinket.*
- Added support for Cho'Gall anomalies in an upcoming version of the Twitch Extension.

## **Release v1.31.0 - 2024-08-20**
**Updated for Hearthstone 30.2.0**

**Overlay**:
- Added golden cards to the Battlegrounds minion browser: hover over the cards for a little longer to see the golden version.
- Slightly reduced the number of games shown in the session recap from 10 to 8 to free up some vertical screen space.

**Battlegrounds**:
- Added over 70 implementations for the new trinkets and new or updated cards.\
  *We'll be monitoring the simulation accuracy and will likely issue another update within the coming days.*

**Streaming**:
- Added basic trinket support to the Twitch Extension so that viewers can hover one of the trinkets on the stream.\
  *We're working on an update to the extension so that viewers can hover both trinkets as you'd expect.*

## **Release v1.30.3 - 2024-08-08**
**Updated for Hearthstone 30.0.3**

## **Release v1.30.2 - 2024-08-05**
**Hearthstone**:
- Fixed the Mulligan Guide popup in the bottom right corner not appearing correctly.
- Fixed Arena decks with unknown cards being stuck in a broken state after an expansion release.

## **Release v1.30.1 - 2024-08-02**
**Deck Tracker**:
- Fixed a number of recent cards not showing what the opponent added to their hand.
- Fixed Snake Oil appearing twice in the opponent's deck list after trading.
- Fixed the spell school counter not automatically appearing for Shaman decks with Razzle-Dazzler.
- Fixed the underlying issue causing Arena decks to be repeatedly imported when a new set is released.

**Overlay**:
- Fixed the full screen overlay being misaligned when screen scaling was enabled on a second monitor.
- Fixed card tooltips to not appear in the correct place when hovering the opponent's deck list.
- Fixed hover zones for card marks in the opponent's hand sometimes being too small.
- Fixed an issue causing the Mulligan Guide box to be misaligned in the deck picker for Warlock decks with runes (from Tourist).

## **Release v1.30.0 - 2024-07-17**
**Updated for Hearthstone 30.0.0**

Arena players may have noticed the deck tracker repeatedly importing decks that contained cards from the new expansion.
This issue is resolved for now as this update contains the new cards, but we'll fix the underlying issue in a future update.

**New**:
- Added initial deck tracking support for Perils in Paradise cards. More to come soon!
- Added Tourist support to the deck builder.

**Fixes**:
- Fixed the Excavate counter not appearing for all Excavate cards.
- Fixed an issue where the Tier7 hero picking overlay would have conflicting hover zones.
- Fixed the Twitch Extension not allowing viewers to hover the buddy button.

## **Release v1.29.9 - 2024-07-12**
**Fixes**:
- Tier7 setting not affecting Composition Stats visibility.

## **Release v1.29.8 - 2024-07-11**
**Fixes**:
- Tier7 Composition Stats visibility.

## **Release v1.29.7 - 2024-07-11**
**New**:
- Hide Hero Picking overlay covering up buddies.
- Added Tier7 Composition Stats!

**Fixes**:
- Remove obsolete tooltip from Hero Picking tiers.

**Bob's Buddy**:
- Fixed incorrect simulation results in Duos due to partial combat.

## **Release v1.29.6 - 2024-07-05**
**Fixes**:
- Fixed an issue causing automatic deck importing to not update premade decks, such as Twist and Loaner decks.
- Fixed a memory leak that could cause a sudden crash after a long session of interacting with the Battlegrounds minion browser.

**Bob's Buddy**:
- Fixed an issue where minions exclusive to Duos would prevent simulations even when not playing Duos.

## **Release v1.29.5 - 2024-06-27**
**Updated for Hearthstone 29.6.2**

**Bob's Buddy**:
- Fixed incorrect simulation results due to Sky Pirate (Scallywag's summon).
- Fixed incorrect simulation results due to Sr. Tomb Diver.

## **Release v1.29.4 - 2024-06-21**
**Bob's Buddy**:
- Fixed incorrect simulation results in Duos due to minions being unable to attack.
- Fixed incorrect simulation results due to Teron Gorefiend's hero power (Rapid Reanimation).

## **Release v1.29.3 - 2024-06-20**
**Bob's Buddy**:
- Fixed incorrect simulation results due to Tarecgosa.
- Fixed incorrect simulation results due to Golden Persistent Poet.
- Fixed incorrect simulation results due to Sky Pirate (Scallywag's summon).
- Fixed incorrect simulation results due to Teron Gorefiend's hero power (Rapid Reanimation).

## **Release v1.29.2 - 2024-06-17**
**Updated for Hearthstone 29.6.0**

**Fixes**:
- Fixed an issue where counters from traditional Hearthstone would be shown in Battlegrounds.

## **Release v1.29.1 - 2024-06-11**
**New**:
- Show Fatigue Counter in more circumstances (such as when playing Insanity Warlock).
- Make it easier to sign in to HSReplay.net after subscribing to Tier7.

**Fixes**:
- Fixed an issue where Bob's Buddy would not update after an Akazamzarak secret was revealed.
- Fixed an issue where Bob's Buddy would enter an invalid state when conceding during hero selection.

## **Release v1.29.0 - 2024-06-03**
**New**:
- Added Tier7 Hero Picking stats in Duos!
- Added Bob's Buddy in Duos!\
  *You may occasionally see a partial result, in case where we don't see one of the teammates.*

**Changes**:
- Limit how fast HDT catches up with the game, which should prevent sudden HDT crashes in very complex Battlegrounds games.

## **Release v1.28.6 - 2024-05-31**
**Fixes**:
- Fixed a crash when closing Hearthstone.

## **Release v1.28.5 - 2024-05-31**
**New**:
- Added automatic deck importing for the new Twist season!
- Added automatic deck importing for Loaner decks!

## **Release v1.28.4 - 2024-05-30**
**Fixes**:
- Fixed a memory leak that could cause the deck tracker to crash mid-game.
- Fixed an issue where the session recap would show really bad Duos losses as 5th place.
- Fixed an issue where Twitch VODs would not appear on HSReplay.net.

**Bob's Buddy**:
- Fixed various minor simulation issues.

## **Release v1.28.3 - 2024-05-23**
**Updated for Hearthstone 29.4.2**

**Fixes**:
- Fixed Bargain Bin not appearing as a possible secret.
- Added extra logging to help us investigate certain types of bugs.

## **Release v1.28.2 - 2024-05-18**
**Bob's Buddy**:
- Fixed opposing Boon of Beetles not being simulated correctly.
- Fixed various minor simulation issues.

## **Release v1.28.1 - 2024-05-17**
**New**:
- Start tracking the last known board state in Battlegrounds Duos!\
  *Hover over heroes on the leaderboard as usual to see the last board you encountered.*

**Fixes**:
- Fixed an issue causing the last known board state in Battlegrounds sometimes showing a board from the wrong hero.
- Fixed an issue causing the death counter in Battlegrounds to sometimes be misaligned.

## **Release v1.28.0 - 2024-05-14**
**Updated for Hearthstone 29.4.0**

## **Release v1.27.3 - 2024-05-13**
**New**:
- Switched the tiers shown in Battlegrounds hero picking overlay to a new and improved methodology.\
  *Hero tiers are now one of S, A, B, C, D and F. The S and F tiers are very rare and will only appear for true outliers.*
- Visual improvements to the Battlegrounds hero picking overlay.

**Bob's Buddy**:
- Added support for Boon of Beetles.
- Fixed incorrect simulation results when the opponent had multiple secrets.

## **Release v1.27.2 - 2024-05-10**
**Fixes**:
- Ensure the Battlegrounds Compare Heroes popup uses the same filters as the hero picking overlay.

**Bob's Buddy**:
- Fixed various simulation issues.

## **Release v1.27.1 - 2024-05-08**
**New**:
- Added Duos support to the Battlegrounds session recap.\
  *Duos support for Bob's Buddy and the hero picking overlay are being worked on!*

**Fixes**:
- Fixed automatic deck importing for Whizbang the Wonderful.\
  *Whizbang the Splendiferous and Zayle, Shadow Cloak will follow in a future update.*
- Fixed the Battlegrounds hero picking popup not disappearing after a disconnect.
- Improved the reliability of detecting the available minion types in Battlegrounds.

**Bob's Buddy**:
- Fixed incorrect lethal rates due to an issue detecting the damage cap.
- Fixed incorrect simulation results due to Fleeting Vigor.
- Fixed incorrect simulation results due to Teron Gorefiend's hero power.

## **Release v1.27.0 - 2024-04-25**
**Updated for Hearthstone 29.2.2**

## **Release v1.26.1 - 2024-04-23**

**Fixes**:
- Fixed "All" type minions missing from the Battlegrounds minion list when filtering for a specific minion type.
- Fixed decks containing certain Zilliax Deluxe 3000 cosmetics not showing HSReplay.net statistics.
- Fixed duplicate tooltips in the overlay when deck window card tooltips were enabled.
- Fixed various crashes related to the Battlegrounds overlay.

**Bob's Buddy**:
- Fixed incorrect simulation results due to Pack Tactics.
- Fixed incorrect simulation results due to Golden Goose.
- Fixed incorrect simulation results due to Silithid Burrower.
- Fixed incorrect simulation results due to Teron Gorefiend's hero power (Rapid Reanimation).

## **Release v1.26.0 - 2024-04-18**

**New**:
- Added a button to filter the Battlegrounds minion list by minion type!

**Fixes**:
- Fixed an issue causing the Battlegrounds Hero Picking overlay to not align with the heroes.
- Fixed an issue causing Duos-exclusive Battlegrounds minions to appear in the normal Battlegrounds minion list.
- Fixed an issue causing the Twitch Extension to show incorrect card tooltips while you viewed your teammate's board in Duos.
- Fixed plugin compatibility in Duos.

## **Release v1.25.4 - 2024-04-16**
**Updated for Hearthstone 29.2.0**

**Notes**:
- Most Battlegrounds features are disabled in Duos right now. We'll be investigating what's possible in the coming days!

**New**:
- Added a new setting to show the available Minion Types in the Battlegrounds session panel!

**Fixes**:
- Fixed an issue causing the Twitch Extension to generate incomplete deck codes if Zilliax Deluxe 3000 was in the deck.
- Fixed an issue causing the Mulligan Guide to not show data for Zilliax Deluxe 3000.

## **Release v1.25.3 - 2024-03-28**
**Updated for Hearthstone 29.0.3**

## **Release v1.25.2 - 2024-03-27**
**Fixes**:
- Fixed a memory leak that could cause the deck tracker to crash mid-game.
- Fixed a long-standing issue that could cause long games (especially Battlegrounds) to go missing.
- Fixed an issue causing Zilliax Deluxe 3000 to appear in the deck list twice after drawing it.
- Fixed an issue causing new core secrets to not appear in the secret tracker.

## **Release v1.25.1 - 2024-03-19**
**New**:
- Added support for Zilliax Deluxe 3000's custom cost in the deck list.

**Fixes**:
- Fixed an issue causing E.T.C.'s Band to appear when Zilliax was in the deck.
- Fixed an issue causing the deck list to continuously reset when playing a Whizbang deck.
- Fixed an issue causing decks with cards from Caverns of Time or Legacy to not be flagged as Wild.

## **Release v1.25.0 - 2024-03-19**
**Updated for Year of the Pegasus**

## **Release v1.24.9 - 2024-03-13**
- Fixed an issue that could cause deck that are legal in Standard to appear in the Wild section.

## **Release v1.24.8 - 2024-03-12**
- Fixed a crash related to Arena runs with new cards.

## **Release v1.24.7 - 2024-03-11**
**Updated for Hearthstone 29.0.0**
- Updates for the release of Whizbang's Workshop and the Standard rotation will follow!

## **Release v1.24.6 - 2024-02-22**
**Updated for Hearthstone 28.6.2**

## **Release v1.24.5 - 2024-02-19**
**Fixes**:
- Battlegrounds: Fixed an issue where the "Minions Banned" component showed the wrong minion types.
- Battlegrounds: Fixed an issue where the hero picking overlay did not disappear immediately upon choosing a hero.

## **Release v1.24.4 - 2024-02-18**
**Fixes**:
- Fixed an issue that could cause the mulligan popup to appear twice.
- Fixed an issue causing the Wild icon to appear on decks with Gift cards and/or Harth Stonebrew.

## **Release v1.24.3 - 2024-02-17**
**Bob's Buddy**:
- Enable combat simulations for Diremuck Forager when the opponent's board is full.

**Changes**:
- Started using data more appropriate for the current MMR in the Tier7 quest and hero picking overlays.

**Fixes**:
- Fixed an issue where the Tier7 quest overlay would not appear.
- Fixed an issue where the in-menu Battlegrounds overlays would appear and disappear at incorrect times.

## **Release v1.24.2 - 2024-02-14**
**Fixes**:
- Fixed an issue that could cause the deck lists to disappear.

## **Release v1.24.1 - 2024-02-13**
**Updated for Hearthstone 28.6.0**
- There are likely still issues with some new cards in Bob's Buddy. We will update these in the coming days.
- The Battlegrounds Quest Picking Overlay will return as soon as there's enough data for quests.

**New**:
- Added an in-game Mulligan Guide for HSReplay.net Premium subscribers! This feature is available in Ranked, Casual, Friendly Challenge and Arena.

**Fixes**:
- Fixed an issue where secrets would be incorrectly grayed out when dormant minions or portals were on the board.
- Fixed an issue where Plagues moving into the opponent's hand through effects such as Sir Finley, Sea Guide were unintentionally revealed.

## **Release v1.23.15 - 2024-01-29**
**Updated for Hearthstone 28.4.1**

**Fixes**:
- Fixed Summoning Ward not appearing in the Mage secret tracker.
- Fixed an issue where the attack counter incorrectly accounted for Mega-Windfury despite Silence (e.g. a silenced Walking Mountain).
- Fixed an issue causing the "Know your opponent's deck?" prompt to stay up when entering menus.

## **Release v1.23.15 - 2024-01-19**
**Bob's Buddy**:
- Fixed an issue that caused Bob's Buddy to get stuck on turn 1.

## **Release v1.23.13 - 2024-01-18**
**Updated for the release of Delve into Deepholm**

**Changes**:
- Hide card counters and card marks during the mulligan phase.

**Bob's Buddy**:
- Added support for Murozond (via Rylak).

## **Release v1.23.12 - 2024-01-08**
**Fixes**:
- Fixed a long-standing issue where a duplicate overlay could appear on slower devices.

**Bob's Buddy**:
- Fixed an issue where Admiral Eliza Goreblade was not simulated correctly.

## **Release v1.23.11 - 2023-12-19**
**Updated for Hearthstone 28.2.3**

**Changes**:
- Reworked how Whizbang decks are imported, making HDT support new decks immediately when future expansions are released!
- Show tavern tier 7 in the minion list overlay when Thorim, Stormlord is offered.

**Bob's Buddy**:
- Fixed an issue where the Recurring Nightmare deathrattle was not taken into account if it was added to another minion in the shopping phase.

## **Release v1.23.10 - 2023-12-13**
**New**:
- Battlegrounds: Added support for Venomous and Reborn to the Last Known Board and Final Board features.

**Changes**:
- Battlegrounds: Improved the behaviour of the Bob's Buddy panel at the end of a match.

**Fixes**:
- Fixed an issue causing the popup with a link to the Mulligan guide sometimes incorrectly identifying the First/Coin state.
- Battlegrounds: Fixed an issue causing the hero picking overlay and popup not disappearing when HDT was started during the hero picking phase.

## **Release v1.23.9 - 2023-12-10**
**Fixes**:
- Fixed an issue where tooltips from the sideboard would appear even if the deck list is hidden.
- Fixed an issue where the attack counters would not correctly handle Mega Mountain.

**Bob's Buddy**:
- Fixed an issue where Battlecries from Rylak Metalhead were not simulated correctly after being triggered by Hawkstrider Herald.
- Fixed various simulation issues related to recently introduced and updated cards.

## **Release v1.23.8 - 2023-12-08**
**Updated for Hearthstone 28.2.1**

**Bob's Buddy**:
- Added support for spell triggers during combat (such as extra battlecries/deathrattles and start of combat effects).
- Fixed an issue where Audacious Anchor could crash the simulation.

## **Release v1.23.7 - 2023-12-07**
**New**:
- Added Battlegrounds spells to the Battlegrounds minion list overlay!

**Fixes**:
- Fixed an issue where the deck builder did not show neutral cards.
- Fixed an issue where some cards in the Battlegrounds minion list were missing their card art.
- Fixed an issue where the Twitch Extension would not work properly with boards containing Battlegrounds spells.

## **Release v1.23.6 - 2023-12-05**
**Updated for Hearthstone 28.2**

**Bob's Buddy**:
- There are likely still issues with some new cards in Bob's Buddy. We will update these in the coming days.

## **Release v1.23.5 - 2023-12-04**
**Changes**:
- The Battlegrounds minion overlay no longer shows minions from tavern tier 7 unless Secrets of Norgannon is active.

**Fixes**:
- Fixed an issue that caused the deck builder to not show appropriate multi-class cards.

**Bob's Buddy**:
- Added support for Fairy Tale Caroler's Battlecry (with Rylak Metalhead).

## **Release v1.23.4 - 2023-11-29**
**Updated for Hearthstone 28.0.3**

**Fixes**:
- Fixed an issue where Snipe occasionally did not appear as a valid secret.
- Fixed an issue where the Spell School counter overlay settings did not persist properly.
- Fixed an issue where Love Everlasting and similar cards were not treated as spells.

## **Release v1.23.3 - 2023-11-23**
**New**:
- Added a spell school counter!

**Fixes**:
- Fixed an issue where Sigils were not treated as spells.

**Bob's Buddy**:
- Improved secret handling by showing the odds immediately and recalculating whenever secrets are revealed (similar to Free-Flying Feathermane).
- Fixed an issue where Admiral Eliza Goreblade was not simulated correctly.

## **Release v1.23.1 - 2023-11-15**
**Fixes**:
- Fixed an issue causing the secret tracker to show Wild secrets in Standard.
- Fixed the HSReplay.net settings not showing Tier7 subscriptions.

## **Release v1.23.0 - 2023-11-14**
**Updated for the release of Showdown in the Badlands**

**New**:
- Added Excavate counters.
- Added support for a number of older cards.

## **Release v1.22.12 - 2023-11-08**
**Updated for Hearthstone 28.0**

**Changes**:
- The Battlegrounds minion overlay is now available during hero picking.

## **Release v1.22.11 - 2023-10-26**
**Updated for Hearthstone 27.6.2**

**Fixes**:
- Improved reliability of the available secrets for specific game modes.
- Fixed an issue where the attack counters were not correctly handling Titans.
- Fixed an issue where Plagues were not correctly added back to the deck when Helya is in play.

## **Release v1.22.10 - 2023-10-17**
**Updated for Hearthstone 27.6**

**Bob's Buddy**:
- There are likely still issues with some new cards in Bob's Buddy. We will update these in the coming days.

## **Release v1.22.9 - 2023-10-16**
**Fixes**
- Fixed Battlegrounds minion types not appearing in the correct language.
- Fixed a state in which HDT would excessively try to fetch remote data.

## **Release v1.22.8 - 2023-10-10**
**Bob's Buddy**
- Fixed an issue where Choral Mrrrglr was not simulated correctly.

## **Release v1.22.7 - 2023-10-01**
**Fixes**
- Fixed an issue where Battlegrounds games were sometimes not recorded in the Session Recap.

## **Release v1.22.6 - 2023-09-29**
**Fixes**
- Fixed an occasional crash on Hearthstone startup.

## **Release v1.22.5 - 2023-09-28**
**Updated for Hearthstone 27.4.2**

## **Release v1.22.3 - 2023-09-25**
- Improved stability.

## **Release v1.21.12 - 2023-09-20**
**Bob's Buddy**
- Fixed an issue where the Blessed or Blighted anomaly was not simulated correctly.

## **Release v1.21.11 - 2023-09-19**
**Updated for Hearthstone 27.4.0**

**Fixes**
- Fixed an issue where randomly cast cards with Dredge could unintentionally reveal the affected cards.
- Fixed the C'Thun counter.

**Bob's Buddy**
- Fixed an issue where Mannoroth and Murcules were not simulated correctly after being attacked.
- Fixed an issue where Frostwolf Lieutenant was simulated according to outdated card text.

## **Release v1.21.10 - 2023-09-08**
- Added missing Caverns of Time icon.

**Bob's Buddy**
- Fixed some rare interactions crashing the simulation.
- Fixed various card issues related to cards updated in Hearthstone 27.2.2.

## **Release v1.21.9 - 2023-09-05**
- Added Caverns of Time filter to deck editor.

**Bob's Buddy**
- Fixed an issue with a player having multiple Recurring Nightmares.
- Fixed various card issues related to cards updated in Hearthstone 27.2.2.

## **Release v1.21.8 - 2023-08-30**
**Updated for Hearthstone 27.2.2**

## **Release v1.21.7 - 2023-08-25**
- Minions that are banned in a given anomaly are now marked as such in the Battlegrounds minion list.

**Bob's Buddy**
- Fixed Bob's Buddy reappearing when Free-Flying Feathermane is summoned by the opponent.
- Fixed further issues related to cards and mechanics added with Hearthstone 27.2.0.

## **Release v1.21.6 - 2023-08-24**
- Restored the Tier7 hero picking overlay with Anomaly support.

**Bob's Buddy**
- Fixed further issues related to cards and mechanics added with Hearthstone 27.2.0.

## **Release v1.21.5 - 2023-08-23**
- Added Anomaly support to the Twitch Extension.

**Fixes**
- Fixed an issue where the label for E.T.C.'s band would be visible on launch.
- Fixed missing sideboards when copying a deck from the Twitch Extension.

**Bob's Buddy**
- Added support for Murky.
- Fixed various issues related to cards and mechanics added with Hearthstone 27.2.0.
- Fixed an issue where Menagerie Mug, Menagerie Jug and Tide Oracle Morgl could crash the simulation.

## **Release v1.21.4 - 2023-08-22**
**Bob's Buddy**
- Added support for the new Minions and Anomalies.
- There are likely still issues with some new cards. We will update these in the coming days.

## **Release v1.21.3 - 2023-08-22**
**Partially updated for Hearthstone 27.2.0**
- The new minions are now available in the Battlegrounds overlay
- An initial update for Bob's Buddy will follow soon!

## **Release v1.21.2 - 2023-08-18**
- Preparations for the upcoming Hearthstone patch 27.2.

## **Release v1.21.1 - 2023-08-09**
- Added support for an upcoming HSReplay.net feature

**Bob's Buddy**:
- Added support for Annihilan Battlemaster

## **Release v1.21.0 - 2023-08-01**
**Updated for the release of TITANS**

**Fixes**
- Fixed an issue where Buddy tooltips were still shown to viewers on Twitch

## **Release v1.20.18 - 2023-07-25**
**Updated for Hearthstone 27.0.0**

## **Release v1.20.17 - 2023-07-16**
**Bob's Buddy**:
- Fixed an issue where buffs to cards in hand were not working correctly. This was leading to various incorrect 99% predictions.

## **Release v1.20.15 - 2023-07-14**
**Bob's Buddy**:
- Fixed an issue where some Hero Power Start of Combat effects could be resolved in an incorrect order.

## **Release v1.20.14 - 2023-07-13**
**Fixes**:
- Fixed an issue where the Tier7 Quest overlay was not working correctly.

## **Release v1.20.13 - 2023-07-12**
**Bob's Buddy**:
- Fixed an issue where Tavish Stormpike's Hero Power was dealing an incorrect amount of damage.
- Fixed an issue where Teron Gorefiend's Hero Power was sometimes resummoning the minion in the wrong position.
- Fixed an issue where Ghoul of the Feast was triggering too often.

## **Release v1.20.12 - 2023-07-11**
**Bob's Buddy**:
- Updated with support for the new Quests and Quest Rewards.
- Fixed an issue where the initial board state used for simulations could be slightly incorrect in some cases.
- We are actively investigating simulation issues and should have more improvements soon!

## **Release v1.20.11 - 2023-07-06**
**Updated for Hearthstone 26.6.2**

## **Release v1.20.10 - 2023-06-27**
**Updated for Hearthstone 26.6.0**

## **Release v1.20.9 - 2023-06-15**
**Updated for Hearthstone 26.4.3**

## **Release v1.20.8 - 2023-06-01**
**Fixes**:
- Fixed an issue where old games were potentially parsed when starting HDT.

## **Release v1.20.7 - 2023-05-31**
**Updated for Hearthstone 26.4.0**

## **Release v1.20.5 - 2023-05-31**
**Restores functionality for Hearthstone 26.4.0**
- Another update for the new card data will follow.

**Bob's Buddy**:
- Fixed an issue where Scourfin was unnecessarily preventing simulations.
- Fixed an issue where Mantid Queen was not working correctly.

## **Release v1.20.3 - 2023-05-30**
**Bob's Buddy**:
- Added support for many Battlecry interactions with Rylak Metalhead
- Fixed various issues related to cards and mechanics added with Hearthstone 26.2.0.

## **Release v1.20.2 - 2023-05-19**
**Updated for Hearthstone 26.2.2**

## **Release v1.20.1 - 2023-05-11**
**Bob's Buddy**:
- Fixed various issues related to cards and mechanics added with Hearthstone 26.2.0.

## **Release v1.20.0 - 2023-05-10**
**Updated for Hearthstone 26.2.0**

**Bob's Buddy**:
- There are likely still issues with some new cards in Bob's Buddy. We will update these in the coming days.
- Interactions with Battlecries (Rylak Metalhead) are currently unsupported.
- Interactions with unknown cards in the opponents hand (e.g. Bassgill or Scourfin) are currently unsupported.

## **Release v1.19.24 - 2023-04-27**
**Updated for Hearthstone 26.0.4**

## **Release v1.19.23 - 2023-04-14**
**Updated for Hearthstone 26.0.2**

## **Release v1.19.22 - 2023-04-12**
**Fixes**:
- Fixed an issue where decks with Festival of Legends cards were marked as Wild.
- Fixed an issue where ETC sideboard overlay was not showing correctly.

## **Release v1.19.21 - 2023-04-11**
**Updated for Year of the Wolf**

**Changes**:
- Added support for the majority of new cards.

## **Release v1.19.20 - 2023-04-04**
**Updated for Hearthstone 26.0.0**

## **Release v1.19.19 - 2023-03-29**
- Added support for E.T.C Band Manager in overlay.

## **Release v1.19.17 - 2023-03-23**
**Updated for Hearthstone 25.6.2**

**Fixes**:
- Fixed an issue where the expected damage range displayed by Bob's Buddy did not quite match the explanation in the tooltip.
- Fixed an issue where Tribe-less supporting minions in Battlegrounds would be displayed when their Tribe was not available in the current lobby.

## **Release v1.19.16 - 2023-03-14**
**Updated for Hearthstone 25.6.0**

## **Release v1.19.15 - 2023-03-02**
**Updated for Hearthstone 25.4.3**

## **Release v1.19.14 - 2023-02-15**
**Bob's Buddy**:
- Fixed an issue where Teron Gorefiends Hero Power was not working correctly.

## **Release v1.19.13 - 2023-02-14**
**Updated for Hearthstone 25.4.0**

## **Release v1.19.12 - 2023-01-26**
**Updated for Hearthstone 25.2.2**

## **Release v1.19.11 - 2023-01-20**
**Bob's Buddy**:
- Fixed various issues related to cards and mechanics added with Hearthstone 25.2.0.

## **Release v1.19.10 - 2023-01-19**
**Bob's Buddy**:
- Fixed an issue where dual-type minions were not working correctly.
- Fixed an issue where Rot Hide Gnoll was not working correctly.

**Fixes**:
- Fixed an issue where the 5th banned Tribe was not appearing in the Session Recap panel.

## **Release v1.19.9 - 2023-01-18**
**Bob's Buddy**:
- Added support for Putricide's Creations.
- Fixed various issues related to Hearthstone 25.2.0.

## **Release v1.19.8 - 2023-01-17**
**Updated for Hearthstone 25.2.0**

**Notes**:
- There are likely still issues with some new cards in Bob's Buddy. We will update these in the coming days.

## **Release v1.19.7 - 2022-12-19**
**Updated for Hearthstone 25.0.4**

## **Release v1.19.6 - 2022-12-13**
**Changes**:
- Added a setting to show/hide menu Overlays while Hearthstone is in the background. Defaults to hidden.
- Added a setting to disable the Tier7 overlay functionality entirely.
- Added a setting to disable the Tier7 MMR and "Go to my stats" panel.

## **Release v1.19.5 - 2022-12-07**
**Fixes**:
- Fix an issue where cards consumed by the players Souleater's Scythe were revealed before the mulligan.
- Fix an issue where cards consumed by the opponents Souleater's Scythe were revealed at all.

## **Release v1.19.4 - 2022-12-06**
**Changes**:
- Added an option to disable the Battlegrounds Quest Reward Composition stats.

**Fixes**:
- Fix an issue where the Tier7 Pre-Game overlay could cover parts of the in-game Shop, Season Rewards, Friendslist and Quest UIs.

## **Release v1.19.2 - 2022-12-05**
**New**:
- Added Battlegrounds Hero and Quest Reward stats to the Overlay!

## **Release v1.19.1 - 2022-12-02**
**Added support for March of the Lich King**

## **Release v1.19.0 - 2022-11-29**
**Fixes**:
- Restored general functionality for Hearthstone 25.0.0.

## **Release v1.18.27 - 2022-11-22**
**Updated how Khadgar interacts with Evil Twin in Bob's Buddy**

## **Release v1.18.26 - 2022-11-10**
**Updated for Hearthstone 24.6.2**

**Fixes**:
- Fixed various Bob's Buddy simulation issues related to Hearthstone 24.6.0.

## **Release v1.18.25 - 2022-11-03**
**Fixes**:
- Fixed an issue in Bob's Buddy where Volatile Venom was not working correctly.
- Fixed an issue where Venomstrike Trap and Frozen Clone were not showing up in the secret tracker.

## **Release v1.18.24 - 2022-11-01**
**Updated for Hearthstone 24.6.0**

## **Release v1.18.23 - 2022-10-13**
**Updated for Hearthstone 24.4.3**

## **Release v1.18.22 - 2022-09-29**
**Added support for Dual and Neutral classes on Duels stats machups table**
**Added support for Maw and Disorder secrets**
**Fixed an issue where secrets were excluded from the list when Tight-Lipped Witness was in play**
**Fixed several issues in Bob's Buddy related to Hearthstone 24.4.0**

## **Release v1.18.21 - 2022-09-27**
**Updated for Hearthstone 24.4.0**

## **Release v1.18.20 - 2022-09-09**
**Updated for Hearthstone 24.2.2**

## **Release v1.18.19 - 2022-09-06**
**Fixes**:
- Fixed various more Bob's Buddy simulation issues related to Hearthstone 24.2.0.

## **Release v1.18.18 - 2022-09-01**
**Fixes**:
- Fixed various more Bob's Buddy simulation issues related to Hearthstone 24.2.0.

## **Release v1.18.17 - 2022-08-31**
**Fixes**:
- Fixed various Bob's Buddy simulation issues related to Hearthstone 24.2.0.
- Fixed an issue where the opponents Battlegrounds Hero was not correctly appearing in the Twitch Extension.
- Fixed an issue where multiple Battlegrounds Quests were not correctly appearing in the Twitch Extension.

## **Release v1.18.16 - 2022-08-30**
**Fixes**:
- Fixed an issue in Bob's Buddy where Quest Rewards would sometimes incorrectly be considered active.
- Fixed an issue where Quest Rewards were not appearing in the Twitch Extension.

## **Release v1.18.14 - 2022-08-30**
**Updated for Hearthstone 24.2.0**

**Fixes**:
- Fixed an issue where it was revealed that the opponent was playing Renathal during mulligan.

**Notes**:
- There are likely still issues with some new cards in Bob's Buddy. We will update these in the coming days.
- Tooltips for vaious Battlegrounds cards may still be missing but should start appearing soon.
- The experience progress bar has been disabled until we are able to update it for this patch.


## **Release v1.18.13 - 2022-08-16**
**Updated for Hearthstone 24.0.3**

**Fixes**:
- Fixed an issue where Secrets countered by Blademaster Okami were not handled correctly.

## **Release v1.18.12 - 2022-08-03**
**Fixes**:
- Fixed an issue where Location cards were not working correctly with the Twitch Extension.
- Fixed an issue where the chosen cards of Suspicious Alchemist/Usher/Pirate was revealed.

## **Release v1.18.10 - 2022-08-01**
**Added support for Murder at Castle Nathria**

## **Release v1.18.9 - 2022-07-26**
**Updated for Hearthstone 24.0.0**

## **Release v1.18.8 - 2022-07-12**
**Fixes**:
- Fixed an issue where Battlegrounds Session Recap was not respecting some settings

## **Release v1.18.6 - 2022-06-27**
**Updated for Hearthstone 23.6.0**

## **Release v1.18.5 - 2022-06-16**
**Updated for Hearthstone 23.4.3**

**New**:
- Added a Battlegrounds Session Recap overlay & window, showing Banned Minions, MMR changes, and Recent Games.
- Added a counter for Abyssal Curse

**Fixes**:
- Fixed an issue where Mirror Entity was displayed in Standard games.
- Fixed an issue where information about cards discarded by Immolation was unintentionally revealed.

## **Release v1.18.4 - 2022-06-01**
**Fixes**:
- Fixed an issue where the Ozumat Hero Power was not working correctly.

## **Release v1.18.3 - 2022-06-01**
**Updated for Hearthstone 23.4.0**

**New**:
- Hovering an opponent in Battlegrounds will now display their Tavern-Up and Triple history.

## **Release v1.18.2 - 2022-05-19**
**Updated for Hearthstone 23.2.2**

**Fixes**:
- Fixed an issue where cards added to the top or bottom of the deck by From the Depths were not tracked correctly.

## **Release v1.18.1 - 2022-05-10**
**Fixes**:
- Fixed a remaining issue from the 23.2.0 patch where players were not correctly detected, leading e.g. to missing game results.

## **Release v1.18.0 - 2022-05-10**
**Updated for Hearthstone 23.2.0**

**Fixes**:
- Fixed an issue where Questline parts were counting towards the spell counter.

## **Release v1.17.14 - 2022-05-03**
**Fixes**:
- Fixed an issue where the dredge card panels were missing in some cases.

## **Release v1.17.13 - 2022-04-26**
**Updated for Hearthstone 23.0.3**

## **Release v1.17.12 - 2022-04-14**
**New**
- Cards added to the top or bottom of the deck, e.g. by Dredge or Azsharan cards, are now displayed next to the deck list.
  - These additonal panels can be moved or disabled under "options > overlay > player".
  - The following cards are currently not supported and will clear these panels to avoid displaying inaccurate information: Sir Finley Sea Guide, Ambassador Faelin, Sphere of Sapience, and Sightless Watcher.

## **Release v1.17.11 - 2022-04-12**
**Updated for Year of the Hydra**

**Changes**:
- Added support for the majority of new cards.

Dredge support coming soon!


## **Release v1.17.10 - 2022-04-05**
**Updated for Hearthstone 23.0.0**

## **Release v1.17.9 - 2022-03-18**
**Fixes**:
- Fixed an issue where uploading the Mercenaries collection was no longer working after patch 22.6.0.

## **Release v1.17.8 - 2022-03-17**
**Updated for Hearthstone 22.6.0**

## **Release v1.17.7 - 2022-03-03**
**Updated for Hearthstone 22.4.3**

## **Release v1.17.6 - 2022-02-15**
**Updated for Hearthstone 22.4.0**

## **Release v1.17.5 - 2022-02-08**
**Updated for Hearthstone 22.2.2**

**Fixes**:
- Fixed an issue where the indicator for how long Battlegrounds opponents have been dead was misaligned when Hero Skins were present in the lobby.

## **Release v1.17.4 - 2022-02-01**
**Changes**:
- The Twitch Extension now shows the Buddy when hovering the Buddy Meter in Battlegrounds.

**Bob's Buddy**:
- Tarecgosa now retains the 'Immune while attacking' buff, while the game has this behavior.
- Fixed an issue where the additional reborn minions summond by Arfus had an incorrect amount of health.
- Fixed an issue where attack and health values could overflow.

## **Release v1.17.3 - 2022-01-25**
**Bob's Buddy**:
- Fixed various issues related to Spirit Raptor, Sr. Tomb Diver, Elementium Squirrel Bomb, and Arfus.
- Fixed an issue with the interaction between Rafaam's Hero Power and Peggy Brittlebone.
- Fixed an issue where deaths of multiple Scallywags were not resolved in the correct order in specific edge cases.

## **Release v1.17.2 - 2022-01-25**
**Bob's Buddy**:
- Fixed various issues related to Spirit Raptor, Baby Y'Shaarj, Sr. Tomb Diver and Eclipsion Illidari.
- Fixed an issue with the resolution order of Bru'Kan's Hero Power.
- Fixed an issue with the interaction between golden Tarecgosa and Whelp Smuggler.
- Fixed an issue introduced in today's update where Fragrant Phylactery would trigger without being activated.
- Known issue: Piloted Whirl-O-Tron is not yet implemented.

## **Release v1.17.1 - 2022-01-25**
**Updated for Hearthstone 22.2.0**

**Bob's Buddy**:
- Added initial support for all Buddies. Fixes for any issues related to Buddies will follow shortly.


## **Release v1.17.0 - 2022-01-19**
**New**:
- You can now view your [Mercenaries Collection on HSReplay.net](https://hsreplay.net/mercenaries/collection/mine/?utm_source=hdt&utm_medium=client&utm_campaign=update_notes)

## **Release v1.16.19 - 2022-01-18**
**Fixes**:
- Fixed an issue where hotkeys were not working correctly.

**Bob's Buddy**:
- Fixed an issue where Mechano-Tank would target the wrong minion.
- Fixed various issues related to resolution order of effects.

## **Release v1.16.16 - 2022-01-04**
**Bob's Buddy**:
- Fixed an issue where Fish of N'Zoth was not copying all types of Deathrattles correctly.
- Fixed an issue where Cattlecarp of N'Zoth was not working.
- Fixed an issue where extra Deathrattles from Baron Rivendare would resolve too early.
- Fixed an issue where Avenge effects would resolve too early.
- Fixed an issue where golden Impulsive Trickster would always target the same minion twice.
- Fixed an issue where Grease Bot would buff the target before damage was dealt.
- Fixed an issue with the interaction between Greybough's Hero Power and Khadgar.
- Fixed an issue where Prestor's Pyrospawn woud trigger on non-dragon minions and itself.
- Fixed an issue where the 15 damage cap was still applied incorrectly in many cases when determining lethal rates.

## **Release v1.16.13 - 2021-12-20**
**Updated for Hearthstone 22.0.2**

## **Release v1.16.12 - 2021-12-17**
**Bob's Buddy**:
- Fixed various interactions with Peggy Brittlebone.
- Fixed an issue where various Avenge effects would trigger too often.
- Fixed an issue where Tamsin Roame's Hero Power could target the wrong minion.
- Fixed an issue where Impulsive Trickster would not pass on the correct amount of health when buffed.
- Fixed an issue where Sewer Rat was not considered to have a Deathrattle effect.
- Fixed an issue where the 15 damage cap was applied incorrectly in many cases when determining lethal rates.

## **Release v1.16.11 - 2021-12-06**
**Fixes**:
- Fixed an issue where the turn timer could be visible during Mercenaries games.

**Changes**:
- Added support for Alterac Valley cards.

## **Release v1.16.10 - 2021-11-30**
**Updated for Hearthstone 22.0.0**

## **Release v1.16.9 - 2021-11-19**
**Fixes**
- Fixed an issue where importing Duels decks was not working correctly.
- Improved Bob's Buddy performance for Diablo.
- Improved Bob's Buddy speed.
- Improved Bob's Buddy performance when two players with secrest enter combat.

## **Release v1.16.8 - 2021-11-16**
**Updated for Hearthstone 21.8.0**

**Fixes**
- Fixed an issue where the Mercenaries game overlay would sometimes stay visible after the end of a game.
- Fixed an issue where some Plugins would not receive game events.

## **Release v1.16.7 - 2021-11-07**
**Fixes**
- Fixed Bob's Buddy's interaction with Diablo.
- Fixed issue where overlay could sometimes block the "back" button when playing Mercenaries.

## **Release v1.16.6 - 2021-11-02**
**Updated for Hearthstone 21.6.0**


## **Release v1.16.5 - 2021-10-31**
**Fixes**
- Fixed an issue where the Attack counter would be displayed during Mercenaries gameplay.
- Fixed an issue where hovering the Minion Tier icons in Battlegrounds would not work correctly at resolutions above 1080p.


## **Release v1.16.4 - 2021-10-28**

**Fixes**
- Fixed an issue where the "set opponent deck" panel in friendly games would be difficult to interact with in some cases.

**Mercenaries**:
- Added a "Tasks" icon to the overlay that displays the list of current tasks and their progress on hover.


## **Release v1.16.3 - 2021-10-21**
**Updated for Hearthstone 21.4.4**

**Fixes**
- Fixed an issue with the "damage on board" calculations when playing heroes with a weapon (e.g. Jaraxxus).

**Mercenaries**:
- Added icons above/below each Mercenary showing their Abilites with current Speed and Cooldown. Works for PvP and PvE.
- Updated the Mercenaries hovers to show the actual level of an ability if it has been revealed.
- Updated the Mercenaries hovers to show abilities for all PvE opponents.
- All Mercenaries related overlay features can now individually be disabled under `options > overlay > mercenaries`.


## **Release v1.16.2 - 2021-10-14**
**Fixes**
- Fixed a few issues related to Mercenaries.

## **Release v1.16.0 - 2021-10-12**
**Updated for Hearthstone 21.4.0**

**Mercenaries**:
- Added initial support for Mercenaries.
- Hovering the opposing Mercenaries in PVP will display their 3 Abilities on the side of the screen.
- More will follow in the coming days and weeks!

## **Release v1.15.9 - 2021-09-21**
**Updated for Hearthstone 21.3.0**

**Fixes**
- Improve Bob's Buddy preformance.

## **Release v1.15.8 - 2021-09-14**
**Fixes**
- Improve Bob's Buddy preformance.
- Fix issue where Judgement of Justice would be removed from the secret list after the player's hero attacked.
- Fix issue where HDT would display when an opponent drew Pack Mule in their mulligan.

## **Release v1.15.7 - 2021-09-07**
**Fixes**
- Improve Bob's Buddy preformance.

## **Release v1.15.6 - 2021-09-03**
**Fixes**
- Fix other accuracy issues with Bob's Buddy.

## **Release v1.15.5 - 2021-09-02**
**Fixes**
- Fix accuracy issues with Bob's Buddy.

## **Release v1.15.4 - 2021-09-02**
**Bob's Buddy**
- Added a data quality warning about simulation results. We are actively working on improvements.

## **Release v1.15.3 - 2021-08-31**
**Updated for Hearthstone 21.2.0**

## **Release v1.15.2 - 2021-08-17**
**Updated for Hearthstone 21.0.3**

**Fixes**:
- Fixed various issues related to tracking secrets.
- Fixed an issue where tradable cards were not tracked correctly.

## **Release v1.15.1 - 2021-08-03**
**Fixes**:
- Fixed an issue where HDT did not count games played against an opponent with Maestra as games against a Rogue.
- Fixed an issue where the battlegrounds overlay would not work with hero skins in some cases.
- Fixed an issue where questlines were not considered quests.

## **Release v1.15.0 - 2021-07-27**
**Updated for Hearthstone 21.0.0**

## **Release v1.14.27 - 2021-07-15**
**Updated for Hearthstone 20.8.2**
**Fixes**:
- Fixed issue where the secret Judgement of Justice wouldn't be tracked.
- Fixed issue where Bob's Buddy would have problems detecting the Lich King hero power.
- Fixed issue where linking the opponent's deck would occasionally be duplicated.

## **Release v1.14.26 - 2021-07-06**
**New**:
- The opponent deck list can now be set in friendly games. This can be enabled for all game modes under `options > overlay > opponent`.
- Added support for Spanish as a language for the overlay.

## **Release v1.14.25 - 2021-07-01**
**Updated for Hearthstone 20.8.0**

## **Release v1.14.24 - 2021-06-28**
**New**:
- Added ability to handle opponent secrets for Bob's Buddy.
- Added tracking for what effect drew cards in the opponent's hand.
**Fixes**:
- Fixed issue where the opponent spell tracker would occasionally break.

## **Release v1.14.22 - 2021-06-23**
**Fixes**
- Bob's Buddy improvements.

## **Release v1.14.21- 2021-06-16**
**Updated for Hearthstone 20.4.2**
**Fixes**
- Fixed bug where Agamaggan the Great Boar was classified as a beast in the battlegrounds minion menu.

## **Release v1.14.20- 2021-06-14**
**Fixes**
- Fixed crash related to previous secret tracker update.

## **Release v1.14.19- 2021-06-13**
**Fixes**
- Fixed crashes related to previous secret tracker update.

## **Release v1.14.17- 2021-06-13**
**Fixes**
- Fix issue with Reckoning being removed as a possible secret when the damage dealer dies.
- Fix issue with secrets triggered by spells being removed by spells cast by Sparkjoy Cheat.

## **Release v1.14.16- 2021-06-03**
**Updated for Hearthstone 20.4.0**

## **Release v1.14.15- 2021-05-25**
**Fixes**
- Fix text of libram option.

## **Release v1.14.14- 2021-05-22**
**Fixes**
- Bob's Buddy improvements.

## **Release v1.14.13- 2021-05-19**
**New**
- Added tracker for cost reductions to librams.
- Added tracking for cost reductions from Efficient Octo-bot.
**Fixes**
- Fixed Rigged Faire Game not being removed from possible secrets when the opponent only lost armor.
- Bob's Buddy improvements.

## **Release v1.14.12- 2021-05-12**
**Updated for Hearthstone 20.2.2**

## **Release v1.14.11- 2021-05-05**
**Fixes**
- Added card tiles for new Battlegrounds cards.

## **Release v1.14.10 - 2021-05-04**
**Updated for Hearthstone 20.2.0**

## **Release v1.14.9 - 2021-05-04**
**Fixes**
- Fixed an issue related to the Hearthstone 20.2 patch that would cause the app to freeze. Another update for the Battlegrounds changes will follow shortly

## **Release v1.14.8 - 2021-04-13**
**Updated for Hearthstone 20.0.2**
**New**
- Added mulligan toast for constructed games.
**Fixes**
- Fixed an issue where "Rank 1" spells were not tracked correctly.

## **Release v1.14.6 - 2021-04-10**
**Fixes**
- Fix issue where old secrets would incorrectly appear as available in Standard.
- Fix issue where a secret transformed by Oh My Yogg would still cause the secret list to appear.
- Fix issue where Rigged Faire Game would occasionally incorrectly be ruled out a possible secret.
- Fix issue where Oasis Ally could appear as having been ruled out as a possible secret during their turn if they played Hysteria.

## **Release v1.14.4 - 2021-04-03**
**Fixes**
- Add Demon Hunter Initiate to wild.
- Add support for diamond cards
- Fix playing against opponents with hidden names

## **Release v1.14.3 - 2021-03-31**
**Fixes**
- Fix issue where Ashes of Outland was mistakenly moved to wild.
- Fix Bob's Buddy issue with Barrens Blacksmith.

## **Release v1.14.2 - 2021-03-30**
**Fixes**
- Add support for Forged in the Barrens.

## **Release v1.14.1 - 2021-03-30**
**Fixes**
- Add support for secrets in Classic.
- Prevent a duplicate murloc tidecaller from appearing in the Battlegrounds minion tiers.
- Stop a data leak where cards discarded by opponent trackings would be visible in their decklist.
- Fix an issue where Bob's Buddy could occasionally crash.
- Fix an issue with tracking Competitive Spirit and Open the Cages.

## **Release v1.14.0 - 2021-03-25**
**Updated for Hearthstone 20.0.0**
**Fixes**:
- Fixed various Hearthstone patch related issues to restore general functionality. More fixes and updates for the patch will follow soon.

## **Release v1.13.27 - 2021-03-08**
**Fixes**:
- Fixed an issue where the xp bar could fill up over and over again on startup.
- Improved Bob's Buddy.
- Fix issue where card images could download again even when the image already existed.


## **Release v1.13.26 - 2021-02-19**
**Updated for Hearthstone 19.6.0.74257 **

## **Release v1.13.25 - 2021-01-29**
**Fixes**:
- Fixed an issue C'Thun The Shattered pieces were added to the wrong deck.

## **Release v1.13.24 - 2021-01-28**
**Updated for Hearthstone 19.4.1.72661**
**Fixes**
- Fixed an issue where Bob's Buddy would sometimes miss-use Greybough's hero power with reborn

## **Release v1.13.23 - 2021-01-25**
**New**
- Upgraded cards in decklist to show full card images on hover
**Fixes**
- Fixed an issue where Shenanigans might be removed from possible secrets late

## **Release v1.13.22 - 2021-01-21**
**Updated for Hearthstone 19.4.0.71003**
**New**
- Added an indicator for how long Battlegrounds Opponents have been dead.

## **Release v1.13.21 - 2021-01-08**
**Updated for Hearthstone 19.2.1.70828**
**Fixes**
- Fixed an issue where player's could see cards created by C'thun The Shattered in their opponents' hands.

## **Release v1.13.20 - 2020-12-18**
**New**:
- Added experience bar.
**Fixes**:
- Improved Bob's Buddy for most recent patch.

## **Release v1.13.19 - 2020-12-15**
**Fixes**:
- Fixed an issue where playing against or with Fish of N'Zoth could cause Bob's Buddy to not run that turn.

## **Release v1.13.18 - 2020-12-15**
**Updated for Hearthstone 19.2.0.68600**

## **Release v1.13.17 - 2020-12-04**
**Fixes**:
- Restore option to not show flavor text on card hover.

## **Release v1.13.16 - 2020-11-24**
**Fixes**:
- Fixed an issue where Darkmoon Faire secrets might not appear as possible opponent secrets.

## **Release v1.13.15 - 2020-11-18**
**New**:
- Added card and secret tracking for Darkmoon Faire.

## **Release v1.13.14 - 2020-11-13**
**Fixes**:
- Fixed an issue where the Capturable Overlay (for streamers) could move around when e.g. hovering opponents in Battlegrounds.
- Fixed an issue where Bob's Buddy mistook the player's board.

## **Release v1.13.13 - 2020-11-12**
**Updated for Hearthstone 19.0.0.65614**

## **Release v1.13.12 - 2020-11-08**
**Fixes**:
- Fixed an issue where viewing opponent boards would ocassionally cause HDT to crash.

## **Release v1.13.11 - 2020-11-05**
**Updated for Hearthstone 18.6.1.65000**

**New**:
- Added support for the new Duels game mode.

**Changes**:
- Improved the way past opponent boards in Battlegrounds are displayed.

## **Release v1.13.10 - 2020-10-28**
- Added support for upcoming Tier7 feature

## **Release v1.13.9 - 2020-10-22**
**Updated for Hearthstone 18.6.0.63160**
-Fix an issue where past known Battlegrounds boards wouldn't appear in custom lobbies.
-Support for Duels game mode will be coming soon!

## **Release v1.13.8 - 2020-09-08**
**Updated for Hearthstone 18.4.2.62331**

## **Release v1.13.7 - 2020-10-07**

**Bob's Buddy**
-Add information about the average damage given and taken in combat.
-Fix an issue where Wildfire Elemental would sometimes damage the wrong minion.
-Fix an issue where golden Crackling Cyclone's would sometimes not get Mega Windfury.

## **Release v1.13.6 - 2020-09-29**
**Updated for Hearthstone 18.4.0.60352**


## **Release v1.13.5 - 2020-09-08**
**Updated for Hearthstone 18.2.0.58213**

**Fixes**:
- Fixed an issue where Bob's Buddy might crash when facing Lich King.


## **Release v1.13.4 - 2020-09-03**

**Bob's Buddy**
- Added additional instrumentation to track down Lich King prediction inaccuracies.


## **Release v1.13.3 - 2020-09-01**

**Fixes**:
- Fixed an issue where additional secrets could be greyed out when the opponent had multiple secrets in play and Counterspell was triggered.
- Fixed an issue where Aranna Starseeker's last board was not tracked between transforming to Aranna, Unleashed.

**Bob's Buddy**
- Fixed an issue where activations of Lich King's hero power would occasionally be missed.


## **Release v1.13.2 - 2020-08-18**
**Updated for Hearthstone 18.0.2.56359**

**Fixes**:
- Fixed an issue where Zoobot would still appear on the Battlegrounds minion list.
- Fixed an issue where HDT would not work while playing Millhouse Manastorm with the Korean localization of Hearthstone.
- Fixed an issue where drawing Transfer Student would add another copy to the deck.


## **Release v1.13.1 - 2020-08-06**

**Changes**:
- Added support for Plagiarize.
- Added tracking support for most Scholomance Academy cards.


## **Release v1.13.0 - 2020-07-20**
**Updated for Scholomance Academy**


## **Release v1.12.17 - 2020-07-20**

**Fixes**:
- Fixed an issue where HDT would not correctly start on Windows 10, version 2004.


## **Release v1.12.16 - 2020-07-14**
**Updated for Hearthstone 17.6.0.53261**

**Bob's Buddy**:
-Fixed an issue where Khadgar-copied Sky Pirates wouldn't trigger Arcane Cannons.
-Fixed an issue where Waxrider Toggwaggle would be able to save itself after being hit by a cleave minion (in response to Blizzard server-side changes).
-Fixed an issue where a Baron Rivendare killed in the same attack as a Deathrattle minion wouldn't double the Deathrattle.


## **Release v1.12.14 - 2020-07-08**

**Bob's Buddy**:
- Fixed an issue where Khadgar paired with a Scallywag would summon too few Sky Pirates.


## **Release v1.12.13 - 2020-07-02**

**Bob's Buddy**:
- Fixed an issue where King Bagurgle triggered by Monstrous Macaw would buff itself.
- Fixed an issue where duplicate Hero Powers would not stack (e.g. Deathwing vs Sir Finnley).
- Fixed an issue where Deflect-o-Bot Divine Shield trigger did not correctly interact with Deathrattles.
- Updated Khadgar to be able to duplicate minions with Reborn (this was a server-side change by Blizzard).


## **Release v1.12.12 - 2020-06-18**
**Updated for Hearthstone 17.4.1.51510**

**Fixes**:
 - Fixed an issue where Zoobot might get duplicated in the minions list in Battlegrounds games without Mechs.

**Bob's Buddy**:
- Fixed an issue where Bob's Buddy was not working when spectating Battlegrounds games.
- Fixed more issues related to auras that increase health.


## **Release v1.12.11 - 2020-06-15**

**Fixes**:
- Fixed an issue where Zoobot would not show up in the Minions list in Battlegrounds games without Mechs.

**Bob's Buddy**:
- Fixed an issue with the interaction between Illidans Hero Power and Arcane Canon.
- Random summons are now restricted to the tribes available during the game.
- Fixed an issue where auras that increase health were not correctly removed.


## **Release v1.12.10 - 2020-06-13**

**Bob's Buddy**:
- Fixed an issue with the interaction between Scallywag and Monstrous Macaw.
- Fixed an issue where Arcane Canon would sometimes not detect its neighbouring minions correctly.
- Fixed an issue where Khadgar would not correctly work with The Beast's Deathrattle.


## **Release v1.12.9 - 2020-06-11**

**Bob's Buddy**:
- Fixed an issue with the attack timing for Skallywag's Deathrattle and Arcane Canon.
- Fixed an issue with resolving multiple Deathrattles at once.


## **Release v1.12.8 - 2020-06-09**
**Updated for Hearthstone 17.4.0.49534**

**Changes**:
- The minion list in Battlegrounds games will now only show races available in the current game.

**Bob's Buddy**:
- Added initial support for all new minions added in this Hearthstone patch (Pirates).
- Fixed various minor issues related to Kangor's Apprentice's Deathrattle.
- Fixed an issue where Siegebreaker's aura wasn't working correctly.


## **Release v1.12.7 - 2020-06-03**

**Bob's Buddy**:
- Fixed an issue where multiple Deathrattles triggering simultaneously would sometimes not resolve correctly (e.g. in Exodia builds).
- Fixed an issue where Professor Putricide's Hero Power was applied twice in some cases.
- Fixed an issue where Mal'Ganis' aura was sometimes not applied correctly.


## **Release v1.12.6 - 2020-05-25**

**New**:
- Opponent hand icons now display the card they have been created by.

**Fixes**:
- Fixed an issue causing high GPU usage during Battlegrounds games.

**Bob's Buddy**:
- Increased the maximum amount of time simulations are allowed to run for complex boards.
- Fixed an issue where Reborn minions could trigger effects on themselves.


## **Release v1.12.5 - 2020-05-20**

**Fixes**:
- Fixed an issue where HDT had unnecessarily high CPU/GPU usage in some cases.
- Fixed an issue where flavor text tooltips were not working correctly for cards held in hand.
- Fixed an issue where flavor text tooltips were not working correctly with transformed minions.
- Fixed an issue where card tooltips in the Twitch Extension were not working correctly with transformed minions.
- Fixed several issues where the secret helper would not correctly handle minions that died during an attack.

**Bob's Buddy**:
- Fixed an issue where Start of Combat triggers for Kel'Thuzad were not handled correctly (this was recently fixed in Hearthstone).
- Fixed an issue where opposing Lich King / Putricide were considered to have used their hero power when they did not.
- Fixed an issue where Fiendish Servant was not able to target the same minion twice.
- Fixed an issue where Khadgar would incorrectly duplicate minions with Reborn.


## **Release v1.12.2 - 2020-05-18**
**Updated for Hearthstone 17.2.1.48313**

**Changes**:
- The attack counters are now automatically hidden while in Battlegrounds.
- Fixed a rounding issue where the Bob's Buddy lethal chance could exceed the chance to win.
- Improved Bob's Buddy prediction accuracy.


## **Release v1.12.0 - 2020-05-13**
**Updated for Hearthstone 17.2.0.47374**

**Notes**:
- Hearthstone 17.2 introduced major internal changes. We think we got everything working again, but please let us know if you encounter issues with this release.
- Some card images added with 17.2 may still be missing. These will be added with the next update.

**Changes**:
- Improved Bob's Buddy prediction accuracy.
- Potentially fixed an issue causing decks to not be selected at the start of a game.


## **Release v1.11.9 - 2020-05-06**
**Fixes**:
- Fixed an issue where some Deathrattle interactions were not handled correctly in Bob's Buddy.


## **Release v1.11.8 - 2020-05-05**
**Changes**:
- Added Tracking for cards copied by e.g. Maname Lazul and Mind Vision.
- Improved Bob's Buddy prediction accuracy.


## **Release v1.11.7 - 2020-04-30**
**Fixes**:
- Fixed an issue where golden minions in Battlegrounds could lead to incorrect outcome predictions.


## **Release v1.11.6 - 2020-04-29**
**New**:
- Added Bob's Buddy: A Battlegrounds combat simulator showing the likelihood to win, tie or lose.  [Learn more.](https://articles.hsreplay.net/2020/04/24/introducing-bobs-buddy/)

**Fixes**:
- Fixed an issue where running other deck trackers in parallel may have caused HDT to stop working in some cases.
- Fixed an issue causing several created cards (e.g. Bombs) to not be tracked correctly.
- Fixed an issue where weapons were not correctly accounted for in the attacak mana curve.

**Notes**:
- This version upgrades to .NET Framework 4.7.2, which means installations of Windows 7 and Windows 8 that are not updated to Service Pack 1 will no longer be able to run HDT.
- This version updates several dependencies, causing some Plugins to no longer load.
- Releases v1.11.0-v1.11.5 contained various updates and fixes to Bob's Buddy


## **Release v1.10.8 - 2020-04-20**
**Updated for 17.0.2.45932**

**Fixes**:
- Fixed an issue where Netherwind Portal was missing from the secret helper.
- Plugins should now be less likely to cause crashes.


## **Release v1.10.7 - 2020-04-09**
**Updated for 17.0.0.45310**

**Fixes**:
- Fixed an issue where Snipe, Explosive Runes, Potion of Polymorph and Repentance would get greyed out when playing a dormant minion.
- Fixed an issue where dormant minions would sometimes count towards damage on board.
- Fixed an issue where Al'ar, when resurrected from his ashes, would count towards damage on board.
- Fixed an issue where linked Twitch accounts were not detected correctly in some cases.
- Fixed an issue where the global statistics panel would not show data for new decks (due to local caching, this may take up to 24 hours to update).


## **Release v1.10.6 - 2020-04-07**
**Updated for Year of the Phoenix**

**Changes**:
- Added support for Ashes of Outland secrets
- Added support for card tracking for several new cards


## **Release v1.10.5 - 2020-04-04**
**Fixes**:
- Fixed an issue where the deck tracker would stop working when playing AI games, caused by an oversight in v1.10.4.
- Fixed an issue where moving a game between decks would not update the deck in the games list.


## **Release v1.10.4 - 2020-04-04**
**Fixes**:
- Fixed an issue where the deck tracker would stop working when playing against opponents appearing as offline.


## **Release v1.10.3 - 2020-04-02**
**Changes**:
- Added a "All Leagues + Legacy" filter option to the constructed stats League filter.

**Fixes**:
- Fixed an issue where Warrior was missing from the Arena Win/Loss chart.
- Fixed an issue where Demon Hunter decks were not imported correctly.


## **Release v1.10.2 - 2020-03-30**
**Added support for the new constructed rank system**:
- Added a "League" filter under `STATS > CONSTRUCTED`, when the Game Mode is set to Ranked, to show games played in a specific league.
- Games played in the old rank system can still be found by selecting "Legacy" in the League filter.

**Fixes**:
- Fixed various layout issues introduced by the addition of Demon Hunter and the new rank system.


## **Release v1.10.1 - 2020-03-26**
**Updated for Ashes of Outland**
- Added basic support for Demon Hunter
- Updated for Battlegrounds changes
- Updated for Hall of Fame changes

This update should restore the basic functionality. Support for Demon Hunter card interactions and the new Ranked system coming soon.


## **Release v1.10.0 - 2020-03-25**
**New**:
- Added a turn counter on the Battlegrounds overlay (`options > overlay > general`)
- Added a notification at the start of Battlegrounds games to see the HSReplay.net Hero Tier List filtered to the hero choices (`options > tracker > notifications`).

**Changes**:
- The Battlegrounds overlay is now clickable rather than hover activated.


## **Release v1.9.12 - 2020-03-17**
**Updated for Hearthstone 16.6.0.43246**


## **Release v1.9.11 - 2020-02-26**
**Updated for Hearthstone 16.4.0.42174**

**Fixed**:
- Fixed an issue where Misdirection secret detection would not work correctly with immune targets.


## **Release v1.9.10 - 2020-01-21**
**Updated for Hearthstone 16.2.0.39954**


## **Release v1.9.9 - 2020-01-09**
**Updated for Hearthstone 16.0.8.39282**


## **Release v1.9.8 - 2019-12-20**
**New**:
- Added a new counter for Galakrond invocations.

**Changes**:
- Turn timers are now always hidden while playing Battlegrounds.


## **Release v1.9.7 - 2019-12-19**
**Updated for Hearthstone 16.0.5.38377**


## **Release v1.9.6 - 2019-12-11**
**Fixes**:
- Fixed an issue that was causing HDT to stop tracking cards and stats under certain conditions.


## **Release v1.9.5 - 2019-12-10**
**Changes**:
- Added card tracking for serveral new Descent of Dragons cards.
- The Battlegrounds minion tiers overlay now fades out when hovering opponents in the leaderboard.

**Fixes**:
- Fixed an issue where Galakrond was not tracked correctly.


## **Release v1.9.4 - 2019-12-09**
**Fixes**:
- Potentially fixed an issue where the battlegrounds overlay would go off screen.
- Fixed an issue where HDT would crash when showing tooltips for certain cards.
- Fixed an issue where HDT would cause a crash during some battlegrounds games.


## **Release v1.9.3 - 2019-12-09**
**Fixes**:
- Fixed an issue where the last known board state in Battlegrounds was not always reliably tracked.


## **Release v1.9.2 - 2019-12-05**
**Updated for Descent of Dragons**


## **Release v1.9.1 - 2019-12-03**
**New**:
- Added a new overlay for Battlegrounds, showing minions available in each tavern tier.

**Fixes**:
- Fixed an issue where pinned shortcuts would not work across updates.


## **Release v1.9.0 - 2019-11-14**
**New: Battlegrounds Support**:
- Hovering an opponent in the sidebar will now display their last known board state.

**Fixes**:
- Fixed an issue where the arena dialog would show up after a Battlegrounds match if an arena deck was previously selected.
- The secret panel has been temporarily disabled in Battlegrounds, until it is fixed to work correctly.


## **Release v1.8.22 - 2019-11-05**
**Updated for Hearthstone 15.6.0.35747**


## **Release v1.8.21 - 2019-10-08**
**Fixes**:
- Fixed an issue introduced with 15.4.0.34670 where Arena Decks would not be imported.
- Fixed an issue introduced with 15.4.0.34670 where Adventure Decks would not be imported.


## **Release v1.8.20 - 2019-10-08**
**Updated for Hearthstone 15.4.0.34670**

**Fixes**:
- Fixed an issue introduced with 15.4.0.34670 where HDT would hang when starting Hearthstone.

**Outstanding issues**:
- Adventure deck detection broke with 15.4.0.34670. We are hoping we can fix this soon.
- There might be more issues introduced by the patch that we missed so far. Please let us know if you find any.


## **Release v1.8.19 - 2019-09-23**
**Fixes**:
- Fixed an issue causing HDT to occasionally crash when importing Tombs of Terror decks.


## **Release v1.8.18 - 2019-09-23**
**Added support for Tombs of Terror**


## **Release v1.8.17 - 2019-09-10**
**Updated for Hearthstone 15.2.0.33717**

**New**:
- Added tracking support for minions shuffled by Spirit of the Dead.


## **Release v1.8.16 - 2019-08-26**
**Updated for Hearthstone 15.0.4.33402**


## **Release v1.8.15 - 2019-08-08**
**Added support for several Saviors of Uldum cards**

**Fixes**:
- Fixed an issue where Whizbang decks would not be imported or detected correctly.
- Fixed an issue where Pressure Plate secret detection was not working correctly.


## **Release v1.8.14 - 2019-08-01**
**Updated for Saviors of Uldum**


## **Release v1.8.13 - 2019-07-01**
**Updated for Hearthstone 14.6.0.31761**


## **Release v1.8.12 - 2019-06-18**
**Fixes**:
- Fixed a couple of minor issues causing more information to be revealed than intended.


## **Release v1.8.11 - 2019-06-03**
**Updated for Hearthstone 14.4.0.31268**


## **Release v1.8.10 - 2019-05-27**
**Updated for Hearthstone 14.2.2.31022**
- Added deck tracking support for the Dalaran Heist adventure


## **Release v1.8.9 - 2019-05-16**
**Updated for Hearthstone 14.2.0.30795**
- Full support for the Dalaran Heist adventure will follow with a later update!


## **Release v1.8.7 - 2019-04-13**
**Fixes**:
- Fixed various interactions with Augmented Elekk.
- Fixed an issue where Never surrender would be greyed out with no minions on the board.


## **Release v1.8.6 - 2019-04-11**
**Fixes**:
- Fixed an issue where an incorrect list of secrets would be displayed in Arena.
- Fixed an issue where tooltips were not working correctly for some cards.


## **Release v1.8.5 - 2019-04-09**
__Updated for Year of the Dragon__


## **Release v1.8.4 - 2019-04-04**
__Updated for Rise of Shadows__


## **Release v1.8.3 - 2019-03-16**
**Fixes**:
- Fixed an issue where Hakkar's Corrupted Blood would not be tracked correctly.
- Fixed an issue with detecting the Twitch stream language for HSReplay.net intregration.


## **Release v1.8.2 - 2019-03-15**
**Updated for Hearthstone 13.4.0.29349**


## **Release v1.8.1 - 2019-03-04**
- Added additional features for Twitch VODs on HSReplay.net.


## **Release v1.8.0 - 2019-02-05**
**Updated for Hearthstone 13.2.0.28855**

**New**:
- Added an option to display the set of a card in the tooltip. (`options > overlay > general`)

**Changes**:
- Updated Rumble Run decks for recent changes.

**Fixes**:
- Fixed an issue where cards created by Augmented Elekk were not tracked.
- Fixed an issue where Snipe was excluded from the possible secret in Arena.
- Fixed several set icons.


## __Release v1.7.16 - 2018-12-19__
__Updated for Hearthstone 13.0.3.28329__


## __Release v1.7.15 - 2018-12-13__

__New__:
- Added support for Rumble Run.

__Fixes__:
- Fixed an issue where Freezing Trap and Bear Trap would sometimes be incorrectly greyed out.


## __Release v1.7.13 - 2018-11-29__
__Updated for Rastakhan's Rumble__

__Fixes__:
- Fixed an issue where spells played by an opposing Grand Archivist were not tracked.
- Fixed an issue where the gold tracker would not reset correctly sometimes.


## __Release v1.7.12 - 2018-11-12__

__Fixes__:
- Fixed an issue where gold progress tracking was no longer working with Hearthstone 12.4.0.27641.


## __Release v1.7.11 - 2018-11-05__
__Updated for Hearthstone 12.4.0.27405__


## __Release v1.7.10 - 2018-10-28__

__Fixes__:
- Fixed the Mage and Toki stater decks for Dungeon Run and Monster Hunt modes.


## __Release v1.7.9 - 2018-10-18__
__Updated for Hearthstone 12.2.0.27358__

__Fixes__:
- Fixed an issue where Dungeon Run decks would not be named correctly.


## __Release v1.7.8 - 2018-10-04__

__Fixes__:
- Fixed more issues where deck tracking would not work in some game modes / at legend.


## __Release v1.7.7 - 2018-10-03__

__Fixes__:
- Fixed an issue where deck tracking would not work correctly in some game modes.


## __Release v1.7.6 - 2018-10-02__
__Updated for Hearthstone 12.2.0.26757__

__New__:
- Added a Pogo-Hopper counter for Rogues.

__Fixes__:
- Fixed an issue where starting Hearthstone would sometimes not work correctly.
- Fixed an issue where standard decks could get tagged as "brawl".
- Improved the secret detection when minions die (e.g. Explosive Runes and Potion of Polymorph).
- Improved the way Whizbang decks are detected.
- Improved stability when saving files.


## __Release v1.7.5 - 2018-08-15__

__Fixes__:
- Fixed an issue where Autodefense Matrix would be greyed out when attacking minions with divine shield.
- (Hopefully) Fixed an issue where the player and opponent decks could be swapped in some cases.
- Fixed an issue where it would sometimes still be possible to tell that the opponent was playing a Whizbang deck.
- Improved automatic deck selection when playing the Whizbang deck.


## __Release v1.7.4 - 2018-08-09__

- Fixed several crashes.


## __Release v1.7.2 - 2018-08-09__

__New__:
- Added tracking for several Boomsday cards.
- All possible decks for Whizbang are now automatically imported when his deck is found.

__Fixes__:
- Fixed an issue where Boomsday packs were missing as an arena reward.
- Fixed an issue where Whizbang decks were not tracked correctly.
- Fixed an issue where secrets would be ruled out when using Magnetic minions as a buff.
- (Hopefully) Fixed "Uneven Permissons" issues in some cases.


## __Release v1.7.1 - 2018-08-02__
__Updated for The Boomsday Project__

- Fixed several crashes.
- Tracking for cards created by Boomsday cards will follow in a later update.


## __Release v1.6.9 - 2018-07-10__
__Updated for Hearthstone 11.4.0.25252__

- Fixed issues with collection syncing and arena drafting introduced by this patch.


## __Release v1.6.8 - 2018-06-24__

- Fixed an issue where Hearthstone was no longer starting via the integrated button.


## __Release v1.6.7 - 2018-06-10__
__Updated for Taverns of Time event__

__New__:
- Redesigned the plugins menu (`options > tracker > plugins`).
- Added an option to display the "last edited" date on decks (`options > tracker > general`).
- Improved configuration for turn start and friendly challenge notifications (`options > tracker > notifications`).

__Fixes__:
- Fixed an issue where cards were sometimes not permanently removed from the deck after patch 11.2.0.


## __Release v1.6.6 - 2018-05-22__
__Updated for Hearthstone 11.1.1.24589__

__New__:
- Added an option to close HDT to the system tray. `(options > tracker > settings)`

__Fixes__:
- Fixed tracking for cards created by Shadow Reflection and several Monster Hunt cards.


## __Release v1.6.5 - 2018-04-27__

__Added support for Monster Hunt__

__Fixes__:
- Fixed an issue where Direhorn Hatchling was considered created after dying.


## __Release v1.6.4 - 2018-04-17__

__Fixes__:
- Fixed an issue where cards in dungeon runs were not tracked correctly.
- Fixed an issue where cards created by Shudderwock were not tracked correctly.
- Fixed an issue where cards drawn by Far Sight were not tracked correctly.


## __Release v1.6.3 - 2018-04-13__

__New__:
- The opponent card list now tracks cards revealed by Cameleos.

__Fixes__:
- Fixed an issue where deck tracking would no longer work after playing Prince Liam.
- Fixed an issue where secret tracking for Hidden Wisdom and Rat Trap did not work correctly.
- Fixed an issue where Ice Block, Molten Giant and Coldlight Oracle were still considered Standard.


## __Release v1.6.2 - 2018-04-12__

__Updated for Standard rotation__


## __Release v1.6.1 - 2018-04-10__

__Updated for The Witchwood__

__Fixes__:
- Fixed an issue where the options menu was not scrollable.


## __Release v1.6.0 - 2018-03-21__

__New__:
- Added support to upload your collection to HSReplay.net.

__Fixes__:
- Fixed an issue where the "Start Hearthstone" button would not work correctly in some cases when the launcher was not running.


## __Release v1.5.14 - 2018-03-15__

- Fixed an issue with the updater for the portable version.


## __Release v1.5.13 - 2018-03-12__
__Updated for Hearthstone 10.4.0.23576__

__Fixes__:
- Fixed an issue where the player and opponent could sometimes be swapped.
- Fixed an issue where mulliganed cards would sometimes be out of order in the deck list.
- Fixed an issue where Weasel Tunneler was not tracked correctly.
- Fixed an issue with card name font on the flavor text panel.


## __Release v1.5.12 - 2018-02-06__
__Updated for Hearthstone 10.2.0.23180__

__New__:
- Added an option for Hearthstone to flash when receiving a friendly challenge `(options > tracker > general)`.

__Fixes__:
- Fixed an issue where stats on deck tiles would not update.
- Fixed an issue where spectator games would somtimes be attached to the wrong decks.
- Fixed an issue with the card tooltip font for some languages.


## __Release v1.5.11 - 2018-01-17__

__Fixes__:
- Fixed an issue where the "Toggle Secrets" hotkey wasn't working.
- Fixed several issues with UI components not updating when changing languages/colors.
- Fixed an issue where The Candle wasn't tracked correctly.
- Fixed the image for Psychic Scream.


## __Release v1.5.10 - 2017-12-18__

- Fixed tracking of cards created by: Dead Man's Hand, Psychic Scream, Spiteful Summoner, Dragon's Fury, and several others.


## __Release v1.5.9 - 2017-12-15__

- Fixed an issue where some other cards would no longer be tracked due to the previous update.


## __Release v1.5.8 - 2017-12-14__

- Fixed an issue where Togwaggle and his King's Ransom would reveal more information than they should.


## __Release v1.5.7 - 2017-12-13__

__New:__
- Added support for dungeon run decks.
	- Settings for this can be found under `options (advanced) > tracker > importing`.
- Added filters for dungeon and brawl decks to the decks list filters.

__Fixes:__
- Fixed tracking for cards created by: Fal'dorei Strider, Kingsbane and Scroll of Wonders.
- Fixed an issue where Sudden Betrayal would sometimes grey out when attacking with the hero.
- Fixed an issue where the The Darkness token would count towards the attack counter.
- Fixed a performance issue when "Advanced window search" was enabled.
- Fixed several crashes.


## __Release v1.5.6 - 2017-12-07__

__Updated for Kobolds and Catacombs__

__Fixes__:
- Fixed an issue where flavor text tooltips were barely readable in some cases.

__Changes__:
- Improved secret tracking logic for Hidden Cache.


## __Release v1.5.5 - 2017-11-06__

__Updated for Hearthstone 9.4.0.22115__


## __Release v1.5.4 - 2017-10-28__

- Fixed an issue that caused transformed cards to not be recognized correctly (e.g. Fatespinner or Shifter Zerus).


## __Release v1.5.3 - 2017-10-26__

- Fixed an issue that could cause HDT to crash when trying to authenticate with HSReplay.net.


## __Release v1.5.2 - 2017-10-26__

__New__:
- Our Twitch Overlay Extension is now available! (`options (advanced) > streaming > twitch extension`)

__Fixes__:
- Fixed an issue where starting Battle.net/Hearthstone was not working with the Battle.net beta client.


## __Release v1.5.1 - 2017-10-18__

- Fixed an issue where games played with the new Warlock hero would not be recorded correctly.


## __Release v1.5.0 - 2017-10-17__

__Updated for Hearthstone 9.2.0.21517__

__Fixes__:
- Fixed an issue where Wild Secrets would show up in Arena.


## __Release v1.4.4 - 2017-09-20__

Fixed a crash on startup when the config was set to be stored locally.


## __Release v1.4.3 - 2017-09-19__

__Updated for Hearthstone 9.1.0.20970__

__New__:
- Added support to use the windows native accent color.
- Added hotkey functionality for toggling the "My Games" panel.

__Changes__:
- Deck codes can now also be pasted into the deck editor.
- Several opponent overlay options have been moved from `general` to `opponent`.


## __Release v1.4.2 - 2017-09-05__

- Fixed an issue where cards from the Classic set could not be set as arena rewards.


## __Release v1.4.1 - 2017-08-24__

__Fixes__:
- Fixed an issue where cards destroyed by Skulking Geist would sometimes not be tracked.
- Fixed an issue where Adventure heroes would show up in the card lists.
- Fixed an issue where entering card names in the arena rewards dialog would not work if the UI language was not english.
- Fixed several issues related to secrets tracking.


## __Release v1.4.0 - 2017-08-08__

__Updated for Knights of the Frozen Throne__

__Changes__:
- Opponent card markers now scale with the opponent scaling value set in `options > overlay > opponent`.

__API__:
- Added GameEvents.OnModeChanged


## __Release v1.3.6 - 2017-07-30__

__New__:
- Added German and French translations.
- Added a "Missing cards" tab to the "Export" flyout, which will show you any cards you are missing for that deck.

__Fixes__:
- Fixed an issue where deck importing would not find an existing deck in versions.
- Fixed an issue where auto deck selection would not always find the correct version.
- Fixed an issue where the deck editor would not find non-english card names.
- Fixed an issue where the "This week" timeframe filter would not always use the correct first day of the week.
- Fixed an issue where global statistics would not be loaded for wild decks.

__Changes__:
- Deck code export now has an option to include the version number in the name.
- The global statistics is now hidden while an arena deck is selected.
- Improved touch screen behavior in several places.


## __Release v1.3.5 - 2017-06-03__

__Fixes__:
- Fixed an issue where the export deck dialog would not respect the selected deck version.
- Fixed an issue where editing and saving a deck as the current version would not update it in the UI.
- Fixed an issue where Mirror Entity would be grayed out while the opponent has a full board.
- Fixed several crashes.

__Changes__:
- Added an option to hide the new "my games" panel: `options (advanced) > tracker > general`


## __Release v1.3.2 - 2017-06-02__

__Updated for 8.2.0.19506__
- Fixed a crash when starting/exiting a match.
- Now using Hearthstones new deck code system for importing and exporting decks.


## __Release v1.3.1 - 2017-06-01__
- Fixed a crash on startup if the legacy deck style was selected.


## __Release v1.3.0 - 2017-06-01__

__New__:
- Added more stats, recent games, as well as global stats (if available) for the selected deck.
- Added "Most Played" as a deck sorting option.

__Changes__:
- Greatly improved the deck screenshot dialog.
  - Deck images can now also be copied to the clipboard.
- Deck editor has been moved to it's own flyout.
- Deck version history has been moved to it's own flyout and can now be accessed via the `DECK` menu item or the decks context menu.
- Importing decks from a list of card names now also gives a language selection option if english is the active language but an alternative language is selected.

__Fixes__:
- Fixed an issue where enchantment cards would be tracked in some cases.


## __Release v1.2.5 - 2017-05-02__
- Fixed several crashes.


## __Release v1.2.4 - 2017-05-01__

__New__:
- Added a simple way on decks to open the corresponding HSReplay.net deck page.
- Added Brazilian Portuguese translation.

__Changes__:
- Exporting decks to Hearthstone will now warn you about missing cards before starting the export process.
- Wild deck are now indicated with the proper icon (instead of the 'S' on standard decks).

__Fixes__:
- Fixed an issue where HDT would have trouble picking up the correct Hearthstone path.


## __Release v1.2.3 - 2017-04-12__

__Changes__:
- Hopefully made some improvements to issues with the overlay hiding behind Hearthstone.
  - If you are still having problems, try running HDT as administrator.
- Drag & Dropping plugins into the plugins options menu will now install them without requiring a restart.

__Fixes__:
- Fixed an issue where Direhorn Hatchling would not add a token to the deck.
- Fixed an issue where Patches would remain in the decklist in some cases.
- Fixes an issue where transformed cards would not be displayed correctly in the opponents deck list (Shifter Zerus, Molten Blade).
- Fixed an issue where quests would not count towards the spell counter.

__API__:
- Quests now properly emit `OnPlay` events.


## __Release v1.2.2 - 2017-04-07__

__Fixes__:
- Fixed an issue where Quests would trigger the secret list.
- Fixed an issue where some cards were not in the correct sets.


## __Release v1.2.1 - 2017-04-04__

__Fixes__:
- Fixed an issue where the Tracking (Hunter) pick would not be tracked correctly.
- Fixed an issue where the Desktop/Start shortcut was not updated properly.


## __Release v1.2.0 - 2017-04-04__

__Updated for 8.0.0.18336__
- Fixed deck tracking :).
- The UI will consider rotating sets wild even before they are. This will not affect your stats.

__New__:
- Added Ukranian translation.

__Changes__:
- Secret helper now only displays standard secrets in arena.
- The local replay system has now been fully removed.

__Fixes__:
- Fixes an issue where region detection would not work in some cases
  - This also fixes some issues with gold progress tracking since it relies on regions.
- Fixed an issue that prevented disabling no-deck mode.
- Fixed an issue where importing decks from meta tags would not properly decode values.


## __Release v1.1.7 - 2017-03-01__

__Updated for 7.1.0.17720__

__New__:
- HDT will now notify you if important options (automatic importing and deck selection) are disabled.
- Added Korean and Japanese translations.

__Changes__:
- Trying to start Battle.net/Hearthstone should now time out later.

__Fixes__:
- Drag and drop installing should now work for all plugins.


## __Release v1.1.6 - 2017-01-12__

__New__:
- Added an option to remove detected secrets instead of just greying them out.
  - The option can be found under `options (advanced) > overlay > general`.

__Fixes__:
- Fixed an issue where cards revealed by Jousts would not be tracked.
- Fixed an issue where HDT would crash when starting some brawls.
- Fixed an issue where HDT would force no-deck mode when spectating.


## __Release v1.1.5 - 2016-12-22__

__New__:
- Added Jade Golem counters.
- Now translated into Traditional Chinese (zh-TW).

__Changes__:
- Fully disabled HearthStats integration to prevent deck corruption.
- The arena rewards dialog now accepts and auto completes card names for selected secondary card languages.

__Fixes__:
- Fixed an issue where auto deck importing and selection would not work for brawl.
- Fixed an issue where cards created by Manic Soulcaster and White Eyes would not be tracked.
- Fixed an issue where the "this week" stats filter would not work properly.
- Fixed an issue where the "max rank" stats filter would not recognize legend ranks.


## __Release v1.1.4 - 2016-12-04__

__Changes__:
- Cards created by Jade Idol and White Eyes are now properly tracked.

__Fixes__:
- Fixed an issue where the secrets list would not disappear after all secrets were triggered.
- Fixed an issue where importing decks from the game would not work in some cases.
- Fixed an issue where the "Minimal" card theme would not display any images.
- Fixed an issue where creating deck screenshots would crash HDT.


## __Release v1.1.2 - 2016-11-30__

__Updated for 7.0.0.15590__
- Known issue: The "Hidden Cache" Hunter secret does not automatically grey out.

__Changes__:
- You can now paste (ctrl-v) deck urls directly into HDT, rather than having to use the `IMPORT` menu.
- The installation and update process should be faster now.

__Fixes__:
- Fixed an issue where games would not be sorted by duration properly.


## __Release v1.1.1 - 2016-10-04__

__Updated for 6.1.3.14830__

__Fixes__:
- Fixed an issue where the deck builder would not work properly with some UI languages.
- Minor text changes.


## __Release v1.1.0 - 2016-09-21__

__New__:
- Greatly improved replays! More information after the update notes.
- HDT is now translated into Chinese and Russian.
  - You can change the language under `options > tracker > appearance`
  - Other languages are coming soon! If you want to help with translation, there is a link next to the opion.
- The (Yogg-Saron) counter `Auto` mode now also works for Arcane Giant.

__Fixes__:
- Fixed an issue where Competitive Spirit would sometimes incorrectly be greyed out.
- Fixed an issue where Cat Trick was missing from the secrets list.
- Fixed an issue where card images were missing occasionally in some cases.
- Fixed an issue where HDT would crash during exporting or when opening/closing the friendslist.

__Changes__:
- Made several further improvemets to auto deck importing.
- Made several improvements to auto deck seletion.
- Made several improvements to the "Export to Hearthstone" feature.
- Doubleclicking decks will now activate them. With the changes to deck auto importing, editing decks within HDT should rarely be necessary.

__API__:
- Fixed an issue where `OnTurnStart` would not fire for the first turn of the game.
- Importing from web now supports meta tags (#2769)


## __Release v1.0.5 - 2016-08-10__

__Updated for Hearthstone 6.0.0.13921__:
- Added support for restarted adventure matches.

__Fixes__:
- Fixed an issue where the mana curve would not correctly display spells.
- Fixed an issue where automatic constructed importing would in some cases import multiple decks to the same local deck, resulting in a high number of versions on the deck.

__API/Plugins__:
- Added `API.GameEvents.OnEntityWillTakeDamage.`
- Added support for loading plugins with embedded dependencies - see #2735.


## __Release v1.0.4 - 2016-08-04__

__New__:
- We have a new, awesome updater! HDT will tell you all about it after you close the update notes.
- Added support for importing decks from marduktv.com.br

__Changes__:
- HDT will now try to automatically restore corrupted data files, e.g. from an unexpected shutdown.
- Plugins are now stored in `%AppData%/HearthstoneDeckTracker/Plugins`. Your existing plugins are moved there automatically.
- Custom themes are now stored in `%AppData%/HearthstoneDeckTracker/Themes`. Your existing custom themes are moved there automatically.
- You can now select all/no decks when importing from constructed.
- Plugins are now less likely to cause HDT to crash.

__Fixes__:
- Fixed an issue where the cost reduction would still be displayed for cards that were returned to hand.
- Fixed an issue where the card sorting would no longer match the game's new sorting.
- Fixed an issue where the Yogg or C'Thun counter would sometimes be incorrectly shown during brawls.
- Fixed several crashes.
