import { useState } from "react";
import clsx from "clsx";
import {
  createStyles,
  makeStyles,
  useTheme,
  Theme,
} from "@material-ui/core/styles";
import Drawer from "@material-ui/core/Drawer";
import AppBar from "@material-ui/core/AppBar";
import Toolbar from "@material-ui/core/Toolbar";
import List from "@material-ui/core/List";
import CssBaseline from "@material-ui/core/CssBaseline";
import Typography from "@material-ui/core/Typography";
import Divider from "@material-ui/core/Divider";
import IconButton from "@material-ui/core/IconButton";
import MenuIcon from "@material-ui/icons/Menu";
import ChevronLeftIcon from "@material-ui/icons/ChevronLeft";
import ChevronRightIcon from "@material-ui/icons/ChevronRight";
import ListItem from "@material-ui/core/ListItem";
import ListItemIcon from "@material-ui/core/ListItemIcon";
import ListItemText from "@material-ui/core/ListItemText";
import HomeRoundedIcon from "@material-ui/icons/HomeRounded";
import DnsRoundedIcon from "@material-ui/icons/DnsRounded";
import ViewListRoundedIcon from "@material-ui/icons/ViewListRounded";
import ProductManagement from "../../pages/ProductManagement/ProductManagement";
import { Link } from "react-router-dom";
import OrderPage from "../../pages/OrderPage/OrderPage";
import Home from "../../pages/Home/Home";

const drawerWidth = 240;

const useStyles = makeStyles((theme: Theme) =>
  createStyles({
    root: {
      display: "flex",
    },
    appBar: {
      zIndex: theme.zIndex.drawer + 1,
      backgroundColor: "#DF5E5E",
      transition: theme.transitions.create(["width", "margin"], {
        easing: theme.transitions.easing.sharp,
        duration: theme.transitions.duration.leavingScreen,
      }),
    },
    appBarShift: {
      marginLeft: drawerWidth,
      width: `calc(100% - ${drawerWidth}px)`,
      transition: theme.transitions.create(["width", "margin"], {
        easing: theme.transitions.easing.sharp,
        duration: theme.transitions.duration.enteringScreen,
      }),
    },
    menuButton: {
      marginRight: 36,
    },
    hide: {
      display: "none",
    },
    drawer: {
      width: drawerWidth,
      flexShrink: 0,
      whiteSpace: "nowrap",
    },
    drawerOpen: {
      width: drawerWidth,
      transition: theme.transitions.create("width", {
        easing: theme.transitions.easing.sharp,
        duration: theme.transitions.duration.enteringScreen,
      }),
    },
    drawerClose: {
      transition: theme.transitions.create("width", {
        easing: theme.transitions.easing.sharp,
        duration: theme.transitions.duration.leavingScreen,
      }),
      overflowX: "hidden",
      width: theme.spacing(7) + 1,
      [theme.breakpoints.up("sm")]: {
        width: theme.spacing(9) + 1,
      },
    },
    toolbar: {
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-end",
      padding: theme.spacing(0, 1),
      // necessary for content to be below app bar
      ...theme.mixins.toolbar,
    },
    content: {
      flexGrow: 1,
      padding: theme.spacing(3),
    },
    list: {
      paddingLeft: theme.spacing(1),
    },
  })
);

const comList = [
  {
    cId: 1,
    cName: "Home",
    path: "/",
    cIcon: <HomeRoundedIcon color="secondary" />,
    component: <Home />,
  },
  {
    cId: 2,
    cName: "Products",
    path: "/products",
    cIcon: <DnsRoundedIcon color="secondary" />,
    component: <ProductManagement />,
  },
  {
    cId: 3,
    cName: "Orders",
    path: "/orders",
    cIcon: <ViewListRoundedIcon color="secondary" />,
    component: <OrderPage />,
  },
];

const MUIDrawer = (props) => {
  const {
    isLoggedIn,
    setIsLoggedIn,
    userLoggedIn,
    setUserLoggedIn,
    userTokenKey,
  } = props;
  const classes = useStyles();
  const theme = useTheme();
  const [open, setOpen] = useState(false);

  const handleDrawerOpen = () => {
    setOpen(true);
  };

  const handleDrawerClose = () => {
    setOpen(false);
  };

  const handleLogout = () => {
    setIsLoggedIn(false);
    setUserLoggedIn(null);
    localStorage.removeItem(userTokenKey);
  };

  return (
    <div className={classes.root}>
      <CssBaseline />
      <AppBar
        position="fixed"
        className={clsx(classes.appBar, {
          [classes.appBarShift]: open,
        })}
      >
        <Toolbar className="navbar navbar-expand-sm navbar-dark bgred">
          <IconButton
            color="inherit"
            aria-label="open drawer"
            onClick={handleDrawerOpen}
            edge="start"
            className={clsx(classes.menuButton, {
              [classes.hide]: open,
            })}
          >
            <MenuIcon />
          </IconButton>
          <Typography variant="h6" noWrap>
            <strong>React Cherry Demo</strong>
          </Typography>
          <div className="collapse navbar-collapse" id="navbarNav">
            {isLoggedIn && userLoggedIn !== null ? (
              <ul className="navbar-nav ml-auto">
                <li className="nav-item">
                  <span className="nav-link" style={{ color: "white" }}>
                    Hi {userLoggedIn["userName"]}
                  </span>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" onClick={handleLogout} to="/login">
                    Log Out
                  </Link>
                </li>
              </ul>
            ) : (
              <ul className="navbar-nav ml-auto">
                <li className="nav-item">
                  <Link className="nav-link" to="/register">
                    Register
                  </Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" to="/login">
                    Log In
                  </Link>
                </li>
              </ul>
            )}
          </div>
        </Toolbar>
      </AppBar>
      <Drawer
        variant="permanent"
        className={clsx(classes.drawer, {
          [classes.drawerOpen]: open,
          [classes.drawerClose]: !open,
        })}
        classes={{
          paper: clsx({
            [classes.drawerOpen]: open,
            [classes.drawerClose]: !open,
          }),
        }}
      >
        <div className={classes.toolbar}>
          {/* <div className="mr-auto mt-1 ml-2">
            <DashboardRoundedIcon color="secondary" />
            <span className="ml-4">List</span>
          </div> */}

          <IconButton onClick={handleDrawerClose}>
            {theme.direction === "rtl" ? (
              <ChevronRightIcon />
            ) : (
              <ChevronLeftIcon />
            )}
          </IconButton>
        </div>
        <Divider />
        <List>
          {comList.map((item) => (
            <Link
              key={item.cId}
              to={item.path}
              style={{ textDecoration: "none", color: "#424242" }}
            >
              <ListItem button>
                <ListItemIcon>{item.cIcon}</ListItemIcon>
                <ListItemText primary={item.cName} />
              </ListItem>
            </Link>
          ))}
        </List>
        {/* <Divider />
        <List>
          {["All mail", "Trash", "Spam"].map((text, index) => (
            <ListItem button key={text}>
              <ListItemIcon>
                {index % 2 === 0 ? <InboxIcon /> : <MailIcon />}
              </ListItemIcon>
              <ListItemText primary={text} />
            </ListItem>
          ))}
        </List> */}
      </Drawer>
      <main className={classes.content}>
        <div className={classes.toolbar} />
      </main>
    </div>
  );
};

export default MUIDrawer;
