# React Cherry Demo

This is a Web project made by React and Material UI. 
In this Project, we have an user system, products and orders page, and getting data form API.

In user system, we have a register and a login page, which can register new user and login by user. If we don't login as a user, we can only access home page, otherwise we can enter products and orders page to check products and orders data from API.

In products page, we get all products data from API and show them in Material UI collapsed table with pagination, sorting and searching, each products can be edited and deleted, we can also add new products and upload image into products.

In orders page, same as products page, we get all orders data from API and show in table. Orders row can be filtered by date.

Both products and order page can export data into csv file.


## Dependencies Used

### Material UI

```npm install @material-ui/core```

[Material UI Get Started](https://material-ui.com/getting-started/installation/)

### Axios

```npm install axios```

[Axios Get Started](https://axios-http.com/docs/intro)

### React Router Dom

```npm install react-router-dom```

[React Router Dom Get Started](https://reactrouter.com/web/guides/quick-start)

### React Csv

```npm i react-csv```

[React Csv installed](https://www.npmjs.com/package/react-csv)

## Project screenshot


### Home Page

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/homePage.png?raw=true" />

### Login Page

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/loginPage.png?raw=true" />

### Register Page

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/registerPage.png?raw=true" />

### Products Page

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/productsPage.png?raw=true" />

### Add Product

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/productsAdd.png?raw=true" />

### Edit Product

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/productsEdit.png?raw=true" />

### Delete Product

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/productsDelete.png?raw=true" />

### Products Searching

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/productsSearching.png?raw=true" />

### Spinner

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/spinner.png?raw=true" />

### Orders with different pagination

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/ordersPageWithDiffPagination.png?raw=true" />

### Orders date filter

<img src="https://github.com/Hamsiny/React_Cherry_Demo/blob/master/images/ordersDateFilter.png?raw=true" />