export default {
  easyApplyButtonEnabled: "button.jobs-apply-button:enabled",
  easyApplyButton: 'button.jobs-apply-button[aria-label^="Easy Apply"]',
  applyButton: "button.jobs-apply-button",

  // Job search form
  keywordInput: 'input[id*="jobs-search-box-keyword-id"]',
  locationInput: 'input[id*="jobs-search-box-location-id"]',

  // Easy apply form
  checkbox: ".jobs-easy-apply-modal input[type='checkbox']",
  fieldset: ".jobs-easy-apply-modal fieldset",
  select: ".jobs-easy-apply-modal select",
  nextButton:
    ".jobs-easy-apply-modal footer button[aria-label*='next'], .jobs-easy-apply-modal footer button[aria-label*='Review'], .jobs-easy-apply-modal footer button[aria-label*='Submit application']:enabled, .jobs-easy-apply-modal footer button[aria-label*='Review your application']:enabled, .jobs-easy-apply-modal footer button[aria-label*='Done']:enabled",
  submit: ".jobs-easy-apply-modal footer button[aria-label*='Submit']",
  enabledSubmitOrNextButton:
    ".jobs-easy-apply-modal footer button[aria-label*='Submit']:enabled, .jobs-easy-apply-modal  footer button[aria-label*='next']:enabled, .jobs-easy-apply-modal  footer button[aria-label*='Review']:enabled button[aria-label*='Submit application']:enabled button[aria-label*='Review your application']:enabled",
  textInput:
    ".jobs-easy-apply-modal input[type='text'], .jobs-easy-apply-modal textarea",
  homeCity:
    ".jobs-easy-apply-modal input[id*='easyApplyFormElement'][id*='city-HOME-CITY']",
  phone:
    ".jobs-easy-apply-modal input[id*='easyApplyFormElement'][id*='phoneNumber']",
  documentUpload: ".jobs-easy-apply-modal div[class*='jobs-document-upload']",
  documentUploadLabel: "label[class*='jobs-document-upload']",
  documentUploadInput: "input[type='file'][id*='jobs-document-upload']",
  radioInput: "input[type='radio']",
  option: "option",
  followCompanyCheckbox: 'input[type="checkbox"]#follow-company-checkbox',

  // Login
  captcha: "#captcha-internal",
  emailInput: "#session_key",
  passwordInput: "#session_password",
  loginSubmit: "button[class*='sign-in-form__submit-btn']",
  skipButton: "button[text()='Skip']",

  loginAuthWall:
    "button[class*='authwall-join-form__form-toggle--bottom form-toggle",

  // fetch user
  searchResultList: ".jobs-search-results-list",
  searchResultListText: "small.jobs-search-results-list__text",
  searchResultListItem: ".jobs-search-results__list-item",
  searchResultListItemLink: ".job-card-container__link",
  searchResultListItemCompanyName:
    ".job-details-jobs-unified-top-card__primary-description-container",
  jobDescription: ".jobs-box__html-content.jobs-description-content__text",
  appliedToJobFeedback: ".artdeco-inline-feedback",

  // fetch guest
  jobCount: ".results-context-header__job-count",
  showMoreButton: ".infinite-scroller__show-more-button:enabled",
  searchResultListItemGuest: ".jobs-search__results-list li",
  searchResultListItemTitleGuest: ".base-search-card__title",
  searchResultListItemSubtitleGuest: ".base-search-card__subtitle",
  searchResultListItemLocationGuest: ".job-search-card__location",
};
