## Post-Processing
Post-processing is a crucial step to refine the generated SQL queries, ensuring they meet user expectations more accurately. This involves enhancing the initial SQL output using various strategies.
### SQL Correction Strategies：
#### 🎓Basic concept:
SQL correction strategies are designed to prompt language models to identify and fix syntax errors in SQL queries generated by NLP models. These strategies involve guiding models to refine their outputs by addressing issues such as missing or redundant keywords and incorrect predicate values. As the capabilities of language models improve, these strategies are evolving to support more general error correction, enhancing the accuracy and robustness of SQL query generation.
#### 📚Representative papers：
+ `Paper` [DIN-SQL: Decomposed In-Context Learning of Text-to-SQL with Self-Correction](https://proceedings.neurips.cc/paper_files/paper/2023/hash/72223cc66f63ca1aa59edaec1b3670e6-Abstract-Conference.html) 
+ `Describe` This paper proposes a self-correction module that guides the model to correct SQL errors. This module is implemented in the zero-shot setting, where the model is only provided with the buggy SQL and asked to fix the errors. The study suggests two different prompts for different models: a general prompt for the CodeX model and a mild prompt for the GPT-4 model.
+ `Paper` [Interleaving Pre-Trained Language Models and Large Language Models for Zero-Shot NL2SQL Generation](https://arxiv.org/abs/2306.08891) 
+ `Describe` This paper adopts a multi-level matching approach that incrementally expands the matching scope across three levels (columns, tables, and databases) to sequentially match predicate values. The matched predicate values are then returned to the LLMs, helping it generate SQL queries consistent with the database content.
+ `Paper` [MAC-SQL: A Multi-Agent Collaborative Framework for Text-to-SQL](https://arxiv.org/abs/2312.11242) 
+ `Describe` This paper designs a Refiner agent, whose primary function is to detect and correct SQL errors. After receiving an SQL query, the Refiner Agent will diagnose the SQL statement from three aspects: syntactic correctness, execution feasibility, and whether it retrieves non-empty results from the database. If the check fails, it will reason based on the original SQL and error feedback information or modification guidance signals to correct the erroneous SQL statement. The core function is to enable the model to perform self-diagnosis and self-correction, thereby enhancing the robustness and accuracy of the overall framework.
---
### Output Consistency：
#### 🎓Basic concept:
The purpose of output consistency strategies is to enhance the reliability of SQL queries generated by models, ensuring they consistently express the same meaning despite inherent randomness and uncertainty. Techniques like self-consistency sample multiple reasoning paths and use voting mechanisms to select the most consistent result, while cross-consistency involves multiple models generating SQL at low temperatures to maintain performance and diversify outputs. These methods improve the accuracy and reliability of SQL generation but can significantly increase inference cost and time.
#### 📚Representative papers：
+ `Paper` [C3: Zero-shot Text-to-SQL with ChatGPT](https://arxiv.org/abs/2307.07306) 
+ `Describe` This paper incorporates the Consistency Output (CO) component, which aims to maintain the consistency of the generated SQL queries by overcoming the inherent randomness and uncertainty in the outputs of large language models, thereby improving zero-shot \nlsql performance. Specifically, CO first samples multiple reasoning paths to generate different SQL answers. Then, these SQL queries are executed on the database, and the execution results are collected. After removing errors from all results, a voting mechanism is applied to these execution results to determine the most consistent SQL as the final SQL. This method enables models to leverage the collective knowledge derived from these multiple paths, resulting in more reliable outcomes in generating SQL queries. 
+ `Paper` [PET-SQL: A Prompt-Enhanced Two-Round Refinement of Text-to-SQL with Cross-consistency
](https://arxiv.org/abs/2403.09732) 
+ `Describe` This paper proposes the cross-consistency strategy, which instructs multiple LLMs to generate SQL at lower temperatures and then votes on the execution results of the SQL. This cross-consistency strategy not only diversifies SQL queries but also maintains the performance of LLMs at low-temperature settings.
---
### Execution-Guided Strategies：
#### 🎓Basic concept:
Execution-guided strategies use the results of SQL query executions to refine and ensure the accuracy of generated queries. By incorporating execution feedback, models can iteratively correct errors and optimize SQL queries to retrieve valid data. However, this approach can increase the time required for SQL generation, especially when dealing with large databases.
#### 📚Representative papers：
+ `Paper` [Interleaving Pre-Trained Language Models and Large Language Models for Zero-Shot NL2SQL Generation](https://arxiv.org/abs/2306.08891) 
+ `Describe` This paper continuously generates SQL queries through an executable check process after obtaining multiple candidate SQL sketches. It feeds back error messages to the LLMs to achieve an executable query.
+ `Paper` [CHESS: Contextual Harnessing for Efficient SQL Synthesis](https://arxiv.org/pdf/2405.16755)
+ `Describe` To reflect human behavior when writing complex sql queries, this paper returns not only the database schema, question, and candidate SQL queries but also the execution results of the SQL queries to LLMs. Specifically, CHESS starts with a draft query and refines it based on its execution results, making necessary adjustments to the SQL query in case of syntax errors.
---
### N-best Rankers Strategies：
#### 🎓Basic concept:
N-best rerankers strategies aim to reorder the top n generated SQL queries to enhance accuracy in cross-domain NL2SQL tasks. These methods often utilize larger models or additional knowledge sources to refine the rankings, thereby improving the semantic match between the user’s query and the generated SQL. By employing techniques like fine-tuning pre-trained language models and leveraging contrastive learning, these strategies address the variability and correctness of the generated queries, leading to more reliable outcomes.
#### 📚Representative papers：
+ `Paper` [Bertrand-DR: Improving Text-to-SQL using a Discriminative Re-ranker](https://arxiv.org/abs/2002.00557) 
+ `Describe` This paper fine-tunes a BERT model as a reranker on the Spider dataset, and this work has successfully improved multiple NL2SQL models.
+ `Paper` [G3R: A Graph-Guided Generate-and-Rerank Framework for Complex and Cross-domain Text-to-SQL Generation](https://aclanthology.org/2023.findings-acl.23/) 
+ `Describe` This paper proposes a feature-enhanced reranker based on Pre-trained Language Model (PLM) to address the shortcomings of unstablility and highly dependenence on threshold settings. The SQL reranker leverages a PLM with hybrid prompt tuning to integrate into the PLM's knowledge, effectively bridging gaps between various domains without adding extra parameters. Contrastive learning is then used to push away the representation distance of candidate queries, making them more distinguishable.
+ `Paper` [N-Best Hypotheses Reranking for Text-to-SQL Systems](https://ieeexplore.ieee.org/abstract/document/10023434) 
+ `Describe` This paper proposes two rerankers from the perspectives of consistency and correctness. To improve consistency, query plans generated by independent models can be used to explore N-best reranking. Then, to enhance correctness, they introduced a heuristic algorithm that applies schema linking on the N-best list to impose constraints missing in PICARD. The combined reranking method produces improvements on T5 models.
+ `Paper` [ReFSQL: A Retrieval-Augmentation Framework for Text-to-SQL Generation](https://aclanthology.org/2023.findings-emnlp.48/) 
+ `Describe` This paper employs a ranking algorithm to retrieve the most closely related generated results from the retriever and generator module. 
---


