export default {
	Cancel: 3,
	Help: 6,
	Backspace: 8,
	Tab: 9,
	Clear: 12,
	Enter: 13,
	Shift: 16,
	Control: 17,
	Alt: 18,
	Pause: 19,
	CapsLock: 20,
	Escape: 27,
	Convert: 28,
	NonConvert: 29,
	Accept: 30,
	ModeChange: 31,
	' ': 32,
	PageUp: 33,
	PageDown: 34,
	End: 35,
	Home: 36,
	ArrowLeft: 37,
	ArrowUp: 38,
	ArrowRight: 39,
	ArrowDown: 40,
	Select: 41,
	Print: 42,
	Execute: 43,
	PrintScreen: 44,
	Insert: 45,
	Delete: 46,
	0: 48,
	')': 48,
	1: 49,
	'!': 49,
	2: 50,
	'@': 50,
	3: 51,
	'#': 51,
	4: 52,
	$: 52,
	5: 53,
	'%': 53,
	6: 54,
	'^': 54,
	7: 55,
	'&': 55,
	8: 56,
	'*': 56,
	9: 57,
	'(': 57,
	a: 65,
	A: 65,
	b: 66,
	B: 66,
	c: 67,
	C: 67,
	d: 68,
	D: 68,
	e: 69,
	E: 69,
	f: 70,
	F: 70,
	g: 71,
	G: 71,
	h: 72,
	H: 72,
	i: 73,
	I: 73,
	j: 74,
	J: 74,
	k: 75,
	K: 75,
	l: 76,
	L: 76,
	m: 77,
	M: 77,
	n: 78,
	N: 78,
	o: 79,
	O: 79,
	p: 80,
	P: 80,
	q: 81,
	Q: 81,
	r: 82,
	R: 82,
	s: 83,
	S: 83,
	t: 84,
	T: 84,
	u: 85,
	U: 85,
	v: 86,
	V: 86,
	w: 87,
	W: 87,
	x: 88,
	X: 88,
	y: 89,
	Y: 89,
	z: 90,
	Z: 90,
	OS: 91,
	ContextMenu: 93,
	F1: 112,
	F2: 113,
	F3: 114,
	F4: 115,
	F5: 116,
	F6: 117,
	F7: 118,
	F8: 119,
	F9: 120,
	F10: 121,
	F11: 122,
	F12: 123,
	F13: 124,
	F14: 125,
	F15: 126,
	F16: 127,
	F17: 128,
	F18: 129,
	F19: 130,
	F20: 131,
	F21: 132,
	F22: 133,
	F23: 134,
	F24: 135,
	NumLock: 144,
	ScrollLock: 145,
	VolumeMute: 181,
	VolumeDown: 182,
	VolumeUp: 183,
	';': 186,
	':': 186,
	'=': 187,
	'+': 187,
	',': 188,
	'<': 188,
	'-': 189,
	_: 189,
	'.': 190,
	'>': 190,
	'/': 191,
	'?': 191,
	'`': 192,
	'~': 192,
	'[': 219,
	'{': 219,
	'\\': 220,
	'|': 220,
	']': 221,
	'}': 221,
	"'": 222,
	'"': 222,
	Meta: 224,
	AltGraph: 225,
	Attn: 246,
	CrSel: 247,
	ExSel: 248,
	EraseEof: 249,
	Play: 250,
	ZoomOut: 251,
};

const keymap: Record<string, string> = {
	a: 'a',
	A: 'a',
	b: 'b',
	B: 'b',
	c: 'c',
	C: 'c',
	d: 'd',
	D: 'd',
	e: 'e',
	E: 'e',
	f: 'f',
	F: 'f',
	g: 'g',
	G: 'g',
	h: 'h',
	H: 'h',
	i: 'i',
	I: 'i',
	j: 'j',
	J: 'j',
	k: 'k',
	K: 'k',
	l: 'l',
	L: 'l',
	m: 'm',
	M: 'm',
	n: 'n',
	N: 'n',
	o: 'o',
	O: 'o',
	p: 'p',
	P: 'p',
	q: 'q',
	Q: 'q',
	r: 'r',
	R: 'r',
	s: 's',
	S: 's',
	t: 't',
	T: 't',
	u: 'u',
	U: 'u',
	v: 'v',
	V: 'v',
	w: 'w',
	W: 'w',
	x: 'x',
	X: 'x',
	y: 'y',
	Y: 'y',
	z: 'z',
	Z: 'z',
};

export const keycodeFilter = (key: string) => {
	return keymap[key];
};
