# Otomanopee Font - Features and All Alternate Glyphs

This file provides detailed information on the Otomanopee font Software.  
https://github.com/Gutenberg-Labo/Otomanopee


## Latin character set

### Latin Alphabet

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x0041  | A     | A                           | A.rotat                          |
| 0x0042  | B     | B                           | B.rotat                          |
| 0x0043  | C     | C                           | C.rotat                          |
| 0x0044  | D     | D                           | D.rotat                          |
| 0x0045  | E     | E                           | E.rotat                          |
| 0x0046  | F     | F                           | F.rotat                          |
| 0x0047  | G     | G                           | G.rotat                          |
| 0x0048  | H     | H                           | H.rotat                          |
| 0x0049  | I     | I                           | I.rotat                          |
| 0x004A  | J     | J                           | J.rotat                          |
| 0x004B  | K     | K                           | K.rotat                          |
| 0x004C  | L     | L                           | L.rotat                          |
| 0x004D  | M     | M                           | M.rotat                          |
| 0x004E  | N     | N                           | N.rotat                          |
| 0x004F  | O     | O                           | O.rotat                          |
| 0x0050  | P     | P                           | P.rotat                          |
| 0x0051  | Q     | Q                           | Q.rotat                          |
| 0x0052  | R     | R                           | R.rotat                          |
| 0x0053  | S     | S                           | S.rotat                          |
| 0x0054  | T     | T                           | T.rotat                          |
| 0x0055  | U     | U                           | U.rotat                          |
| 0x0056  | V     | V                           | V.rotat                          |
| 0x0057  | W     | W                           | W.rotat                          |
| 0x0058  | X     | X                           | X.rotat                          |
| 0x0059  | Y     | Y                           | Y.rotat                          |
| 0x005A  | Z     | Z                           | Z.rotat                          |
| 0x0061  | a     | a                           | a.rotat                          |
| 0x0062  | b     | b                           | b.rotat                          |
| 0x0063  | c     | c                           | c.rotat                          |
| 0x0064  | d     | d                           | d.rotat                          |
| 0x0065  | e     | e                           | e.rotat                          |
| 0x0066  | f     | f                           | f.rotat                          |
| 0x0067  | g     | g                           | g.rotat                          |
| 0x0068  | h     | h                           | h.rotat                          |
| 0x0069  | i     | i                           | i.rotat                          |
| 0x006A  | j     | j                           | j.rotat                          |
| 0x006B  | k     | k                           | k.rotat                          |
| 0x006C  | l     | l                           | l.rotat                          |
| 0x006D  | m     | m                           | m.rotat                          |
| 0x006E  | n     | n                           | n.rotat                          |
| 0x006F  | o     | o                           | o.rotat                          |
| 0x0070  | p     | p                           | p.rotat                          |
| 0x0071  | q     | q                           | q.rotat                          |
| 0x0072  | r     | r                           | r.rotat                          |
| 0x0073  | s     | s                           | s.rotat                          |
| 0x0074  | t     | t                           | t.rotat                          |
| 0x0075  | u     | u                           | u.rotat                          |
| 0x0076  | v     | v                           | v.rotat                          |
| 0x0077  | w     | w                           | w.rotat                          |
| 0x0078  | x     | x                           | x.rotat                          |
| 0x0079  | y     | y                           | y.rotat                          |
| 0x007A  | z     | z                           | z.rotat                          |
| 0x00C0  | À     | Agrave                      | Agrave.rotat                     |
| 0x00C1  | Á     | Aacute                      | Aacute.rotat                     |
| 0x00C2  | Â     | Acircumflex                 | Acircumflex.rotat                |
| 0x00C3  | Ã     | Atilde                      | Atilde.rotat                     |
| 0x00C4  | Ä     | Adieresis                   | Adieresis.rotat                  |
| 0x00C5  | Å     | Aring                       | Aring.rotat                      |
| 0x00C6  | Æ     | AE                          | AE.rotat                         |
| 0x00C7  | Ç     | Ccedilla                    | Ccedilla.rotat                   |
| 0x00C8  | È     | Egrave                      | Egrave.rotat                     |
| 0x00C9  | É     | Eacute                      | Eacute.rotat                     |
| 0x00CA  | Ê     | Ecircumflex                 | Ecircumflex.rotat                |
| 0x00CB  | Ë     | Edieresis                   | Edieresis.rotat                  |
| 0x00CC  | Ì     | Igrave                      | Igrave.rotat                     |
| 0x00CD  | Í     | Iacute                      | Iacute.rotat                     |
| 0x00CE  | Î     | Icircumflex                 | Icircumflex.rotat                |
| 0x00CF  | Ï     | Idieresis                   | Idieresis.rotat                  |
| 0x00D0  | Ð     | Eth                         | Eth.rotat                        |
| 0x00D1  | Ñ     | Ntilde                      | Ntilde.rotat                     |
| 0x00D2  | Ò     | Ograve                      | Ograve.rotat                     |
| 0x00D3  | Ó     | Oacute                      | Oacute.rotat                     |
| 0x00D4  | Ô     | Ocircumflex                 | Ocircumflex.rotat                |
| 0x00D5  | Õ     | Otilde                      | Otilde.rotat                     |
| 0x00D6  | Ö     | Odieresis                   | Odieresis.rotat                  |
| 0x00D8  | Ø     | Oslash                      | Oslash.rotat                     |
| 0x00D9  | Ù     | Ugrave                      | Ugrave.rotat                     |
| 0x00DA  | Ú     | Uacute                      | Uacute.rotat                     |
| 0x00DB  | Û     | Ucircumflex                 | Ucircumflex.rotat                |
| 0x00DC  | Ü     | Udieresis                   | Udieresis.rotat                  |
| 0x00DD  | Ý     | Yacute                      | Yacute.rotat                     |
| 0x00DE  | Þ     | Thorn                       | Thorn.rotat                      |
| 0x00DF  | ß     | germandbls                  | germandbls.rotat                 |
| 0x00E0  | à     | agrave                      | agrave.rotat                     |
| 0x00E1  | á     | aacute                      | aacute.rotat                     |
| 0x00E2  | â     | acircumflex                 | acircumflex.rotat                |
| 0x00E3  | ã     | atilde                      | atilde.rotat                     |
| 0x00E4  | ä     | adieresis                   | adieresis.rotat                  |
| 0x00E5  | å     | aring                       | aring.rotat                      |
| 0x00E6  | æ     | ae                          | ae.rotat                         |
| 0x00E7  | ç     | ccedilla                    | ccedilla.rotat                   |
| 0x00E8  | è     | egrave                      | egrave.rotat                     |
| 0x00E9  | é     | eacute                      | eacute.rotat                     |
| 0x00EA  | ê     | ecircumflex                 | ecircumflex.rotat                |
| 0x00EB  | ë     | edieresis                   | edieresis.rotat                  |
| 0x00EC  | ì     | igrave                      | igrave.rotat                     |
| 0x00ED  | í     | iacute                      | iacute.rotat                     |
| 0x00EE  | î     | icircumflex                 | icircumflex.rotat                |
| 0x00EF  | ï     | idieresis                   | idieresis.rotat                  |
| 0x00F0  | ð     | eth                         | eth.rotat                        |
| 0x00F1  | ñ     | ntilde                      | ntilde.rotat                     |
| 0x00F2  | ò     | ograve                      | ograve.rotat                     |
| 0x00F3  | ó     | oacute                      | oacute.rotat                     |
| 0x00F4  | ô     | ocircumflex                 | ocircumflex.rotat                |
| 0x00F5  | õ     | otilde                      | otilde.rotat                     |
| 0x00F6  | ö     | odieresis                   | odieresis.rotat                  |
| 0x00F8  | ø     | oslash                      | oslash.rotat                     |
| 0x00F9  | ù     | ugrave                      | ugrave.rotat                     |
| 0x00FA  | ú     | uacute                      | uacute.rotat                     |
| 0x00FB  | û     | ucircumflex                 | ucircumflex.rotat                |
| 0x00FC  | ü     | udieresis                   | udieresis.rotat                  |
| 0x00FD  | ý     | yacute                      | yacute.rotat                     |
| 0x00FE  | þ     | thorn                       | thorn.rotat                      |
| 0x00FF  | ÿ     | ydieresis                   | ydieresis.rotat                  |
| 0x0100  | Ā     | Amacron                     | Amacron.rotat                    |
| 0x0101  | ā     | amacron                     | amacron.rotat                    |
| 0x0102  | Ă     | Abreve                      | Abreve.rotat                     |
| 0x0103  | ă     | abreve                      | abreve.rotat                     |
| 0x0104  | Ą     | Aogonek                     | Aogonek.rotat                    |
| 0x0105  | ą     | aogonek                     | aogonek.rotat                    |
| 0x0106  | Ć     | Cacute                      | Cacute.rotat                     |
| 0x0107  | ć     | cacute                      | cacute.rotat                     |
| 0x010A  | Ċ     | Cdotaccent                  | Cdotaccent.rotat                 |
| 0x010B  | ċ     | cdotaccent                  | cdotaccent.rotat                 |
| 0x010C  | Č     | Ccaron                      | Ccaron.rotat                     |
| 0x010D  | č     | ccaron                      | ccaron.rotat                     |
| 0x010E  | Ď     | Dcaron                      | Dcaron.rotat                     |
| 0x010F  | ď     | dcaron                      | dcaron.rotat                     |
| 0x0110  | Đ     | Dcroat                      | Dcroat.rotat                     |
| 0x0111  | đ     | dcroat                      | dcroat.rotat                     |
| 0x0112  | Ē     | Emacron                     | Emacron.rotat                    |
| 0x0113  | ē     | emacron                     | emacron.rotat                    |
| 0x0116  | Ė     | Edotaccent                  | Edotaccent.rotat                 |
| 0x0117  | ė     | edotaccent                  | edotaccent.rotat                 |
| 0x0118  | Ę     | Eogonek                     | Eogonek.rotat                    |
| 0x0119  | ę     | eogonek                     | eogonek.rotat                    |
| 0x011A  | Ě     | Ecaron                      | Ecaron.rotat                     |
| 0x011B  | ě     | ecaron                      | ecaron.rotat                     |
| 0x011E  | Ğ     | Gbreve                      | Gbreve.rotat                     |
| 0x011F  | ğ     | gbreve                      | gbreve.rotat                     |
| 0x0120  | Ġ     | Gdotaccent                  | Gdotaccent.rotat                 |
| 0x0121  | ġ     | gdotaccent                  | gdotaccent.rotat                 |
| 0x0122  | Ģ     | Gcommaaccent                | Gcommaaccent.rotat               |
| 0x0123  | ģ     | gcommaaccent                | gcommaaccent.rotat               |
| 0x0126  | Ħ     | Hbar                        | Hbar.rotat                       |
| 0x0127  | ħ     | hbar                        | hbar.rotat                       |
| 0x0128  | Ĩ     | Itilde                      | Itilde.rotat                     |
| 0x0129  | ĩ     | itilde                      | itilde.rotat                     |
| 0x012A  | Ī     | Imacron                     | Imacron.rotat                    |
| 0x012B  | ī     | imacron                     | imacron.rotat                    |
| 0x012E  | Į     | Iogonek                     | Iogonek.rotat                    |
| 0x012F  | į     | iogonek                     | iogonek.rotat                    |
| 0x0130  | İ     | Idotaccent                  | Idotaccent.rotat                 |
| 0x0131  | ı     | idotless                    | idotless.rotat                   |
| 0x0136  | Ķ     | Kcommaaccent                | Kcommaaccent.rotat               |
| 0x0137  | ķ     | kcommaaccent                | kcommaaccent.rotat               |
| 0x0139  | Ĺ     | Lacute                      | Lacute.rotat                     |
| 0x013A  | ĺ     | lacute                      | lacute.rotat                     |
| 0x013B  | Ļ     | Lcommaaccent                | Lcommaaccent.rotat               |
| 0x013C  | ļ     | lcommaaccent                | lcommaaccent.rotat               |
| 0x013D  | Ľ     | Lcaron                      | Lcaron.rotat                     |
| 0x013E  | ľ     | lcaron                      | lcaron.rotat                     |
| 0x0141  | Ł     | Lslash                      | Lslash.rotat                     |
| 0x0142  | ł     | lslash                      | lslash.rotat                     |
| 0x0143  | Ń     | Nacute                      | Nacute.rotat                     |
| 0x0144  | ń     | nacute                      | nacute.rotat                     |
| 0x0145  | Ņ     | Ncommaaccent                | Ncommaaccent.rotat               |
| 0x0146  | ņ     | ncommaaccent                | ncommaaccent.rotat               |
| 0x0147  | Ň     | Ncaron                      | Ncaron.rotat                     |
| 0x0148  | ň     | ncaron                      | ncaron.rotat                     |
| 0x0150  | Ő     | Ohungarumlaut               | Ohungarumlaut.rotat              |
| 0x0151  | ő     | ohungarumlaut               | ohungarumlaut.rotat              |
| 0x0152  | Œ     | OE                          | OE.rotat                         |
| 0x0153  | œ     | oe                          | oe.rotat                         |
| 0x0154  | Ŕ     | Racute                      | Racute.rotat                     |
| 0x0155  | ŕ     | racute                      | racute.rotat                     |
| 0x0158  | Ř     | Rcaron                      | Rcaron.rotat                     |
| 0x0159  | ř     | rcaron                      | rcaron.rotat                     |
| 0x015A  | Ś     | Sacute                      | Sacute.rotat                     |
| 0x015B  | ś     | sacute                      | sacute.rotat                     |
| 0x015E  | Ş     | Scedilla                    | Scedilla.rotat                   |
| 0x015F  | ş     | scedilla                    | scedilla.rotat                   |
| 0x0160  | Š     | Scaron                      | Scaron.rotat                     |
| 0x0161  | š     | scaron                      | scaron.rotat                     |
| 0x0164  | Ť     | Tcaron                      | Tcaron.rotat                     |
| 0x0165  | ť     | tcaron                      | tcaron.rotat                     |
| 0x0168  | Ũ     | Utilde                      | Utilde.rotat                     |
| 0x0169  | ũ     | utilde                      | utilde.rotat                     |
| 0x016A  | Ū     | Umacron                     | Umacron.rotat                    |
| 0x016B  | ū     | umacron                     | umacron.rotat                    |
| 0x016E  | Ů     | Uring                       | Uring.rotat                      |
| 0x016F  | ů     | uring                       | uring.rotat                      |
| 0x0170  | Ű     | Uhungarumlaut               | Uhungarumlaut.rotat              |
| 0x0171  | ű     | uhungarumlaut               | uhungarumlaut.rotat              |
| 0x0172  | Ų     | Uogonek                     | Uogonek.rotat                    |
| 0x0173  | ų     | uogonek                     | uogonek.rotat                    |
| 0x0174  | Ŵ     | Wcircumflex                 | Wcircumflex.rotat                |
| 0x0175  | ŵ     | wcircumflex                 | wcircumflex.rotat                |
| 0x0176  | Ŷ     | Ycircumflex                 | Ycircumflex.rotat                |
| 0x0177  | ŷ     | ycircumflex                 | ycircumflex.rotat                |
| 0x0178  | Ÿ     | Ydieresis                   | Ydieresis.rotat                  |
| 0x0179  | Ź     | Zacute                      | Zacute.rotat                     |
| 0x017A  | ź     | zacute                      | zacute.rotat                     |
| 0x017B  | Ż     | Zdotaccent                  | Zdotaccent.rotat                 |
| 0x017C  | ż     | zdotaccent                  | zdotaccent.rotat                 |
| 0x017D  | Ž     | Zcaron                      | Zcaron.rotat                     |
| 0x017E  | ž     | zcaron                      | zcaron.rotat                     |
| 0x0218  | Ș     | Scommaaccent                | Scommaaccent.rotat               |
| 0x0219  | ș     | scommaaccent                | scommaaccent.rotat               |
| 0x021A  | Ț     | Tcommaaccent                | Tcommaaccent.rotat               |
| 0x021B  | ț     | tcommaaccent                | tcommaaccent.rotat               |
| 0x0237  | ȷ     | jdotless                    | jdotless.rotat                   |
| 0x1E80  | Ẁ     | Wgrave                      | Wgrave.rotat                     |
| 0x1E81  | ẁ     | wgrave                      | wgrave.rotat                     |
| 0x1E82  | Ẃ     | Wacute                      | Wacute.rotat                     |
| 0x1E83  | ẃ     | wacute                      | wacute.rotat                     |
| 0x1E84  | Ẅ     | Wdieresis                   | Wdieresis.rotat                  |
| 0x1E85  | ẅ     | wdieresis                   | wdieresis.rotat                  |
| 0x1E9E  | ẞ     | Germandbls                  | Germandbls.rotat                 |
| 0x1EBC  | Ẽ     | Etilde                      | Etilde.rotat                     |
| 0x1EBD  | ẽ     | etilde                      | etilde.rotat                     |
| 0x1EF2  | Ỳ     | Ygrave                      | Ygrave.rotat                     |
| 0x1EF3  | ỳ     | ygrave                      | ygrave.rotat                     |
| 0x1EF8  | Ỹ     | Ytilde                      | Ytilde.rotat                     |
| 0x1EF9  | ỹ     | ytilde                      | ytilde.rotat                     |
| 0xFB01  | ﬁ     | fi                          | fi.rotat                         |
| 0xFB02  | ﬂ     | fl                          | fl.rotat                         |
|         | i     | idotaccent                  | idotaccent.rotat                 |


### Greek Alphabet

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x0394  | Δ    | Delta                       | Delta.rotat                      |
| 0x03A0  | Π    | Pi                          | Pi.rotat                         |
| 0x03A3  | Σ    | Sigma                       | Sigma.rotat                      |
| 0x03A9  | Ω    | Omega                       | Omega.rotat                      |
| 0x03BC  | μ    | mu                          | mu.rotat                         |
| 0x03C0  | π    | pi                          | pi.rotat                         |


### Numerals

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x0030  | 0     | zero                        | zero.rotat                       |
| 0x0031  | 1     | one                         | one.rotat                        |
| 0x0032  | 2     | two                         | two.rotat                        |
| 0x0033  | 3     | three                       | three.rotat                      |
| 0x0034  | 4     | four                        | four.rotat                       |
| 0x0035  | 5     | five                        | five.rotat                       |
| 0x0036  | 6     | six                         | six.rotat                        |
| 0x0037  | 7     | seven                       | seven.rotat                      |
| 0x0038  | 8     | eight                       | eight.rotat                      |
| 0x0039  | 9     | nine                        | nine.rotat                       |
| 0x00B9  | ¹     | onesuperior                 | onesuperior.rotat                |
| 0x00B2  | ²     | twosuperior                 | twosuperior.rotat                |
| 0x00B3  | ³     | threesuperior               | threesuperior.rotat              |
| 0x2074  | ⁴     | foursuperior                | foursuperior.rotat               |
| 0x00BC  | ¼     | onequarter                  | onequarter.rotat                 |
| 0x00BD  | ½     | onehalf                     | onehalf.rotat                    |
| 0x00BE  | ¾     | threequarters               | threequarters.rotat              |


### Punctation

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x0020  |       | space                       | space.rotat                      |
| 0x0021  | !     | exclam                      | exclam.rotat                     |
| 0x0022  | "     | quotedbl                    | quotedbl.rotat                   |
| 0x0023  | #     | numbersign                  | numbersign.rotat                 |
| 0x0024  | $     | dollar                      | dollar.rotat                     |
| 0x0025  | %     | percent                     | percent.rotat                    |
| 0x0026  | &     | ampersand                   | ampersand.rotat                  |
| 0x0027  | '     | quotesingle                 | quotesingle.rotat                |
| 0x0028  | (     | parenleft                   | parenleft.rotat                  |
| 0x0029  | )     | parenright                  | parenright.rotat                 |
| 0x002A  | *     | asterisk                    | asterisk.rotat                   |
| 0x002B  | +     | plus                        | plus.rotat                       |
| 0x002C  | ,     | comma                       | comma.rotat                      |
| 0x002D  | -     | hyphen                      | hyphen.rotat                     |
| 0x002E  | .     | period                      | period.rotat                     |
| 0x002F  | /     | slash                       | slash.rotat                      |
| 0x003A  | :     | colon                       | colon.rotat                      |
| 0x003B  | ;     | semicolon                   | semicolon.rotat                  |
| 0x003C  | <     | less                        | less.rotat                       |
| 0x003D  | =     | equal                       | equal.rotat                      |
| 0x003E  | >     | greater                     | greater.rotat                    |
| 0x003F  | ?     | question                    | question.rotat                   |
| 0x0040  | @     | at                          | at.rotat                         |
| 0x005B  | [     | bracketleft                 | bracketleft.rotat                |
| 0x005C  | \     | backslash                   | backslash.rotat                  |
| 0x005D  | ]     | bracketright                | bracketright.rotat               |
| 0x005E  | ^     | asciicircum                 | asciicircum.rotat                |
| 0x005F  | _     | underscore                  | underscore.rotat                 |
| 0x0060  | `     | grave                       | grave.rotat                      |
| 0x007B  | {     | braceleft                   | braceleft.rotat                  |
| 0x007C  | \|    | bar                         | bar.rotat                        |
| 0x007D  | }     | braceright                  | braceright.rotat                 |
| 0x007E  | ~     | asciitilde                  | asciitilde.rotat                 |
| 0x00A0  |       | noBreakSpace                | noBreakSpace.rotat               |
| 0x00A1  | ¡     | exclamdown                  | exclamdown.rotat                 |
| 0x00A2  | ¢    | cent                        | cent.rotat                       |
| 0x00A3  | £    | sterling                    | sterling.rotat                   |
| 0x00A4  | ¤     | currency                    | currency.rotat                   |
| 0x00A5  | ¥     | yen                         | yen.rotat                        |
| 0x00A6  | ¦     | brokenbar                   | brokenbar.rotat                  |
| 0x00A7  | §    | section                     | section.rotat                    |
| 0x00A8  | ¨    | dieresis                    | dieresis.rotat                   |
| 0x00A9  | ©     | copyright                   | copyright.rotat                  |
| 0x00AA  | ª     | ordfeminine                 | ordfeminine.rotat                |
| 0x00AB  | «     | guillemetleft               | guillemetleft.rotat              |
| 0x00AC  | ¬    | logicalnot                  | logicalnot.rotat                 |
| 0x00AD  |       | softHyphen                  | softHyphen.rotat                 |
| 0x00AE  | ®     | registered                  | registered.rotat                 |
| 0x00AF  | ¯     | macron                      | macron.rotat                     |
| 0x00B0  | °    | degree                      | degree.rotat                     |
| 0x00B1  | ±    | plusminus                   | plusminus.rotat                  |
| 0x00B4  | ´    | acute                       | acute.rotat                      |
| 0x00B5  | µ     | micro                       | micro.rotat                      |
| 0x00B6  | ¶    | paragraph                   | paragraph.rotat                  |
| 0x00B7  | ·     | periodcentered              | periodcentered.rotat             |
| 0x00B8  | ¸     | cedilla                     | cedilla.rotat                    |
| 0x00BA  | º     | ordmasculine                | ordmasculine.rotat               |
| 0x00BB  | »     | guillemetright              | guillemetright.rotat             |
| 0x00BF  | ¿     | questiondown                | questiondown.rotat               |
| 0x00D7  | ×    | multiply                    | multiply.rotat                   |
| 0x00F7  | ÷    | divide                      | divide.rotat                     |
| 0x0192  | ƒ     | florin                      | florin.rotat                     |
| 0x02BB  | ʻ     | commaturnedmod              |  commaturnedmod.rotat            |
| 0x02BC  | ʼ     | apostrophemod               |  apostrophemod.rotat             |
| 0x02C6  | ˆ     | circumflex                  | circumflex.rotat                 |
| 0x02C7  | ˇ     | caron                       | caron.rotat                      |
| 0x02C9  | ˉ     | firsttonechinese            | firsttonechinese.rotat           |
| 0x02D8  | ˘     | breve                       | breve.rotat                      |
| 0x02D9  | ˙     | dotaccent                   | dotaccent.rotat                  |
| 0x02DA  | ˚     | ring                        | ring.rotat                       |
| 0x02DB  | ˛     | ogonek                      | ogonek.rotat                     |
| 0x02DC  | ˜     | tilde                       | tilde.rotat                      |
| 0x02DD  | ˝     | hungarumlaut                | hungarumlaut.rotat               |
| 0x2002  |       | enSpace                     | enSpace.rotat                    |
| 0x2009  |       | thinSpace                   | thinSpace.rotat                  |
| 0x200B  |       | zerowidthspace              | zeroWidthSpace.rotat             |
| 0x2013  | –     | endash                      | endash.rotat                     |
| 0x2014  | —    | emdash                      | emdash.rotat                     |
| 0x2015  | ―    | horizontalbar               | horizontalbar.vert               |
| 0x2016  | ‖    | dblverticalbar              | dblverticalbar.rotat             |
| 0x2018  | ‘    | quoteleft                   | quoteleft.rotat                  |
| 0x2019  | ’    | quoteright                  | quoteright.rotat                 |
| 0x201A  | ‚     | quotesinglbase              | quotesinglbase.rotat             |
| 0x201C  | “    | quotedblleft                | quotedblleft.rotat               |
| 0x201D  | ”    | quotedblright               | quotedblright.rotat              |
| 0x201E  | „     | quotedblbase                | quotedblbase.rotat               |
| 0x2020  | †    | dagger                      | dagger.rotat                     |
| 0x2021  | ‡    | daggerdbl                   | daggerdbl.rotat                  |
| 0x2022  | •     | bullet                      | bullet.rotat                     |
| 0x2025  | ‥    | twodotenleader              | twodotenleader.vert              |
| 0x2026  | …    | ellipsis                    | ellipsis.vert                    |
| 0x2030  | ‰    | perthousand                 | perthousand.rotat                |
| 0x2032  | ′    | minute                      | minute.rotat                     |
| 0x2033  | ″    | second                      | second.rotat                     |
| 0x2039  | ‹     | guilsinglleft               | guilsinglleft.rotat              |
| 0x203A  | ›     | guilsinglright              | guilsinglright.rotat             |
| 0x203B  | ※    | referencemark               |                                  |
| 0x2044  | ⁄     | fraction                    | fraction.rotat                   |
| 0x20AC  | €     | euro                        | euro.rotat                       |
| 0x2113  | ℓ    | literSign                   | literSign.rotat                  |
| 0x2122  | ™     | trademark                   | trademark.rotat                  |
| 0x2126  | Ω    | Ohm                         | Ohm.rotat                        |
| 0x212E  | ℮     | estimated                   | estimated.rotat                  |
| 0x2191  | ↑    | upArrow                     | upArrow.rotat                    |
| 0x2193  | ↓    | downArrow                   | downArrow.rotat                  |
| 0x2202  | ∂    | partialdiff                 | partialdiff.rotat                |
| 0x2206  | ∆     | increment                   | increment.rotat                  |
| 0x220F  | ∏     | product                     | product.rotat                    |
| 0x2211  | ∑     | summation                   | summation.rotat                  |
| 0x2212  | −    | minus                       | minus.rotat                      |
| 0x2215  | ∕     | divisionslash               | divisionslash.rotat              |
| 0x2219  | ∙     | bulletoperator              | bulletoperator.rotat             |
| 0x221A  | √    | radical                     | radical.rotat                    |
| 0x221E  | ∞    | infinity                    | infinity.rotat                   |
| 0x222B  | ∫    | integral                    | integral.rotat                   |
| 0x2248  | ≈     | approxequal                 | approxequal.rotat                |
| 0x2260  | ≠    | notequal                    | notequal.rotat                   |
| 0x2264  | ≤     | lessequal                   | lessequal.rotat                  |
| 0x2265  | ≥     | greaterequal                | greaterequal.rotat               |
| 0x25CA  | ◊     | lozenge                     | lozenge.rotat                    |
| 0x0300  | `     | gravecomb                   |                                  |
| 0x0301  | ´    | acutecomb                   |                                  |
| 0x0302  | ^     | circumflexcomb              |                                  |
| 0x0303  | ˜     | tildecomb                   |                                  |
| 0x0304  | ¯     | macroncomb                  |                                  |
| 0x0306  | ˘     | brevecomb                   |                                  |
| 0x0307  | ˙     | dotaccentcomb               |                                  |
| 0x0308  | ¨    | dieresiscomb                |                                  |
| 0x030A  | ˚     | ringcomb                    |                                  |
| 0x030B  | ˝     | hungarumlautcomb            |                                  |
| 0x030C  | ˇ     | caroncomb                   |                                  |
| 0x0326  | ,     | commaaccentcomb             |                                  |
| 0x0327  | ¸     | cedillacomb                 |                                  |
| 0x0328  | ˛     | ogonekcomb                  |                                  |
| 0xFEFF  |       | zeroWidthNoBreakSpace       | zeroWidthNoBreakSpace.rotat      |
| 0xFFFD  | �    | replacementCharacter        | replacementCharacter.rotat       |


******

## Japanese character set

### Fullwidth Latin Alphabet

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0xFF21  | Ａ    | A.full                      | A.full.vert                      |
| 0xFF22  | Ｂ    | B.full                      | B.full.vert                      |
| 0xFF23  | Ｃ    | C.full                      | C.full.vert                      |
| 0xFF24  | Ｄ    | D.full                      | D.full.vert                      |
| 0xFF25  | Ｅ    | E.full                      | E.full.vert                      |
| 0xFF26  | Ｆ    | F.full                      | F.full.vert                      |
| 0xFF27  | Ｇ    | G.full                      | G.full.vert                      |
| 0xFF28  | Ｈ    | H.full                      | H.full.vert                      |
| 0xFF29  | Ｉ    | I.full                      | I.full.vert                      |
| 0xFF2A  | Ｊ    | J.full                      | J.full.vert                      |
| 0xFF2B  | Ｋ    | K.full                      | K.full.vert                      |
| 0xFF2C  | Ｌ    | L.full                      | L.full.vert                      |
| 0xFF2D  | Ｍ    | M.full                      | M.full.vert                      |
| 0xFF2E  | Ｎ    | N.full                      | N.full.vert                      |
| 0xFF2F  | Ｏ    | O.full                      | O.full.vert                      |
| 0xFF30  | Ｐ    | P.full                      | P.full.vert                      |
| 0xFF31  | Ｑ    | Q.full                      | Q.full.vert                      |
| 0xFF32  | Ｒ    | R.full                      | R.full.vert                      |
| 0xFF33  | Ｓ    | S.full                      | S.full.vert                      |
| 0xFF34  | Ｔ    | T.full                      | T.full.vert                      |
| 0xFF35  | Ｕ    | U.full                      | U.full.vert                      |
| 0xFF36  | Ｖ    | V.full                      | V.full.vert                      |
| 0xFF37  | Ｗ    | W.full                      | W.full.vert                      |
| 0xFF38  | Ｘ    | X.full                      | X.full.vert                      |
| 0xFF39  | Ｙ    | Y.full                      | Y.full.vert                      |
| 0xFF3A  | Ｚ    | Z.full                      | Z.full.vert                      |
| 0xFF41  | ａ    | a.full                      | a.full.vert                      |
| 0xFF42  | ｂ    | b.full                      | b.full.vert                      |
| 0xFF43  | ｃ    | c.full                      | c.full.vert                      |
| 0xFF44  | ｄ    | d.full                      | d.full.vert                      |
| 0xFF45  | ｅ    | e.full                      | e.full.vert                      |
| 0xFF46  | ｆ    | f.full                      | f.full.vert                      |
| 0xFF47  | ｇ    | g.full                      | g.full.vert                      |
| 0xFF48  | ｈ    | h.full                      | h.full.vert                      |
| 0xFF49  | ｉ    | i.full                      | i.full.vert                      |
| 0xFF4A  | ｊ    | j.full                      | j.full.vert                      |
| 0xFF4B  | ｋ    | k.full                      | k.full.vert                      |
| 0xFF4C  | ｌ    | l.full                      | l.full.vert                      |
| 0xFF4D  | ｍ    | m.full                      | m.full.vert                      |
| 0xFF4E  | ｎ    | n.full                      | n.full.vert                      |
| 0xFF4F  | ｏ    | o.full                      | o.full.vert                      |
| 0xFF50  | ｐ    | p.full                      | p.full.vert                      |
| 0xFF51  | ｑ    | q.full                      | q.full.vert                      |
| 0xFF52  | ｒ    | r.full                      | r.full.vert                      |
| 0xFF53  | ｓ    | s.full                      | s.full.vert                      |
| 0xFF54  | ｔ    | t.full                      | t.full.vert                      |
| 0xFF55  | ｕ    | u.full                      | u.full.vert                      |
| 0xFF56  | ｖ    | v.full                      | v.full.vert                      |
| 0xFF57  | ｗ    | w.full                      | w.full.vert                      |
| 0xFF58  | ｘ    | x.full                      | x.full.vert                      |
| 0xFF59  | ｙ    | y.full                      | y.full.vert                      |
| 0xFF5A  | ｚ    | z.full                      | z.full.vert                      |


### Fullwidth Numerals

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0xFF10  | ０    | zero.full                   | zero.full.vert                   |
| 0xFF11  | １    | one.full                    | one.full.vert                    |
| 0xFF12  | ２    | two.full                    | two.full.vert                    |
| 0xFF13  | ３    | three.full                  | three.full.vert                  |
| 0xFF14  | ４    | four.full                   | four.full.vert                   |
| 0xFF15  | ５    | five.full                   | five.full.vert                   |
| 0xFF16  | ６    | six.full                    | six.full.vert                    |
| 0xFF17  | ７    | seven.full                  | seven.full.vert                  |
| 0xFF18  | ８    | eight.full                  | eight.full.vert                  |
| 0xFF19  | ９    | nine.full                   | nine.full.vert                   |


### Fullwidth punctuation (for Japanese)

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x3000  | 　    | space-han                   |                                  |
| 0x3001  | 、    | comma-han                   | comma-han.vert                   |
| 0x3002  | 。    | period-han                  | period-han.vert                  |
| 0x3003  | 〃    | dittomark                   | dittomark.vert                   |
| 0x3004  | 〄    | jis                         | jis.cv01                         |
| 0x3005  | 々    | iterationmark-han           |                                  |
| 0x3006  | 〆    | close-han                   |                                  |
| 0x3007  | 〇    | zero-han                    |                                  |
| 0x3008  | 〈    | anglebracketleft            | anglebracketleft.vert            |
| 0x3009  | 〉    | anglebracketright           | anglebracketright.vert           |
| 0x300A  | 《    | dblanglebracketleft         | dblanglebracketleft.vert         |
| 0x300B  | 》    | dblanglebracketright        | dblanglebracketright.vert        |
| 0x300C  | 「    | cornerbracketleft           | cornerbracketleft.vert           |
| 0x300D  | 」    | cornerbracketright          | cornerbracketright.vert          |
| 0x300E  | 『    | whitecornerbracketleft      | whitecornerbracketleft.vert      |
| 0x300F  | 』    | whitecornerbracketright     | whitecornerbracketright.vert     |
| 0x3010  | 【    | blacklenticularbracketleft  | blacklenticularbracketleft.vert  |
| 0x3011  | 】    | blacklenticularbracketright | blacklenticularbracketright.vert |
| 0x3012  | 〒    | postalmark                  |                                  |
| 0x3013  | 〓    | getamark                    | getamark.vert                    |
| 0x3014  | 〔    | tortoiseshellbracketleft    | tortoiseshellbracketleft.vert    |
| 0x3015  | 〕    | tortoiseshellbracketright   | tortoiseshellbracketright.vert   |
| 0x3016  | 〖    | whitelenticularbracketleft  | whitelenticularbracketleft.vert  |
| 0x3017  | 〗    | whitelenticularbracketright | whitelenticularbracketright.vert |
| 0x3018  | 〘    | whitetortoiseshellbracketleft | whitetortoiseshellbracketleft.vert  |
| 0x3019  | 〙    | whitetortoiseshellbracketright | whitetortoiseshellbracketright.vert |
| 0x301A  | 〚    | whitesquarebracketleft      | whitesquarebracketleft.vert      |
| 0x301B  | 〛    | whitesquarebracketright     | whitesquarebracketright.vert     |
| 0x301C  | 〜    | wavedash                    | wavedash.vert                    |
| 0x301D  | 〝    | quotedoubleprimeReversed    | quotedoubleprimeReversed.vert    |
| 0x301E  | 〞    | quotedoubleprime            | quotedoubleprime.vert            |
| 0x301F  | 〟    | lowquotedoubleprime         | lowquotedoubleprime.vert         |
| 0x3020  | 〠    | postalmarkface              |                                  |
| 0x3030  | 〰    | wavydash                    | wavydash.vert                    |
| 0x3031  | 〱    | repeat-kana                 |                                  |
| 0x3032  | 〲    | repeatVoiced-kana           |                                  |
| 0x3033  | 〳    | repeatUpperhalf-kana        |                                  |
| 0x3034  | 〴    | repeatVoicedUpperhalf-kana  |                                  |
| 0x3035  | 〵    | repeatLowerhalf-kana        |                                  |
| 0x3036  | 〶    | postalmark.circled          |                                  |
| 0x303B  | 〻    | ninojiten-han               |                                  |
| 0x303C  | 〼    | masumark                    |                                  |
| 0x303D  | 〽    | partalternationmark         |                                  |
| 0x3099  | ゙     | voicedcomb-kana             |                                  |
| 0x309A  | ゚     | semivoicedcomb-kana         |                                  |
| 0x309B  | ゛    | voiced-kana                 | voiced-kana.vert                 |
| 0x309C  | ゜    | semivoiced-kana             | semivoiced-kana.vert             |
| 0x309D  | ゝ    | iteration-hira              | iteration-hira.vert              |
| 0x309E  | ゞ    | voicediteration-hira        | voicediteration-hira.vert        |
| 0x30A0  | ゠    | dblhyphen-kana              | dblhyphen-kana.vert              |
| 0x30FB  | ・    | dot-kata                    | dot-kata.vert                    |
| 0x30FC  | ー    | prolonged-kana              | prolonged-kana.vert              |
| 0x30FD  | ヽ    | iteration-kata              | iteration-kata.vert              |
| 0x30FE  | ヾ    | voicediteration-kata        | voicediteration-kata.vert        |
| 0xFE30  | ︰    | twodotleader.vert           |                                  |
| 0xFE45  | ﹅    | sesamedot                   | sesamedot.vert                   |
| 0xFE46  | ﹆    | whitesesamedot              | whitesesamedot.vert              |
| 0xFF01  | ！    | exclam.full                 | exclam.full.vert                 |
| 0xFF02  | ＂    | quotedbl.full               | quotedbl.full.vert               |
| 0xFF03  | ＃    | numbersign.full             | numbersign.full.vert             |
| 0xFF04  | ＄    | dollar.full                 | dollar.full.vert                 |
| 0xFF05  | ％    | percent.full                | percent.full.vert                |
| 0xFF06  | ＆    | ampersand.full              | ampersand.full.vert              |
| 0xFF07  | ＇    | quotesingle.full            | quotesingle.full.vert            |
| 0xFF08  | （    | parenleft.full              | parenleft.full.vert              |
| 0xFF09  | ）    | parenright.full             | parenright.full.vert             |
| 0xFF0A  | ＊    | asterisk.full               | asterisk.full.vert               |
| 0xFF0B  | ＋    | plus.full                   | plus.full.vert                   |
| 0xFF0C  | ，    | comma.full                  | comma.full.vert                  |
| 0xFF0D  | －    | hyphen.full                 | hyphen.full.vert                 |
| 0xFF0E  | ．    | period.full                 | period.full.vert                 |
| 0xFF0F  | ／    | slash.full                  | slash.full.vert                  |
| 0xFF1A  | ：    | colon.full                  | colon.full.vert                  |
| 0xFF1B  | ；    | semicolon.full              | semicolon.full.vert              |
| 0xFF1C  | ＜    | less.full                   | less.full.vert                   |
| 0xFF1D  | ＝    | equal.full                  | equal.full.vert                  |
| 0xFF1E  | ＞    | greater.full                | greater.full.vert                |
| 0xFF1F  | ？    | question.full               | question.full.vert               |
| 0xFF20  | ＠    | at.full                     | at.full.vert                     |
| 0xFF3B  | ［    | bracketleft.full            | bracketleft.full.vert            |
| 0xFF3C  | ＼    | backslash.full              | backslash.full.vert              |
| 0xFF3D  | ］    | bracketright.full           | bracketright.full.vert           |
| 0xFF3E  | ＾    | asciicircum.full            | asciicircum.full.vert            |
| 0xFF3F  | ＿    | underscore.full             | underscore.full.vert             |
| 0xFF40  | ｀    | grave.full                  | grave.full.vert                  |
| 0xFF5B  | ｛    | braceleft.full              | braceleft.full.vert              |
| 0xFF5C  | ｜    | bar.full                    | bar.full.vert                    |
| 0xFF5D  | ｝    | braceright.full             | braceright.full.vert             |
| 0xFF5E  | ～    | asciitilde.full             | asciitilde.full.vert             |
| 0xFF5F  | ｟    | whiteparenleft.full         | whiteparenleft.full.vert         |
| 0xFF60  | ｠    | whiteparenright.full        | whiteparenright.full.vert        |
| 0xFFE0  | ￠    | cent.full                   | cent.full.vert                   |
| 0xFFE1  | ￡    | sterling.full               | sterling.full.vert               |
| 0xFFE2  | ￢    | logicalnot.full             | logicalnot.full.vert             |
| 0xFFE3  | ￣    | macron.full                 | macron.full.vert                 |
| 0xFFE4  | ￤    | brokenbar.full              | brokenbar.full.vert              |
| 0xFFE5  | ￥    | yen.full                    | yen.full.vert                    |


### Hiragana

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x3041  | ぁ    | asmall-hira                 | asmall-hira.vert                 |
| 0x3042  | あ    | a-hira                      | a-hira.vert                      |
| 0x3043  | ぃ    | ismall-hira                 | ismall-hira.vert                 |
| 0x3044  | い    | i-hira                      | i-hira.vert                      |
| 0x3045  | ぅ    | usmall-hira                 | usmall-hira.vert                 |
| 0x3046  | う    | u-hira                      | u-hira.vert                      |
| 0x3047  | ぇ    | esmall-hira                 | esmall-hira.vert                 |
| 0x3048  | え    | e-hira                      | e-hira.vert                      |
| 0x3049  | ぉ    | osmall-hira                 | osmall-hira.vert                 |
| 0x304A  | お    | o-hira                      | o-hira.vert                      |
| 0x304B  | か    | ka-hira                     | ka-hira.vert                     |
| 0x304C  | が    | ga-hira                     | ga-hira.vert                     |
| 0x304D  | き    | ki-hira                     | ki-hira.vert                     |
| 0x304E  | ぎ    | gi-hira                     | gi-hira.vert                     |
| 0x304F  | く    | ku-hira                     | ku-hira.vert                     |
| 0x3050  | ぐ    | gu-hira                     | gu-hira.vert                     |
| 0x3051  | け    | ke-hira                     | ke-hira.vert                     |
| 0x3052  | げ    | ge-hira                     | ge-hira.vert                     |
| 0x3053  | こ    | ko-hira                     | ko-hira.vert                     |
| 0x3054  | ご    | go-hira                     | go-hira.vert                     |
| 0x3055  | さ    | sa-hira                     | sa-hira.vert                     |
| 0x3056  | ざ    | za-hira                     | za-hira.vert                     |
| 0x3057  | し    | si-hira                     | si-hira.vert                     |
| 0x3058  | じ    | zi-hira                     | zi-hira.vert                     |
| 0x3059  | す    | su-hira                     | su-hira.vert                     |
| 0x305A  | ず    | zu-hira                     | zu-hira.vert                     |
| 0x305B  | せ    | se-hira                     | se-hira.vert                     |
| 0x305C  | ぜ    | ze-hira                     | ze-hira.vert                     |
| 0x305D  | そ    | so-hira                     | so-hira.vert                     |
| 0x305E  | ぞ    | zo-hira                     | zo-hira.vert                     |
| 0x305F  | た    | ta-hira                     | ta-hira.vert                     |
| 0x3060  | だ    | da-hira                     | da-hira.vert                     |
| 0x3061  | ち    | ti-hira                     | ti-hira.vert                     |
| 0x3062  | ぢ    | di-hira                     | di-hira.vert                     |
| 0x3063  | っ    | tusmall-hira                | tusmall-hira.vert                |
| 0x3064  | つ    | tu-hira                     | tu-hira.vert                     |
| 0x3065  | づ    | du-hira                     | du-hira.vert                     |
| 0x3066  | て    | te-hira                     | te-hira.vert                     |
| 0x3067  | で    | de-hira                     | de-hira.vert                     |
| 0x3068  | と    | to-hira                     | to-hira.vert                     |
| 0x3069  | ど    | do-hira                     | do-hira.vert                     |
| 0x306A  | な    | na-hira                     | na-hira.vert                     |
| 0x306B  | に    | ni-hira                     | ni-hira.vert                     |
| 0x306C  | ぬ    | nu-hira                     | nu-hira.vert                     |
| 0x306D  | ね    | ne-hira                     | ne-hira.vert                     |
| 0x306E  | の    | no-hira                     | no-hira.vert                     |
| 0x306F  | は    | ha-hira                     | ha-hira.vert                     |
| 0x3070  | ば    | ba-hira                     | ba-hira.vert                     |
| 0x3071  | ぱ    | pa-hira                     | pa-hira.vert                     |
| 0x3072  | ひ    | hi-hira                     | hi-hira.vert                     |
| 0x3073  | び    | bi-hira                     | bi-hira.vert                     |
| 0x3074  | ぴ    | pi-hira                     | pi-hira.vert                     |
| 0x3075  | ふ    | hu-hira                     | hu-hira.vert                     |
| 0x3076  | ぶ    | bu-hira                     | bu-hira.vert                     |
| 0x3077  | ぷ    | pu-hira                     | pu-hira.vert                     |
| 0x3078  | へ    | he-hira                     | he-hira.vert                     |
| 0x3079  | べ    | be-hira                     | be-hira.vert                     |
| 0x307A  | ぺ    | pe-hira                     | pe-hira.vert                     |
| 0x307B  | ほ    | ho-hira                     | ho-hira.vert                     |
| 0x307C  | ぼ    | bo-hira                     | bo-hira.vert                     |
| 0x307D  | ぽ    | po-hira                     | po-hira.vert                     |
| 0x307E  | ま    | ma-hira                     | ma-hira.vert                     |
| 0x307F  | み    | mi-hira                     | mi-hira.vert                     |
| 0x3080  | む    | mu-hira                     | mu-hira.vert                     |
| 0x3081  | め    | me-hira                     | me-hira.vert                     |
| 0x3082  | も    | mo-hira                     | mo-hira.vert                     |
| 0x3083  | ゃ    | yasmall-hira                | yasmall-hira.vert                |
| 0x3084  | や    | ya-hira                     | ya-hira.vert                     |
| 0x3085  | ゅ    | yusmall-hira                | yusmall-hira.vert                |
| 0x3086  | ゆ    | yu-hira                     | yu-hira.vert                     |
| 0x3087  | ょ    | yosmall-hira                | yosmall-hira.vert                |
| 0x3088  | よ    | yo-hira                     | yo-hira.vert                     |
| 0x3089  | ら    | ra-hira                     | ra-hira.vert                     |
| 0x308A  | り    | ri-hira                     | ri-hira.vert                     |
| 0x308B  | る    | ru-hira                     | ru-hira.vert                     |
| 0x308C  | れ    | re-hira                     | re-hira.vert                     |
| 0x308D  | ろ    | ro-hira                     | ro-hira.vert                     |
| 0x308E  | ゎ    | wasmall-hira                | wasmall-hira.vert                |
| 0x308F  | わ    | wa-hira                     | wa-hira.vert                     |
| 0x3090  | ゐ    | wi-hira                     | wi-hira.vert                     |
| 0x3091  | ゑ    | we-hira                     | we-hira.vert                     |
| 0x3092  | を    | wo-hira                     | wo-hira.vert                     |
| 0x3093  | ん    | n-hira                      | n-hira.vert                      |
| 0x3094  | ゔ    | vu-hira                     | vu-hira.vert                     |
| 0x3095  | ゕ    | kasmall-hira                | kasmall-hira.vert                |
| 0x3096  | ゖ    | kesmall-hira                | kesmall-hira.vert                |
| 0x309F  | ゟ    | digraphyori-hira            | digraphyori-hira.vert            |


### Katakana

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x30A1  | ァ    | asmall-kata                 | asmall-kata.vert                 |
| 0x30A2  | ア    | a-kata                      | a-kata.vert                      |
| 0x30A3  | ィ    | ismall-kata                 | ismall-kata.vert                 |
| 0x30A4  | イ    | i-kata                      | i-kata.vert                      |
| 0x30A5  | ゥ    | usmall-kata                 | usmall-kata.vert                 |
| 0x30A6  | ウ    | u-kata                      | u-kata.vert                      |
| 0x30A7  | ェ    | esmall-kata                 | esmall-kata.vert                 |
| 0x30A8  | エ    | e-kata                      | e-kata.vert                      |
| 0x30A9  | ォ    | osmall-kata                 | osmall-kata.vert                 |
| 0x30AA  | オ    | o-kata                      | o-kata.vert                      |
| 0x30AB  | カ    | ka-kata                     | ka-kata.vert                     |
| 0x30AC  | ガ    | ga-kata                     | ga-kata.vert                     |
| 0x30AD  | キ    | ki-kata                     | ki-kata.vert                     |
| 0x30AE  | ギ    | gi-kata                     | gi-kata.vert                     |
| 0x30AF  | ク    | ku-kata                     | ku-kata.vert                     |
| 0x30B0  | グ    | gu-kata                     | gu-kata.vert                     |
| 0x30B1  | ケ    | ke-kata                     | ke-kata.vert                     |
| 0x30B2  | ゲ    | ge-kata                     | ge-kata.vert                     |
| 0x30B3  | コ    | ko-kata                     | ko-kata.vert                     |
| 0x30B4  | ゴ    | go-kata                     | go-kata.vert                     |
| 0x30B5  | サ    | sa-kata                     | sa-kata.vert                     |
| 0x30B6  | ザ    | za-kata                     | za-kata.vert                     |
| 0x30B7  | シ    | si-kata                     | si-kata.vert                     |
| 0x30B8  | ジ    | zi-kata                     | zi-kata.vert                     |
| 0x30B9  | ス    | su-kata                     | su-kata.vert                     |
| 0x30BA  | ズ    | zu-kata                     | zu-kata.vert                     |
| 0x30BB  | セ    | se-kata                     | se-kata.vert                     |
| 0x30BC  | ゼ    | ze-kata                     | ze-kata.vert                     |
| 0x30BD  | ソ    | so-kata                     | so-kata.vert                     |
| 0x30BE  | ゾ    | zo-kata                     | zo-kata.vert                     |
| 0x30BF  | タ    | ta-kata                     | ta-kata.vert                     |
| 0x30C0  | ダ    | da-kata                     | da-kata.vert                     |
| 0x30C1  | チ    | ti-kata                     | ti-kata.vert                     |
| 0x30C2  | ヂ    | di-kata                     | di-kata.vert                     |
| 0x30C3  | ッ    | tusmall-kata                | tusmall-kata.vert                |
| 0x30C4  | ツ    | tu-kata                     | tu-kata.vert                     |
| 0x30C5  | ヅ    | du-kata                     | du-kata.vert                     |
| 0x30C6  | テ    | te-kata                     | te-kata.vert                     |
| 0x30C7  | デ    | de-kata                     | de-kata.vert                     |
| 0x30C8  | ト    | to-kata                     | to-kata.vert                     |
| 0x30C9  | ド    | do-kata                     | do-kata.vert                     |
| 0x30CA  | ナ    | na-kata                     | na-kata.vert                     |
| 0x30CB  | ニ    | ni-kata                     | ni-kata.vert                     |
| 0x30CC  | ヌ    | nu-kata                     | nu-kata.vert                     |
| 0x30CD  | ネ    | ne-kata                     | ne-kata.vert                     |
| 0x30CE  | ノ    | no-kata                     | no-kata.vert                     |
| 0x30CF  | ハ    | ha-kata                     | ha-kata.vert                     |
| 0x30D0  | バ    | ba-kata                     | ba-kata.vert                     |
| 0x30D1  | パ    | pa-kata                     | pa-kata.vert                     |
| 0x30D2  | ヒ    | hi-kata                     | hi-kata.vert                     |
| 0x30D3  | ビ    | bi-kata                     | bi-kata.vert                     |
| 0x30D4  | ピ    | pi-kata                     | pi-kata.vert                     |
| 0x30D5  | フ    | hu-kata                     | hu-kata.vert                     |
| 0x30D6  | ブ    | bu-kata                     | bu-kata.vert                     |
| 0x30D7  | プ    | pu-kata                     | pu-kata.vert                     |
| 0x30D8  | ヘ    | he-kata                     | he-kata.vert                     |
| 0x30D9  | ベ    | be-kata                     | be-kata.vert                     |
| 0x30DA  | ペ    | pe-kata                     | pe-kata.vert                     |
| 0x30DB  | ホ    | ho-kata                     | ho-kata.vert                     |
| 0x30DC  | ボ    | bo-kata                     | bo-kata.vert                     |
| 0x30DD  | ポ    | po-kata                     | po-kata.vert                     |
| 0x30DE  | マ    | ma-kata                     | ma-kata.vert                     |
| 0x30DF  | ミ    | mi-kata                     | mi-kata.vert                     |
| 0x30E0  | ム    | mu-kata                     | mu-kata.vert                     |
| 0x30E1  | メ    | me-kata                     | me-kata.vert                     |
| 0x30E2  | モ    | mo-kata                     | mo-kata.vert                     |
| 0x30E3  | ャ    | yasmall-kata                | yasmall-kata.vert                |
| 0x30E4  | ヤ    | ya-kata                     | ya-kata.vert                     |
| 0x30E5  | ュ    | yusmall-kata                | yusmall-kata.vert                |
| 0x30E6  | ユ    | yu-kata                     | yu-kata.vert                     |
| 0x30E7  | ョ    | yosmall-kata                | yosmall-kata.vert                |
| 0x30E8  | ヨ    | yo-kata                     | yo-kata.vert                     |
| 0x30E9  | ラ    | ra-kata                     | ra-kata.vert                     |
| 0x30EA  | リ    | ri-kata                     | ri-kata.vert                     |
| 0x30EB  | ル    | ru-kata                     | ru-kata.vert                     |
| 0x30EC  | レ    | re-kata                     | re-kata.vert                     |
| 0x30ED  | ロ    | ro-kata                     | ro-kata.vert                     |
| 0x30EE  | ヮ    | wasmall-kata                | wasmall-kata.vert                |
| 0x30EF  | ワ    | wa-kata                     | wa-kata.vert                     |
| 0x30F0  | ヰ    | wi-kata                     | wi-kata.vert                     |
| 0x30F1  | ヱ    | we-kata                     | we-kata.vert                     |
| 0x30F2  | ヲ    | wo-kata                     | wo-kata.vert                     |
| 0x30F3  | ン    | n-kata                      | n-kata.vert                      |
| 0x30F4  | ヴ    | vu-kata                     | vu-kata.vert                     |
| 0x30F5  | ヵ    | kasmall-kata                | kasmall-kata.vert                |
| 0x30F6  | ヶ    | kesmall-kata                | kesmall-kata.vert                |
| 0x30F7  | ヷ    | va-kata                     | va-kata.vert                     |
| 0x30F8  | ヸ    | vi-kata                     | vi-kata.vert                     |
| 0x30F9  | ヹ    | ve-kata                     | ve-kata.vert                     |
| 0x30FA  | ヺ    | vo-kata                     | vo-kata.vert                     |
| 0x30FF  | ヿ    | digraphkoto-kata            | digraphkoto-kata.vert            |
| 0x31F0  | ㇰ    | kusmall-kata                | kusmall-kata.vert                |
| 0x31F1  | ㇱ    | sismall-kata                | sismall-kata.vert                |
| 0x31F2  | ㇲ    | susmall-kata                | susmall-kata.vert                |
| 0x31F3  | ㇳ    | tosmall-kata                | tosmall-kata.vert                |
| 0x31F4  | ㇴ    | nusmall-kata                | nusmall-kata.vert                |
| 0x31F5  | ㇵ    | hasmall-kata                | hasmall-kata.vert                |
| 0x31F6  | ㇶ    | hismall-kata                | hismall-kata.vert                |
| 0x31F7  | ㇷ    | husmall-kata                | husmall-kata.vert                |
| 0x31F8  | ㇸ    | hesmall-kata                | hesmall-kata.vert                |
| 0x31F9  | ㇹ    | hosmall-kata                | hosmall-kata.vert                |
| 0x31FA  | ㇺ    | musmall-kata                | musmall-kata.vert                |
| 0x31FB  | ㇻ    | rasmall-kata                | rasmall-kata.vert                |
| 0x31FC  | ㇼ    | rismall-kata                | rismall-kata.vert                |
| 0x31FD  | ㇽ    | rusmall-kata                | rusmall-kata.vert                |
| 0x31FE  | ㇾ    | resmall-kata                | resmall-kata.vert                |
| 0x31FF  | ㇿ    | rosmall-kata                | rosmall-kata.vert                |


### Halfwidth Katakana

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0xFF61  | ｡     | period-han.half             | period-han.half.rotat            |
| 0xFF62  | ｢     | cornerbracketleft.half      | cornerbracketleft.half.rotat     |
| 0xFF63  | ｣     | cornerbracketright.half     | cornerbracketright.half.rotat    |
| 0xFF64  | ､     | comma-han.half              | comma-han.half.rotat             |
| 0xFF65  | ･     | middledot-kata.half         | middledot-kata.half.rotat        |
| 0xFF66  | ｦ     | wo-kata.half                | wo-kata.half.rotat               |
| 0xFF67  | ｧ     | asmall-kata.half            | asmall-kata.half.rotat           |
| 0xFF68  | ｨ     | ismall-kata.half            | ismall-kata.half.rotat           |
| 0xFF69  | ｩ     | usmall-kata.half            | usmall-kata.half.rotat           |
| 0xFF6A  | ｪ     | esmall-kata.half            | esmall-kata.half.rotat           |
| 0xFF6B  | ｫ     | osmall-kata.half            | osmall-kata.half.rotat           |
| 0xFF6C  | ｬ     | yasmall-kata.half           | yasmall-kata.half.rotat          |
| 0xFF6D  | ｭ     | yusmall-kata.half           | yusmall-kata.half.rotat          |
| 0xFF6E  | ｮ     | yosmall-kata.half           | yosmall-kata.half.rotat          |
| 0xFF6F  | ｯ     | tusmall-kata.half           | tusmall-kata.half.rotat          |
| 0xFF70  | ｰ     | prolonged-kana.half         | prolonged-kana.half.rotat        |
| 0xFF71  | ｱ     | a-kata.half                 | a-kata.half.rotat                |
| 0xFF72  | ｲ     | i-kata.half                 | i-kata.half.rotat                |
| 0xFF73  | ｳ     | u-kata.half                 | u-kata.half.rotat                |
| 0xFF74  | ｴ     | e-kata.half                 | e-kata.half.rotat                |
| 0xFF75  | ｵ     | o-kata.half                 | o-kata.half.rotat                |
| 0xFF76  | ｶ     | ka-kata.half                | ka-kata.half.rotat               |
| 0xFF77  | ｷ     | ki-kata.half                | ki-kata.half.rotat               |
| 0xFF78  | ｸ     | ku-kata.half                | ku-kata.half.rotat               |
| 0xFF79  | ｹ     | ke-kata.half                | ke-kata.half.rotat               |
| 0xFF7A  | ｺ     | ko-kata.half                | ko-kata.half.rotat               |
| 0xFF7B  | ｻ     | sa-kata.half                | sa-kata.half.rotat               |
| 0xFF7C  | ｼ     | si-kata.half                | si-kata.half.rotat               |
| 0xFF7D  | ｽ     | su-kata.half                | su-kata.half.rotat               |
| 0xFF7E  | ｾ     | se-kata.half                | se-kata.half.rotat               |
| 0xFF7F  | ｿ     | so-kata.half                | so-kata.half.rotat               |
| 0xFF80  | ﾀ     | ta-kata.half                | ta-kata.half.rotat               |
| 0xFF81  | ﾁ     | ti-kata.half                | ti-kata.half.rotat               |
| 0xFF82  | ﾂ     | tu-kata.half                | tu-kata.half.rotat               |
| 0xFF83  | ﾃ     | te-kata.half                | te-kata.half.rotat               |
| 0xFF84  | ﾄ     | to-kata.half                | to-kata.half.rotat               |
| 0xFF85  | ﾅ     | na-kata.half                | na-kata.half.rotat               |
| 0xFF86  | ﾆ     | ni-kata.half                | ni-kata.half.rotat               |
| 0xFF87  | ﾇ     | nu-kata.half                | nu-kata.half.rotat               |
| 0xFF88  | ﾈ     | ne-kata.half                | ne-kata.half.rotat               |
| 0xFF89  | ﾉ     | no-kata.half                | no-kata.half.rotat               |
| 0xFF8A  | ﾊ     | ha-kata.half                | ha-kata.half.rotat               |
| 0xFF8B  | ﾋ     | hi-kata.half                | hi-kata.half.rotat               |
| 0xFF8C  | ﾌ     | hu-kata.half                | hu-kata.half.rotat               |
| 0xFF8D  | ﾍ     | he-kata.half                | he-kata.half.rotat               |
| 0xFF8E  | ﾎ     | ho-kata.half                | ho-kata.half.rotat               |
| 0xFF8F  | ﾏ     | ma-kata.half                | ma-kata.half.rotat               |
| 0xFF90  | ﾐ     | mi-kata.half                | mi-kata.half.rotat               |
| 0xFF91  | ﾑ     | mu-kata.half                | mu-kata.half.rotat               |
| 0xFF92  | ﾒ     | me-kata.half                | me-kata.half.rotat               |
| 0xFF93  | ﾓ     | mo-kata.half                | mo-kata.half.rotat               |
| 0xFF94  | ﾔ     | ya-kata.half                | ya-kata.half.rotat               |
| 0xFF95  | ﾕ     | yu-kata.half                | yu-kata.half.rotat               |
| 0xFF96  | ﾖ     | yo-kata.half                | yo-kata.half.rotat               |
| 0xFF97  | ﾗ     | ra-kata.half                | ra-kata.half.rotat               |
| 0xFF98  | ﾘ     | ri-kata.half                | ri-kata.half.rotat               |
| 0xFF99  | ﾙ     | ru-kata.half                | ru-kata.half.rotat               |
| 0xFF9A  | ﾚ     | re-kata.half                | re-kata.half.rotat               |
| 0xFF9B  | ﾛ     | ro-kata.half                | ro-kata.half.rotat               |
| 0xFF9C  | ﾜ     | wa-kata.half                | wa-kata.half.rotat               |
| 0xFF9D  | ﾝ     | n-kata.half                 | n-kata.half.rotat                |
| 0xFF9E  | ﾞ     | voiced-kana.half            | voiced-kana.half.rotat           |
| 0xFF9F  | ﾟ     | semivoiced-kana.half        | semivoiced-kana.half.rotat       |


******

### Kanji (CJK Unified Ideographs)

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x4E00  | 一    | (CJK Unified Ideographs)    |                                  |
| 0x4E03  | 七    | (CJK Unified Ideographs)    |                                  |
| 0x4E07  | 万    | (CJK Unified Ideographs)    |                                  |
| 0x4E09  | 三    | (CJK Unified Ideographs)    |                                  |
| 0x4E0A  | 上    | (CJK Unified Ideographs)    |                                  |
| 0x4E0B  | 下    | (CJK Unified Ideographs)    |                                  |
| 0x4E2D  | 中    | (CJK Unified Ideographs)    |                                  |
| 0x4E38  | 丸    | (CJK Unified Ideographs)    |                                  |
| 0x4E5D  | 九    | (CJK Unified Ideographs)    |                                  |
| 0x4E8C  | 二    | (CJK Unified Ideographs)    |                                  |
| 0x4E94  | 五    | (CJK Unified Ideographs)    |                                  |
| 0x4EA4  | 交    | (CJK Unified Ideographs)    |                                  |
| 0x4EAC  | 京    | (CJK Unified Ideographs)    |                                  |
| 0x4EBA  | 人    | (CJK Unified Ideographs)    |                                  |
| 0x4ECA  | 今    | (CJK Unified Ideographs)    |                                  |
| 0x4F11  | 休    | (CJK Unified Ideographs)    |                                  |
| 0x4F1A  | 会    | (CJK Unified Ideographs)    |                                  |
| 0x4F53  | 体    | (CJK Unified Ideographs)    |                                  |
| 0x4F55  | 何    | (CJK Unified Ideographs)    |                                  |
| 0x4F5C  | 作    | (CJK Unified Ideographs)    |                                  |
| 0x5143  | 元    | (CJK Unified Ideographs)    |                                  |
| 0x5144  | 兄    | (CJK Unified Ideographs)    |                                  |
| 0x5148  | 先    | (CJK Unified Ideographs)    |                                  |
| 0x5149  | 光    | (CJK Unified Ideographs)    |                                  |
| 0x5165  | 入    | (CJK Unified Ideographs)    |                                  |
| 0x516B  | 八    | (CJK Unified Ideographs)    |                                  |
| 0x516C  | 公    | (CJK Unified Ideographs)    |                                  |
| 0x516D  | 六    | (CJK Unified Ideographs)    |                                  |
| 0x5185  | 内    | (CJK Unified Ideographs)    |                                  |
| 0x5186  | 円    | (CJK Unified Ideographs)    |                                  |
| 0x51AC  | 冬    | (CJK Unified Ideographs)    |                                  |
| 0x51FA  | 出    | (CJK Unified Ideographs)    |                                  |
| 0x5200  | 刀    | (CJK Unified Ideographs)    |                                  |
| 0x5206  | 分    | (CJK Unified Ideographs)    |                                  |
| 0x5207  | 切    | (CJK Unified Ideographs)    |                                  |
| 0x524D  | 前    | (CJK Unified Ideographs)    |                                  |
| 0x529B  | 力    | (CJK Unified Ideographs)    |                                  |
| 0x5317  | 北    | (CJK Unified Ideographs)    |                                  |
| 0x5341  | 十    | (CJK Unified Ideographs)    |                                  |
| 0x5343  | 千    | (CJK Unified Ideographs)    |                                  |
| 0x5348  | 午    | (CJK Unified Ideographs)    |                                  |
| 0x534A  | 半    | (CJK Unified Ideographs)    |                                  |
| 0x5357  | 南    | (CJK Unified Ideographs)    |                                  |
| 0x539F  | 原    | (CJK Unified Ideographs)    |                                  |
| 0x53CB  | 友    | (CJK Unified Ideographs)    |                                  |
| 0x53E3  | 口    | (CJK Unified Ideographs)    |                                  |
| 0x53E4  | 古    | (CJK Unified Ideographs)    |                                  |
| 0x53F0  | 台    | (CJK Unified Ideographs)    |                                  |
| 0x53F3  | 右    | (CJK Unified Ideographs)    |                                  |
| 0x5408  | 合    | (CJK Unified Ideographs)    |                                  |
| 0x540C  | 同    | (CJK Unified Ideographs)    |                                  |
| 0x540D  | 名    | (CJK Unified Ideographs)    |                                  |
| 0x56DB  | 四    | (CJK Unified Ideographs)    |                                  |
| 0x56DE  | 回    | (CJK Unified Ideographs)    |                                  |
| 0x56F3  | 図    | (CJK Unified Ideographs)    |                                  |
| 0x56FD  | 国    | (CJK Unified Ideographs)    |                                  |
| 0x5712  | 園    | (CJK Unified Ideographs)    |                                  |
| 0x571F  | 土    | (CJK Unified Ideographs)    |                                  |
| 0x5730  | 地    | (CJK Unified Ideographs)    |                                  |
| 0x5834  | 場    | (CJK Unified Ideographs)    |                                  |
| 0x58F0  | 声    | (CJK Unified Ideographs)    |                                  |
| 0x58F2  | 売    | (CJK Unified Ideographs)    |                                  |
| 0x590F  | 夏    | (CJK Unified Ideographs)    |                                  |
| 0x5915  | 夕    | (CJK Unified Ideographs)    |                                  |
| 0x5916  | 外    | (CJK Unified Ideographs)    |                                  |
| 0x591A  | 多    | (CJK Unified Ideographs)    |                                  |
| 0x591C  | 夜    | (CJK Unified Ideographs)    |                                  |
| 0x5927  | 大    | (CJK Unified Ideographs)    |                                  |
| 0x5929  | 天    | (CJK Unified Ideographs)    |                                  |
| 0x592A  | 太    | (CJK Unified Ideographs)    |                                  |
| 0x5973  | 女    | (CJK Unified Ideographs)    |                                  |
| 0x59B9  | 妹    | (CJK Unified Ideographs)    |                                  |
| 0x59C9  | 姉    | (CJK Unified Ideographs)    |                                  |
| 0x5B50  | 子    | (CJK Unified Ideographs)    |                                  |
| 0x5B57  | 字    | (CJK Unified Ideographs)    |                                  |
| 0x5B66  | 学    | (CJK Unified Ideographs)    |                                  |
| 0x5BA4  | 室    | (CJK Unified Ideographs)    |                                  |
| 0x5BB6  | 家    | (CJK Unified Ideographs)    |                                  |
| 0x5BFA  | 寺    | (CJK Unified Ideographs)    |                                  |
| 0x5C0F  | 小    | (CJK Unified Ideographs)    |                                  |
| 0x5C11  | 少    | (CJK Unified Ideographs)    |                                  |
| 0x5C71  | 山    | (CJK Unified Ideographs)    |                                  |
| 0x5CA9  | 岩    | (CJK Unified Ideographs)    |                                  |
| 0x5DDD  | 川    | (CJK Unified Ideographs)    |                                  |
| 0x5DE5  | 工    | (CJK Unified Ideographs)    |                                  |
| 0x5DE6  | 左    | (CJK Unified Ideographs)    |                                  |
| 0x5E02  | 市    | (CJK Unified Ideographs)    |                                  |
| 0x5E30  | 帰    | (CJK Unified Ideographs)    |                                  |
| 0x5E74  | 年    | (CJK Unified Ideographs)    |                                  |
| 0x5E83  | 広    | (CJK Unified Ideographs)    |                                  |
| 0x5E97  | 店    | (CJK Unified Ideographs)    |                                  |
| 0x5F13  | 弓    | (CJK Unified Ideographs)    |                                  |
| 0x5F15  | 引    | (CJK Unified Ideographs)    |                                  |
| 0x5F1F  | 弟    | (CJK Unified Ideographs)    |                                  |
| 0x5F31  | 弱    | (CJK Unified Ideographs)    |                                  |
| 0x5F37  | 強    | (CJK Unified Ideographs)    |                                  |
| 0x5F53  | 当    | (CJK Unified Ideographs)    |                                  |
| 0x5F62  | 形    | (CJK Unified Ideographs)    |                                  |
| 0x5F8C  | 後    | (CJK Unified Ideographs)    |                                  |
| 0x5FC3  | 心    | (CJK Unified Ideographs)    |                                  |
| 0x601D  | 思    | (CJK Unified Ideographs)    |                                  |
| 0x6238  | 戸    | (CJK Unified Ideographs)    |                                  |
| 0x624B  | 手    | (CJK Unified Ideographs)    |                                  |
| 0x624D  | 才    | (CJK Unified Ideographs)    |                                  |
| 0x6559  | 教    | (CJK Unified Ideographs)    |                                  |
| 0x6570  | 数    | (CJK Unified Ideographs)    |                                  |
| 0x6587  | 文    | (CJK Unified Ideographs)    |                                  |
| 0x65B0  | 新    | (CJK Unified Ideographs)    |                                  |
| 0x65B9  | 方    | (CJK Unified Ideographs)    |                                  |
| 0x65E5  | 日    | (CJK Unified Ideographs)    |                                  |
| 0x65E9  | 早    | (CJK Unified Ideographs)    |                                  |
| 0x660E  | 明    | (CJK Unified Ideographs)    |                                  |
| 0x661F  | 星    | (CJK Unified Ideographs)    |                                  |
| 0x6625  | 春    | (CJK Unified Ideographs)    |                                  |
| 0x663C  | 昼    | (CJK Unified Ideographs)    |                                  |
| 0x6642  | 時    | (CJK Unified Ideographs)    |                                  |
| 0x6674  | 晴    | (CJK Unified Ideographs)    |                                  |
| 0x66DC  | 曜    | (CJK Unified Ideographs)    |                                  |
| 0x66F8  | 書    | (CJK Unified Ideographs)    |                                  |
| 0x6708  | 月    | (CJK Unified Ideographs)    |                                  |
| 0x671D  | 朝    | (CJK Unified Ideographs)    |                                  |
| 0x6728  | 木    | (CJK Unified Ideographs)    |                                  |
| 0x672C  | 本    | (CJK Unified Ideographs)    |                                  |
| 0x6751  | 村    | (CJK Unified Ideographs)    |                                  |
| 0x6765  | 来    | (CJK Unified Ideographs)    |                                  |
| 0x6771  | 東    | (CJK Unified Ideographs)    |                                  |
| 0x6797  | 林    | (CJK Unified Ideographs)    |                                  |
| 0x6821  | 校    | (CJK Unified Ideographs)    |                                  |
| 0x68EE  | 森    | (CJK Unified Ideographs)    |                                  |
| 0x697D  | 楽    | (CJK Unified Ideographs)    |                                  |
| 0x6B4C  | 歌    | (CJK Unified Ideographs)    |                                  |
| 0x6B62  | 止    | (CJK Unified Ideographs)    |                                  |
| 0x6B63  | 正    | (CJK Unified Ideographs)    |                                  |
| 0x6B69  | 歩    | (CJK Unified Ideographs)    |                                  |
| 0x6BCD  | 母    | (CJK Unified Ideographs)    |                                  |
| 0x6BCE  | 毎    | (CJK Unified Ideographs)    |                                  |
| 0x6BDB  | 毛    | (CJK Unified Ideographs)    |                                  |
| 0x6C17  | 気    | (CJK Unified Ideographs)    |                                  |
| 0x6C34  | 水    | (CJK Unified Ideographs)    |                                  |
| 0x6C60  | 池    | (CJK Unified Ideographs)    |                                  |
| 0x6C7D  | 汽    | (CJK Unified Ideographs)    |                                  |
| 0x6D3B  | 活    | (CJK Unified Ideographs)    |                                  |
| 0x6D77  | 海    | (CJK Unified Ideographs)    |                                  |
| 0x706B  | 火    | (CJK Unified Ideographs)    |                                  |
| 0x70B9  | 点    | (CJK Unified Ideographs)    |                                  |
| 0x7236  | 父    | (CJK Unified Ideographs)    |                                  |
| 0x725B  | 牛    | (CJK Unified Ideographs)    |                                  |
| 0x72AC  | 犬    | (CJK Unified Ideographs)    |                                  |
| 0x7389  | 玉    | (CJK Unified Ideographs)    |                                  |
| 0x738B  | 王    | (CJK Unified Ideographs)    |                                  |
| 0x7406  | 理    | (CJK Unified Ideographs)    |                                  |
| 0x751F  | 生    | (CJK Unified Ideographs)    |                                  |
| 0x7528  | 用    | (CJK Unified Ideographs)    |                                  |
| 0x7530  | 田    | (CJK Unified Ideographs)    |                                  |
| 0x7537  | 男    | (CJK Unified Ideographs)    |                                  |
| 0x753A  | 町    | (CJK Unified Ideographs)    |                                  |
| 0x753B  | 画    | (CJK Unified Ideographs)    |                                  |
| 0x756A  | 番    | (CJK Unified Ideographs)    |                                  |
| 0x767D  | 白    | (CJK Unified Ideographs)    |                                  |
| 0x767E  | 百    | (CJK Unified Ideographs)    |                                  |
| 0x76EE  | 目    | (CJK Unified Ideographs)    |                                  |
| 0x76F4  | 直    | (CJK Unified Ideographs)    |                                  |
| 0x77E2  | 矢    | (CJK Unified Ideographs)    |                                  |
| 0x77E5  | 知    | (CJK Unified Ideographs)    |                                  |
| 0x77F3  | 石    | (CJK Unified Ideographs)    |                                  |
| 0x793E  | 社    | (CJK Unified Ideographs)    |                                  |
| 0x79CB  | 秋    | (CJK Unified Ideographs)    |                                  |
| 0x79D1  | 科    | (CJK Unified Ideographs)    |                                  |
| 0x7A7A  | 空    | (CJK Unified Ideographs)    |                                  |
| 0x7ACB  | 立    | (CJK Unified Ideographs)    |                                  |
| 0x7AF9  | 竹    | (CJK Unified Ideographs)    |                                  |
| 0x7B54  | 答    | (CJK Unified Ideographs)    |                                  |
| 0x7B97  | 算    | (CJK Unified Ideographs)    |                                  |
| 0x7C73  | 米    | (CJK Unified Ideographs)    |                                  |
| 0x7CF8  | 糸    | (CJK Unified Ideographs)    |                                  |
| 0x7D19  | 紙    | (CJK Unified Ideographs)    |                                  |
| 0x7D30  | 細    | (CJK Unified Ideographs)    |                                  |
| 0x7D44  | 組    | (CJK Unified Ideographs)    |                                  |
| 0x7D75  | 絵    | (CJK Unified Ideographs)    |                                  |
| 0x7DDA  | 線    | (CJK Unified Ideographs)    |                                  |
| 0x7FBD  | 羽    | (CJK Unified Ideographs)    |                                  |
| 0x8003  | 考    | (CJK Unified Ideographs)    |                                  |
| 0x8033  | 耳    | (CJK Unified Ideographs)    |                                  |
| 0x805E  | 聞    | (CJK Unified Ideographs)    |                                  |
| 0x8089  | 肉    | (CJK Unified Ideographs)    |                                  |
| 0x81EA  | 自    | (CJK Unified Ideographs)    |                                  |
| 0x8239  | 船    | (CJK Unified Ideographs)    |                                  |
| 0x8272  | 色    | (CJK Unified Ideographs)    |                                  |
| 0x82B1  | 花    | (CJK Unified Ideographs)    |                                  |
| 0x8336  | 茶    | (CJK Unified Ideographs)    |                                  |
| 0x8349  | 草    | (CJK Unified Ideographs)    |                                  |
| 0x866B  | 虫    | (CJK Unified Ideographs)    |                                  |
| 0x884C  | 行    | (CJK Unified Ideographs)    |                                  |
| 0x897F  | 西    | (CJK Unified Ideographs)    |                                  |
| 0x898B  | 見    | (CJK Unified Ideographs)    |                                  |
| 0x89AA  | 親    | (CJK Unified Ideographs)    |                                  |
| 0x89D2  | 角    | (CJK Unified Ideographs)    |                                  |
| 0x8A00  | 言    | (CJK Unified Ideographs)    |                                  |
| 0x8A08  | 計    | (CJK Unified Ideographs)    |                                  |
| 0x8A18  | 記    | (CJK Unified Ideographs)    |                                  |
| 0x8A71  | 話    | (CJK Unified Ideographs)    |                                  |
| 0x8A9E  | 語    | (CJK Unified Ideographs)    |                                  |
| 0x8AAD  | 読    | (CJK Unified Ideographs)    |                                  |
| 0x8C37  | 谷    | (CJK Unified Ideographs)    |                                  |
| 0x8C9D  | 貝    | (CJK Unified Ideographs)    |                                  |
| 0x8CB7  | 買    | (CJK Unified Ideographs)    |                                  |
| 0x8D64  | 赤    | (CJK Unified Ideographs)    |                                  |
| 0x8D70  | 走    | (CJK Unified Ideographs)    |                                  |
| 0x8DB3  | 足    | (CJK Unified Ideographs)    |                                  |
| 0x8ECA  | 車    | (CJK Unified Ideographs)    |                                  |
| 0x8FD1  | 近    | (CJK Unified Ideographs)    |                                  |
| 0x901A  | 通    | (CJK Unified Ideographs)    |                                  |
| 0x9031  | 週    | (CJK Unified Ideographs)    |                                  |
| 0x9053  | 道    | (CJK Unified Ideographs)    |                                  |
| 0x9060  | 遠    | (CJK Unified Ideographs)    |                                  |
| 0x91CC  | 里    | (CJK Unified Ideographs)    |                                  |
| 0x91CE  | 野    | (CJK Unified Ideographs)    |                                  |
| 0x91D1  | 金    | (CJK Unified Ideographs)    |                                  |
| 0x9577  | 長    | (CJK Unified Ideographs)    |                                  |
| 0x9580  | 門    | (CJK Unified Ideographs)    |                                  |
| 0x9593  | 間    | (CJK Unified Ideographs)    |                                  |
| 0x96E8  | 雨    | (CJK Unified Ideographs)    |                                  |
| 0x96EA  | 雪    | (CJK Unified Ideographs)    |                                  |
| 0x96F2  | 雲    | (CJK Unified Ideographs)    |                                  |
| 0x96FB  | 電    | (CJK Unified Ideographs)    |                                  |
| 0x9752  | 青    | (CJK Unified Ideographs)    |                                  |
| 0x97F3  | 音    | (CJK Unified Ideographs)    |                                  |
| 0x982D  | 頭    | (CJK Unified Ideographs)    |                                  |
| 0x9854  | 顔    | (CJK Unified Ideographs)    |                                  |
| 0x98A8  | 風    | (CJK Unified Ideographs)    |                                  |
| 0x98DF  | 食    | (CJK Unified Ideographs)    |                                  |
| 0x9996  | 首    | (CJK Unified Ideographs)    |                                  |
| 0x99AC  | 馬    | (CJK Unified Ideographs)    |                                  |
| 0x9AD8  | 高    | (CJK Unified Ideographs)    |                                  |
| 0x9B5A  | 魚    | (CJK Unified Ideographs)    |                                  |
| 0x9CE5  | 鳥    | (CJK Unified Ideographs)    |                                  |
| 0x9CF4  | 鳴    | (CJK Unified Ideographs)    |                                  |
| 0x9EA6  | 麦    | (CJK Unified Ideographs)    |                                  |
| 0x9EC4  | 黄    | (CJK Unified Ideographs)    |                                  |
| 0x9ED2  | 黒    | (CJK Unified Ideographs)    |                                  |


******

### Others

| unicode | Glyph | GlyphName                   | Features or Alternate            |
|---------|-------|-----------------------------|----------------------------------|
| 0x0000  |       | NULL                        |                                  |
| 0x000D  |       | CR                          |                                  |
|         |       | .notdef                     |                                  |
